/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.mc;

import java.awt.image.BufferedImage;
import org.nlogo.api.CompilerException;
import org.nlogo.api.Observer;
import org.nlogo.api.SimpleJobOwner;
import org.nlogo.mc.Image;
import org.nlogo.mc.ImageException;
import org.nlogo.nvm.Workspace;
import org.nlogo.nvm.WorkspaceFactory;

class ImageGenerator {
    ImageGenerator() {
        throw new IllegalStateException("This class cannot be instantiated");
    }

    static Image getAutoGeneratedModelImage(final WorkspaceFactory workspaceFactory) {
        return new Image(){

            public BufferedImage getImage() throws ImageException {
                return ImageGenerator.helper(workspaceFactory);
            }
        };
    }

    private static BufferedImage helper(WorkspaceFactory workspaceFactory) throws ImageException {
        BufferedImage image = null;
        try {
            Workspace ws = workspaceFactory.newInstance();
            String command = "random-seed 0 " + ws.previewCommands();
            SimpleJobOwner owner = new SimpleJobOwner("ImageGenerator", ws.world().mainRNG, Observer.class);
            ws.runCompiledCommands(owner, ws.compileCommands(command));
            image = ws.exportView();
            ws.dispose();
            return image;
        }
        catch (InterruptedException e) {
            return image;
        }
        catch (CompilerException compilerException) {
            throw new ImageException("Could not auto-generate preview image due to invalid auto-generate NetLogo code", compilerException);
        }
    }
}

