/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.mc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.nlogo.mc.LoginRequest;
import org.nlogo.mc.ModelingCommons;
import org.nlogo.mc.Person;

public strictfp class LoginDialog
extends JDialog {
    private JPanel topLevelContainer;
    private JButton cancelButton;
    private JButton loginButton;
    private JPasswordField passwordField;
    private JTextField emailField;
    private JLabel errorLabel;
    private JButton createAccountButton;
    private ModelingCommons communicator;
    private Frame frame;

    public LoginDialog(Frame frame, final ModelingCommons communicator, String errorLabelText) {
        super(frame, "Login To Modeling Commons", true);
        this.communicator = communicator;
        this.frame = frame;
        this.initializeGUIComponents();
        this.getRootPane().setDefaultButton(this.loginButton);
        this.errorLabel.setText(errorLabelText);
        this.createAccountButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.dispose();
                communicator.promptForCreateAccount();
            }
        });
        this.loginButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.onOK();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                LoginDialog.this.onCancel();
            }
        });
        this.topLevelContainer.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setResizable(true);
    }

    private void onOK() {
        String emailAddress = this.emailField.getText();
        char[] passwordArr = this.passwordField.getPassword();
        String password = new String(passwordArr);
        Arrays.fill(passwordArr, '\u0000');
        this.dispose();
        LoginRequest request = new LoginRequest(this.communicator.getHttpClient(), this.frame, emailAddress, password){

            protected void onLogin(String status, Person person) {
                if (status.equals("INVALID_CREDENTIALS")) {
                    LoginDialog.this.communicator.promptForLogin("Invalid email address or password");
                } else if (status.equals("MISSING_PARAMETERS")) {
                    LoginDialog.this.communicator.promptForLogin("Missing email address or password");
                } else if (status.equals("INVALID_RESPONSE_FROM_SERVER")) {
                    LoginDialog.this.communicator.promptForLogin("Invalid response from Modeling Commons");
                } else if (status.equals("CONNECTION_ERROR")) {
                    LoginDialog.this.communicator.promptForLogin("Could not connect to Modeling Commons");
                } else if (status.equals("SUCCESS")) {
                    LoginDialog.this.communicator.setPerson(person);
                    LoginDialog.this.communicator.promptForUpload();
                } else {
                    LoginDialog.this.communicator.promptForLogin("Unknown server error");
                }
            }
        };
        request.execute();
    }

    private void onCancel() {
        this.dispose();
    }

    private void setMaxHeightToPreferredHeight(JComponent component) {
        component.setMaximumSize(new Dimension((int)component.getMaximumSize().getWidth(), (int)component.getPreferredSize().getHeight()));
    }

    private void initializeGUIComponents() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        this.topLevelContainer = new JPanel();
        this.topLevelContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.topLevelContainer.setLayout(new BoxLayout(this.topLevelContainer, 1));
        this.setContentPane(this.topLevelContainer);
        JPanel titlePanel = new JPanel(new FlowLayout(3));
        JPanel formPanel = new JPanel(new BorderLayout());
        JPanel errorPanel = new JPanel(new FlowLayout(3));
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        this.topLevelContainer.add(titlePanel);
        this.topLevelContainer.add(formPanel);
        this.topLevelContainer.add(Box.createVerticalGlue());
        this.topLevelContainer.add(errorPanel);
        this.topLevelContainer.add(buttonsPanel);
        titlePanel.add(new JLabel("You must login to upload to the Modeling Commons"));
        this.setMaxHeightToPreferredHeight(titlePanel);
        JPanel formLabels = new JPanel(new GridLayout(2, 1));
        formLabels.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        JPanel formFields = new JPanel(new GridLayout(2, 1));
        formPanel.add((Component)formLabels, "Before");
        formPanel.add((Component)formFields, "Center");
        formLabels.add(new JLabel("Email Address", 11));
        this.emailField = new JTextField();
        JPanel emailFieldPanel = new JPanel(new GridBagLayout());
        emailFieldPanel.add((Component)this.emailField, constraints);
        formFields.add(emailFieldPanel);
        formLabels.add(new JLabel("Password", 11));
        this.passwordField = new JPasswordField();
        JPanel passwordFieldPanel = new JPanel(new GridBagLayout());
        passwordFieldPanel.add((Component)this.passwordField, constraints);
        formFields.add(passwordFieldPanel);
        this.setMaxHeightToPreferredHeight(formPanel);
        this.errorLabel = new JLabel("Error");
        this.errorLabel.setForeground(Color.RED);
        errorPanel.add(this.errorLabel);
        this.setMaxHeightToPreferredHeight(errorPanel);
        this.createAccountButton = new JButton("Create Account");
        this.cancelButton = new JButton("Cancel");
        this.loginButton = new JButton("Login");
        buttonsPanel.add(this.createAccountButton);
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(this.cancelButton);
        buttonsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonsPanel.add(this.loginButton);
        this.setMaxHeightToPreferredHeight(buttonsPanel);
    }
}

