/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.mc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.nlogo.mc.DisableableComboBox;
import org.nlogo.mc.FileImage;
import org.nlogo.mc.FileSelector;
import org.nlogo.mc.Group;
import org.nlogo.mc.Image;
import org.nlogo.mc.ImageGenerator;
import org.nlogo.mc.LogoutRequest;
import org.nlogo.mc.Model;
import org.nlogo.mc.ModelingCommons;
import org.nlogo.mc.NewModelType;
import org.nlogo.mc.Permission;
import org.nlogo.mc.Request;
import org.nlogo.mc.SearchForModelsRequest;
import org.nlogo.mc.UpdateModelRequest;
import org.nlogo.mc.UploadModelRequest;

public strictfp class UploadDialog
extends JDialog {
    private JLabel personNameLabel;
    private JLabel errorLabel;
    private JButton uploadModelButton;
    private JButton cancelButton;
    private JButton logoutButton;
    private JTextField modelNameField;
    private JComboBox groupComboBox;
    private DisableableComboBox visibilityComboBox;
    private DisableableComboBox changeabilityComboBox;
    private JRadioButton useCurrentViewRadioButton;
    private JRadioButton autoGenerateViewRadioButton;
    private JRadioButton noPreviewRadioButton;
    private JRadioButton imageFromFileRadioButton;
    private JLabel autoGenerateDisabledExplanation;
    private JRadioButton newModelRadioButton;
    private JRadioButton childOfExistingModelRadioButton;
    private JRadioButton newVersionOfExistingRadioButton;
    private DisableableComboBox existingModelNameComboBox;
    private JTextField existingModelNameSearchField;
    private JTextField descriptionTextField;
    private JLabel modelNameLabel;
    private JLabel existingModelNameLabel;
    private JLabel descriptionLabel;
    private JLabel modelGroupLabel;
    private JLabel visibilityLabel;
    private JLabel changeabilityLabel;
    private JLabel previewImageLabel;
    private ButtonGroup uploadTypeButtonGroup;
    private ButtonGroup previewImageButtonGroup;
    private FileSelector fileSelector;
    private JPanel topLevelContainer;
    private ModelingCommons communicator;
    private int groupPermissionIndex;
    private int userPermissionIndex;
    private int everyonePermissionIndex;
    private Request currentModelSearchRequest;
    private String nextModelSearchString;
    private boolean enableAutoGeneratePreviewImage;
    private Frame frame;

    public UploadDialog(Frame frame, ModelingCommons communicator, String errorLabelText, boolean enableAutoGeneratePreviewImage) {
        super(frame, "Upload Model to Modeling Commons", true);
        this.frame = frame;
        this.communicator = communicator;
        this.enableAutoGeneratePreviewImage = enableAutoGeneratePreviewImage;
        this.initializeGUIComponents();
        this.getRootPane().setDefaultButton(this.uploadModelButton);
        this.errorLabel.setText(errorLabelText);
        this.personNameLabel.setText("Hello " + communicator.getPerson().getFirstName() + " " + communicator.getPerson().getLastName());
        this.uploadModelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UploadDialog.this.onOK();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UploadDialog.this.onCancel();
            }
        });
        this.logoutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UploadDialog.this.dispose();
                LogoutRequest request = new LogoutRequest(UploadDialog.this.communicator.getHttpClient(), UploadDialog.this.frame){

                    protected void onLogout(String status, boolean logoutSuccessful) {
                        if (logoutSuccessful) {
                            UploadDialog.this.communicator.setPerson(null);
                        }
                        UploadDialog.this.communicator.promptForLogin();
                    }
                };
                ((Request)request).execute();
            }
        });
        ArrayList<Group> groups = new ArrayList<Group>(communicator.getGroups());
        groups.add(0, null);
        this.groupComboBox.setModel(new DefaultComboBoxModel<Object>(groups.toArray()));
        this.everyonePermissionIndex = this.visibilityComboBox.addItem(Permission.getPermissions().get("a"), true);
        this.changeabilityComboBox.addItem(Permission.getPermissions().get("a"), true);
        this.groupPermissionIndex = this.visibilityComboBox.addItem(Permission.getPermissions().get("g"), false);
        this.changeabilityComboBox.addItem(Permission.getPermissions().get("g"), false);
        this.userPermissionIndex = this.visibilityComboBox.addItem(Permission.getPermissions().get("u"), true);
        this.changeabilityComboBox.addItem(Permission.getPermissions().get("u"), true);
        this.groupComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean groupSelected = UploadDialog.this.groupComboBox.getSelectedItem() != null;
                UploadDialog.this.visibilityComboBox.setIndexEnabled(UploadDialog.this.groupPermissionIndex, groupSelected);
                UploadDialog.this.changeabilityComboBox.setIndexEnabled(UploadDialog.this.groupPermissionIndex, groupSelected);
                Permission visibility = (Permission)UploadDialog.this.visibilityComboBox.getSelectedObject();
                if (!groupSelected && visibility.getId().equals("g")) {
                    UploadDialog.this.visibilityComboBox.setSelectedIndex(UploadDialog.this.userPermissionIndex);
                }
                Permission changeability = (Permission)UploadDialog.this.changeabilityComboBox.getSelectedObject();
                if (!groupSelected && changeability.getId().equals("g")) {
                    UploadDialog.this.changeabilityComboBox.setSelectedIndex(UploadDialog.this.userPermissionIndex);
                }
            }
        });
        this.useCurrentViewRadioButton.setSelected(true);
        this.fileSelector.setEnabled(false);
        this.imageFromFileRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                UploadDialog.this.fileSelector.setEnabled(UploadDialog.this.imageFromFileRadioButton.isSelected());
            }
        });
        if (!enableAutoGeneratePreviewImage) {
            this.autoGenerateViewRadioButton.setEnabled(false);
        } else {
            this.autoGenerateDisabledExplanation.setVisible(false);
        }
        this.existingModelNameSearchField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                UploadDialog.this.updateExistingModelNameComboBox(UploadDialog.this.existingModelNameSearchField.getText());
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                UploadDialog.this.updateExistingModelNameComboBox(UploadDialog.this.existingModelNameSearchField.getText());
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.newModelRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (UploadDialog.this.newModelRadioButton.isSelected()) {
                    UploadDialog.this.setNewModelMode();
                }
            }
        });
        this.newVersionOfExistingRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (UploadDialog.this.newVersionOfExistingRadioButton.isSelected()) {
                    UploadDialog.this.setNewVersionMode();
                }
            }
        });
        this.childOfExistingModelRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (UploadDialog.this.childOfExistingModelRadioButton.isSelected()) {
                    UploadDialog.this.setChildMode();
                }
            }
        });
        this.newModelRadioButton.setSelected(true);
        this.setNewModelMode();
        this.updateExistingModelNameComboBox("");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                UploadDialog.this.onCancel();
            }
        });
        this.topLevelContainer.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UploadDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setResizable(false);
    }

    private void setNextModelSearch(String searchString) {
        this.nextModelSearchString = searchString;
        if (this.currentModelSearchRequest == null) {
            this.executeModelSearch();
        } else {
            this.currentModelSearchRequest.abort();
        }
    }

    private void executeModelSearch() {
        boolean ensureChangeabilityPermission = this.getSelectedUploadType() == NewModelType.NEW_VERSION;
        this.currentModelSearchRequest = new SearchForModelsRequest(this.communicator.getHttpClient(), this.nextModelSearchString, 10, ensureChangeabilityPermission){

            @Override
            protected void onSearchResults(String status, List<Model> models) {
                if (status.equals("ABORTED_OR_CONNECTION_ERROR")) {
                    if (UploadDialog.this.nextModelSearchString != null) {
                        UploadDialog.this.executeModelSearch();
                    } else {
                        UploadDialog.this.currentModelSearchRequest = null;
                        UploadDialog.this.clearExistingModelNameComboBox();
                        UploadDialog.this.existingModelNameComboBox.addItem("Error connecting to Modeling Commons", false);
                    }
                } else if (status.equals("INVALID_RESPONSE_FROM_SERVER")) {
                    UploadDialog.this.clearExistingModelNameComboBox();
                    UploadDialog.this.existingModelNameComboBox.addItem("Invalid response from Modeling Commons", false);
                } else if (status.equals("SUCCESS")) {
                    UploadDialog.this.existingModelNameComboBox.removeAllItems();
                    if (models.size() > 0) {
                        for (Model model : models) {
                            UploadDialog.this.existingModelNameComboBox.addItem(model, true);
                        }
                        boolean currentFocus = UploadDialog.this.existingModelNameSearchField.hasFocus();
                        UploadDialog.this.existingModelNameComboBox.showPopup();
                        if (currentFocus) {
                            UploadDialog.this.existingModelNameSearchField.requestFocus();
                        }
                    } else {
                        UploadDialog.this.existingModelNameComboBox.addItem("No existing models found", false);
                    }
                    UploadDialog.this.currentModelSearchRequest = null;
                    UploadDialog.this.nextModelSearchString = null;
                }
            }
        };
        this.nextModelSearchString = null;
        this.currentModelSearchRequest.execute();
    }

    private void clearExistingModelNameComboBox() {
        this.existingModelNameComboBox.removeAllItems();
        this.existingModelNameComboBox.hidePopup();
    }

    private void updateExistingModelNameComboBox(String searchString) {
        this.clearExistingModelNameComboBox();
        if (searchString.length() > 0) {
            this.existingModelNameComboBox.addItem("Searching", false);
            this.setNextModelSearch(searchString);
        } else {
            this.existingModelNameComboBox.addItem("Enter name of existing model", false);
            if (this.currentModelSearchRequest != null) {
                this.currentModelSearchRequest.abort();
            }
        }
    }

    private boolean isValidInput() {
        NewModelType uploadType = this.getSelectedUploadType();
        if ((uploadType == NewModelType.NEW || uploadType == NewModelType.CHILD) && this.modelNameField.getText().trim().length() == 0) {
            this.errorLabel.setText("Missing model name");
            return false;
        }
        if ((uploadType == NewModelType.NEW_VERSION || uploadType == NewModelType.CHILD) && this.getSelectedExistingModel() == null) {
            if (uploadType == NewModelType.NEW_VERSION) {
                this.errorLabel.setText("Must select an existing model to make a new version of");
            } else {
                this.errorLabel.setText("Must select an existing parent model");
            }
            return false;
        }
        if ((uploadType == NewModelType.NEW_VERSION || uploadType == NewModelType.CHILD) && this.descriptionTextField.getText().trim().length() == 0) {
            this.errorLabel.setText("Description cannot be blank");
            return false;
        }
        return true;
    }

    private void onOK() {
        if (!this.isValidInput()) {
            return;
        }
        this.dispose();
        String modelName = this.modelNameField.getText().trim();
        String description = this.descriptionTextField.getText().trim();
        Group group = (Group)this.groupComboBox.getSelectedItem();
        Permission visibility = (Permission)this.visibilityComboBox.getSelectedObject();
        Permission changeability = (Permission)this.changeabilityComboBox.getSelectedObject();
        NewModelType uploadType = this.getSelectedUploadType();
        Model selectedExistingModel = this.getSelectedExistingModel();
        int existingModelId = -1;
        if (selectedExistingModel != null) {
            existingModelId = selectedExistingModel.getId();
        }
        Image previewImage = null;
        if (this.useCurrentViewRadioButton.isSelected()) {
            previewImage = this.communicator.getCurrentModelViewImage();
        } else if (this.imageFromFileRadioButton.isSelected()) {
            if (this.fileSelector.getFilePath() != null) {
                previewImage = new FileImage(this.fileSelector.getFilePath());
            }
        } else if (this.autoGenerateViewRadioButton.isSelected()) {
            previewImage = ImageGenerator.getAutoGeneratedModelImage(this.communicator.workspaceFactory);
        }
        if (uploadType == NewModelType.NEW) {
            UploadModelRequest request = new UploadModelRequest(this.communicator.getHttpClient(), this.frame, modelName, this.communicator.getModelBody(), group, visibility, changeability, previewImage){

                protected void onUploaded(String status, String uploadedModelURL, String uploadedModelName) {
                    if (status.equals("NOT_LOGGED_IN")) {
                        UploadDialog.this.communicator.promptForLogin();
                    } else if (status.equals("MISSING_PARAMETERS")) {
                        UploadDialog.this.communicator.promptForUpload("Missing model name");
                    } else if (status.equals("MODEL_NOT_SAVED")) {
                        UploadDialog.this.communicator.promptForUpload("Server error");
                    } else if (status.equals("INVALID_RESPONSE_FROM_SERVER")) {
                        UploadDialog.this.communicator.promptForUpload("Invalid response from Modeling Commons", false);
                    } else if (status.equals("CONNECTION_ERROR")) {
                        UploadDialog.this.communicator.promptForUpload("Could not connect to Modeling Commons", false);
                    } else if (status.equals("SUCCESS")) {
                        UploadDialog.this.communicator.promptForSuccess(uploadedModelURL, uploadedModelName);
                    } else if (status.equals("INVALID_PREVIEW_IMAGE")) {
                        UploadDialog.this.communicator.promptForUpload("Invalid preview image");
                    } else if (status.equals("SUCCESS_PREVIEW_NOT_SAVED")) {
                        UploadDialog.this.communicator.promptForSuccess("The model was uploaded, but the preview image was not saved", uploadedModelURL, uploadedModelName);
                    } else {
                        UploadDialog.this.communicator.promptForUpload("Unknown server error", false);
                    }
                }
            };
            ((Request)request).execute();
        } else if (uploadType == NewModelType.NEW_VERSION || uploadType == NewModelType.CHILD) {
            UpdateModelRequest request = new UpdateModelRequest(this.communicator.getHttpClient(), this.frame, existingModelId, modelName, this.communicator.getModelBody(), description, uploadType){

                protected void onUploaded(String status, String uploadedModelURL, String uploadedModelName) {
                    if (status.equals("NOT_LOGGED_IN")) {
                        UploadDialog.this.communicator.promptForLogin();
                    } else if (status.equals("MISSING_PARAMETERS")) {
                        UploadDialog.this.communicator.promptForUpload("Missing parameters");
                    } else if (status.equals("MODEL_NOT_SAVED")) {
                        UploadDialog.this.communicator.promptForUpload("Server error");
                    } else if (status.equals("INVALID_RESPONSE_FROM_SERVER")) {
                        UploadDialog.this.communicator.promptForUpload("Invalid response from Modeling Commons", false);
                    } else if (status.equals("CONNECTION_ERROR")) {
                        UploadDialog.this.communicator.promptForUpload("Could not connect to Modeling Commons", false);
                    } else if (status.equals("SUCCESS")) {
                        UploadDialog.this.communicator.promptForSuccess(uploadedModelURL, uploadedModelName);
                    } else {
                        UploadDialog.this.communicator.promptForUpload("Unknown server error", false);
                    }
                }
            };
            ((Request)request).execute();
        }
    }

    private void onCancel() {
        this.dispose();
    }

    private NewModelType getSelectedUploadType() {
        if (this.newModelRadioButton.isSelected()) {
            return NewModelType.NEW;
        }
        if (this.newVersionOfExistingRadioButton.isSelected()) {
            return NewModelType.NEW_VERSION;
        }
        if (this.childOfExistingModelRadioButton.isSelected()) {
            return NewModelType.CHILD;
        }
        return null;
    }

    private Model getSelectedExistingModel() {
        Object selectedModel = this.existingModelNameComboBox.getSelectedObject();
        if (selectedModel != null && selectedModel instanceof Model) {
            return (Model)selectedModel;
        }
        return null;
    }

    private void modelNameSetEnabled(boolean enabled) {
        this.modelNameField.setEnabled(enabled);
        this.modelNameLabel.setEnabled(enabled);
    }

    private void existingModelSetEnabled(boolean enabled) {
        this.existingModelNameSearchField.setEnabled(enabled);
        this.existingModelNameComboBox.setEnabled(enabled);
        this.existingModelNameLabel.setEnabled(enabled);
        this.existingModelNameSearchField.setText("");
    }

    private void descriptionSetEnabled(boolean enabled) {
        this.descriptionTextField.setEnabled(enabled);
        this.descriptionLabel.setEnabled(enabled);
    }

    private void permissionsSetEnabled(boolean enabled) {
        this.groupComboBox.setEnabled(enabled);
        this.visibilityComboBox.setEnabled(enabled);
        this.changeabilityComboBox.setEnabled(enabled);
        this.modelGroupLabel.setEnabled(enabled);
        this.visibilityLabel.setEnabled(enabled);
        this.changeabilityLabel.setEnabled(enabled);
    }

    private void previewImageSetEnabled(boolean enabled) {
        this.useCurrentViewRadioButton.setEnabled(enabled);
        this.autoGenerateViewRadioButton.setEnabled(enabled && this.enableAutoGeneratePreviewImage);
        this.imageFromFileRadioButton.setEnabled(enabled);
        this.fileSelector.setEnabled(enabled && this.imageFromFileRadioButton.isSelected());
        this.noPreviewRadioButton.setEnabled(enabled);
        this.previewImageLabel.setEnabled(enabled);
        this.autoGenerateDisabledExplanation.setEnabled(enabled);
    }

    private void setNewModelMode() {
        this.modelNameSetEnabled(true);
        this.existingModelSetEnabled(false);
        this.descriptionSetEnabled(false);
        this.permissionsSetEnabled(true);
        this.previewImageSetEnabled(true);
    }

    private void setNewVersionMode() {
        this.modelNameSetEnabled(false);
        this.existingModelSetEnabled(true);
        this.descriptionSetEnabled(true);
        this.permissionsSetEnabled(false);
        this.previewImageSetEnabled(false);
    }

    private void setChildMode() {
        this.modelNameSetEnabled(true);
        this.existingModelSetEnabled(true);
        this.descriptionSetEnabled(true);
        this.permissionsSetEnabled(false);
        this.previewImageSetEnabled(false);
    }

    private void setMaxHeightToPreferredHeight(JComponent component) {
        component.setMaximumSize(new Dimension((int)component.getMaximumSize().getWidth(), (int)component.getPreferredSize().getHeight()));
    }

    private void initializeGUIComponents() {
        this.topLevelContainer = new JPanel();
        this.topLevelContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.topLevelContainer.setLayout(new BoxLayout(this.topLevelContainer, 1));
        this.setContentPane(this.topLevelContainer);
        JPanel helloPanel = new JPanel();
        JPanel formPanel = new JPanel();
        JPanel errorPanel = new JPanel();
        JPanel buttonsPanel = new JPanel();
        this.topLevelContainer.add(helloPanel);
        this.topLevelContainer.add(formPanel);
        this.topLevelContainer.add(Box.createVerticalGlue());
        this.topLevelContainer.add(errorPanel);
        this.topLevelContainer.add(buttonsPanel);
        helloPanel.setLayout(new BoxLayout(helloPanel, 0));
        this.personNameLabel = new JLabel("Hello Firstname Lastname");
        helloPanel.add(this.personNameLabel);
        helloPanel.add(Box.createHorizontalGlue());
        this.setMaxHeightToPreferredHeight(helloPanel);
        formPanel.setLayout(new BorderLayout());
        JPanel formLabels = new JPanel(new GridLayout(17, 1));
        JPanel formFields = new JPanel(new GridLayout(17, 1));
        formLabels.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        formPanel.add((Component)formLabels, "Before");
        formPanel.add((Component)formFields, "Center");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        formLabels.add(new JLabel("Upload As"));
        this.newModelRadioButton = new JRadioButton("New model");
        formFields.add(this.newModelRadioButton);
        formLabels.add(new JLabel(""));
        this.childOfExistingModelRadioButton = new JRadioButton("Child of existing model");
        formFields.add(this.childOfExistingModelRadioButton);
        formLabels.add(new JLabel(""));
        this.newVersionOfExistingRadioButton = new JRadioButton("New version of existing model");
        formFields.add(this.newVersionOfExistingRadioButton);
        formLabels.add(new JLabel(""));
        formFields.add(new JLabel(""));
        this.modelNameLabel = new JLabel("New Model Name");
        formLabels.add(this.modelNameLabel);
        this.modelNameField = new JTextField();
        JPanel modelNameFieldPanel = new JPanel(new GridBagLayout());
        modelNameFieldPanel.add((Component)this.modelNameField, constraints);
        formFields.add(modelNameFieldPanel);
        this.existingModelNameLabel = new JLabel("Existing Model Name");
        formLabels.add(this.existingModelNameLabel);
        this.existingModelNameSearchField = new JTextField();
        JPanel existingModelNameSearchFieldPanel = new JPanel(new GridBagLayout());
        existingModelNameSearchFieldPanel.add((Component)this.existingModelNameSearchField, constraints);
        formFields.add(existingModelNameSearchFieldPanel);
        formLabels.add(new JLabel(""));
        this.existingModelNameComboBox = new DisableableComboBox();
        JPanel existingModelNameComboBoxPanel = new JPanel(new GridBagLayout());
        existingModelNameComboBoxPanel.add((Component)this.existingModelNameComboBox, constraints);
        formFields.add(existingModelNameComboBoxPanel);
        this.descriptionLabel = new JLabel("Short Comment");
        formLabels.add(this.descriptionLabel);
        this.descriptionTextField = new JTextField();
        JPanel descriptionTextFieldPanel = new JPanel(new GridBagLayout());
        descriptionTextFieldPanel.add((Component)this.descriptionTextField, constraints);
        formFields.add(descriptionTextFieldPanel);
        formLabels.add(new JLabel(""));
        formFields.add(new JLabel(""));
        this.modelGroupLabel = new JLabel("Model Group");
        formLabels.add(this.modelGroupLabel);
        this.groupComboBox = new JComboBox();
        JPanel groupComboBoxPanel = new JPanel(new GridBagLayout());
        groupComboBoxPanel.add((Component)this.groupComboBox, constraints);
        formFields.add(groupComboBoxPanel);
        this.visibilityLabel = new JLabel("Visible By");
        formLabels.add(this.visibilityLabel);
        this.visibilityComboBox = new DisableableComboBox();
        JPanel visibilityComboBoxPanel = new JPanel(new GridBagLayout());
        visibilityComboBoxPanel.add((Component)this.visibilityComboBox, constraints);
        formFields.add(visibilityComboBoxPanel);
        this.changeabilityLabel = new JLabel("Changeable By");
        formLabels.add(this.changeabilityLabel);
        this.changeabilityComboBox = new DisableableComboBox();
        JPanel changeabilityComboBoxPanel = new JPanel(new GridBagLayout());
        changeabilityComboBoxPanel.add((Component)this.changeabilityComboBox, constraints);
        formFields.add(changeabilityComboBoxPanel);
        formLabels.add(new JLabel(""));
        formFields.add(new JLabel(""));
        this.previewImageLabel = new JLabel("Preview Image");
        formLabels.add(this.previewImageLabel);
        this.useCurrentViewRadioButton = new JRadioButton("Use current image");
        formFields.add(this.useCurrentViewRadioButton);
        formLabels.add(new JLabel(""));
        JPanel autoGeneratePanel = new JPanel();
        autoGeneratePanel.setLayout(new BoxLayout(autoGeneratePanel, 0));
        formFields.add(autoGeneratePanel);
        this.autoGenerateViewRadioButton = new JRadioButton("Auto-generate image");
        this.autoGenerateDisabledExplanation = new JLabel("Setup and go procedures must be defined to auto-generate");
        autoGeneratePanel.add(this.autoGenerateViewRadioButton);
        autoGeneratePanel.add(Box.createRigidArea(new Dimension(10, 0)));
        autoGeneratePanel.add(this.autoGenerateDisabledExplanation);
        formLabels.add(new JLabel(""));
        JPanel selectFilePanel = new JPanel();
        selectFilePanel.setLayout(new BoxLayout(selectFilePanel, 0));
        formFields.add(selectFilePanel);
        this.imageFromFileRadioButton = new JRadioButton("Image from file");
        selectFilePanel.add(this.imageFromFileRadioButton);
        this.fileSelector = new FileSelector(selectFilePanel);
        selectFilePanel.add(this.fileSelector);
        formLabels.add(new JLabel(""));
        this.noPreviewRadioButton = new JRadioButton("No preview image");
        formFields.add(this.noPreviewRadioButton);
        this.setMaxHeightToPreferredHeight(formPanel);
        errorPanel.setLayout(new BoxLayout(errorPanel, 0));
        this.errorLabel = new JLabel("Error! ");
        this.errorLabel.setForeground(Color.RED);
        errorPanel.add(this.errorLabel);
        errorPanel.add(Box.createHorizontalGlue());
        this.setMaxHeightToPreferredHeight(errorPanel);
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        this.logoutButton = new JButton("Logout");
        buttonsPanel.add(this.logoutButton);
        buttonsPanel.add(Box.createHorizontalGlue());
        this.cancelButton = new JButton("Cancel");
        buttonsPanel.add(this.cancelButton);
        buttonsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.uploadModelButton = new JButton("Upload Model");
        buttonsPanel.add(this.uploadModelButton);
        this.setMaxHeightToPreferredHeight(buttonsPanel);
        this.uploadTypeButtonGroup = new ButtonGroup();
        this.uploadTypeButtonGroup.add(this.newModelRadioButton);
        this.uploadTypeButtonGroup.add(this.childOfExistingModelRadioButton);
        this.uploadTypeButtonGroup.add(this.newVersionOfExistingRadioButton);
        this.previewImageButtonGroup = new ButtonGroup();
        this.previewImageButtonGroup.add(this.useCurrentViewRadioButton);
        this.previewImageButtonGroup.add(this.autoGenerateViewRadioButton);
        this.previewImageButtonGroup.add(this.imageFromFileRadioButton);
        this.previewImageButtonGroup.add(this.noPreviewRadioButton);
    }
}

