/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.mc;

import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import org.apache.http.client.HttpClient;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.nlogo.mc.Group;
import org.nlogo.mc.Image;
import org.nlogo.mc.ImageException;
import org.nlogo.mc.LoadingDialog;
import org.nlogo.mc.MultiPartPostRequest;
import org.nlogo.mc.Permission;

public strictfp abstract class UploadModelRequest
extends MultiPartPostRequest {
    private JDialog loadingDialog;
    private String invalid;
    private Frame frame;

    public UploadModelRequest(HttpClient http, Frame frame, String modelName, String modelBody, Group group, Permission visibility, Permission changeability, Image previewImage) {
        super(http, "http://modelingcommons.org/upload/create_model");
        this.frame = frame;
        this.addStringParam("new_model[name]", modelName);
        this.addStringParam("read_permission", visibility.getId());
        this.addStringParam("write_permission", changeability.getId());
        if (group != null) {
            this.addStringParam("group_id", "" + group.getId());
        }
        this.addFileParam("new_model[uploaded_body]", modelBody, modelName + ".nlogo");
        if (previewImage != null) {
            try {
                ByteArrayOutputStream previewImageStream = new ByteArrayOutputStream();
                BufferedImage image = previewImage.getImage();
                if (image == null) {
                    this.invalid = "INVALID_PREVIEW_IMAGE";
                } else {
                    ImageIO.write((RenderedImage)image, "png", previewImageStream);
                    this.addFileParam("new_model[uploaded_preview]", previewImageStream.toByteArray(), modelName + ".png");
                }
            }
            catch (ImageException e) {
                this.invalid = "INVALID_PREVIEW_IMAGE";
            }
            catch (IOException e) {
                this.invalid = "INVALID_PREVIEW_IMAGE";
            }
        }
    }

    protected void onReturn(String response) {
        this.loadingDialog.dispose();
        if (response == null) {
            this.onUploaded("CONNECTION_ERROR", null, null);
            return;
        }
        JSONParser json = new JSONParser();
        try {
            JSONObject obj = (JSONObject)json.parse(response);
            String status = (String)obj.get((Object)"status");
            String uploadedModelURL = null;
            String uploadedModelName = null;
            if (status.equals("SUCCESS")) {
                JSONObject model = (JSONObject)obj.get((Object)"model");
                uploadedModelURL = (String)model.get((Object)"url");
                uploadedModelName = (String)model.get((Object)"name");
            }
            this.onUploaded(status, uploadedModelURL, uploadedModelName);
        }
        catch (ParseException e) {
            this.onUploaded("INVALID_RESPONSE_FROM_SERVER", null, null);
        }
    }

    public void execute() {
        if (this.invalid != null) {
            this.onUploaded(this.invalid, null, null);
            return;
        }
        this.loadingDialog = new LoadingDialog(this.frame, "Uploading model to Modeling Commons");
        super.execute();
        this.loadingDialog.setVisible(true);
    }

    protected abstract void onUploaded(String var1, String var2, String var3);
}

