/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.api.Let;
import org.nlogo.api.LogoException;
import org.nlogo.nvm.Activation;
import org.nlogo.nvm.Command;
import org.nlogo.nvm.ConcurrentJob;
import org.nlogo.nvm.EngineException;
import org.nlogo.nvm.ExclusiveJob;
import org.nlogo.nvm.HaltException;
import org.nlogo.nvm.Instruction;
import org.nlogo.nvm.Job;
import org.nlogo.nvm.LetBinding;
import org.nlogo.nvm.NonLocalExit$;
import org.nlogo.nvm.Reporter;
import org.nlogo.nvm.StackTraceBuilder;
import org.nlogo.util.Exceptions;
import scala.Option;
import scala.collection.LinearSeqOptimized;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class Context {
    public final Job job;
    public Agent myself;
    public Agent agent;
    public int agentBit;
    public int ip;
    public Activation activation;
    public boolean waiting = false;
    private boolean inReporterProcedure = false;
    public List<LetBinding> letBindings = Nil$.MODULE$;
    public boolean stopping = false;
    public boolean finished = false;

    public Context(Job job, Agent agent, int ip, Activation activation) {
        this.job = job;
        this.agent = agent;
        if (agent != null) {
            this.agentBit = agent.getAgentBit();
        }
        this.ip = ip;
        this.activation = activation;
    }

    public Context(Context context, AgentSet agents) {
        this.job = context.job;
        this.activation = context.activation;
        this.letBindings = context.letBindings;
        this.myself = context.agent;
        this.agentBit = agents.getAgentBit();
    }

    public Context(Context context, Agent agent) {
        this.job = context.job;
        this.activation = context.activation;
        this.letBindings = context.letBindings;
        this.myself = context.agent;
        this.agentBit = agent.getAgentBit();
    }

    public boolean makeChildrenExclusive() {
        return this.inReporterProcedure || this.job.exclusive();
    }

    void stepConcurrent() throws LogoException {
        if (this.agent.id == -1L) {
            this.finished = true;
            return;
        }
        Command command = null;
        try {
            do {
                command = this.activation.procedure.code[this.ip];
                if ((this.agentBit & command.agentBits) == 0) {
                    command.throwAgentClassException(this, this.agent.getAgentClass());
                }
                command.perform(this);
                if (!command.world.comeUpForAir) continue;
                this.comeUpForAir(command);
            } while (!command.switches && !this.finished);
        }
        catch (LogoException ex) {
            EngineException.rethrow(ex, this, command);
        }
        catch (StackOverflowError ex) {
            throw new EngineException(this, "stack overflow (recursion too deep)");
        }
    }

    void runExclusive() throws LogoException {
        if (this.agent.id == -1L) {
            this.finished = true;
            return;
        }
        Command command = null;
        try {
            do {
                command = this.activation.procedure.code[this.ip];
                if ((this.agentBit & command.agentBits) == 0) {
                    command.throwAgentClassException(this, this.agent.getAgentClass());
                }
                command.perform(this);
                if (!command.world.comeUpForAir) continue;
                this.comeUpForAir(command);
            } while (!this.finished);
        }
        catch (LogoException ex) {
            EngineException.rethrow(ex, this, command);
        }
    }

    public boolean hasParentContext() {
        return this.job.parentContext != null;
    }

    public Agent myself() {
        if (this.myself == null) {
            if (this.job.parentContext == null) {
                return null;
            }
            this.myself = this.job.parentContext.agent;
        }
        return this.myself;
    }

    public boolean atTopActivation() {
        return this.job.parentContext == null || this.activation != this.job.parentContext.activation;
    }

    public void runExclusiveJob(AgentSet agentset2, int address) throws LogoException {
        new ExclusiveJob(this.job.owner, agentset2, this.activation.procedure, address, this, this.job.random).run();
        if (this.agent.id == -1L) {
            this.finished = true;
        }
    }

    public Job makeConcurrentJob(AgentSet agentset2) {
        return new ConcurrentJob(this.job.owner, agentset2, null, this.ip + 1, this, this.job.random);
    }

    public void returnFromProcedure() {
        this.ip = this.activation.returnAddress;
        this.activation = this.activation.parent;
    }

    public void stop() {
        if (this.activation.procedure.isTask()) {
            throw NonLocalExit$.MODULE$;
        }
        if (this.activation.procedure.topLevel) {
            this.job.stopping = true;
            this.finished = true;
        }
        this.returnFromProcedure();
        this.stopping = true;
    }

    public Object evaluateReporter(Agent agent, Reporter reporter) throws LogoException {
        this.agent = agent;
        return reporter.report(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callReporterProcedure(Activation newActivation) throws LogoException {
        boolean oldInReporterProcedure = this.inReporterProcedure;
        Command command = null;
        this.inReporterProcedure = true;
        this.activation = newActivation;
        this.ip = 0;
        try {
            do {
                command = this.activation.procedure.code[this.ip];
                if ((this.agentBit & command.agentBits) == 0) {
                    command.throwAgentClassException(this, this.agent.getAgentClass());
                }
                command.perform(this);
                if (!command.world.comeUpForAir) continue;
                this.comeUpForAir(command);
            } while (!this.finished && this.job.result == null);
        }
        catch (NonLocalExit$ e) {
        }
        catch (LogoException ex) {
            EngineException.rethrow(ex, this, command);
        }
        finally {
            this.inReporterProcedure = oldInReporterProcedure;
        }
        this.ip = this.activation.returnAddress;
        this.activation = this.activation.parent;
        Object result = this.job.result;
        this.job.result = null;
        return result;
    }

    public void let(Let let, Object value) {
        this.letBindings = this.letBindings.$colon$colon(new LetBinding(let, value));
    }

    public Object getLet(Let let) {
        for (LinearSeqOptimized rest = this.letBindings; rest != Nil$.MODULE$; rest = rest.tail()) {
            LetBinding binding = rest.head();
            if (let != binding.let) continue;
            return binding.value;
        }
        return this.job.parentContext.getLet(let);
    }

    public void setLet(Let let, Object value) {
        for (LinearSeqOptimized rest = this.letBindings; rest != Nil$.MODULE$; rest = rest.tail()) {
            LetBinding binding = rest.head();
            if (let != binding.let) continue;
            binding.value = value;
            return;
        }
        this.job.parentContext.setLet(let, value);
    }

    public List<LetBinding> allLets() {
        if (this.job.parentContext == null) {
            return this.letBindings;
        }
        ListBuffer buf = new ListBuffer();
        Context walk = this;
        while (walk != null && this.activation == walk.activation) {
            buf.$plus$plus$eq((TraversableOnce)walk.letBindings);
            walk = walk.job.parentContext;
        }
        return buf.toList();
    }

    public void runtimeError(Exception ex) {
        try {
            Instruction instruction = null;
            Context context = null;
            if (ex instanceof EngineException) {
                instruction = ((EngineException)ex).instruction;
                context = ((EngineException)ex).context;
            }
            if (instruction == null) {
                instruction = this.activation.procedure.code[this.ip];
            }
            if (context == null) {
                context = this;
            }
            this.activation.procedure.code[this.ip].workspace.runtimeError(this.job.owner, context, instruction, ex);
        }
        catch (RuntimeException ex2) {
            Exceptions.handle(ex);
        }
    }

    public String buildRuntimeErrorMessage(Instruction instruction, Throwable throwable) {
        if (throwable instanceof EngineException && ((EngineException)throwable).cachedRuntimeErrorMessage.isDefined()) {
            return ((EngineException)throwable).cachedRuntimeErrorMessage.get();
        }
        return StackTraceBuilder.build(this.activation, this.agent, instruction, Option.apply(throwable));
    }

    private void comeUpForAir(Command command) throws HaltException {
        if (command.switches && this.job.owner.ownsPrimaryJobs()) {
            command.workspace.breathe();
        }
        if (Thread.currentThread().isInterrupted()) {
            command.world.comeUpForAir = false;
            this.finished = true;
            throw new HaltException(true);
        }
    }
}

