/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.prim.etc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.nlogo.agent.Agent;
import org.nlogo.agent.Agent3D;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.Dump;
import org.nlogo.api.I18N;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoList;
import org.nlogo.api.Syntax;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.EngineException;
import org.nlogo.nvm.Reporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class _atpoints
extends Reporter {
    @Override
    public Object report(Context context) throws LogoException {
        ArrayList<Agent> result;
        AgentSet sourceSet;
        block15: {
            Set<Patch> patches;
            block14: {
                sourceSet = this.argEvalAgentSet(context, 0);
                result = new ArrayList<Agent>();
                LogoList points = this.argEvalList(context, 1);
                Iterator<Object> it = points.iterator();
                while (it.hasNext()) {
                    if (this.validateListEntry(it.next())) continue;
                    throw new EngineException(context, this, I18N.errorsJ().getN("org.nlogo.prim.etc._atpoints.invalidListOfPoints", Dump.logoObject(points)));
                }
                patches = this.getPatchesAtPoints(context, context.agent, points);
                if (sourceSet.type() != Patch.class) break block14;
                if (sourceSet != this.world.patches()) {
                    for (Patch patch2 : patches) {
                        if (!sourceSet.contains(patch2)) continue;
                        result.add(patch2);
                    }
                } else {
                    result.addAll(patches);
                }
                break block15;
            }
            if (sourceSet.type() != Turtle.class) break block15;
            if (sourceSet != this.world.turtles()) {
                if (this.world.isBreed(sourceSet)) {
                    for (Patch otherPatch : patches) {
                        for (Turtle tempTurtle : otherPatch.turtlesHere()) {
                            if (sourceSet != tempTurtle.getBreed()) continue;
                            result.add(tempTurtle);
                        }
                    }
                } else {
                    for (Patch otherPatch : patches) {
                        for (Turtle tempTurtle : otherPatch.turtlesHere()) {
                            if (!sourceSet.contains(tempTurtle)) continue;
                            result.add(tempTurtle);
                        }
                    }
                }
            } else {
                for (Patch p : patches) {
                    for (Turtle t : p.turtlesHere()) {
                        result.add(t);
                    }
                }
            }
        }
        return new ArrayAgentSet(sourceSet.type(), result.toArray(new Agent[result.size()]), this.world);
    }

    private boolean validateListEntry(Object entry) {
        LogoList entryList;
        if (entry instanceof LogoList && ((entryList = (LogoList)entry).size() == 2 || this.world.program().is3D() && entryList.size() == 3)) {
            Iterator<Object> iter2 = entryList.iterator();
            while (iter2.hasNext()) {
                if (iter2.next() instanceof Double) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Set<Patch> getPatchesAtPoints(Context context, Agent agent, LogoList points) throws LogoException {
        LinkedHashSet<Patch> result = new LinkedHashSet<Patch>();
        boolean is3D2 = this.world.program().is3D();
        for (LogoList entry : points) {
            Double x = null;
            Double y = null;
            Double z = World.ZERO;
            int j = 0;
            Iterator<Object> it2 = entry.iterator();
            while (it2.hasNext()) {
                switch (j) {
                    case 0: {
                        x = (Double)it2.next();
                        break;
                    }
                    case 1: {
                        y = (Double)it2.next();
                        break;
                    }
                    case 2: {
                        if (!is3D2) {
                            throw new EngineException(context, this, I18N.errorsJ().getN("org.nlogo.prim.etc._atpoints.invalidListOfPoints", Dump.logoObject(points)));
                        }
                        z = (Double)it2.next();
                        break;
                    }
                    default: {
                        throw new EngineException(context, this, I18N.errorsJ().getN("org.nlogo.prim.etc._atpoints.invalidListOfPoints", Dump.logoObject(points)));
                    }
                }
                ++j;
            }
            if (x == null || y == null) {
                throw new EngineException(context, this, I18N.errorsJ().getN("org.nlogo.prim.etc._atpoints.invalidListOfPoints", Dump.logoObject(points)));
            }
            try {
                Patch patch2 = null;
                patch2 = !is3D2 ? agent.getPatchAtOffsets(x, y) : ((Agent3D)((Object)agent)).getPatchAtOffsets(x, y, z);
                if (patch2 == null) continue;
                result.add(patch2);
            }
            catch (AgentException e) {}
        }
        return result;
    }

    @Override
    public Syntax syntax() {
        int left = Syntax.TurtlesetType() | Syntax.PatchsetType();
        int[] right = new int[]{Syntax.ListType()};
        int ret = Syntax.AgentsetType();
        return Syntax.reporterSyntax(left, right, ret, Syntax.NormalPrecedence() + 2);
    }
}

