/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentSet;
import org.nlogo.api.Color;
import org.nlogo.api.Graphics2DWrapper;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.Link;
import org.nlogo.api.Patch;
import org.nlogo.api.Turtle;
import org.nlogo.api.ViewSettings;
import org.nlogo.api.World;
import org.nlogo.render.AbstractRenderer;

public strictfp class Renderer
extends AbstractRenderer {
    public Renderer(World world) {
        this(world, false);
    }

    public Renderer(World world, boolean renderLabelsAsRectangles) {
        super(world, world.turtleShapeList(), world.linkShapeList());
        this.renderLabelsAsRectangles_$eq(renderLabelsAsRectangles);
    }

    public void paint(Graphics2D g, ViewSettings settings) {
        this.paint(new Graphics2DWrapper(g, this.renderLabelsAsRectangles()), settings);
    }

    protected void paintPatchLabels(GraphicsInterface g, double patchSize) {
        if (this.world.patchesWithLabels() > 0) {
            int patchCount = this.world.patches().count();
            for (int i = 0; i < patchCount; ++i) {
                Patch patch2 = this.world.getPatch(i);
                if (!patch2.hasLabel()) continue;
                this.drawPatchLabel(g, patch2, patchSize);
            }
        }
        if (this.outlineAgent instanceof Patch) {
            Patch patch3 = (Patch)this.outlineAgent;
            this.topology.drawWrappedRect(g, Color.getComplement(Color.getColor(patch3.pcolor())), 1.0f, patch3.pxcor(), patch3.pycor(), 1.0, patchSize, false);
        }
    }

    protected void paintLinks(GraphicsInterface g, double patchSize) {
        int linksDrawn = 0;
        Collection<Object> breeds = this.world.program().linkBreeds().values();
        for (Object next : breeds) {
            if (!(next instanceof AgentSet)) continue;
            AgentSet breed = (AgentSet)next;
            for (Agent a : breed.agents()) {
                this.linkDrawer.drawLink(g, this.topology, (Link)a, patchSize, false);
                ++linksDrawn;
            }
        }
        if (linksDrawn < this.world.links().count()) {
            for (Agent a : this.world.links().agents()) {
                Link link = (Link)a;
                if (link.getBreed() != this.world.links()) continue;
                this.linkDrawer.drawLink(g, this.topology, link, patchSize, false);
            }
        }
        if (this.outlineAgent instanceof Link) {
            this.linkDrawer.drawLink(g, this.topology, (Link)this.outlineAgent, patchSize, true);
        }
    }

    protected void paintTurtles(GraphicsInterface g, double patchSize) {
        int turtlesDrawn = 0;
        Collection<Object> breeds = this.world.program().breeds().values();
        for (Object next : breeds) {
            AgentSet breed;
            if (!(next instanceof AgentSet) || !Turtle.class.isAssignableFrom((breed = (AgentSet)next).type())) continue;
            for (Agent a : breed.agents()) {
                this.turtleDrawer.drawTurtle(g, this.topology, (Turtle)a, patchSize);
                ++turtlesDrawn;
            }
        }
        if (turtlesDrawn < this.world.turtles().count()) {
            for (Agent a : this.world.turtles().agents()) {
                Turtle turtle2 = (Turtle)a;
                if (turtle2.getBreed() != this.world.turtles()) continue;
                this.turtleDrawer.drawTurtle(g, this.topology, turtle2, patchSize);
            }
        }
        if (this.outlineAgent instanceof Turtle) {
            this.turtleDrawer.drawTurtleWithOutline(g, this.topology, (Turtle)this.outlineAgent, patchSize);
        }
    }

    private void drawPatchLabel(GraphicsInterface g, Patch patch2, double patchSize) {
        this.topology.drawLabelHelper(g, patch2.pxcor(), patch2.pycor(), patch2.labelString(), patch2.labelColor(), patchSize, 1.0);
    }

    Agent targetAgent() {
        return this.world.observer().targetAgent();
    }

    protected BufferedImage getSpotlightImage(ViewSettings settings) {
        double ycor;
        double xcor;
        double spotlightSize;
        boolean wrap = false;
        Agent agent = this.targetAgent();
        if (agent instanceof Turtle) {
            Turtle turtle2 = (Turtle)agent;
            spotlightSize = turtle2.size() * 2.0;
            xcor = turtle2.xcor();
            ycor = turtle2.ycor();
            wrap = true;
        } else if (agent instanceof Link) {
            Link link = (Link)agent;
            spotlightSize = link.size();
            xcor = link.midpointX();
            ycor = link.midpointY();
        } else {
            Patch patch2 = (Patch)agent;
            spotlightSize = 2.0;
            xcor = patch2.pxcor();
            ycor = patch2.pycor();
        }
        return this.spotlightDrawer.getImage(this.topology, xcor, ycor, this.getWidth(settings.patchSize()), this.getHeight(settings.patchSize()), settings.patchSize(), spotlightSize, this.darkenPeripheral(settings), wrap);
    }

    protected boolean anyTurtles() {
        return this.world.turtles().count() > 0;
    }

    public double graphicsX(double xcor, double patchSize, double viewOffsetX) {
        return this.topology.graphicsX(xcor, patchSize, viewOffsetX);
    }

    public double graphicsY(double ycor, double patchSize, double viewOffsetY) {
        return this.topology.graphicsY(ycor, patchSize, viewOffsetY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage exportView(ViewSettings settings) {
        BufferedImage image = new BufferedImage(this.getWidth(settings.patchSize()), this.getHeight(settings.patchSize()), 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        Font font = g.getFont();
        Font newFont = new Font(font.getName(), font.getStyle(), settings.fontSize());
        g.setFont(newFont);
        World world = this.world;
        synchronized (world) {
            this.paint(g, settings);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportView(Graphics2D g, ViewSettings settings) {
        World world = this.world;
        synchronized (world) {
            this.paint(g, settings);
        }
    }
}

