/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import org.nlogo.api.Agent;
import org.nlogo.api.Color;
import org.nlogo.api.Dump;
import org.nlogo.api.File;
import org.nlogo.api.Graphics2DWrapper;
import org.nlogo.api.Link;
import org.nlogo.api.Perspective;
import org.nlogo.api.TrailDrawerInterface;
import org.nlogo.api.Turtle;
import org.nlogo.api.ViewSettings;
import org.nlogo.api.World;
import org.nlogo.render.LinkDrawer;
import org.nlogo.render.TopologyRenderer;
import org.nlogo.render.TurtleDrawer;
import org.nlogo.util.HexString;

public strictfp class TrailDrawer
implements TrailDrawerInterface,
ViewSettings {
    private final World world;
    private BufferedImage drawingImage = null;
    private int width;
    private int height;
    int[] colors = null;
    public TopologyRenderer topology;
    private final TurtleDrawer turtleDrawer;
    private final LinkDrawer linkDrawer;
    boolean drawingDirty = false;
    boolean drawingBlank = true;
    private boolean sendPixels = false;

    public TrailDrawer(World world, TurtleDrawer turtleDrawer, LinkDrawer linkDrawer) {
        this.world = world;
        this.turtleDrawer = turtleDrawer;
        this.linkDrawer = linkDrawer;
    }

    public int[] colors() {
        if (this.drawingDirty) {
            if (this.colors == null) {
                this.colors = new int[this.width * this.height * 4];
            }
            WritableRaster raster = this.drawingImage.getRaster();
            raster.getDataElements(0, 0, this.width, this.height, this.colors);
        }
        return this.colors;
    }

    public void setTopology(TopologyRenderer topology) {
        this.topology = topology;
    }

    public boolean sendPixels() {
        return this.sendPixels;
    }

    public void sendPixels(boolean dirty) {
        this.sendPixels = dirty;
    }

    public boolean isDirty() {
        return this.drawingDirty;
    }

    public boolean isBlank() {
        return this.drawingBlank;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void markDirty() {
        this.drawingBlank = false;
        this.drawingDirty = true;
    }

    public void markClean() {
        this.drawingDirty = false;
    }

    private void setUpDrawingImage() {
        this.width = (int)StrictMath.round(this.world.patchSize() * (double)this.world.worldWidth());
        this.height = (int)StrictMath.round(this.world.patchSize() * (double)this.world.worldHeight());
        if (this.width > 0 && this.height > 0) {
            this.drawingImage = new BufferedImage(this.width, this.height, 2);
            this.colors = null;
        } else {
            this.drawingImage = null;
        }
        this.drawingBlank = true;
    }

    public void rescaleDrawing() {
        BufferedImage oldImage = this.drawingImage;
        this.setUpDrawingImage();
        if (oldImage != null && this.drawingImage != null) {
            Graphics2D graphics = this.drawingImage.createGraphics();
            graphics.drawImage(oldImage, 0, 0, this.width, this.height, null);
            this.drawingDirty = true;
        }
    }

    public BufferedImage getAndCreateDrawing(boolean dirty) {
        if (this.drawingImage == null) {
            this.setUpDrawingImage();
        }
        if (dirty) {
            this.drawingBlank = false;
            this.drawingDirty = true;
        }
        return this.drawingImage;
    }

    public Object getDrawing() {
        return this.drawingImage;
    }

    public void readImage(InputStream is) throws IOException {
        this.setUpDrawingImage();
        BufferedImage image = ImageIO.read(is);
        Graphics2D dg = this.drawingImage.createGraphics();
        dg.drawImage((Image)image, 0, 0, null);
        this.drawingBlank = false;
        this.drawingDirty = true;
    }

    public void importDrawing(InputStream is) throws IOException {
        if (this.drawingImage == null) {
            this.setUpDrawingImage();
        }
        if (this.drawingImage != null) {
            float scaley;
            BufferedImage image = ImageIO.read(is);
            if (image == null) {
                throw new IIOException("Unsupported image format.");
            }
            float scalex = (float)this.getWidth() / (float)image.getWidth();
            float scale = scalex < (scaley = (float)this.getHeight() / (float)image.getHeight()) ? scalex : scaley;
            BufferedImage scaledImage = null;
            if (scale != 1.0f) {
                AffineTransformOp trans = new AffineTransformOp(AffineTransform.getScaleInstance(scale, scale), 2);
                if (image.getColorModel().getColorSpace().getType() == 6 && !image.getColorModel().hasAlpha()) {
                    scaledImage = trans.createCompatibleDestImage(image, image.getColorModel());
                    trans.filter(image, scaledImage);
                } else {
                    scaledImage = trans.filter(image, null);
                }
            } else {
                scaledImage = image;
            }
            int xOffset = (this.getWidth() - scaledImage.getWidth()) / 2;
            int yOffset = (this.getHeight() - scaledImage.getHeight()) / 2;
            this.drawingImage.createGraphics().drawImage((Image)scaledImage, xOffset, yOffset, null);
            this.markDirty();
        }
        this.sendPixels = true;
    }

    public void importDrawing(File file) throws IOException {
        try {
            this.importDrawing(file.getInputStream());
        }
        catch (IIOException ex) {
            throw new IIOException("Unsupported image format: " + file.getPath(), ex);
        }
    }

    public void exportDrawingToCSV(PrintWriter writer) {
        if (!this.drawingBlank) {
            writer.println(Dump.csv().encode("DRAWING"));
            writer.println(Dump.csv().encode(Double.toString(this.world.patchSize())));
            String colorString = HexString.toHexString(this.colors());
            Dump.csv().stringToCSV(writer, colorString);
        }
        writer.println();
    }

    public void setColors(int[] colors) {
        this.setUpDrawingImage();
        BufferedImage image = new BufferedImage(this.width, this.height, 2);
        image.setRGB(0, 0, this.width, this.height, colors, 0, this.width);
        Graphics2D dg = this.drawingImage.createGraphics();
        dg.drawImage((Image)image, 0, 0, null);
        this.drawingBlank = false;
        this.drawingDirty = true;
        this.sendPixels = true;
    }

    public void clearDrawing() {
        if (this.drawingImage != null) {
            this.setUpDrawingImage();
        }
    }

    public void stamp(Agent agent, boolean erase) {
        Graphics2DWrapper tg = new Graphics2DWrapper(this.getAndCreateDrawing(false).createGraphics());
        tg.antiAliasing(true);
        tg.setComposite(erase ? AlphaComposite.Clear : AlphaComposite.SrcOver);
        this.topology.prepareToPaint(this, this.width, this.height);
        if (agent instanceof Turtle) {
            this.turtleDrawer.drawTurtleShape(tg, this.topology, (Turtle)agent, this.world.patchSize());
        } else if (agent instanceof Link) {
            this.linkDrawer.drawLink(tg, this.topology, (Link)agent, this.world.patchSize(), false);
        }
        tg.antiAliasing(false);
        this.markDirty();
    }

    public void drawLine(double x1, double y1, double x2, double y2, Object penColor, double penSize, String penMode) {
        if (this.drawingImage == null) {
            this.setUpDrawingImage();
        }
        if (this.drawingImage != null) {
            Graphics2DWrapper tg = new Graphics2DWrapper((Graphics2D)this.drawingImage.getGraphics());
            tg.setPenWidth(penSize);
            if (penMode.equals("erase")) {
                tg.setComposite(AlphaComposite.Clear);
                this.drawWrappedLine(tg, x1, y1, x2, y2, penSize);
                tg.setComposite(AlphaComposite.SrcOver);
            } else {
                tg.antiAliasing(true);
                tg.setColor(Color.getColor(penColor));
                this.drawWrappedLine(tg, x1, y1, x2, y2, penSize);
                tg.antiAliasing(false);
            }
        }
    }

    private void drawWrappedLine(Graphics2DWrapper tg, double x1, double y1, double x2, double y2, double penSize) {
        double temp;
        double startX = x1;
        double startY = y1;
        double endX = x1;
        double endY = y1;
        if (endX < startX) {
            temp = endX;
            endX = startX;
            startX = temp;
        }
        if (endY < startY) {
            temp = endY;
            endY = startY;
            startY = temp;
        }
        double xdiff = x2 - x1;
        double ydiff = y2 - y1;
        double distX = x2 - x1;
        double distY = y2 - y1;
        double newStartX = 0.0;
        double newStartY = 0.0;
        double maxy = (double)this.world.maxPycor() + 0.4999999;
        double maxx = (double)this.world.maxPxcor() + 0.4999999;
        double miny = (double)this.world.minPycor() - 0.5;
        double minx = (double)this.world.minPxcor() - 0.5;
        double pixelSize = 1.0 / this.world.patchSize();
        do {
            endX = startX + distX;
            endY = startY + distY;
            if (endY < miny) {
                endX = (miny - startY) * xdiff / ydiff + startX;
                endY = miny;
                newStartY = maxy;
                newStartX = endX;
                if (newStartX == minx) {
                    newStartX = maxx;
                } else if (newStartX == maxx) {
                    newStartX = minx;
                }
            }
            if (endY > maxy) {
                endX = startX + (maxy - startY) * xdiff / ydiff;
                endY = maxy;
                newStartX = endX;
                newStartY = miny;
                if (newStartX == minx) {
                    newStartX = maxx;
                } else if (newStartX == maxx) {
                    newStartX = minx;
                }
            }
            if (endX < minx) {
                endX = minx;
                endY = ydiff * (endX - startX) / xdiff + startY;
                newStartX = maxx;
                newStartY = endY;
                if (newStartY == miny) {
                    newStartY = maxy;
                } else if (newStartY == maxy) {
                    newStartY = miny;
                }
            }
            if (endX > maxx) {
                endX = maxx;
                endY = ydiff * (endX - startX) / xdiff + startY;
                newStartX = minx;
                newStartY = endY;
                if (newStartY == miny) {
                    newStartY = maxy;
                } else if (newStartY == maxy) {
                    newStartY = miny;
                }
            }
            this.topology.drawLine(tg, startX, startY, endX, endY, penSize);
            startX = newStartX;
        } while (StrictMath.abs(distY -= endY - (startY = newStartY)) >= pixelSize || StrictMath.abs(distX -= endX - startX) >= pixelSize);
        this.markDirty();
    }

    public int fontSize() {
        throw new UnsupportedOperationException();
    }

    public double patchSize() {
        return this.world.patchSize();
    }

    public double viewWidth() {
        return this.world.worldWidth();
    }

    public double viewHeight() {
        return this.world.worldHeight();
    }

    public Perspective perspective() {
        throw new UnsupportedOperationException();
    }

    public double viewOffsetX() {
        throw new UnsupportedOperationException();
    }

    public double viewOffsetY() {
        throw new UnsupportedOperationException();
    }

    public boolean drawSpotlight() {
        throw new UnsupportedOperationException();
    }

    public boolean renderPerspective() {
        return false;
    }

    public boolean isHeadless() {
        throw new UnsupportedOperationException();
    }
}

