/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.sdm.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jhotdraw.contrib.DiamondFigure;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.standard.NullHandle;
import org.jhotdraw.standard.RelativeLocator;
import org.jhotdraw.util.Storable;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;
import org.nlogo.api.Editable;
import org.nlogo.api.Property;
import org.nlogo.sdm.Converter;
import org.nlogo.sdm.ModelElement;
import org.nlogo.sdm.gui.ModelElementFigure;
import org.nlogo.sdm.gui.Properties;
import org.nlogo.sdm.gui.Utils;
import org.nlogo.sdm.gui.WrappedConverter;
import org.nlogo.sdm.gui.Wrapper;
import org.nlogo.window.InterfaceColors;
import scala.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class ConverterFigure
extends DiamondFigure
implements ModelElementFigure,
Storable,
Editable {
    private Converter converter;
    private boolean dirty = false;

    public ConverterFigure() {
        this.setAttribute(FigureAttributeConstant.FILL_COLOR, InterfaceColors.SLIDER_BACKGROUND);
        this.converter = new Converter();
    }

    @Override
    public ModelElement getModelElement() {
        return this.converter;
    }

    @Override
    public boolean anyErrors() {
        return false;
    }

    @Override
    public void error(Object o, Exception e) {
    }

    @Override
    public Exception error(Object o) {
        return null;
    }

    @Override
    public int sourceOffset() {
        return 0;
    }

    public void draw(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.draw(g);
        if (this.converter != null) {
            String name;
            Color oldColor = g.getColor();
            if (!this.converter.isComplete()) {
                g.setColor(Color.RED);
            }
            if ((name = this.converter.getName()).length() == 0) {
                name = "?";
            }
            Utils.drawStringInBox(g, name, this.displayBox().x + 14, this.displayBox().y + 1 + this.displayBox().height / 2);
            g.setColor(oldColor);
        }
    }

    protected Rectangle invalidateRectangle(Rectangle r) {
        Rectangle box = super.invalidateRectangle(r);
        box.grow(this.converter.getName().length() * 10, this.converter.getName().length() * 10);
        return box;
    }

    public HandleEnumeration handles() {
        ArrayList<NullHandle> handles = new ArrayList<NullHandle>();
        handles.add(new NullHandle((Figure)this, RelativeLocator.southEast()));
        handles.add(new NullHandle((Figure)this, RelativeLocator.southWest()));
        handles.add(new NullHandle((Figure)this, RelativeLocator.northEast()));
        handles.add(new NullHandle((Figure)this, RelativeLocator.northWest()));
        return new HandleEnumerator(handles);
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(Wrapper.wrap(this.converter));
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.converter = ((WrappedConverter)dr.readStorable()).converter;
    }

    @Override
    public Option<String> helpLink() {
        return Option.apply(null);
    }

    @Override
    public List<Property> propertySet() {
        return Properties.converter();
    }

    @Override
    public String classDisplayName() {
        return "Variable";
    }

    @Override
    public boolean editFinished() {
        return true;
    }

    @Override
    public boolean dirty() {
        return this.dirty;
    }

    public void nameWrapper(String name) {
        this.dirty = this.dirty || !this.converter.getName().equals(name);
        this.converter.setName(name);
    }

    public String nameWrapper() {
        return this.converter.getName();
    }

    public void expressionWrapper(String expression) {
        this.dirty = this.dirty || !this.converter.getExpression().equals(expression);
        this.converter.setExpression(expression);
    }

    public String expressionWrapper() {
        return this.converter.getExpression();
    }
}

