/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape.editor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.nlogo.api.I18N;
import org.nlogo.api.Shape;
import org.nlogo.api.ShapeList;
import org.nlogo.shape.LinkLine;
import org.nlogo.shape.LinkShape;
import org.nlogo.shape.VectorShape;
import org.nlogo.shape.editor.DrawableList;
import org.nlogo.shape.editor.EditorDialog;
import org.nlogo.swing.ButtonPanel;
import org.nlogo.swing.Utils;

strictfp class LinkEditorDialog
extends JDialog
implements EditorDialog.VectorShapeContainer {
    private final JTextField name = new JTextField(10);
    private final JTextField curviness = new JTextField(10);
    private final JComboBox[] dashes = new JComboBox[3];
    private final LinkShape shape;
    private final LinkShape originalShape;
    private final DrawableList list;

    public void update(Shape originalShape, Shape newShape) {
        this.shape.setDirectionIndicator((VectorShape)newShape);
    }

    public boolean exists(String name) {
        return false;
    }

    LinkEditorDialog(DrawableList list, final LinkShape shape2, int x, int y) {
        super((Frame)null, true);
        this.originalShape = shape2;
        this.shape = (LinkShape)shape2.clone();
        this.list = list;
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                LinkEditorDialog.this.saveShape();
            }
        });
        Utils.addEscKeyAction(this, (Action)new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (!LinkEditorDialog.this.originalShape.toString().equals(LinkEditorDialog.this.getCurrentShape().toString()) && 0 != JOptionPane.showConfirmDialog(LinkEditorDialog.this, "You may lose changes made to this shape. Do you want to cancel anyway?", "Confirm Cancel", 0)) {
                    return;
                }
                LinkEditorDialog.this.dispose();
            }
        });
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gb);
        JLabel label = new JLabel("name: ");
        c.anchor = 17;
        this.add((Component)label, c);
        c.gridwidth = 0;
        this.name.setText(shape2.getName());
        this.add((Component)this.name, c);
        c.gridwidth = 1;
        label = new JLabel("direction indicator: ");
        this.add((Component)label, c);
        c.gridwidth = 0;
        JButton diButton = new JButton("Edit");
        this.add((Component)diButton, c);
        diButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new EditorDialog(LinkEditorDialog.this, (VectorShape)shape2.getDirectionIndicator(), LinkEditorDialog.this.getLocation().x, LinkEditorDialog.this.getLocation().y, false);
            }
        });
        c.gridwidth = 1;
        label = new JLabel("curviness: ");
        this.add((Component)label, c);
        c.gridwidth = 0;
        this.curviness.setText(Double.toString(shape2.curviness()));
        this.add((Component)this.curviness, c);
        for (int i = 0; i < this.dashes.length; ++i) {
            this.dashes[i] = new JComboBox((E[])LinkLine.dashChoices);
            this.dashes[i].setRenderer(new DashCellRenderer());
            this.dashes[i].setSelectedItem(shape2.getDashes(i));
        }
        c.gridwidth = 1;
        this.add((Component)new JLabel("left line"), c);
        c.gridwidth = 0;
        this.add((Component)this.dashes[2], c);
        c.gridwidth = 1;
        this.add((Component)new JLabel("middle line"), c);
        c.gridwidth = 0;
        this.add((Component)this.dashes[1], c);
        c.gridwidth = 1;
        this.add((Component)new JLabel("right line"), c);
        c.gridwidth = 0;
        this.add((Component)this.dashes[0], c);
        JButton cancel = new JButton(I18N.guiJ().get("common.buttons.cancel"));
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LinkEditorDialog.this.dispose();
            }
        });
        JButton done = new JButton(I18N.guiJ().get("common.buttons.ok"));
        done.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LinkEditorDialog.this.saveShape();
                LinkEditorDialog.this.setVisible(false);
                LinkEditorDialog.this.dispose();
            }
        });
        ButtonPanel buttonPanel = new ButtonPanel(new JButton[]{done, cancel});
        c.anchor = 13;
        this.add((Component)buttonPanel, c);
        this.setLocation(x + 10, y + 10);
        this.setTitle("Link Shape");
        this.name.setEnabled(!ShapeList.isDefaultShapeName(shape2.getName()));
        list.update();
        this.pack();
        this.getRootPane().setDefaultButton(done);
        if (ShapeList.isDefaultShapeName(shape2.getName())) {
            this.curviness.requestFocus();
        } else {
            this.name.requestFocus();
        }
        this.setVisible(true);
    }

    void saveShape() {
        String nameStr;
        if (this.name.getText().equals("")) {
            nameStr = JOptionPane.showInputDialog(this, "Name:", "Name Shape", -1);
            if (nameStr == null) {
                return;
            }
        } else {
            nameStr = this.name.getText();
        }
        nameStr = nameStr.toLowerCase();
        this.shape.setName(nameStr);
        String originalName = this.originalShape.getName();
        if (this.list.exists(nameStr) && !nameStr.equals(originalName) && 0 != JOptionPane.showConfirmDialog(this, "A shape with this name already exists. Do you want to replace it?", "Confirm Overwrite", 0)) {
            return;
        }
        double cv = 0.0;
        String str = this.curviness.getText();
        while (str != null) {
            try {
                cv = Double.parseDouble(str);
                str = null;
            }
            catch (NumberFormatException e) {
                str = JOptionPane.showInputDialog(this, "Curviness:", "Enter a number", -1);
            }
        }
        this.shape.curviness(cv);
        for (int i = 0; i < this.dashes.length; ++i) {
            int index = this.dashes[i].getSelectedIndex();
            this.shape.setLineVisible(i, index != 0);
            this.shape.setDashiness(i, LinkLine.dashChoices[index]);
        }
        this.list.update(this.originalShape, this.shape);
        this.dispose();
    }

    private LinkShape getCurrentShape() {
        LinkShape currentShape = (LinkShape)this.shape.clone();
        currentShape.setName(this.name.getText());
        currentShape.curviness(Double.parseDouble(this.curviness.getText()));
        for (int i = 0; i < this.dashes.length; ++i) {
            int index = this.dashes[i].getSelectedIndex();
            currentShape.setLineVisible(i, index != 0);
            currentShape.setDashiness(i, LinkLine.dashChoices[index]);
        }
        return currentShape;
    }

    private strictfp class DashCellRenderer
    implements ListCellRenderer {
        private DashCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            final Object obj = value;
            return new Component(){
                private final Dimension dimension = new Dimension(85, 18);

                public Dimension getMinimumSize() {
                    return this.dimension;
                }

                public Dimension getPreferredSize() {
                    return this.dimension;
                }

                public Dimension getMaximumSize() {
                    return this.dimension;
                }

                public void paint(Graphics g) {
                    float[] arry = (float[])obj;
                    if (arry.length == 2 && arry[0] == 0.0f && arry[1] == 1.0f) {
                        return;
                    }
                    Graphics2D g2 = (Graphics2D)g;
                    Dimension d = this.getMinimumSize();
                    g2.setColor(Color.black);
                    g2.setStroke(new BasicStroke(1.0f, 1, 1, 1.0f, (float[])obj, 0.0f));
                    g2.drawLine(0, d.height / 2, d.width, d.height / 2);
                }
            };
        }
    }
}

