/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape.editor;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.nlogo.api.Graphics2DWrapper;
import org.nlogo.shape.Circle;
import org.nlogo.shape.Element;
import org.nlogo.shape.Line;
import org.nlogo.shape.Polygon;
import org.nlogo.shape.Rectangle;
import org.nlogo.shape.VectorShape;
import org.nlogo.shape.editor.EditorDialog;

strictfp class ShapeView
extends JPanel
implements Observer {
    private final VectorShape shape;
    private final EditorDialog editorDialog;
    private Point start;
    private Point last;
    private Point previous;
    private Element tempElement;
    private Element selectedElement = null;
    private Point[] handles;
    private boolean draggingHandle = false;
    private boolean draggingElement = false;
    private boolean drawingPolygon = false;
    private int handleIndex;
    private static final boolean IS_MAC = System.getProperty("os.name").startsWith("Mac");
    private double gridGapX;
    private double gridGapY;

    ShapeView(EditorDialog editorDialog, VectorShape shape2) {
        this.gridGapX = (double)this.getBounds().width / 20.0;
        this.gridGapY = (double)this.getBounds().height / 20.0;
        this.editorDialog = editorDialog;
        this.shape = shape2;
        this.setBackground(Color.DARK_GRAY.darker().darker());
        this.setOpaque(true);
        this.setCursor(Cursor.getPredefinedCursor(1));
        MouseInputAdapter handler = new MouseInputAdapter(){

            public void mousePressed(MouseEvent e) {
                ShapeView.this.mousePressed(e);
            }

            public void mouseMoved(MouseEvent e) {
                ShapeView.this.mouseMoved(e);
            }

            public void mouseDragged(MouseEvent e) {
                ShapeView.this.mouseDragged(e);
            }

            public void mouseReleased(MouseEvent e) {
                ShapeView.this.mouseReleased(e);
            }
        };
        this.addMouseListener(handler);
        this.addMouseMotionListener(handler);
    }

    public int getHandleIndex() {
        return this.handleIndex;
    }

    public Element getSelectedElement() {
        return this.selectedElement;
    }

    public boolean hasSelectedElement() {
        return this.selectedElement != null;
    }

    public boolean drawingPolygon() {
        return this.drawingPolygon;
    }

    public void setDrawingPolygon(boolean drawing) {
        this.drawingPolygon = drawing;
    }

    public void selectElement(Element el) {
        this.selectedElement = el;
        el.select();
    }

    public void setTempElement(Element el) {
        this.tempElement = el;
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 300);
    }

    public Dimension getMinimumSize() {
        return new Dimension(300, 300);
    }

    public Dimension getMaximumSize() {
        return new Dimension(300, 300);
    }

    public void update(Observable o, Object rect) {
        if (rect == null) {
            this.repaint();
        } else {
            this.repaint((java.awt.Rectangle)rect);
        }
    }

    public void snapPointToGrid(Point pointToChange) {
        double clickedGridX = (double)((int)(pointToChange.getX() / this.gridGapX)) * this.gridGapX;
        double clickedGridY = (double)((int)(pointToChange.getY() / this.gridGapY)) * this.gridGapY;
        if (pointToChange.getX() < clickedGridX + this.gridGapX / 2.0) {
            if (pointToChange.getY() < clickedGridY + this.gridGapY / 2.0) {
                pointToChange.setLocation(clickedGridX, clickedGridY);
            } else {
                pointToChange.setLocation(clickedGridX, clickedGridY + this.gridGapY);
            }
        } else if (pointToChange.getY() < clickedGridY + this.gridGapY / 2.0) {
            pointToChange.setLocation(clickedGridX + this.gridGapX, clickedGridY);
        } else {
            pointToChange.setLocation(clickedGridX + this.gridGapX, clickedGridY + this.gridGapY);
        }
    }

    public void selfFinishPolygon(boolean add2) {
        if (this.tempElement instanceof Polygon) {
            ((Polygon)this.tempElement).selfClose();
            this.tempElement.setFilled(this.editorDialog.fillShapes());
            this.editorDialog.makeUndoableDraw(this.tempElement);
            if (add2) {
                this.shape.add(this.tempElement);
            }
            this.drawingPolygon = false;
            this.tempElement = null;
        }
    }

    public void paintComponent(Graphics g) {
        int i;
        super.paintComponent(g);
        Graphics2DWrapper g2 = new Graphics2DWrapper((Graphics2D)g);
        java.awt.Rectangle bounds = this.getBounds();
        List<Element> elements2 = this.shape.getElements();
        if (this.editorDialog.isRotatable()) {
            g.setColor(Color.DARK_GRAY.darker());
            g.fillRect(0, 0, bounds.width, bounds.height);
            g.setColor(Color.BLACK);
            g.fillOval(0, 0, bounds.width, bounds.height);
        }
        this.gridGapX = (double)bounds.width / 20.0;
        this.gridGapY = (double)bounds.height / 20.0;
        g.setColor(Color.DARK_GRAY.darker());
        for (i = 1; i < 20; ++i) {
            g.drawLine(i * Element.round(this.gridGapX), 0, i * Element.round(this.gridGapX), bounds.height);
            g.drawLine(0, i * Element.round(this.gridGapY), bounds.width, i * Element.round(this.gridGapY));
        }
        g.setColor(Color.DARK_GRAY);
        g.drawLine(bounds.width / 2, 0, bounds.width / 2, bounds.height);
        g.drawLine(0, bounds.height / 2, bounds.width, bounds.width / 2);
        g.drawLine(0, 20 * Element.round(this.gridGapY), bounds.width, 20 * Element.round(this.gridGapY));
        g2.antiAliasing(true);
        for (i = 0; i < elements2.size(); ++i) {
            Element element = elements2.get(i);
            g.setColor(element.getColor());
            element.draw(g2, null, IS_MAC ? 299.0 : 300.0, 0.0);
        }
        if (this.tempElement != null) {
            g.setColor(this.editorDialog.getElementColor());
            this.tempElement.draw(g2, null, IS_MAC ? 299.0 : 300.0, 0.0);
        }
        if (this.hasSelectedElement()) {
            this.handles = this.getSelectedElement().getHandles();
            for (i = 0; i < this.handles.length; ++i) {
                g.setColor(Color.WHITE);
                g.drawRect(this.handles[i].x - 2, this.handles[i].y - 2, 4, 4);
                g.setColor(Color.BLACK);
                g.fillRect(this.handles[i].x - 1, this.handles[i].y - 1, 3, 3);
            }
        }
    }

    int checkHandles(Point start2) {
        for (int i = 0; i < this.handles.length; ++i) {
            if (start2.x >= this.handles[i].x + 3 || start2.x <= this.handles[i].x - 3 || start2.y >= this.handles[i].y + 3 || start2.y <= this.handles[i].y - 3) continue;
            return i;
        }
        return -1;
    }

    void selectHandle(int index, Element lastElement) {
        this.draggingHandle = true;
        this.handleIndex = index;
        lastElement.setModifiedPoint(this.handles[index]);
        this.editorDialog.makeUndoableModification(this.selectedElement, this.shape.getElements().indexOf(this.selectedElement));
    }

    void deselectAll() {
        for (int i = 0; i < this.shape.getElements().size(); ++i) {
            this.shape.getElements().get(i).deselect();
        }
        this.selectedElement = null;
        this.shape.changed();
        this.repaint();
    }

    private void checkElements(Point start2) {
        for (int i = this.shape.getElements().size() - 1; i >= 0; --i) {
            int spIndex;
            Element currentElement = this.shape.getElements().get(i);
            if (this.hasSelectedElement() && (spIndex = this.checkHandles(start2)) != -1) {
                this.selectHandle(spIndex, this.selectedElement);
                return;
            }
            if (!currentElement.contains(start2)) continue;
            this.draggingElement = true;
            if (this.hasSelectedElement()) {
                this.selectedElement.deselect();
            }
            currentElement.select();
            this.selectedElement = currentElement;
            this.editorDialog.makeUndoableModification(this.selectedElement, this.shape.getElements().indexOf(this.selectedElement));
            this.shape.changed();
            this.repaint();
            return;
        }
        this.deselectAll();
        this.repaint();
    }

    private void mousePressed(MouseEvent e) {
        this.start = this.last = e.getPoint();
        if (this.editorDialog.editingElements()) {
            this.checkElements(this.start);
        }
        if (this.editorDialog.snapToGrid()) {
            this.snapPointToGrid(this.start);
        }
        if (this.tempElement instanceof Polygon) {
            ((Polygon)this.tempElement).addNewPoint(this.start);
            this.repaint();
        } else if (this.editorDialog.getElementType() == Polygon.class) {
            this.tempElement = this.createElement(this.start, this.start);
            this.editorDialog.makeUndoableUnfinishedPolygon();
            this.drawingPolygon = true;
        }
    }

    private void mouseMoved(MouseEvent e) {
        this.last = e.getPoint();
        if (this.editorDialog.snapToGrid()) {
            this.snapPointToGrid(this.last);
        }
        if (this.tempElement instanceof Polygon) {
            ((Polygon)this.tempElement).modifyPoint(this.last);
            this.repaint();
        }
    }

    private void mouseDragged(MouseEvent e) {
        this.previous = this.last;
        this.last = e.getPoint();
        if (this.editorDialog.snapToGrid()) {
            this.snapPointToGrid(this.last);
        }
        if (this.editorDialog.editingElements()) {
            if (this.draggingHandle) {
                this.selectedElement.reshapeElement(this.handles[this.handleIndex], this.last);
            } else if (this.draggingElement) {
                this.selectedElement.moveElement(this.last.x - this.previous.x, this.last.y - this.previous.y);
            }
            this.repaint();
        }
        if (this.editorDialog.getElementType() != Polygon.class) {
            if (this.tempElement == null) {
                this.tempElement = this.createElement(this.start, this.last);
            } else {
                this.tempElement.modify(this.start, this.last);
            }
            this.repaint();
        }
    }

    private void mouseReleased(MouseEvent e) {
        if (this.editorDialog.editingElements()) {
            if (this.draggingHandle) {
                this.draggingHandle = false;
                this.shape.changed();
            } else if (this.draggingElement) {
                this.draggingElement = false;
                this.shape.changed();
            }
        }
        if (!(this.tempElement instanceof Polygon) || e.getClickCount() == 2) {
            if (this.tempElement != null) {
                if (this.tempElement instanceof Polygon) {
                    ((Polygon)this.tempElement).finishUp();
                }
                if (!(this.tempElement instanceof Polygon) || ((Polygon)this.tempElement).getXcoords().size() >= 3) {
                    this.tempElement.setFilled(this.editorDialog.fillShapes());
                    this.shape.add(this.tempElement);
                    this.editorDialog.makeUndoableDraw(this.tempElement);
                    this.tempElement.select();
                    this.selectedElement = this.tempElement;
                    this.editorDialog.setEditingElements(true);
                    this.shape.changed();
                }
                this.drawingPolygon = false;
                this.tempElement = null;
            }
            this.previous = null;
            this.last = null;
            this.start = null;
            this.repaint();
        }
    }

    private Element createElement(Point start2, Point last2) {
        if (!this.editorDialog.editingElements()) {
            if (this.editorDialog.getElementType() == Line.class) {
                return new Line(start2, last2, this.editorDialog.getElementColor());
            }
            if (this.editorDialog.getElementType() == Rectangle.class) {
                return new Rectangle(start2, last2, this.editorDialog.getElementColor());
            }
            if (this.editorDialog.getElementType() == Circle.class) {
                return new Circle(start2, last2, this.editorDialog.getElementColor());
            }
            if (this.editorDialog.getElementType() == Polygon.class) {
                return new Polygon(start2, this.editorDialog.getElementColor());
            }
        }
        return null;
    }
}

