/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public strictfp class NonemptyTextFieldButtonEnabler
implements DocumentListener {
    private final JButton target;
    private final Set<JTextField> fields;
    private boolean enabled;

    public NonemptyTextFieldButtonEnabler(JButton target) {
        this.target = target;
        this.fields = new HashSet<JTextField>();
        this.enabled = true;
    }

    public void addRequiredField(JTextField field) {
        field.getDocument().addDocumentListener(this);
        this.fields.add(field);
        this.update();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.update();
    }

    private void update() {
        this.target.setEnabled(this.areFieldsNotEmpty());
    }

    private boolean areFieldsNotEmpty() {
        if (!this.enabled) {
            return false;
        }
        for (JTextField field : this.fields) {
            if (field.getDocument().getLength() != 0) continue;
            return false;
        }
        return true;
    }

    public void changedUpdate(DocumentEvent e) {
        this.update();
    }

    public void insertUpdate(DocumentEvent e) {
        this.update();
    }

    public void removeUpdate(DocumentEvent e) {
        this.update();
    }
}

