/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import org.nlogo.awt.Fonts;
import org.nlogo.swing.Printable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class PrinterManager {
    private final String fileName;
    private List<List<Object>> textPages;
    private final Font printFont = new Font("Monospaced", 0, 9);

    private PrinterManager(String fileName) {
        this.fileName = fileName;
        this.textPages = null;
    }

    public static void print(final Printable p, String fileName) throws PrinterAbortException, PrinterException {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        final PrinterManager printer = new PrinterManager(fileName);
        printerJob.setPrintable(new java.awt.print.Printable(){

            public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
                if (System.getProperty("os.name").startsWith("Mac") && System.getProperty("os.version").startsWith("10.5")) {
                    g.setFont(printer.printFont);
                }
                return p.print(g, pageFormat, pageIndex, printer);
            }
        }, printerJob.pageDialog(printerJob.defaultPage()));
        if (printerJob.printDialog()) {
            printerJob.print();
        }
    }

    protected String getFooter(int pageNum, int pageWidth, FontMetrics fm) {
        String pageNumString = " - page " + pageNum;
        String shortFileName = Fonts.shortenStringToFit(this.fileName, pageWidth - fm.stringWidth(pageNumString), fm);
        return shortFileName + pageNumString;
    }

    private List<List<Object>> buildTextPages(Graphics g, PageFormat pageFormat, String text) throws IOException {
        ArrayList<List<Object>> pages = new ArrayList<List<Object>>();
        ArrayList<Object> lines2 = new ArrayList<Object>();
        Point2D.Float pen = new Point2D.Float();
        float wrappingWidth = (float)pageFormat.getImageableWidth();
        Graphics2D g2d = (Graphics2D)g;
        TextLayout defaultLayout = new TextLayout(" ", this.printFont, g2d.getFontRenderContext());
        float layoutDescent = defaultLayout.getDescent();
        float layoutAscent = defaultLayout.getAscent();
        double pageHeight = pageFormat.getImageableHeight() - (double)(2.0f * (defaultLayout.getLeading() + layoutDescent + layoutAscent));
        LineNumberReader lineReader = new LineNumberReader(new StringReader(text));
        String nextLine = lineReader.readLine();
        while (nextLine != null) {
            if (nextLine.length() == 0) {
                pen.y += layoutAscent + layoutDescent;
                if ((double)pen.y < pageHeight) {
                    lines2.add(nextLine);
                    pen.y += defaultLayout.getLeading();
                } else {
                    pages.add(lines2);
                    lines2 = new ArrayList();
                    lines2.add(nextLine);
                    pen = new Point2D.Float();
                    pen.y += defaultLayout.getLeading() + layoutDescent + layoutAscent;
                }
                nextLine = lineReader.readLine();
                continue;
            }
            AttributedString formattedText = new AttributedString(nextLine);
            formattedText.addAttribute(TextAttribute.FONT, this.printFont);
            AttributedCharacterIterator charIterator = formattedText.getIterator();
            LineBreakMeasurer measurer = new LineBreakMeasurer(charIterator, g2d.getFontRenderContext());
            while (measurer.getPosition() < charIterator.getEndIndex()) {
                TextLayout layout = measurer.nextLayout(wrappingWidth);
                pen.y += layoutAscent + layoutDescent;
                if ((double)pen.y < pageHeight) {
                    lines2.add(layout);
                    pen.y += layout.getLeading();
                    continue;
                }
                pages.add(lines2);
                lines2 = new ArrayList();
                lines2.add(layout);
                pen = new Point2D.Float();
                pen.y += layout.getLeading() + layoutDescent + layoutAscent;
            }
            nextLine = lineReader.readLine();
        }
        pages.add(lines2);
        return pages;
    }

    public int printText(Graphics g, PageFormat pageFormat, int pageIndex, String text) throws IOException {
        if (this.textPages == null) {
            this.textPages = this.buildTextPages(g, pageFormat, text);
        }
        if (pageIndex >= this.textPages.size()) {
            return 1;
        }
        float wrappingWidth = (float)pageFormat.getImageableWidth();
        Graphics2D g2d = (Graphics2D)g;
        TextLayout defaultLayout = new TextLayout(" ", this.printFont, g2d.getFontRenderContext());
        float layoutDescent = defaultLayout.getDescent();
        float layoutAscent = defaultLayout.getAscent();
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        List<Object> lines2 = this.textPages.get(pageIndex);
        Point2D.Float pen = new Point2D.Float();
        for (int i = 0; i < lines2.size(); ++i) {
            if (!(lines2.get(i) instanceof TextLayout)) {
                pen.y += defaultLayout.getLeading() + layoutDescent + layoutAscent;
                continue;
            }
            TextLayout layout = (TextLayout)lines2.get(i);
            pen.y += layoutAscent;
            layout.draw(g2d, pen.x, pen.y);
            pen.y += layoutDescent + layout.getLeading();
        }
        String footer = this.getFooter(pageIndex + 1, (int)StrictMath.floor(pageFormat.getImageableWidth()), g.getFontMetrics(this.printFont));
        TextLayout footerLayout = new TextLayout(footer, this.printFont, g2d.getFontRenderContext());
        pen.x = (wrappingWidth - footerLayout.getAdvance()) / 2.0f;
        pen.y = (float)pageFormat.getImageableHeight() - layoutDescent;
        footerLayout.draw(g2d, pen.x, pen.y);
        return 0;
    }
}

