/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.util.Iterator;
import java.util.List;
import org.nlogo.api.CompilerException;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.Dump;
import org.nlogo.api.Editable;
import org.nlogo.api.I18N;
import org.nlogo.api.LogoList;
import org.nlogo.api.ModelReader;
import org.nlogo.api.Property;
import org.nlogo.window.Chooser;
import org.nlogo.window.Properties;
import org.nlogo.window.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class DummyChooserWidget
extends Chooser
implements Editable {
    public DummyChooserWidget(CompilerServices compiler) {
        super(compiler);
        this.setBorder(this.widgetBorder());
    }

    @Override
    public void updateConstraints() {
    }

    @Override
    public String classDisplayName() {
        return I18N.guiJ().get("tabs.run.widgets.chooser");
    }

    @Override
    public List<Property> propertySet() {
        return Properties.dummyChooser();
    }

    @Override
    public boolean editFinished() {
        super.editFinished();
        this.name(this.name());
        return true;
    }

    public String choicesWrapper() {
        StringBuilder buf = new StringBuilder();
        Iterator<Object> it = this.constraint.acceptedValues().iterator();
        while (it.hasNext()) {
            buf.append(Dump.logoObject(it.next(), true, false));
            buf.append('\n');
        }
        return buf.toString();
    }

    public void choicesWrapper(String choicesString) {
        try {
            Object oldValue = this.value();
            LogoList newChoices = (LogoList)this.compiler.readFromString("[ " + choicesString + " ]");
            this.constraint.acceptedValues(newChoices);
            int newIndex = this.constraint.indexForValue(oldValue);
            if (newIndex == -1) {
                this.index(0);
            } else {
                this.index(newIndex);
            }
        }
        catch (CompilerException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Object load(String[] strings, Widget.LoadHelper helper) {
        int x1 = Integer.parseInt(strings[1]);
        int y1 = Integer.parseInt(strings[2]);
        int x2 = Integer.parseInt(strings[3]);
        int y2 = Integer.parseInt(strings[4]);
        this.setSize(x2 - x1, y2 - y1);
        this.name(ModelReader.restoreLines(strings[5]));
        this.choicesWrapper(strings[7]);
        this.index(Integer.parseInt(strings[8]));
        return this;
    }

    @Override
    public String save() {
        StringBuilder s = new StringBuilder();
        s.append("CHOOSER\n");
        s.append(this.getBoundsString());
        if (null != this.name() && !this.name().trim().equals("")) {
            s.append(this.name() + "\n");
            s.append(this.name() + "\n");
        } else {
            s.append("NIL\n");
            s.append("NIL\n");
        }
        s.append(this.choicesWrapper().trim().replaceAll("\n", " ") + "\n");
        s.append(this.index() + "\n");
        return s.toString();
    }
}

