/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.List;
import org.nlogo.api.Editable;
import org.nlogo.api.I18N;
import org.nlogo.api.Property;
import org.nlogo.awt.Fonts;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.Properties;
import org.nlogo.window.SingleErrorWidget;
import org.nlogo.window.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class DummyMonitorWidget
extends SingleErrorWidget
implements Editable {
    private static final int LEFT_MARGIN = 5;
    private static final int RIGHT_MARGIN = 6;
    private static final int BOTTOM_MARGIN = 6;
    private String name = "";
    private static final int MIN_WIDTH = 50;
    private static final int MAX_HEIGHT = 49;
    private int decimalPlaces = 3;

    public DummyMonitorWidget() {
        this.setOpaque(true);
        this.setBackground(InterfaceColors.MONITOR_BACKGROUND);
        this.setBorder(this.widgetBorder());
        Fonts.adjustDefaultFont(this);
    }

    public void name(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    @Override
    public String displayName() {
        return this.name;
    }

    @Override
    public String classDisplayName() {
        return I18N.guiJ().get("tabs.run.widgets.monitor");
    }

    @Override
    public List<Property> propertySet() {
        return Properties.dummyMonitor();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(50, 49);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(10000, 49);
    }

    @Override
    public Dimension getPreferredSize(Font font) {
        Dimension size2 = this.getMinimumSize();
        int pad = 12;
        FontMetrics fontMetrics = this.getFontMetrics(font);
        size2.width = StrictMath.max(size2.width, fontMetrics.stringWidth(this.displayName()) + pad);
        size2.height = StrictMath.max(size2.height, fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + pad);
        return size2;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        FontMetrics fm = g.getFontMetrics();
        int labelHeight = fm.getMaxDescent() + fm.getMaxAscent();
        Dimension d = this.getSize();
        g.setColor(this.getForeground());
        String displayName = this.displayName();
        int boxHeight = (int)StrictMath.ceil((double)labelHeight * 1.4);
        g.drawString(displayName, 5, d.height - 6 - boxHeight - fm.getMaxDescent() - 1);
        g.setColor(Color.WHITE);
        g.fillRect(5, d.height - 6 - boxHeight, d.width - 5 - 6 - 1, boxHeight);
        g.setColor(Color.BLACK);
    }

    public int decimalPlaces() {
        return this.decimalPlaces;
    }

    public void decimalPlaces(int decimalPlaces) {
        if (decimalPlaces != this.decimalPlaces) {
            this.decimalPlaces = decimalPlaces;
        }
    }

    @Override
    public String save() {
        StringBuilder s = new StringBuilder();
        s.append("MONITOR\n");
        s.append(this.getBoundsString());
        if (null != this.name() && !this.name().trim().equals("")) {
            s.append(this.name() + "\n");
        } else {
            s.append("NIL\n");
        }
        s.append("NIL\n");
        s.append(this.decimalPlaces + "\n");
        s.append("1\n");
        return s.toString();
    }

    @Override
    public Object load(String[] strings, Widget.LoadHelper helper) {
        String displayName = strings[5];
        if (displayName.equals("NIL")) {
            this.name("");
        } else {
            this.name(displayName);
        }
        if (strings.length > 7) {
            this.decimalPlaces = Integer.parseInt(strings[7]);
        }
        int x1 = Integer.parseInt(strings[1]);
        int y1 = Integer.parseInt(strings[2]);
        int x2 = Integer.parseInt(strings[3]);
        int y2 = Integer.parseInt(strings[4]);
        this.setSize(x2 - x1, y2 - y1);
        return this;
    }
}

