/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.nlogo.awt.EventQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class Event {
    private Thread raisingThread = null;
    public static boolean logEvents = false;
    private static Map<Object, Map<Class<?>, List<Handler>>> handlers = new HashMap();
    private static List<Object[]> recentEvents = new ArrayList<Object[]>();
    private static int nestingDepth = 0;
    private static Map<Class<?>, Set<Class<? extends Event>>> eventsHandledMap = new HashMap();

    public abstract void beHandledBy(Handler var1);

    public static String recentEventTrace() {
        EventQueue.mustBeEventDispatchThread();
        StringBuilder buf = new StringBuilder();
        for (Object[] info : recentEvents) {
            Event event = (Event)info[0];
            Object raiser = info[1];
            Thread thread = (Thread)info[2];
            Date time = (Date)info[3];
            String timeString = new SimpleDateFormat("hh:mm:ss.SSS").format(time);
            buf.append(timeString + " " + Event.eventName(event) + " (" + Event.readableName(raiser) + ") " + thread.getName() + "\n");
        }
        return buf.toString();
    }

    public static void rehash() {
        handlers.clear();
    }

    private static String eventName(Object o) {
        String longName = o.getClass().getName();
        String shorterName = longName.substring(longName.lastIndexOf(46) + 1);
        return shorterName.substring(shorterName.lastIndexOf(36) + 1);
    }

    private static String readableName(Object o) {
        Class<?> clazz = o.getClass();
        String longName = clazz.getName();
        while (clazz.getName().indexOf(36) != -1) {
            clazz = clazz.getSuperclass();
        }
        if (clazz == o.getClass()) {
            return longName;
        }
        return longName + " (" + clazz.getName() + ")";
    }

    public void raiseLater(final Object raiser) {
        this.raisingThread = Thread.currentThread();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Event.this.doRaise(raiser);
            }
        });
    }

    public void raise(Object raiser) {
        this.raisingThread = Thread.currentThread();
        this.doRaise(raiser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRaise(Object raiser) {
        EventQueue.mustBeEventDispatchThread();
        int oldNestingDepth = nestingDepth++;
        try {
            List<Handler> handlersV;
            recentEvents.add(0, new Object[]{this, raiser, this.raisingThread, new Date()});
            if (recentEvents.size() > 10) {
                recentEvents.remove(recentEvents.size() - 1);
            }
            Class<?> eventClass = this.getClass();
            String name = Event.eventName(this);
            if (logEvents && !name.equals("PeriodicUpdateEvent") && !name.equals("InterfaceGlobalEvent")) {
                for (int i = 0; i < oldNestingDepth; ++i) {
                    System.out.print(' ');
                }
                System.out.println("raising " + name + ": " + Event.readableName(raiser));
            }
            if (raiser == null) {
                throw new IllegalStateException("event raised with null raiser");
            }
            Map<Class<?>, List<Handler>> events = handlers.get(raiser);
            if (null == events) {
                events = new HashMap();
                handlers.put(raiser, events);
            }
            if (null == (handlersV = events.get(eventClass))) {
                handlersV = this.findHandlers(this.findTop(raiser), eventClass);
                events.put(eventClass, handlersV);
            }
            for (Handler handler : handlersV) {
                if (logEvents && !name.equals("PeriodicUpdateEvent") && !name.equals("InterfaceGlobalEvent")) {
                    for (int i = 0; i < nestingDepth; ++i) {
                        System.out.print(' ');
                    }
                    System.out.println("handling " + Event.eventName(this) + ": " + Event.readableName(handler));
                }
                this.beHandledBy(handler);
            }
            --nestingDepth;
        }
        finally {
            nestingDepth = oldNestingDepth;
        }
    }

    private Component findTop(Object top) {
        while (top != null) {
            Component parent = null;
            if (top instanceof LinkChild) {
                Object linkParent = ((LinkChild)top).getLinkParent();
                while (linkParent != null && !(linkParent instanceof Component)) {
                    linkParent = ((LinkChild)linkParent).getLinkParent();
                }
                parent = (Component)linkParent;
            } else if (top instanceof Component && !(top instanceof Window)) {
                parent = ((Component)top).getParent();
            }
            if (null == parent) break;
            top = parent;
        }
        return (Component)top;
    }

    private List<Handler> findHandlers(Object top, Class<? extends Event> eventClass) {
        int i;
        ArrayList<Handler> result = new ArrayList<Handler>();
        if (top instanceof Container) {
            Component[] comps = ((Container)top).getComponents();
            for (i = 0; i < comps.length; ++i) {
                result.addAll(this.findHandlers(comps[i], eventClass));
            }
        }
        if (top instanceof LinkParent) {
            Object[] objs = ((LinkParent)top).getLinkChildren();
            for (i = 0; i < objs.length; ++i) {
                result.addAll(this.findHandlers(objs[i], eventClass));
            }
        }
        if (this.isHandler(top, eventClass)) {
            result.add((Handler)top);
        }
        return result;
    }

    private boolean isHandler(Object comp, Class<? extends Event> eventClass) {
        if (!(comp instanceof Handler)) {
            return false;
        }
        Handler handler = (Handler)comp;
        Set<Class<? extends Event>> eventsHandled = eventsHandledMap.get(comp.getClass());
        if (eventsHandled == null) {
            eventsHandled = new HashSet<Class<? extends Event>>();
            eventsHandledMap.put(comp.getClass(), eventsHandled);
            for (Class<?> handlerClass = handler.getClass(); handlerClass != null; handlerClass = handlerClass.getSuperclass()) {
                Class<?>[] interfaces = Event.getAllInterfaces(handlerClass);
                for (int i = 0; i < interfaces.length; ++i) {
                    String interfaceName = interfaces[i].getName();
                    if (!interfaceName.endsWith("$Handler")) continue;
                    eventsHandled.add(this.eventClassForHandlerClassName(interfaceName.substring(0, interfaceName.length() - 8)));
                }
            }
        }
        return eventsHandled.contains(eventClass);
    }

    private Class<? extends Event> eventClassForHandlerClassName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static Class<?>[] getAllInterfaces(Class<?> theClass) {
        ArrayList<Class> result = new ArrayList<Class>();
        Stack stack = new Stack();
        stack.addElement(theClass);
        while (!stack.empty()) {
            theClass = (Class)stack.pop();
            if (theClass.isInterface()) {
                result.add(theClass);
            } else if (theClass.getSuperclass() != null) {
                stack.push(theClass.getSuperclass());
            }
            Class<?>[] interfaces = theClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                stack.push(interfaces[i]);
            }
        }
        return result.toArray(new Class[result.size()]);
    }

    public static interface LinkParent {
        public Object[] getLinkChildren();
    }

    public static interface LinkChild {
        public Object getLinkParent();
    }

    public static interface Handler {
    }
}

