/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.BooleanConstraint;
import org.nlogo.agent.Importer;
import org.nlogo.agent.Observer;
import org.nlogo.agent.OutputObject;
import org.nlogo.agent.SliderConstraint;
import org.nlogo.agent.World;
import org.nlogo.api.Agent;
import org.nlogo.api.CommandRunnable;
import org.nlogo.api.CompilerException;
import org.nlogo.api.DrawingInterface;
import org.nlogo.api.File;
import org.nlogo.api.I18N;
import org.nlogo.api.JobOwner;
import org.nlogo.api.LogoException;
import org.nlogo.api.ModelSectionJ;
import org.nlogo.api.ModelTypeJ;
import org.nlogo.api.PerspectiveJ;
import org.nlogo.api.RendererInterface;
import org.nlogo.api.ReporterRunnable;
import org.nlogo.api.Shape;
import org.nlogo.api.SimpleJobOwner;
import org.nlogo.api.SourceOwner;
import org.nlogo.api.TrailDrawerInterface;
import org.nlogo.api.WorldDimensions;
import org.nlogo.api.WorldPropertiesInterface;
import org.nlogo.awt.MovieEncoder;
import org.nlogo.awt.UserCancelException;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.HaltException;
import org.nlogo.nvm.Instruction;
import org.nlogo.nvm.Procedure;
import org.nlogo.nvm.Workspace;
import org.nlogo.plot.Plot;
import org.nlogo.shape.InvalidShapeDescriptionException;
import org.nlogo.shape.LinkShape;
import org.nlogo.shape.VectorShape;
import org.nlogo.swing.FileDialog;
import org.nlogo.swing.ModalProgressTask;
import org.nlogo.swing.OptionDialog;
import org.nlogo.swing.Utils;
import org.nlogo.util.Exceptions;
import org.nlogo.window.AppEventType;
import org.nlogo.window.Event;
import org.nlogo.window.Events;
import org.nlogo.window.ExternalFileManager;
import org.nlogo.window.GLViewManagerInterface;
import org.nlogo.window.JOGLLoadingException;
import org.nlogo.window.JobWidget;
import org.nlogo.window.LocalViewInterface;
import org.nlogo.window.MonitorWidget;
import org.nlogo.window.NetLogoListenerManager;
import org.nlogo.window.PeriodicUpdater;
import org.nlogo.window.PlotWidgetExportType;
import org.nlogo.window.RuntimeErrorDialog;
import org.nlogo.window.ThreadUtils;
import org.nlogo.window.UpdateManagerInterface;
import org.nlogo.window.View;
import org.nlogo.window.ViewManager;
import org.nlogo.window.ViewWidget;
import org.nlogo.window.WidgetContainer;
import org.nlogo.workspace.AbstractWorkspace;
import org.nlogo.workspace.AbstractWorkspaceScala;
import scala.collection.JavaConversions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class GUIWorkspace
extends AbstractWorkspaceScala
implements Event.LinkChild,
Events.AboutToQuitEvent.Handler,
Events.AddJobEvent.Handler,
Events.AfterLoadEvent.Handler,
Events.BeforeLoadEvent.Handler,
Events.ExportPlotEvent.Handler,
Events.JobStoppingEvent.Handler,
Events.LoadSectionEvent.Handler,
Events.RemoveAllJobsEvent.Handler,
Events.RemoveJobEvent.Handler,
Events.AddSliderConstraintEvent.Handler,
Events.RemoveConstraintEvent.Handler,
Events.AddBooleanConstraintEvent.Handler,
Events.AddChooserConstraintEvent.Handler,
Events.AddInputBoxConstraintEvent.Handler,
Events.CompiledEvent.Handler,
TrailDrawerInterface,
DrawingInterface {
    public final KioskLevel kioskLevel;
    private final Frame frame;
    private final Component linkParent;
    public final ViewWidget viewWidget;
    public final View view;
    private WidgetContainer widgetContainer = null;
    public GLViewManagerInterface glView = null;
    public ViewManager viewManager = new ViewManager();
    private final ExternalFileManager externalFileManager;
    public MovieEncoder movieEncoder = null;
    public final NetLogoListenerManager listenerManager;
    private boolean snapOn = false;
    private double _frameRate = 30.0;
    private boolean dualView;
    private final Runnable updateRunner = new Runnable(){

        public void run() {
            new Events.PeriodicUpdateEvent().raise(GUIWorkspace.this);
        }
    };
    private boolean periodicUpdatesEnabled = false;
    private double lastTicksListenersHeard = -1.0;
    public final Action hubNetControlCenterAction = new AbstractAction(I18N.guiJ().get("menu.tools.hubNetControlCenter")){

        public void actionPerformed(ActionEvent e) {
            GUIWorkspace.this.hubNetManager.showControlCenter();
        }
    };
    public final Action switchTo3DViewAction = new AbstractAction("3D View"){

        public void actionPerformed(ActionEvent e) {
            GUIWorkspace.this.open3DView();
        }
    };

    public GUIWorkspace(final World world, KioskLevel kioskLevel, Frame frame, Component linkParent, AbstractWorkspace.HubNetManagerFactory hubNetManagerFactory, ExternalFileManager externalFileManager, NetLogoListenerManager listenerManager) {
        super(world, hubNetManagerFactory);
        this.kioskLevel = kioskLevel;
        this.frame = frame;
        this.linkParent = linkParent;
        this.externalFileManager = externalFileManager;
        this.listenerManager = listenerManager;
        this.hubNetControlCenterAction.setEnabled(false);
        this.viewWidget = new ViewWidget(this);
        this.view = this.viewWidget.view;
        this.viewManager.setPrimary(this.view);
        PeriodicUpdater periodicUpdater = new PeriodicUpdater(this.jobManager);
        periodicUpdater.start();
        world.trailDrawer(this);
        AbstractAction repaintAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (world.displayOn() && GUIWorkspace.this.displaySwitchOn() && !GUIWorkspace.this.jobManager.anyPrimaryJobs()) {
                    GUIWorkspace.this.viewManager.paintImmediately(world.observer().updatePosition());
                }
            }
        };
        new Timer(100, repaintAction).start();
        new Lifeguard().start();
    }

    public void init(GLViewManagerInterface glView) {
        this.glView = glView;
    }

    public double frameRate() {
        return this._frameRate;
    }

    public void frameRate(double frameRate) {
        this._frameRate = frameRate;
        this.updateManager().recompute();
    }

    public abstract UpdateManagerInterface updateManager();

    public abstract RendererInterface newRenderer();

    @Override
    public void stamp(Agent agent, boolean erase) {
        this.view.renderer.prepareToPaint(this.view, this.view.renderer.trailDrawer().getWidth(), this.view.renderer.trailDrawer().getHeight());
        this.view.renderer.trailDrawer().stamp(agent, erase);
        if (this.hubNetManager != null) {
            this.hubNetManager.sendStamp(agent, erase);
        }
    }

    @Override
    public void importWorld(String filename) throws IOException {
        super.importWorld(filename);
        new Events.TickStateChangeEvent(true).raiseLater(this);
    }

    @Override
    public void importWorld(Reader reader) throws IOException {
        super.importWorld(reader);
        new Events.TickStateChangeEvent(true).raiseLater(this);
    }

    @Override
    public void importDrawing(InputStream is) throws IOException {
        this.view.renderer.trailDrawer().importDrawing(is);
    }

    @Override
    public void importDrawing(File file) throws IOException {
        this.view.renderer.trailDrawer().importDrawing(file);
    }

    @Override
    public void exportDrawing(String filename, String format2) throws IOException {
        FileOutputStream stream = new FileOutputStream(new java.io.File(filename));
        ImageIO.write((RenderedImage)this.view.renderer.trailDrawer().getAndCreateDrawing(true), format2, stream);
        stream.close();
    }

    @Override
    public BufferedImage getAndCreateDrawing() {
        return this.getAndCreateDrawing(true);
    }

    @Override
    public BufferedImage getAndCreateDrawing(boolean dirty) {
        return this.view.renderer.trailDrawer().getAndCreateDrawing(dirty);
    }

    @Override
    public void clearDrawing() {
        this.world.clearDrawing();
        this.view.renderer.trailDrawer().clearDrawing();
        if (this.hubNetManager != null) {
            this.hubNetManager.sendClear();
        }
    }

    @Override
    public void resetTicks(Context context) {
        super.resetTicks(context);
        new Events.TickStateChangeEvent(true).raiseLater(this);
    }

    @Override
    public void clearTicks() {
        super.clearTicks();
        new Events.TickStateChangeEvent(false).raiseLater(this);
    }

    @Override
    public void clearAll() {
        super.clearAll();
        new Events.TickStateChangeEvent(false).raiseLater(this);
    }

    @Override
    public boolean sendPixels() {
        return this.view.renderer.trailDrawer().sendPixels();
    }

    @Override
    public void sendPixels(boolean dirty) {
        this.view.renderer.trailDrawer().sendPixels(dirty);
    }

    @Override
    public void dispose() {
        throw new UnsupportedOperationException();
    }

    public WidgetContainer getWidgetContainer() {
        return this.widgetContainer;
    }

    public void setWidgetContainer(WidgetContainer widgetContainer) {
        this.widgetContainer = widgetContainer;
    }

    @Override
    public boolean isHeadless() {
        return false;
    }

    public void waitFor(Runnable runnable) {
        ThreadUtils.waitFor(this, runnable);
    }

    @Override
    public void waitFor(CommandRunnable runnable) throws LogoException {
        ThreadUtils.waitFor(this, runnable);
    }

    @Override
    public <T> T waitForResult(ReporterRunnable<T> runnable) throws LogoException {
        return ThreadUtils.waitForResult(this, runnable);
    }

    @Override
    public void waitForQueuedEvents() throws LogoException {
        ThreadUtils.waitForQueuedEvents(this);
    }

    @Override
    public Object getLinkParent() {
        return this.linkParent;
    }

    @Override
    public boolean warningMessage(String message) {
        Object[] options = new String[]{I18N.guiJ().get("common.buttons.continue"), I18N.guiJ().get("common.buttons.cancel")};
        return 0 == OptionDialog.show(this.getFrame(), I18N.guiJ().get("common.messages.warning"), "Warning: " + message, options);
    }

    @Override
    public void resizeView() {
        org.nlogo.awt.EventQueue.mustBeEventDispatchThread();
        this.viewWidget.settings().resizeWithProgress(true);
    }

    @Override
    public void patchSize(double patchSize) {
        this.viewWidget.settings().patchSize(patchSize);
    }

    @Override
    public double patchSize() {
        return this.world.patchSize();
    }

    @Override
    public void setDimensions(final WorldDimensions d) {
        Runnable runner = new Runnable(){

            public void run() {
                GUIWorkspace.this.viewWidget.settings().setDimensions(d);
            }
        };
        if (EventQueue.isDispatchThread()) {
            runner.run();
        } else {
            try {
                org.nlogo.awt.EventQueue.invokeAndWait(runner);
            }
            catch (InterruptedException ex) {
                Exceptions.handle(ex);
            }
        }
    }

    @Override
    public void setDimensions(final WorldDimensions d, final double patchSize) {
        Runnable runner = new Runnable(){

            public void run() {
                GUIWorkspace.this.viewWidget.settings().setDimensions(d, patchSize);
            }
        };
        if (EventQueue.isDispatchThread()) {
            runner.run();
        } else {
            try {
                org.nlogo.awt.EventQueue.invokeAndWait(runner);
            }
            catch (InterruptedException ex) {
                Exceptions.handle(ex);
            }
        }
    }

    public void patchesCreatedNotify() {
        new Events.PatchesCreatedEvent().raise(this);
    }

    public Frame getFrame() {
        return this.frame;
    }

    @Override
    public boolean compilerTestingMode() {
        return false;
    }

    @Override
    public WorldPropertiesInterface getPropertiesInterface() {
        return this.viewWidget.settings();
    }

    @Override
    public void changeTopology(boolean wrapX, boolean wrapY) {
        this.world.changeTopology(wrapX, wrapY);
        this.viewWidget.view.renderer.changeTopology(wrapX, wrapY);
    }

    @Override
    public void open(final String path) {
        try {
            org.nlogo.awt.EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    new Events.OpenModelEvent(path).raise(GUIWorkspace.this);
                }
            });
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void openString(String modelContents) {
        throw new UnsupportedOperationException();
    }

    public void reload() {
        new Events.AppEvent(AppEventType.RELOAD, new Object[0]).raiseLater(this);
    }

    @Override
    public void magicOpen(String name) {
        new Events.AppEvent(AppEventType.MAGIC_OPEN, new Object[]{name}).raiseLater(this);
    }

    @Override
    public void changeLanguage() {
        new Events.AppEvent(AppEventType.CHANGE_LANGUAGE, new Object[0]).raiseLater(this);
    }

    @Override
    public void startLogging(String properties) {
        try {
            new Events.AppEvent(AppEventType.START_LOGGING, new Object[]{this.fileManager.attachPrefix(properties)}).raiseLater(this);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void zipLogFiles(String filename) {
        try {
            new Events.AppEvent(AppEventType.ZIP_LOG_FILES, new Object[]{this.fileManager.attachPrefix(filename)}).raiseLater(this);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void deleteLogFiles() {
        new Events.AppEvent(AppEventType.DELETE_LOG_FILES, new Object[0]).raiseLater(this);
    }

    public boolean displaySwitchOn() {
        return this.viewManager.getPrimary().displaySwitch();
    }

    public void displaySwitchOn(boolean on) {
        this.viewManager.getPrimary().displaySwitch(on);
    }

    public void set2DViewEnabled(boolean enabled) {
        if (enabled) {
            this.displaySwitchOn(this.glView.displayOn());
            this.viewManager.setPrimary(this.view);
            this.viewManager.remove(this.glView);
            this.view.dirty();
            if (this.glView.displayOn()) {
                this.view.thaw();
            }
            if (this.world.observer().perspective() != PerspectiveJ.FOLLOW() && this.world.observer().perspective() != PerspectiveJ.RIDE()) {
                this.world.observer().home();
            }
            this.viewWidget.setVisible(true);
            try {
                this.viewWidget.displaySwitch.setOn(this.glView.displaySwitch());
            }
            catch (IllegalStateException e) {
                Exceptions.ignore(e);
            }
        } else {
            this.viewManager.setPrimary(this.glView);
            if (!this.dualView) {
                this.viewManager.remove(this.view);
                this.view.freeze();
            }
            this.glView.displaySwitch(this.viewWidget.displaySwitch.isSelected());
            this.viewWidget.setVisible(this.dualView);
        }
        this.view.renderPerspective = enabled;
        this.viewWidget.settings().refreshViewProperties(!enabled);
        new Events.Enable2DEvent(enabled).raise(this);
    }

    public boolean dualView() {
        return this.dualView;
    }

    public void dualView(boolean on) {
        if (on != this.dualView) {
            this.dualView = on;
            if (this.dualView) {
                this.view.thaw();
                this.viewManager.setSecondary(this.view);
            } else {
                this.view.freeze();
                this.viewManager.remove(this.view);
            }
            this.viewWidget.setVisible(on);
        }
    }

    public boolean mouseDown() throws LogoException {
        this.waitForQueuedEvents();
        return this.viewManager.mouseDown();
    }

    public boolean mouseInside() throws LogoException {
        this.waitForQueuedEvents();
        return this.viewManager.mouseInside();
    }

    public double mouseXCor() throws LogoException {
        this.waitForQueuedEvents();
        return this.viewManager.mouseXCor();
    }

    public double mouseYCor() throws LogoException {
        this.waitForQueuedEvents();
        return this.viewManager.mouseYCor();
    }

    @Override
    public void updateMode(Workspace.UpdateMode updateMode) {
        super.updateMode(updateMode);
        this.updateManager().recompute();
    }

    public double speedSliderPosition() {
        double s = this.updateManager().speed() * 2.0;
        if (s > 0.0) {
            s += 10.0;
        } else if (s < 0.0) {
            s -= 10.0;
        }
        return s;
    }

    public void speedSliderPosition(double speed) {
        this.updateManager().speed_$eq(speed);
    }

    @Override
    public void updateDisplay(boolean haveWorldLockAlready) {
        this.view.dirty();
        if (!this.world.displayOn()) {
            return;
        }
        if (!this.updateManager().shouldUpdateNow()) {
            this.viewManager.framesSkipped();
            return;
        }
        if (!this.displaySwitchOn()) {
            return;
        }
        if (haveWorldLockAlready) {
            try {
                this.waitFor(new CommandRunnable(){

                    public void run() {
                        GUIWorkspace.this.viewManager.incrementalUpdateFromEventThread();
                    }
                });
                while (!this.updateManager().isDoneSmoothing()) {
                    ThreadUtils.waitForQueuedEvents(this);
                }
            }
            catch (HaltException ex) {
                Exceptions.ignore(ex);
            }
            catch (LogoException ex) {
                throw new IllegalStateException(ex);
            }
        } else {
            this.viewManager.incrementalUpdateFromJobThread();
        }
        this.updateManager().pause();
    }

    public void setPeriodicUpdatesEnabled(boolean periodicUpdatesEnabled) {
        this.periodicUpdatesEnabled = periodicUpdatesEnabled;
    }

    @Override
    public void periodicUpdate() {
        if (this.periodicUpdatesEnabled) {
            ThreadUtils.waitFor(this, this.updateRunner);
        }
    }

    @Override
    public void breathe() {
        this.jobManager.maybeRunSecondaryJobs();
        if (this.updateMode() == Workspace.UpdateMode.CONTINUOUS) {
            this.updateManager().pseudoTick();
            this.updateDisplay(true);
        }
        this.world.comeUpForAir = this.updateManager().shouldComeUpForAirAgain();
        this.notifyListeners();
    }

    public void updateUI() {
        ThreadUtils.waitFor(this, this.updateRunner);
        this.updateManager().reset();
        this.requestDisplayUpdate(true);
    }

    @Override
    public void requestDisplayUpdate(boolean force) {
        if (force) {
            this.updateManager().pseudoTick();
        }
        this.updateDisplay(true);
        this.notifyListeners();
    }

    private void notifyListeners() {
        double ticks = this.world.tickCounter.ticks();
        if (ticks != this.lastTicksListenersHeard) {
            this.lastTicksListenersHeard = ticks;
            this.listenerManager.tickCounterChanged(ticks);
        }
        this.listenerManager.possibleViewUpdate();
    }

    @Override
    public void halt() {
        this.jobManager.interrupt();
        ModalProgressTask.apply(this.getFrame(), "Halting...", new Runnable(){

            public void run() {
                GUIWorkspace.super.halt();
                GUIWorkspace.this.view.dirty();
                GUIWorkspace.this.view.repaint();
            }
        });
    }

    public void shapeChanged(Shape shape2) {
        this.viewManager.shapeChanged(shape2);
    }

    @Override
    public void handle(Events.AfterLoadEvent e) {
        this.setPeriodicUpdatesEnabled(true);
        this.world.observer().resetPerspective();
        this.updateManager().reset();
        this.updateManager().speed_$eq(0.0);
        if (this.glView != null) {
            this.glView.close();
        }
        if (this.world.program().is3D()) {
            this.open3DView();
        }
        try {
            this.evaluateCommands(new SimpleJobOwner("startup", this.world.mainRNG, Observer.class), "without-interruption [ startup ]", false);
        }
        catch (CompilerException error) {
            Exceptions.ignore(error);
        }
    }

    private void open3DView() {
        try {
            this.glView.open();
            this.set2DViewEnabled(false);
        }
        catch (JOGLLoadingException jlex) {
            String message = jlex.getMessage();
            Utils.alert("3D View", message, "" + jlex.getCause(), I18N.guiJ().get("common.buttons.continue"));
            this.switchTo3DViewAction.setEnabled(false);
        }
    }

    public void addCustomShapes(String filename) throws IOException, InvalidShapeDescriptionException {
        try {
            this.glView.addCustomShapes(this.fileManager.attachPrefix(filename));
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public int[] colors() {
        return this.view.renderer.trailDrawer().colors();
    }

    @Override
    public boolean isDirty() {
        return this.view.renderer.trailDrawer().isDirty();
    }

    @Override
    public boolean isBlank() {
        return this.view.renderer.trailDrawer().isBlank();
    }

    @Override
    public void markClean() {
        this.view.renderer.trailDrawer().markClean();
    }

    @Override
    public void markDirty() {
        this.view.renderer.trailDrawer().markDirty();
    }

    @Override
    public int getWidth() {
        return this.view.renderer.trailDrawer().getWidth();
    }

    @Override
    public int getHeight() {
        return this.view.renderer.trailDrawer().getHeight();
    }

    @Override
    public void readImage(InputStream is) throws IOException {
        this.view.renderer.trailDrawer().readImage(is);
    }

    @Override
    public void rescaleDrawing() {
        this.view.renderer.trailDrawer().rescaleDrawing();
    }

    @Override
    public void drawLine(double x0, double y0, double x1, double y1, Object color, double size2, String mode) {
        this.view.renderer.trailDrawer().drawLine(x0, y0, x1, y1, color, size2, mode);
        if (this.hubNetManager != null) {
            this.hubNetManager.sendLine(x0, y0, x1, y1, color, size2, mode);
        }
    }

    @Override
    public void setColors(int[] colors) {
        this.view.renderer.trailDrawer().setColors(colors);
    }

    @Override
    public Object getDrawing() {
        return this.view.renderer.trailDrawer().getDrawing();
    }

    @Override
    public void ownerFinished(JobOwner owner) {
        new Events.JobRemovedEvent(owner).raiseLater(this);
        if (owner.ownsPrimaryJobs()) {
            this.updateManager().reset();
            this.updateDisplay(false);
        }
    }

    @Override
    public void handle(Events.AddJobEvent e) {
        JobWidget widget;
        JobOwner owner = e.owner;
        AgentSet agents = e.agents;
        if (owner instanceof JobWidget && agents == null && (widget = (JobWidget)owner).useAgentClass()) {
            agents = this.world.agentClassToAgentSet(widget.agentClass());
        }
        if (owner.ownsPrimaryJobs()) {
            if (e.procedure != null) {
                this.jobManager.addJob(owner, agents, e.procedure);
            } else {
                new Events.JobRemovedEvent(owner).raiseLater(this);
            }
        } else {
            this.jobManager.addSecondaryJob(owner, agents, e.procedure);
        }
    }

    @Override
    public void handle(Events.RemoveJobEvent e) {
        JobOwner owner = e.owner;
        if (owner.ownsPrimaryJobs()) {
            this.jobManager.finishJobs(owner);
        } else {
            this.jobManager.finishSecondaryJobs(owner);
        }
    }

    @Override
    public void handle(Events.JobStoppingEvent e) {
        this.jobManager.stoppingJobs(e.owner);
    }

    @Override
    public void handle(Events.RemoveAllJobsEvent e) {
        this.jobManager.haltSecondary();
        this.jobManager.haltPrimary();
    }

    @Override
    public void handle(Events.AddBooleanConstraintEvent e) {
        BooleanConstraint con = new BooleanConstraint(e.defaultValue);
        int index = this.world.observerOwnsIndexOf(e.varname.toUpperCase());
        if (index != -1) {
            this.world.observer().variableConstraint(index, con);
        }
    }

    @Override
    public void handle(Events.AddInputBoxConstraintEvent e) {
        int index = this.world.observerOwnsIndexOf(e.varname.toUpperCase());
        if (index != -1) {
            this.world.observer().variableConstraint(index, e.constraint);
        }
    }

    @Override
    public void handle(Events.AddChooserConstraintEvent e) {
        int index = this.world.observerOwnsIndexOf(e.varname.toUpperCase());
        if (index != -1) {
            this.world.observer().variableConstraint(index, e.constraint);
        }
    }

    @Override
    public void handle(Events.AddSliderConstraintEvent e) {
        block3: {
            try {
                SliderConstraint con = SliderConstraint.makeSliderConstraint(this.world.observer(), e.minSpec, e.maxSpec, e.incSpec, e.value, e.slider.name(), this);
                e.slider.removeAllErrors();
                e.slider.setSliderConstraint(con);
                int index = this.world.observerOwnsIndexOf(e.varname.toUpperCase());
                if (index == -1) break block3;
                this.world.observer().variableConstraint(index, con);
            }
            catch (SliderConstraint.ConstraintExceptionHolder ex) {
                for (SliderConstraint.SliderConstraintException cce : JavaConversions.asJavaIterable(ex.getErrors())) {
                    e.slider.setConstraintError(cce.spec().fieldName(), cce);
                }
            }
        }
    }

    @Override
    public void handle(Events.RemoveConstraintEvent e) {
        int index = this.world.observerOwnsIndexOf(e.varname.toUpperCase());
        if (index != -1) {
            this.world.observer().variableConstraint(index, null);
        }
    }

    @Override
    public void handle(Events.CompiledEvent e) {
        this.codeBits.clear();
    }

    public abstract void closeAgentMonitors();

    @Override
    public abstract void inspectAgent(Class<? extends org.nlogo.agent.Agent> var1, org.nlogo.agent.Agent var2, double var3);

    public void inspectAgent(Class<? extends org.nlogo.agent.Agent> agentClass) {
        this.inspectAgent(agentClass, null, (this.world.worldWidth() - 1) / 2);
    }

    @Override
    public void clearOutput() {
        final Events.OutputEvent event = new Events.OutputEvent(true, null, false, false);
        if (!EventQueue.isDispatchThread()) {
            ThreadUtils.waitFor(this, new Runnable(){

                public void run() {
                    event.raise(GUIWorkspace.this);
                }
            });
        } else {
            event.raise(this);
        }
    }

    @Override
    protected void sendOutput(OutputObject oo, boolean toOutputArea) {
        final Events.OutputEvent event = new Events.OutputEvent(false, oo, false, !toOutputArea);
        if (!EventQueue.isDispatchThread()) {
            ThreadUtils.waitFor(this, new Runnable(){

                public void run() {
                    event.raise(GUIWorkspace.this);
                }
            });
        } else {
            event.raise(this);
        }
    }

    @Override
    protected Importer.ErrorHandler importerErrorHandler() {
        return new Importer.ErrorHandler(){

            public boolean showError(String title, String errorDetails, boolean fatalError) {
                Object[] objectArray;
                org.nlogo.awt.EventQueue.mustBeEventDispatchThread();
                if (fatalError) {
                    Object[] objectArray2 = new String[1];
                    objectArray = objectArray2;
                    objectArray2[0] = I18N.guiJ().get("common.buttons.ok");
                } else {
                    String[] stringArray = new String[2];
                    stringArray[0] = I18N.guiJ().get("common.buttons.continue");
                    objectArray = stringArray;
                    stringArray[1] = I18N.guiJ().get("common.buttons.cancel");
                }
                Object[] options = objectArray;
                return OptionDialog.show(GUIWorkspace.this.getFrame(), title, errorDetails, options) == 0;
            }
        };
    }

    public Component getExportWindowFrame() {
        return this.viewManager.getPrimary().getExportWindowFrame();
    }

    @Override
    public BufferedImage exportView() {
        return this.viewManager.getPrimary().exportView();
    }

    @Override
    public void exportView(String filename, String format2) throws IOException {
        this.exportView(this.viewManager.getPrimary(), filename, format2);
    }

    public void exportView(LocalViewInterface display, String filename, String format2) throws IOException {
        FileOutputStream stream = new FileOutputStream(new java.io.File(filename));
        ImageIO.write((RenderedImage)display.exportView(), format2, stream);
        stream.close();
    }

    public void doExportView(final LocalViewInterface exportee) {
        try {
            final String exportPath = FileDialog.show(this.getExportWindowFrame(), "Export View", 1, this.guessExportName("view.png"));
            final IOException[] exception = new IOException[]{null};
            ModalProgressTask.apply(this.getFrame(), "Exporting...", new Runnable(){

                public void run() {
                    try {
                        GUIWorkspace.this.exportView(exportee, exportPath, "png");
                    }
                    catch (IOException ex) {
                        exception[0] = ex;
                    }
                }
            });
            if (exception[0] != null) {
                throw exception[0];
            }
        }
        catch (UserCancelException ex) {
            Exceptions.ignore(ex);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.getExportWindowFrame(), ex.getMessage(), I18N.guiJ().get("common.messages.error"), 0);
        }
    }

    @Override
    public void exportInterface(String filename) throws IOException {
        FileOutputStream stream = new FileOutputStream(new java.io.File(filename));
        IOException[] exceptionBox = new IOException[1];
        new Events.ExportInterfaceEvent(stream, exceptionBox).raise(this);
        stream.close();
        if (exceptionBox[0] != null) {
            throw exceptionBox[0];
        }
    }

    @Override
    public void exportOutput(String filename) {
        new Events.ExportOutputEvent(filename).raise(this);
    }

    @Override
    public void exportDrawingToCSV(PrintWriter writer) {
        this.view.renderer.trailDrawer().exportDrawingToCSV(writer);
    }

    @Override
    public void exportOutputAreaToCSV(PrintWriter writer) {
        new Events.ExportWorldEvent(writer).raise(this);
    }

    public void exportPlot(PlotWidgetExportType whichPlots, Plot plot2, String filename) {
        new Events.ExportPlotEvent(whichPlots, plot2, filename).raise(this);
    }

    @Override
    public void handle(Events.ExportPlotEvent e) {
        if (e.whichPlots == PlotWidgetExportType.ALL) {
            if (this.plotManager().getPlotNames().length == 0) {
                OptionDialog.show(this.getFrame(), "Export Plot", "There are no plots to export.", new String[]{I18N.guiJ().get("common.buttons.ok")});
                return;
            }
            try {
                super.exportAllPlots(e.filename);
            }
            catch (IOException ex) {
                String message = "Export of all plots to" + e.filename + " failed: " + ex.getMessage();
                Object[] options = new String[]{I18N.guiJ().get("common.buttons.ok")};
                OptionDialog.show(this.getFrame(), "Export Plot Failed", message, options);
            }
        } else {
            Plot plot2 = e.plot;
            if (plot2 == null) {
                plot2 = this.choosePlot(this.getFrame());
            }
            if (plot2 != null) {
                try {
                    super.exportPlot(plot2.name(), e.filename);
                }
                catch (IOException ex) {
                    String message = "Export of " + plot2.name() + " plot to " + e.filename + " failed: " + ex.getMessage();
                    Object[] options = new String[]{I18N.guiJ().get("common.buttons.ok")};
                    OptionDialog.show(this.getFrame(), "Export Plot Failed", message, options);
                }
            }
        }
    }

    Plot choosePlot(Frame frame) {
        Object[] plotNames = this.plotManager().getPlotNames();
        if (plotNames.length == 0) {
            String message = "There are no plots to export.";
            Object[] options = new String[]{I18N.guiJ().get("common.buttons.ok")};
            OptionDialog.show(frame, "Export Plot", message, options);
            return null;
        }
        String message = "Which plot would you like to export?";
        int plotnum = OptionDialog.showAsList(frame, "Export Plot", message, plotNames);
        if (plotnum < 0) {
            return null;
        }
        return this.plotManager().getPlot((String)plotNames[plotnum]);
    }

    @Override
    public void runtimeError(final JobOwner owner, final Context context, final Instruction instruction, final Exception ex) {
        final Thread thread = Thread.currentThread();
        org.nlogo.awt.EventQueue.invokeLater(new Runnable(){

            public void run() {
                GUIWorkspace.this.runtimeErrorPrivate(owner, context, instruction, thread, ex);
            }
        });
    }

    private void runtimeErrorPrivate(JobOwner owner, final Context context, final Instruction instruction, final Thread thread, final Exception ex) {
        if (ex instanceof HaltException && ((HaltException)ex).haltAll()) {
            this.halt();
        } else if (!(owner instanceof MonitorWidget)) {
            this.world.displayOn(true);
        }
        if (!(ex instanceof HaltException)) {
            SourceOwner sourceOwner = context.activation.procedure.getOwner();
            int[] posAndLength = instruction.token() == null ? new int[]{-1, 0} : instruction.getPositionAndLength();
            new Events.RuntimeErrorEvent(owner, sourceOwner, posAndLength[0], posAndLength[1]).raiseLater(this);
        }
        if (!(owner instanceof MonitorWidget) && !(ex instanceof HaltException)) {
            org.nlogo.awt.EventQueue.invokeLater(new Runnable(){

                public void run() {
                    RuntimeErrorDialog.show("Runtime Error", context, instruction, thread, ex);
                }
            });
        }
    }

    @Override
    public void handle(Events.BeforeLoadEvent e) {
        this.setPeriodicUpdatesEnabled(false);
        if (!GUIWorkspace.isApplet()) {
            this.setModelPath(e.modelPath);
            this.setModelType(e.modelType);
        }
        if (this.hubNetManager != null) {
            this.hubNetManager.disconnect();
        }
        this.jobManager.haltSecondary();
        this.jobManager.haltPrimary();
        this.getExtensionManager().reset();
        this.fileManager.handleModelChange();
        this.previewCommands_$eq(GUIWorkspace.DefaultPreviewCommands());
        this.clearDrawing();
        this.viewManager.resetMouseCors();
        this.displaySwitchOn(true);
        this.setProcedures(new HashMap<String, Procedure>());
        this.lastTicksListenersHeard = -1.0;
        this.plotManager().forgetAll();
    }

    public void modelSaved(String newModelPath) {
        this.setModelPath(newModelPath);
        this.setModelType(ModelTypeJ.NORMAL());
    }

    @Override
    public void handle(Events.AboutToQuitEvent e) {
        if (this.hubNetManager != null) {
            this.hubNetManager.disconnect();
        }
    }

    @Override
    public void hubNetRunning(boolean hubNetRunning) {
        if (this.hubNetRunning != hubNetRunning) {
            if (hubNetRunning) {
                this.viewManager.add(this.hubNetManager);
            } else {
                this.viewManager.remove(this.hubNetManager);
            }
        }
        this.hubNetRunning = hubNetRunning;
        this.hubNetControlCenterAction.setEnabled(hubNetRunning);
    }

    @Override
    public void handle(Events.LoadSectionEvent e) {
        if (e.section == ModelSectionJ.PREVIEW_COMMANDS() && e.text.trim().length() > 0) {
            this.previewCommands_$eq(e.text);
        }
        if (e.section == ModelSectionJ.CLIENT() && e.lines.length > 0 && !GUIWorkspace.isApplet()) {
            this.getHubNetManager().load(e.lines, e.version);
        }
        if (e.section == ModelSectionJ.SHAPES()) {
            this.world.turtleShapeList().replaceShapes(VectorShape.parseShapes(e.lines, e.version));
        }
        if (e.section == ModelSectionJ.LINK_SHAPES()) {
            this.world.linkShapeList().replaceShapes(LinkShape.parseShapes(e.lines, e.version));
        }
    }

    public void snapOn(boolean snapOn) {
        this.snapOn = snapOn;
    }

    public boolean snapOn() {
        return this.snapOn;
    }

    @Override
    public String getSource(String filename) throws IOException {
        String source2 = null;
        if (this.externalFileManager != null) {
            source2 = this.externalFileManager.getSource(filename);
        }
        if (source2 == null) {
            source2 = super.getSource(filename);
        }
        return source2;
    }

    private strictfp class Lifeguard
    extends Thread {
        Lifeguard() {
            super("Lifeguard");
        }

        public void run() {
            try {
                while (true) {
                    if (GUIWorkspace.this.jobManager.anyPrimaryJobs()) {
                        GUIWorkspace.this.world.comeUpForAir = true;
                    }
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException ex) {
                Exceptions.ignore(ex);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public strictfp static enum KioskLevel {
        NONE,
        MODERATE;

    }
}

