/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.nlogo.agent.OutputObject;
import org.nlogo.api.File;
import org.nlogo.api.FileModeJ;
import org.nlogo.api.LocalFile;
import org.nlogo.awt.EventQueue;
import org.nlogo.awt.Fonts;
import org.nlogo.awt.LineBreaker;
import org.nlogo.util.Exceptions;

public strictfp class OutputArea
extends JPanel {
    private boolean addCarriageReturn = false;
    private String lastTemporaryAddition;
    String help = null;
    public final JTextArea text;
    private final JScrollPane scrollPane;

    public OutputArea() {
        this(new JTextArea(){

            public Dimension getMinimumSize() {
                return new Dimension(50, (int)((double)this.getRowHeight() * 1.25));
            }
        });
    }

    public OutputArea(final Component nextFocus) {
        this(new JTextArea(){

            public Dimension getMinimumSize() {
                return new Dimension(50, (int)((double)this.getRowHeight() * 1.25));
            }

            public void transferFocus() {
                nextFocus.requestFocus();
            }
        });
    }

    public OutputArea(JTextArea textArea) {
        this.text = textArea;
        this.text.setEditable(false);
        this.text.setDragEnabled(false);
        this.text.setFont(new Font(Fonts.platformMonospacedFont(), 0, 12));
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.text, 22, 30);
        this.add((Component)this.scrollPane, "Center");
    }

    public int fontSize() {
        return this.text.getFont().getSize();
    }

    public void fontSize(int fontSize) {
        this.text.setFont(new Font(Fonts.platformMonospacedFont(), 0, fontSize));
    }

    public void clear() {
        this.text.setText("");
        this.addCarriageReturn = false;
    }

    public Dimension getMinimumSize() {
        return new Dimension(50, this.text.getMinimumSize().height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 45);
    }

    public boolean isFocusable() {
        return false;
    }

    public void append(OutputObject oo, boolean wrapLines) {
        String message = oo.get();
        if (this.lastTemporaryAddition != null) {
            String contents2 = this.text.getText();
            if (contents2.length() >= this.lastTemporaryAddition.length() && contents2.substring(contents2.length() - this.lastTemporaryAddition.length()).equals(this.lastTemporaryAddition)) {
                this.text.replaceRange("", contents2.length() - this.lastTemporaryAddition.length(), contents2.length());
            }
            this.lastTemporaryAddition = null;
        }
        if (wrapLines) {
            FontMetrics fontMetrics = this.getFontMetrics(this.text.getFont());
            List<String> messageLines = LineBreaker.breakLines(message, fontMetrics, this.text.getWidth() - 24);
            StringBuilder wrappedMessage = new StringBuilder();
            for (int i = 0; i < messageLines.size(); ++i) {
                wrappedMessage.append(messageLines.get(i));
                wrappedMessage.append("\n");
            }
            message = wrappedMessage.toString();
        }
        StringBuilder buf = new StringBuilder();
        if (this.addCarriageReturn) {
            buf.append('\n');
            this.addCarriageReturn = false;
        }
        buf.append(message);
        if (buf.length() > 0 && buf.charAt(buf.length() - 1) == '\n') {
            buf.setLength(buf.length() - 1);
            this.addCarriageReturn = true;
        }
        this.text.append(buf.toString());
        this.lastTemporaryAddition = null;
        if (oo.isTemporary()) {
            this.text.select(this.text.getText().length() - buf.length(), this.text.getText().length());
            this.lastTemporaryAddition = this.text.getSelectedText();
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                OutputArea.this.scrollPane.getVerticalScrollBar().setValue(OutputArea.this.scrollPane.getVerticalScrollBar().getMaximum());
                OutputArea.this.scrollPane.getHorizontalScrollBar().setValue(0);
            }
        });
    }

    public void export(String filename) {
        LocalFile file = new LocalFile(filename);
        try {
            ((File)file).open(FileModeJ.WRITE());
            StringTokenizer lines2 = new StringTokenizer(this.text.getText(), "\n");
            while (lines2.hasMoreTokens()) {
                ((File)file).println(lines2.nextToken());
            }
            ((File)file).close(true);
        }
        catch (IOException ex) {
            try {
                ((File)file).close(false);
            }
            catch (IOException ex2) {
                Exceptions.ignore(ex2);
            }
        }
    }
}

