/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.util.ArrayList;
import java.util.List;
import org.nlogo.api.CompilerException;
import org.nlogo.api.Editable;
import org.nlogo.api.I18N;
import org.nlogo.api.Property;
import org.nlogo.api.WorldDimensions;
import org.nlogo.api.WorldPropertiesInterface;
import org.nlogo.nvm.Workspace;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.OriginConfiguration;
import org.nlogo.window.Properties;
import org.nlogo.window.ViewWidget;
import org.nlogo.workspace.WorldLoaderInterface;
import scala.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class WorldViewSettings
implements Editable,
WorldLoaderInterface,
WorldPropertiesInterface {
    protected final GUIWorkspace workspace;
    protected final ViewWidget gWidget;
    protected List<Property> dimensionProperties;
    protected List<Property> wrappingProperties;
    protected List<Property> viewProperties;
    protected List<Property> modelProperties;
    protected List<OriginConfiguration> cornerChoices;
    protected List<OriginConfiguration> edgeChoices;
    protected List<OriginConfiguration> originConfigurations;
    protected List<Property> propertySet = null;
    protected boolean wrappingChanged = false;
    protected boolean edgesChanged = false;
    protected boolean patchSizeChanged = false;
    protected boolean fontSizeChanged = false;
    protected double newPatchSize;
    protected int newMinX;
    protected int newMaxX;
    protected int newMinY;
    protected int newMaxY;
    protected boolean newWrapX;
    protected boolean newWrapY;
    protected int newFontSize;
    protected CompilerException error = null;

    @Override
    public String classDisplayName() {
        return "Model Settings";
    }

    WorldViewSettings(GUIWorkspace workspace, ViewWidget gw) {
        this.workspace = workspace;
        this.gWidget = gw;
        this.addProperties();
    }

    public abstract void resizeWithProgress(boolean var1);

    public abstract String save();

    public abstract void addWrappingProperties();

    public abstract void addDimensionProperties();

    protected void addProperties() {
        this.propertySet(new ArrayList<Property>());
        this.dimensionProperties = new ArrayList<Property>();
        this.addDimensionProperties();
        this.wrappingProperties = new ArrayList<Property>();
        this.addWrappingProperties();
        this.viewProperties = new ArrayList<Property>();
        this.addViewProperties();
        this.modelProperties = new ArrayList<Property>();
        this.addModelProperties();
        this.cornerChoices = new ArrayList<OriginConfiguration>();
        this.addCornerChoices();
        this.edgeChoices = new ArrayList<OriginConfiguration>();
        this.addEdgeChoices();
        this.originConfigurations = new ArrayList<OriginConfiguration>();
        this.addOriginConfigurations();
    }

    public List<Property> getDimensionProperties() {
        return this.dimensionProperties;
    }

    public List<Property> getWrappingProperties() {
        return this.wrappingProperties;
    }

    public List<Property> getViewProperties() {
        return this.viewProperties;
    }

    public List<Property> getModelProperties() {
        return this.modelProperties;
    }

    public List<OriginConfiguration> getCornerChoices() {
        return this.cornerChoices;
    }

    public List<OriginConfiguration> getEdgeChoices() {
        return this.edgeChoices;
    }

    public List<OriginConfiguration> getOriginConfigurations() {
        return this.originConfigurations;
    }

    public void addViewProperties() {
        this.viewProperties.addAll(Properties.view2D());
    }

    public void addModelProperties() {
        this.modelProperties.addAll(Properties.model());
    }

    public void refreshViewProperties(boolean threedView) {
        this.viewProperties.clear();
        this.addViewProperties();
        if (threedView) {
            this.viewProperties.addAll(Properties.view3D());
        }
    }

    public void addCornerChoices() {
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.corner.bottomLeft"), new boolean[]{false, true, false, true}, new boolean[]{true, false, true, false}));
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.corner.topLeft"), new boolean[]{false, true, true, false}, new boolean[]{true, false, false, true}));
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.corner.topRight"), new boolean[]{true, false, true, false}, new boolean[]{false, true, false, true}));
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.corner.bottomRight"), new boolean[]{true, false, false, true}, new boolean[]{false, true, true, false}));
    }

    public void addEdgeChoices() {
        this.edgeChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.edge.bottom"), new boolean[]{true, true, false, true}, new boolean[]{false, false, true, false}));
        this.edgeChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.edge.top"), new boolean[]{true, true, true, false}, new boolean[]{false, false, false, true}));
        this.edgeChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.edge.right"), new boolean[]{true, false, true, true}, new boolean[]{false, true, false, false}));
        this.edgeChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.edge.left"), new boolean[]{false, true, true, true}, new boolean[]{true, false, false, false}));
    }

    public void addOriginConfigurations() {
        this.originConfigurations.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.center"), new boolean[]{false, true, false, true}, new boolean[]{false, false, false, false}));
        this.originConfigurations.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.corner"), new boolean[]{true, true, true, true}, new boolean[]{false, false, false, false}));
        this.originConfigurations.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.edge"), new boolean[]{true, true, true, true}, new boolean[]{false, false, false, false}));
        this.originConfigurations.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.custom"), new boolean[]{true, true, true, true}, new boolean[]{false, false, false, false}));
    }

    public int firstEditor() {
        return 0;
    }

    public int lastEditor() {
        return 3;
    }

    public int getSelectedLocation() {
        int minx = this.minPxcor();
        int maxx = this.maxPxcor();
        int miny = this.minPycor();
        int maxy = this.maxPycor();
        if (minx == -maxx && miny == -maxy) {
            return 0;
        }
        if (!(minx != 0 && maxx != 0 || miny != 0 && maxy != 0)) {
            return 1;
        }
        if (minx == 0 || maxx == 0 || miny == 0 || maxy == 0) {
            return 2;
        }
        return 3;
    }

    public int getSelectedConfiguration() {
        int minx = this.minPxcor();
        int maxx = this.maxPxcor();
        int miny = this.minPycor();
        int maxy = this.maxPycor();
        if (minx == 0 && miny == 0) {
            return 0;
        }
        if (minx == 0 && maxy == 0) {
            return 1;
        }
        if (maxx == 0 && maxy == 0) {
            return 2;
        }
        if (maxx == 0 && miny == 0) {
            return 3;
        }
        if (minx == 0) {
            return 3;
        }
        if (maxx == 0) {
            return 2;
        }
        if (miny == 0) {
            return 0;
        }
        if (maxy == 0) {
            return 1;
        }
        return 0;
    }

    public Object load(String[] strings, String version) {
        this.workspace.loadWorld(strings, version, this);
        this.workspace.world.tickCounter.clear();
        this.workspace.world.clearPatches();
        this.workspace.world.displayOn(true);
        return this;
    }

    public boolean smooth() {
        return this.workspace.glView.antiAliasingOn();
    }

    public void smooth(boolean smooth) {
        if (this.workspace.glView.antiAliasingOn() != smooth) {
            this.workspace.glView.antiAliasingOn(smooth);
        }
    }

    public boolean wireframe() {
        return this.workspace.glView.wireframeOn();
    }

    public void wireframe(boolean on) {
        if (on != this.wireframe()) {
            this.workspace.glView.wireframeOn_$eq(on);
            this.workspace.glView.repaint();
        }
    }

    public boolean dualView() {
        return this.workspace.dualView();
    }

    public void dualView(boolean on) {
        this.workspace.dualView(on);
    }

    @Override
    public Option<String> helpLink() {
        return Option.apply(null);
    }

    @Override
    public List<Property> propertySet() {
        return this.propertySet;
    }

    public void propertySet(List<Property> propertySet) {
        this.propertySet = propertySet;
    }

    public void minPxcor(int minPxcor) {
        if (minPxcor <= 0) {
            this.newMinX = minPxcor;
            this.edgesChanged = this.edgesChanged || this.newMinX != this.workspace.world.minPxcor();
        }
    }

    public int minPxcor() {
        return this.newMinX;
    }

    public void maxPxcor(int maxPxcor) {
        if (maxPxcor >= 0) {
            this.newMaxX = maxPxcor;
            this.edgesChanged = this.edgesChanged || this.newMaxX != this.workspace.world.maxPxcor();
        }
    }

    public int maxPxcor() {
        return this.newMaxX;
    }

    public void minPycor(int minPycor) {
        if (minPycor <= 0) {
            this.newMinY = minPycor;
            this.edgesChanged = this.edgesChanged || this.newMinY != this.workspace.world.minPycor();
        }
    }

    public int minPycor() {
        return this.newMinY;
    }

    public void maxPycor(int maxPycor) {
        if (maxPycor >= 0) {
            this.newMaxY = maxPycor;
            this.edgesChanged = this.edgesChanged || this.newMaxY != this.workspace.world.maxPycor();
        }
    }

    public int maxPycor() {
        return this.newMaxY;
    }

    @Override
    public void patchSize(double size2) {
        this.newPatchSize = size2;
        this.patchSizeChanged = this.patchSizeChanged || size2 != this.patchSize();
    }

    public double patchSize() {
        return this.workspace.world.patchSize();
    }

    public Workspace.UpdateMode updateMode() {
        return this.workspace.updateMode();
    }

    @Override
    public void updateMode(Workspace.UpdateMode updateMode) {
        this.workspace.updateMode(updateMode);
    }

    public boolean wrappingX() {
        if (!this.wrappingChanged) {
            this.newWrapX = this.workspace.world.wrappingAllowedInX();
        }
        return this.newWrapX;
    }

    public void wrappingX(boolean value) {
        this.newWrapX = value;
        this.wrappingChanged = this.wrappingChanged || this.newWrapX != this.workspace.world.wrappingAllowedInX();
    }

    public boolean wrappingY() {
        if (!this.wrappingChanged) {
            this.newWrapY = this.workspace.world.wrappingAllowedInY();
        }
        return this.newWrapY;
    }

    public void wrappingY(boolean value) {
        this.newWrapY = value;
        this.wrappingChanged = this.wrappingChanged || this.newWrapY != this.workspace.world.wrappingAllowedInY();
    }

    @Override
    public int fontSize() {
        return this.gWidget.view.fontSize();
    }

    @Override
    public void fontSize(int newFontSize) {
        this.newFontSize = newFontSize;
        if (newFontSize != this.fontSize()) {
            this.fontSizeChanged = true;
        }
        this.workspace.viewManager.applyNewFontSize(newFontSize);
    }

    @Override
    public double frameRate() {
        return this.workspace.frameRate();
    }

    @Override
    public void frameRate(double frameRate) {
        this.workspace.frameRate(frameRate);
    }

    @Override
    public void showTickCounter(boolean visible) {
        this.workspace.viewWidget.showTickCounter(visible);
    }

    @Override
    public boolean showTickCounter() {
        return this.workspace.viewWidget.showTickCounter();
    }

    @Override
    public String tickCounterLabel() {
        return this.workspace.viewWidget.tickCounterLabel();
    }

    @Override
    public void tickCounterLabel(String label) {
        this.workspace.viewWidget.tickCounterLabel(label);
    }

    @Override
    public void changeTopology(boolean wrapX, boolean wrapY) {
        this.workspace.changeTopology(wrapX, wrapY);
    }

    @Override
    public void clearTurtles() {
        this.workspace.world.clearTurtles();
    }

    @Override
    public boolean anyErrors() {
        return this.error != null;
    }

    public void error(Exception e) {
        if (!(e instanceof CompilerException)) {
            throw new IllegalStateException(e);
        }
        this.error = (CompilerException)e;
    }

    @Override
    public void error(Object o, Exception e) {
        this.error(e);
    }

    public Exception error() {
        return this.error;
    }

    @Override
    public Exception error(Object o) {
        return this.error;
    }

    @Override
    public void setSize(int x, int y) {
        this.gWidget.setSize(x, y);
    }

    @Override
    public int getMinimumWidth() {
        return this.gWidget.getMinimumWidth();
    }

    @Override
    public int insetWidth() {
        return this.gWidget.insetWidth();
    }

    @Override
    public double computePatchSize(int width, int numPatches) {
        return this.gWidget.computePatchSize(width, numPatches);
    }

    @Override
    public int calculateHeight(int worldHeight, double patchSize) {
        return this.gWidget.calculateHeight(worldHeight, patchSize);
    }

    @Override
    public int calculateWidth(int worldWidth, double patchSize) {
        return this.gWidget.calculateWidth(worldWidth, patchSize);
    }

    @Override
    public void setDimensions(WorldDimensions d, double patchSize) {
        this.workspace.world.patchSize(patchSize);
        this.setDimensions(d);
        this.patchSize(patchSize);
        this.gWidget.resetSize();
    }

    public void setDimensions(WorldDimensions d) {
        this.setDimensions(d.minPxcor(), d.maxPxcor(), d.minPycor(), d.maxPycor());
    }

    public void setDimensions(int minPxcor, int maxPxcor, int minPycor, int maxPycor) {
        this.newMinX = minPxcor;
        this.newMaxX = maxPxcor;
        this.newMinY = minPycor;
        this.newMaxY = maxPycor;
        if (minPxcor != this.workspace.world.minPxcor() || maxPxcor != this.workspace.world.maxPxcor() || minPycor != this.workspace.world.minPycor() || maxPycor != this.workspace.world.maxPycor()) {
            this.prepareForWorldResize();
            this.workspace.world.createPatches(minPxcor, maxPxcor, minPycor, maxPycor);
            this.finishWorldResize();
        }
    }

    void prepareForWorldResize() {
        this.workspace.jobManager.haltNonObserverJobs();
        this.workspace.world.clearTurtles();
        this.workspace.world.clearLinks();
    }

    void finishWorldResize() {
        this.workspace.patchesCreatedNotify();
        this.gWidget.resetSize();
        this.workspace.clearDrawing();
    }

    @Override
    public int sourceOffset() {
        throw new IllegalStateException();
    }
}

