/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import org.nlogo.agent.World3D;
import org.nlogo.api.I18N;
import org.nlogo.api.WorldDimensions;
import org.nlogo.api.WorldDimensions3D;
import org.nlogo.awt.Hierarchy;
import org.nlogo.swing.ModalProgressTask;
import org.nlogo.window.Events;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.OriginConfiguration;
import org.nlogo.window.Properties;
import org.nlogo.window.ViewWidget;
import org.nlogo.window.WorldViewSettings;

public strictfp class WorldViewSettings3D
extends WorldViewSettings {
    protected final World3D world;
    protected int newMinZ;
    protected int newMaxZ;
    protected boolean newWrapZ;

    WorldViewSettings3D(GUIWorkspace workspace, ViewWidget gw) {
        super(workspace, gw);
        this.world = (World3D)workspace.world;
    }

    public void minPzcor(int minPzcor) {
        if (minPzcor <= 0) {
            this.newMinZ = minPzcor;
            this.edgesChanged = this.edgesChanged || this.newMinZ != this.world.minPzcor();
        }
    }

    public int minPzcor() {
        return this.newMinZ;
    }

    public void maxPzcor(int maxPzcor) {
        if (maxPzcor >= 0) {
            this.newMaxZ = maxPzcor;
            this.edgesChanged = this.edgesChanged || this.newMaxZ != this.world.maxPzcor();
        }
    }

    public int maxPzcor() {
        return this.newMaxZ;
    }

    public boolean wrappingZ() {
        if (!this.wrappingChanged) {
            this.newWrapZ = this.world.wrappingAllowedInZ();
        }
        return this.newWrapZ;
    }

    public void wrappingZ(boolean value) {
        this.newWrapZ = value;
        this.wrappingChanged = this.wrappingChanged || this.newWrapZ != this.world.wrappingAllowedInZ();
    }

    public void addDimensionProperties() {
        this.dimensionProperties.addAll(Properties.dims3D());
    }

    public void addWrappingProperties() {
        this.wrappingProperties.addAll(Properties.wrap3D());
    }

    public void addCornerChoices() {
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.corner.bottomSouthwest"), new boolean[]{false, true, false, true, false, true}, new boolean[]{true, false, true, false, true, false}));
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.corner.bottomNorthwest"), new boolean[]{false, true, true, false, false, true}, new boolean[]{true, false, false, true, true, false}));
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.corner.bottomNortheast"), new boolean[]{true, false, true, false, false, true}, new boolean[]{false, true, false, true, true, false}));
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.corner.bottomSoutheast"), new boolean[]{true, false, false, true, false, true}, new boolean[]{false, true, true, false, true, false}));
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.corner.topSouthwest"), new boolean[]{false, true, false, true, true, false}, new boolean[]{true, false, true, false, false, true}));
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.corner.topNorthwest"), new boolean[]{false, true, true, false, true, false}, new boolean[]{true, false, false, true, false, true}));
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.corner.topNortheast"), new boolean[]{true, false, true, false, true, false}, new boolean[]{false, true, false, true, false, true}));
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.corner.topSoutheast"), new boolean[]{true, false, false, true, true, false}, new boolean[]{false, true, true, false, false, true}));
    }

    public void addEdgeChoices() {
        this.edgeChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.edge.south"), new boolean[]{true, true, false, true, true, true}, new boolean[]{false, false, true, false, false, false}));
        this.edgeChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.edge.north"), new boolean[]{true, true, true, false, true, true}, new boolean[]{false, false, false, true, false, false}));
        this.edgeChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.edge.east"), new boolean[]{true, false, true, true, true, true}, new boolean[]{false, true, false, false, false, false}));
        this.edgeChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.edge.west"), new boolean[]{false, true, true, true, true, true}, new boolean[]{true, false, false, false, false, false}));
        this.edgeChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.edge.bottom"), new boolean[]{true, true, true, true, false, true}, new boolean[]{false, false, false, false, true, false}));
        this.edgeChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.3D.origin.location.edge.top"), new boolean[]{true, true, true, true, true, false}, new boolean[]{false, false, false, false, false, true}));
    }

    public void addOriginConfigurations() {
        this.originConfigurations.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.center"), new boolean[]{false, true, false, true, false, true}, new boolean[]{false, false, false, false, false, false}));
        this.originConfigurations.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.corner"), new boolean[]{true, true, true, true, true, true}, new boolean[]{false, false, false, false, false, false}));
        this.originConfigurations.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.edge"), new boolean[]{true, true, true, true, true, true}, new boolean[]{false, false, false, false, false, false}));
        this.originConfigurations.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.custom"), new boolean[]{true, true, true, true, true, true}, new boolean[]{false, false, false, false, false, false}));
    }

    public int firstEditor() {
        return 0;
    }

    public int lastEditor() {
        return 5;
    }

    public int getSelectedLocation() {
        int minx = this.minPxcor();
        int maxx = this.maxPxcor();
        int miny = this.minPycor();
        int maxy = this.maxPycor();
        int maxz = this.maxPzcor();
        int minz = this.minPzcor();
        if (minx == -maxx && miny == -maxy && minz == -maxz) {
            return 0;
        }
        if (!(minx != 0 && maxx != 0 || miny != 0 && maxy != 0 || minz != 0 && maxz != 0)) {
            return 1;
        }
        if (minx == 0 || maxx == 0 || miny == 0 || maxy == 0 || minz == 0 || maxz == 0) {
            return 2;
        }
        return 3;
    }

    public int getSelectedConfiguration() {
        int minx = this.minPxcor();
        int maxx = this.maxPxcor();
        int miny = this.minPycor();
        int maxy = this.maxPycor();
        int minz = this.minPzcor();
        int maxz = this.maxPzcor();
        if (minx == 0 && miny == 0 && minz == 0) {
            return 0;
        }
        if (minx == 0 && maxy == 0 && minz == 0) {
            return 1;
        }
        if (maxx == 0 && maxy == 0 && minz == 0) {
            return 2;
        }
        if (maxx == 0 && miny == 0 && minz == 0) {
            return 3;
        }
        if (minx == 0 && miny == 0 && maxz == 0) {
            return 4;
        }
        if (minx == 0 && maxy == 0 && maxz == 0) {
            return 5;
        }
        if (maxx == 0 && maxy == 0 && maxz == 0) {
            return 6;
        }
        if (maxx == 0 && miny == 0 && maxz == 0) {
            return 7;
        }
        if (minx == 0) {
            return 3;
        }
        if (maxx == 0) {
            return 2;
        }
        if (miny == 0) {
            return 0;
        }
        if (maxy == 0) {
            return 1;
        }
        if (minz == 0) {
            return 4;
        }
        if (maxz == 0) {
            return 5;
        }
        return 0;
    }

    public boolean editFinished() {
        this.gWidget.editFinished();
        if (this.wrappingChanged) {
            this.workspace.changeTopology(this.newWrapX, this.newWrapY);
            this.wrappingChanged = false;
        }
        if (this.edgesChanged || this.patchSizeChanged) {
            this.resizeWithProgress(true);
            this.edgesChanged = false;
            this.patchSizeChanged = false;
        }
        if (this.fontSizeChanged) {
            this.gWidget.applyNewFontSize(this.newFontSize);
            this.fontSizeChanged = false;
        }
        this.gWidget.view.dirty();
        this.gWidget.view.repaint();
        this.workspace.glView.editFinished();
        return true;
    }

    public void resizeWithProgress(boolean showProgress) {
        boolean oldGraphicsOn = this.world.displayOn();
        if (oldGraphicsOn) {
            this.world.displayOn(false);
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (WorldViewSettings3D.this.edgesChanged) {
                    new Events.RemoveAllJobsEvent().raise(WorldViewSettings3D.this.gWidget);
                    WorldViewSettings3D.this.world.clearTurtles();
                    WorldViewSettings3D.this.world.clearLinks();
                    WorldViewSettings3D.this.world.createPatches(WorldViewSettings3D.this.newMinX, WorldViewSettings3D.this.newMaxX, WorldViewSettings3D.this.newMinY, WorldViewSettings3D.this.newMaxY, WorldViewSettings3D.this.newMinZ, WorldViewSettings3D.this.newMaxZ);
                    WorldViewSettings3D.this.workspace.patchesCreatedNotify();
                    WorldViewSettings3D.this.gWidget.resetSize();
                }
                if (WorldViewSettings3D.this.patchSizeChanged) {
                    WorldViewSettings3D.this.world.patchSize(WorldViewSettings3D.this.newPatchSize);
                    WorldViewSettings3D.this.gWidget.resetSize();
                }
                if (WorldViewSettings3D.this.edgesChanged) {
                    WorldViewSettings3D.this.workspace.clearDrawing();
                } else {
                    WorldViewSettings3D.this.gWidget.view.renderer.trailDrawer().rescaleDrawing();
                }
            }
        };
        if (showProgress) {
            ModalProgressTask.apply(Hierarchy.getFrame(this.gWidget), "Resizing...", runnable);
        } else {
            runnable.run();
        }
        this.gWidget.displaySwitchOn(true);
        if (oldGraphicsOn) {
            this.world.displayOn(true);
            this.gWidget.view.dirty();
            this.gWidget.view.repaint();
        }
    }

    public void setDimensions(WorldDimensions d) {
        if (d instanceof WorldDimensions3D) {
            WorldDimensions3D dd = (WorldDimensions3D)d;
            this.setDimensions(dd.minPxcor(), dd.maxPxcor(), dd.minPycor(), dd.maxPycor(), dd.minPzcor(), dd.maxPzcor());
        } else {
            this.setDimensions(d.minPxcor(), d.maxPxcor(), d.minPycor(), d.maxPycor(), 0, 0);
        }
    }

    public void setDimensions(int minPxcor, int maxPxcor, int minPycor, int maxPycor, int minPzcor, int maxPzcor) {
        this.newMinX = minPxcor;
        this.newMaxX = maxPxcor;
        this.newMinY = minPycor;
        this.newMaxY = maxPycor;
        this.newMinZ = minPzcor;
        this.newMaxZ = maxPzcor;
        if (minPxcor != this.world.minPxcor() || maxPxcor != this.world.maxPxcor() || minPycor != this.world.minPycor() || maxPycor != this.world.maxPycor() || minPzcor != this.world.minPzcor() || maxPzcor != this.world.maxPzcor()) {
            this.prepareForWorldResize();
            this.world.createPatches(minPxcor, maxPxcor, minPycor, maxPycor, minPzcor, maxPzcor);
            this.finishWorldResize();
        }
    }

    public String save() {
        return "GRAPHICS-WINDOW\n" + this.gWidget.getBoundsString() + (-this.world.minPxcor() == this.world.maxPxcor() ? this.world.maxPxcor() : -1) + "\n" + (-this.world.minPycor() == this.world.maxPycor() ? this.world.maxPycor() : -1) + "\n" + this.world.patchSize() + "\n" + "1\n" + this.gWidget.view.fontSize() + "\n" + "1\n1\n1\n0\n" + (this.world.wrappingAllowedInX() ? "1" : "0") + "\n" + (this.world.wrappingAllowedInY() ? "1" : "0") + "\n" + "1\n" + this.world.minPxcor() + "\n" + this.world.maxPxcor() + "\n" + this.world.minPycor() + "\n" + this.world.maxPycor() + "\n" + this.world.minPzcor() + "\n" + this.world.maxPzcor() + "\n" + (this.world.wrappingAllowedInZ() ? "1" : "0") + "\n" + this.workspace.updateMode().save() + "\n" + (this.showTickCounter() ? "1" : "0") + "\n" + (this.tickCounterLabel().trim().equals("") ? "NIL" : this.tickCounterLabel()) + "\n" + this.frameRate() + "\n";
    }
}

