/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import java.text.DecimalFormat;
import org.nlogo.agent.Observer;
import org.nlogo.api.SimpleJobOwner;
import org.nlogo.nvm.Procedure;
import org.nlogo.workspace.AbstractWorkspace;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.UninitializedFieldError;
import scala.collection.generic.TraversableForwarder;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

public final class Benchmarker$
implements ScalaObject {
    public static final Benchmarker$ MODULE$;
    private final double Z;
    private final double TOLERANCE;
    private final DecimalFormat formatter;
    private volatile int bitmap$init$0;

    static {
        new Benchmarker$();
    }

    private double Z() {
        if ((this.bitmap$init$0 & 1) != 0) {
            return this.Z;
        }
        throw new UninitializedFieldError("Uninitialized field: Benchmarker.scala: 11".toString());
    }

    private double TOLERANCE() {
        if ((this.bitmap$init$0 & 2) != 0) {
            return this.TOLERANCE;
        }
        throw new UninitializedFieldError("Uninitialized field: Benchmarker.scala: 12".toString());
    }

    private DecimalFormat formatter() {
        if ((this.bitmap$init$0 & 4) != 0) {
            return this.formatter;
        }
        throw new UninitializedFieldError("Uninitialized field: Benchmarker.scala: 13".toString());
    }

    public void benchmark(AbstractWorkspace workspace$1, int minTime$1, int maxTime$1) {
        ListBuffer times$1 = new ListBuffer();
        Procedure goProcedure$1 = workspace$1.compileCommands("ca benchmark");
        Procedure resultProcedure$1 = workspace$1.compileReporter("result");
        SimpleJobOwner owner$1 = new SimpleJobOwner("Benchmarker", workspace$1.world.mainRNG, Observer.class);
        LongRef lastChatterTime$1 = new LongRef(0L);
        this.warmUp$1(workspace$1, minTime$1, goProcedure$1, resultProcedure$1, owner$1);
        while (true) {
            if (this.done$1(minTime$1, maxTime$1, times$1)) {
                this.debrief$1(workspace$1, times$1, lastChatterTime$1);
                return;
            }
            times$1.$plus$eq(BoxesRunTime.boxToDouble(this.goOnce$1(workspace$1, goProcedure$1, resultProcedure$1, owner$1)));
            if (this.done$1(minTime$1, maxTime$1, times$1)) continue;
            this.chatter$1(times$1, lastChatterTime$1);
        }
    }

    private final double goOnce$1(AbstractWorkspace abstractWorkspace, Procedure procedure, Procedure procedure2, SimpleJobOwner simpleJobOwner) {
        abstractWorkspace.runCompiledCommands(simpleJobOwner, procedure);
        double result = BoxesRunTime.unboxToDouble(abstractWorkspace.runCompiledReporter(simpleJobOwner, procedure2));
        Predef$.MODULE$.assert(result > 0.0);
        return result;
    }

    public final double average$1(ListBuffer listBuffer) {
        return this.total$1(listBuffer) / (double)listBuffer.size();
    }

    private final double total$1(ListBuffer listBuffer) {
        return BoxesRunTime.unboxToDouble(listBuffer.sum(Numeric.DoubleIsFractional$.MODULE$));
    }

    private final double squareOfDifference$1(ListBuffer listBuffer) {
        return BoxesRunTime.unboxToDouble(((TraversableForwarder)listBuffer.map(new Serializable(listBuffer){
            public static final long serialVersionUID;
            private final ListBuffer times$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final double apply(double time) {
                return this.apply$mcDD$sp(time);
            }

            public double apply$mcDD$sp(double v1) {
                return package$.MODULE$.pow(v1 - Benchmarker$.MODULE$.average$1(this.times$1), 2.0);
            }
            {
                this.times$1 = listBuffer;
            }
        }, ListBuffer$.MODULE$.canBuildFrom())).sum(Numeric.DoubleIsFractional$.MODULE$));
    }

    private final double stddev$1(ListBuffer listBuffer) {
        return package$.MODULE$.sqrt(this.squareOfDifference$1(listBuffer) / (double)listBuffer.size());
    }

    private final int runs$1(ListBuffer listBuffer) {
        return Predef$.MODULE$.intWrapper(2).max((int)package$.MODULE$.ceil(package$.MODULE$.pow(this.Z() * this.stddev$1(listBuffer) / (this.TOLERANCE() * this.average$1(listBuffer)), 2.0)));
    }

    private final void warmUp$1(AbstractWorkspace abstractWorkspace, int n, Procedure procedure, Procedure procedure2, SimpleJobOwner simpleJobOwner) {
        Predef$.MODULE$.println(new StringBuilder().append((Object)"(").append((Object)abstractWorkspace.modelNameForDisplay()).append((Object)")").toString());
        System.gc();
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)(n * 1000)) {
            this.goOnce$1(abstractWorkspace, procedure, procedure2, simpleJobOwner);
        }
    }

    private final boolean done$1(int n, int n2, ListBuffer listBuffer) {
        return this.total$1(listBuffer) > (double)n && (listBuffer.size() >= this.runs$1(listBuffer) || this.total$1(listBuffer) >= (double)n2);
    }

    private final void chatter$1(ListBuffer listBuffer, LongRef longRef) {
        if (System.currentTimeMillis() - longRef.elem > 10000L) {
            Predef$.MODULE$.println(new StringBuilder().append(listBuffer.size()).append((Object)"/").append(BoxesRunTime.boxToInteger(this.runs$1(listBuffer))).append((Object)" (mean=").append((Object)this.formatter().format(this.average$1(listBuffer))).append((Object)", stddev=").append((Object)this.formatter().format(this.stddev$1(listBuffer))).append((Object)")").toString());
            longRef.elem = System.currentTimeMillis();
        }
    }

    private final void debrief$1(AbstractWorkspace abstractWorkspace, ListBuffer listBuffer, LongRef longRef) {
        longRef.elem = 0L;
        this.chatter$1(listBuffer, longRef);
        Predef$.MODULE$.println(new StringBuilder().append((Object)"@@@ ").append((Object)abstractWorkspace.modelNameForDisplay()).append((Object)": ").append((Object)this.formatter().format(this.average$1(listBuffer))).append((Object)(listBuffer.size() < this.runs$1(listBuffer) ? " (hit time limit)" : "")).toString());
    }

    private Benchmarker$() {
        MODULE$ = this;
        this.Z = 2.3263;
        this.bitmap$init$0 |= 1;
        this.TOLERANCE = 0.003;
        this.bitmap$init$0 |= 2;
        this.formatter = new DecimalFormat("0.000");
        this.bitmap$init$0 |= 4;
    }
}

