/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.nlogo.agent.OutputObject;
import org.nlogo.agent.World;
import org.nlogo.api.CompilerException;
import org.nlogo.api.FileMode;
import org.nlogo.api.FileModeJ;
import org.nlogo.api.I18N;
import org.nlogo.api.LocalFile;
import org.nlogo.api.RemoteFile;
import org.nlogo.nvm.FileManager;
import org.nlogo.workspace.AbstractWorkspace;

public strictfp final class DefaultFileManager
implements FileManager {
    private final List<org.nlogo.api.File> openFiles = new ArrayList<org.nlogo.api.File>();
    private org.nlogo.api.File currentFile;
    private String prefix;
    private final AbstractWorkspace workspace;

    public DefaultFileManager(AbstractWorkspace workspace) {
        this.workspace = workspace;
        if (AbstractWorkspace.isApp()) {
            this.setPrefix(System.getProperty("user.home"));
        }
    }

    public String getErrorInfo() throws IOException {
        long position = this.currentFile.pos();
        this.currentFile.close(true);
        this.currentFile.open(FileModeJ.READ());
        int lineNumber = 1;
        long prevPosition = 0L;
        String lastLine = this.readLine();
        while (this.currentFile.pos() < position) {
            ++lineNumber;
            prevPosition = this.currentFile.pos();
            lastLine = this.readLine();
        }
        int charPos = (int)(position - prevPosition);
        if (charPos >= lastLine.length() && !this.eof()) {
            lastLine = this.readLine();
            charPos = 0;
            ++lineNumber;
        }
        this.closeCurrentFile();
        return " (line number " + lineNumber + ", character " + (charPos + 1) + ")";
    }

    public String getPrefix() {
        return this.prefix;
    }

    public org.nlogo.api.File getFile(String fileName) {
        if (AbstractWorkspace.isApplet()) {
            return new RemoteFile(fileName);
        }
        return new LocalFile(fileName);
    }

    public void setPrefix(String newPrefix) {
        if (AbstractWorkspace.isApplet()) {
            return;
        }
        if (newPrefix.charAt(newPrefix.length() - 1) != File.separatorChar) {
            newPrefix = newPrefix + File.separatorChar;
        }
        if (new File(newPrefix).isAbsolute()) {
            this.prefix = newPrefix;
        } else {
            this.prefix = this.relativeToAbsolute(newPrefix);
            if (this.prefix.charAt(this.prefix.length() - 1) != File.separatorChar) {
                this.prefix = this.prefix + File.separatorChar;
            }
        }
    }

    public void setPrefix(URL newPrefix) {
        this.prefix = newPrefix.toString();
    }

    public String attachPrefix(String filename) throws MalformedURLException {
        if (AbstractWorkspace.isApplet()) {
            try {
                return new URL(new URL(this.prefix), filename).toString();
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException(ex);
            }
        }
        File fileForm = new File(filename);
        if (fileForm.isAbsolute() || this.prefix == null) {
            return filename;
        }
        return this.relativeToAbsolute(filename);
    }

    private String relativeToAbsolute(String newPath) {
        try {
            return new File(this.prefix + File.separatorChar + newPath).getCanonicalPath();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public org.nlogo.api.File currentFile() {
        return this.hasCurrentFile() ? this.currentFile : null;
    }

    public boolean hasCurrentFile() {
        return this.currentFile != null && this.isFileOpen(this.currentFile.getAbsolutePath());
    }

    private boolean isFileOpen(String fileName) {
        return this.findOpenFile(fileName) != null;
    }

    public org.nlogo.api.File findOpenFile(String fileName) {
        if (AbstractWorkspace.isApplet()) {
            for (org.nlogo.api.File nextFile : this.openFiles) {
                if (!fileName.equals(nextFile.getPath())) continue;
                return nextFile;
            }
        } else {
            File newFile = new File(fileName);
            for (org.nlogo.api.File nextFile : this.openFiles) {
                if (!newFile.getAbsolutePath().equals(nextFile.getAbsolutePath())) continue;
                return nextFile;
            }
        }
        return null;
    }

    private boolean isFileCurrent(org.nlogo.api.File checkFile) {
        return this.currentFile == checkFile;
    }

    public void setCurrentFile(org.nlogo.api.File newFile) {
        if (!this.isFileCurrent(newFile)) {
            this.currentFile = newFile;
        }
    }

    public void ensureMode(FileMode openMode) throws IOException {
        if (!this.hasCurrentFile()) {
            throw new IOException(I18N.errorsJ().get("org.nlogo.workspace.DefaultFileManager.noOpenFile"));
        }
        if (this.currentFile.mode() == FileModeJ.NONE()) {
            try {
                this.currentFile.open(openMode);
            }
            catch (FileNotFoundException ex) {
                throw new IOException("The file " + this.currentFile.getAbsolutePath() + " cannot be found");
            }
            catch (IOException ex) {
                throw new IOException(ex.getMessage());
            }
        } else if (this.currentFile.mode() != openMode) {
            String mode = this.currentFile.mode() == FileModeJ.READ() ? "READING" : "WRITING";
            throw new IOException("You can only use " + mode + " primitives with this file");
        }
    }

    public boolean fileExists(String filePath) {
        if (AbstractWorkspace.isApplet()) {
            try {
                return RemoteFile.exists(this.attachPrefix(filePath));
            }
            catch (MalformedURLException ex) {
                return false;
            }
        }
        return new File(filePath).exists();
    }

    public void deleteFile(String filePath) throws IOException {
        org.nlogo.api.File file = this.findOpenFile(filePath);
        if (file != null) {
            throw new IOException("You need to close the file before deletion");
        }
        File checkFile = new File(filePath);
        if (!checkFile.exists()) {
            throw new IOException(I18N.errorsJ().get("org.nlogo.workspace.DefaultFileManager.cannotDeleteNonExistantFile"));
        }
        if (!checkFile.canWrite()) {
            throw new IOException("Modification to this file is denied.");
        }
        if (!checkFile.isFile()) {
            throw new IOException(I18N.errorsJ().get("org.nlogo.workspace.DefaultFileManager.canOnlyDeleteFiles"));
        }
        if (!checkFile.delete()) {
            throw new IOException("Deletion failed.");
        }
    }

    public void openFile(String newFileName) throws IOException {
        String fullFileName = this.attachPrefix(newFileName);
        if (fullFileName == null) {
            throw new IOException("This filename is illegal, " + newFileName);
        }
        org.nlogo.api.File newFile = this.findOpenFile(fullFileName);
        if (newFile == null) {
            newFile = AbstractWorkspace.isApplet() ? new RemoteFile(fullFileName) : new LocalFile(fullFileName);
            this.openFiles.add(newFile);
        }
        this.setCurrentFile(newFile);
    }

    public void flushCurrentFile() throws IOException {
        if (!this.hasCurrentFile()) {
            throw new IOException("There is no file to file");
        }
        this.flushFile(this.currentFile.getAbsolutePath());
    }

    public void flushFile(String flushFileName) {
        org.nlogo.api.File flushFile = this.findOpenFile(flushFileName);
        flushFile.flush();
    }

    public void closeCurrentFile() throws IOException {
        if (!this.hasCurrentFile()) {
            this.closeAllFiles();
            throw new IOException("There is no file to close");
        }
        this.closeFile(this.currentFile.getAbsolutePath());
        this.setCurrentFile(null);
    }

    private void closeFile(String closeFileName) throws IOException {
        org.nlogo.api.File closeFile = this.findOpenFile(closeFileName);
        closeFile.close(true);
        this.openFiles.remove(closeFile);
    }

    public String readLine() throws IOException {
        if (this.eof()) {
            throw new EOFException();
        }
        BufferedReader buffReader = this.currentFile.reader();
        String retString = "";
        char[] charbuff = new char[80];
        int charsRead = 80;
        int skip = 1;
        while (charsRead == 80) {
            buffReader.mark(82);
            charsRead = buffReader.read(charbuff, 0, 80);
            for (int i = 0; i < charsRead; ++i) {
                if (charbuff[i] == '\r') {
                    if (i < 79 && charbuff[i + 1] == '\n' || i == 79 && buffReader.read() == 10) {
                        skip = 2;
                    }
                    charsRead = i;
                    continue;
                }
                if (charbuff[i] != '\n') continue;
                charsRead = i;
            }
            this.currentFile.pos_$eq(this.currentFile.pos() + (long)charsRead);
            retString = retString + new String(charbuff, 0, charsRead);
        }
        buffReader.reset();
        this.currentFile.pos_$eq(this.currentFile.pos() + buffReader.skip(charsRead + skip) - (long)charsRead);
        return retString;
    }

    public String readChars(int num) throws IOException {
        if (this.eof()) {
            throw new EOFException();
        }
        char[] charbuff = new char[num];
        BufferedReader buffReader = this.currentFile.reader();
        this.currentFile.pos_$eq(this.currentFile.pos() + (long)buffReader.read(charbuff, 0, num));
        return String.valueOf(charbuff);
    }

    public String readRemainder() throws IOException {
        if (this.eof()) {
            throw new EOFException();
        }
        String remainder = "";
        String line = this.readLine();
        while (line != null) {
            remainder = remainder + line;
            line = this.readLine();
            this.currentFile.pos_$eq(this.currentFile.pos() + (long)line.length());
        }
        return remainder;
    }

    public Object read(World world) throws IOException, CompilerException {
        if (this.eof()) {
            throw new EOFException();
        }
        return this.workspace.compiler().readFromFile(this.currentFile, world, this.workspace.getExtensionManager());
    }

    public boolean eof() throws IOException {
        this.ensureMode(FileModeJ.READ());
        if (!this.currentFile.eof()) {
            BufferedReader buffReader = this.currentFile.reader();
            buffReader.mark(2);
            this.currentFile.eof_$eq(buffReader.read() == -1);
            buffReader.reset();
        }
        return this.currentFile.eof();
    }

    public void closeAllFiles() throws IOException {
        Iterator<org.nlogo.api.File> files = this.openFiles.iterator();
        while (files.hasNext()) {
            org.nlogo.api.File nextFile = files.next();
            this.closeFile(nextFile.getAbsolutePath());
            files = this.openFiles.iterator();
        }
        this.setCurrentFile(null);
    }

    public void writeOutputObject(OutputObject oo) {
        PrintWriter w = this.currentFile.getPrintWriter();
        w.print(oo.get());
    }

    public void handleModelChange() {
        if (this.workspace.getModelDir() != null) {
            this.setPrefix(this.workspace.getModelDir());
        } else if (AbstractWorkspace.isApp()) {
            this.setPrefix(System.getProperty("user.home"));
        }
        try {
            this.closeAllFiles();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

