/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.bitmap;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.DefaultClassManager;
import org.nlogo.api.DefaultCommand;
import org.nlogo.api.DefaultReporter;
import org.nlogo.api.Dump;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.api.Primitive;
import org.nlogo.api.PrimitiveManager;
import org.nlogo.api.Syntax;
import org.nlogo.extensions.bitmap.LogoBitmap;
import org.nlogo.nvm.ExtensionContext;
import org.nlogo.nvm.FileManager;
import org.nlogo.nvm.Workspace;

public class BitmapExtension
extends DefaultClassManager {
    public void load(PrimitiveManager primitiveManager) {
        primitiveManager.addPrimitive("import", (Primitive)new LoadImage());
        primitiveManager.addPrimitive("export", (Primitive)new SaveImage());
        primitiveManager.addPrimitive("from-view", (Primitive)new GrabView());
        primitiveManager.addPrimitive("scaled", (Primitive)new Scale());
        primitiveManager.addPrimitive("difference-rgb", (Primitive)new DifferenceRGB());
        primitiveManager.addPrimitive("channel", (Primitive)new ExtractChannel());
        primitiveManager.addPrimitive("to-grayscale", (Primitive)new Grayscale());
        primitiveManager.addPrimitive("copy-to-drawing", (Primitive)new ImportToDrawing());
        primitiveManager.addPrimitive("copy-to-pcolors", (Primitive)new ImportToPcolors());
        primitiveManager.addPrimitive("width", (Primitive)new Width());
        primitiveManager.addPrimitive("height", (Primitive)new Height());
        primitiveManager.addPrimitive("average-color", (Primitive)new RGBLevels());
    }

    private static BufferedImage getBitmapFromArgument(Argument arg) throws ExtensionException, LogoException {
        Object obj = arg.get();
        if (!(obj instanceof BufferedImage)) {
            throw new ExtensionException("not a bitmap: " + Dump.logoObject((Object)obj));
        }
        return (BufferedImage)obj;
    }

    private static LogoBitmap scale(BufferedImage image, float scalex, float scaley) {
        return new LogoBitmap(new AffineTransformOp(AffineTransform.getScaleInstance(scalex, scaley), 2).filter(image, null));
    }

    private static LogoBitmap diff(BufferedImage src1, BufferedImage src2) {
        int width = src1.getWidth();
        int height = src1.getHeight();
        int[] rgbArray1 = new int[width * height];
        int[] rgbArray2 = new int[width * height];
        src1.getRGB(0, 0, width, height, rgbArray1, 0, width);
        src2.getRGB(0, 0, width, height, rgbArray2, 0, width);
        for (int i = 0; i < rgbArray1.length; ++i) {
            rgbArray1[i] = rgbArray1[i] ^ rgbArray2[i] | 0xFF000000;
        }
        WritableRaster raster = src1.copyData(null);
        BufferedImage dest = new BufferedImage(src1.getColorModel(), raster, src1.isAlphaPremultiplied(), null);
        dest.setRGB(0, 0, width, height, rgbArray1, 0, width);
        return new LogoBitmap(dest);
    }

    private static LogoBitmap extractChannel(BufferedImage img, int channel) {
        int width = img.getWidth();
        int height = img.getHeight();
        int[] rgbArray = new int[width * height];
        img.getRGB(0, 0, width, height, rgbArray, 0, width);
        for (int i = 0; i < rgbArray.length; ++i) {
            int val = (rgbArray[i] & 255 << 8 * (3 - channel)) >> 8 * (3 - channel);
            rgbArray[i] = val | val << 8 | val << 16 | 0xFF000000;
        }
        WritableRaster raster = img.copyData(null);
        BufferedImage dest = new BufferedImage(img.getColorModel(), raster, img.isAlphaPremultiplied(), null);
        dest.setRGB(0, 0, width, height, rgbArray, 0, width);
        return new LogoBitmap(dest);
    }

    public static class RGBLevels
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        public String getAgentClassString() {
            return "O";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            BufferedImage image = BitmapExtension.getBitmapFromArgument(args[0]);
            int width = image.getWidth();
            int height = image.getHeight();
            int[] rgbArray = new int[width * height];
            image.getRGB(0, 0, width, height, rgbArray, 0, width);
            long rSum = 0L;
            long gSum = 0L;
            long bSum = 0L;
            for (int i = 0; i < rgbArray.length; ++i) {
                rSum += (long)(rgbArray[i] >> 16 & 0xFF);
                gSum += (long)(rgbArray[i] >> 8 & 0xFF);
                bSum += (long)(rgbArray[i] & 0xFF);
            }
            LogoListBuilder lst = new LogoListBuilder();
            lst.add((Object)((double)rSum / (double)width / (double)height));
            lst.add((Object)((double)gSum / (double)width / (double)height));
            lst.add((Object)((double)bSum / (double)width / (double)height));
            return lst.toLogoList();
        }
    }

    public static class Grayscale
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        public String getAgentClassString() {
            return "O";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            BufferedImage colorImage = BitmapExtension.getBitmapFromArgument(args[0]);
            BufferedImage grayImage = new BufferedImage(colorImage.getWidth(), colorImage.getHeight(), 10);
            Graphics g = grayImage.getGraphics();
            g.drawImage(colorImage, 0, 0, null);
            g.dispose();
            return grayImage;
        }
    }

    public static class ExtractChannel
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType()}, (int)Syntax.WildcardType());
        }

        public String getAgentClassString() {
            return "O";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            BufferedImage image = BitmapExtension.getBitmapFromArgument(args[0]);
            int channel = args[1].getIntValue();
            if (channel < 0 || channel > 3) {
                throw new ExtensionException("The channel # must be between 0 and 3 (0=alpha,1=red,2=green,3=blue).");
            }
            return BitmapExtension.extractChannel(image, channel);
        }
    }

    public static class DifferenceRGB
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        public String getAgentClassString() {
            return "O";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            BufferedImage image1 = BitmapExtension.getBitmapFromArgument(args[0]);
            BufferedImage image2 = BitmapExtension.getBitmapFromArgument(args[1]);
            if (image1.getWidth() != image2.getWidth() || image1.getHeight() != image2.getHeight()) {
                throw new ExtensionException("The two images you are 'differencing' must be the same dimensions!");
            }
            return BitmapExtension.diff(image1, image2);
        }
    }

    public static class ImportToPcolors
    extends DefaultCommand {
        public Syntax getSyntax() {
            int[] right = new int[]{Syntax.WildcardType(), Syntax.BooleanType()};
            return Syntax.commandSyntax((int[])right);
        }

        public String getAgentClassString() {
            return "O";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            BufferedImage image = BitmapExtension.getBitmapFromArgument(args[0]);
            context.importPcolors(image, args[1].getBooleanValue());
        }
    }

    public static class ImportToDrawing
    extends DefaultCommand {
        public Syntax getSyntax() {
            int[] right = new int[]{Syntax.WildcardType(), Syntax.NumberType(), Syntax.NumberType()};
            return Syntax.commandSyntax((int[])right);
        }

        public String getAgentClassString() {
            return "O";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            BufferedImage image = BitmapExtension.getBitmapFromArgument(args[0]);
            int xOffset = args[1].getIntValue();
            int yOffset = args[2].getIntValue();
            BufferedImage drawing = context.getDrawing();
            drawing.createGraphics().drawImage((Image)image, xOffset, yOffset, null);
        }
    }

    public static class Scale
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType(), Syntax.NumberType()}, (int)Syntax.WildcardType());
        }

        public String getAgentClassString() {
            return "O";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            BufferedImage image = BitmapExtension.getBitmapFromArgument(args[0]);
            float scalex = (float)args[1].getDoubleValue() / (float)image.getWidth();
            float scaley = (float)args[2].getDoubleValue() / (float)image.getHeight();
            return BitmapExtension.scale(image, scalex, scaley);
        }
    }

    public static class Height
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.NumberType());
        }

        public String getAgentClassString() {
            return "O";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            return (double)BitmapExtension.getBitmapFromArgument(args[0]).getHeight();
        }
    }

    public static class Width
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.NumberType());
        }

        public String getAgentClassString() {
            return "O";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            return (double)BitmapExtension.getBitmapFromArgument(args[0]).getWidth();
        }
    }

    public static class GrabView
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[0], (int)Syntax.WildcardType());
        }

        public String getAgentClassString() {
            return "O";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            ExtensionContext ec = (ExtensionContext)context;
            Workspace ws = ec.workspace();
            return new LogoBitmap(ws.exportView());
        }
    }

    public static class SaveImage
    extends DefaultCommand {
        public Syntax getSyntax() {
            int[] right = new int[]{Syntax.WildcardType(), Syntax.StringType()};
            return Syntax.commandSyntax((int[])right);
        }

        public String getAgentClassString() {
            return "O";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            BufferedImage image = BitmapExtension.getBitmapFromArgument(args[0]);
            try {
                String filename = context.attachCurrentDirectory(args[1].getString());
                FileOutputStream stream = new FileOutputStream(filename);
                ImageIO.write((RenderedImage)image, "png", stream);
                stream.close();
            }
            catch (IOException e) {
                throw new ExtensionException(e.getMessage());
            }
        }
    }

    public static class LoadImage
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.StringType()}, (int)Syntax.WildcardType());
        }

        public String getAgentClassString() {
            return "O";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            FileManager fm = ((ExtensionContext)context).workspace().fileManager();
            try {
                String path = fm.attachPrefix(args[0].getString());
                return new LogoBitmap(ImageIO.read(fm.getFile(path).getInputStream()));
            }
            catch (IOException e) {
                throw new ExtensionException(e.getMessage());
            }
        }
    }
}

