/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.Patch;
import org.nlogo.agent.PatchException;
import org.nlogo.agent.Topology;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;

strictfp final class HorizCylinder
extends Topology {
    HorizCylinder(World world) {
        super(world);
    }

    double wrapX(double d) throws AgentException {
        double d2 = (double)this.world.maxPxcor() + 0.5;
        double d3 = (double)this.world.minPxcor() - 0.5;
        if (d >= d2 || d < d3) {
            throw new AgentException("Cannot move turtle beyond the world's edge.");
        }
        return d;
    }

    double wrapY(double d) {
        return HorizCylinder.wrap(d, (double)this.world.minPycor() - 0.5, (double)this.world.maxPycor() + 0.5);
    }

    double distanceWrap(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d4 > d6 ? d6 + (double)this.world.worldHeight() - d4 : d6 - (double)this.world.worldHeight() - d4;
        d2 = StrictMath.abs(d7) < StrictMath.abs(d2) ? d7 : d2;
        return this.world.rootsTable.gridRoot(d * d + d2 * d2);
    }

    double towardsWrap(double d, double d2) {
        if ((d2 = HorizCylinder.wrap(d2, -((double)this.world.worldHeight()) / 2.0, (double)this.world.worldHeight() / 2.0)) == 0.0) {
            return d > 0.0 ? 90.0 : 270.0;
        }
        if (d == 0.0) {
            return d2 > 0.0 ? 0.0 : 180.0;
        }
        return (270.0 + StrictMath.toDegrees(Math.PI + StrictMath.atan2(-d2, d))) % 360.0;
    }

    Patch getPatchAt(double d, double d2) throws AgentException {
        if (d > (double)this.world.maxPxcor() + 0.5 || d < (double)this.world.minPxcor() - 0.5) {
            return null;
        }
        return this.world.getPatchAt(d, d2);
    }

    double shortestPathX(double d, double d2) {
        return d2;
    }

    double shortestPathY(double d, double d2) {
        double d3 = d > d2 ? d2 + (double)this.world.worldHeight() : d2 - (double)this.world.worldHeight();
        if (StrictMath.abs(d2 - d) > StrictMath.abs(d3 - d)) {
            d2 = d3;
        }
        return d2;
    }

    void diffuse(double d, int n) throws AgentException, PatchException {
        int n2 = this.world.worldWidth();
        int n3 = this.world.worldHeight();
        int n4 = n2 * 2;
        int n5 = n3 * 2;
        double[][] dArray = this.world.getPatchScratch();
        double[][] dArray2 = new double[n2][n3];
        int n6 = 0;
        int n7 = 0;
        int n8 = this.world.minPxcor();
        int n9 = this.world.minPycor();
        try {
            for (n7 = 0; n7 < n3; ++n7) {
                for (n6 = 0; n6 < n2; ++n6) {
                    dArray[n6][n7] = (Double)this.world.fastGetPatchAt(n6 + n8, n7 + n9).getPatchVariable(n);
                    dArray2[n6][n7] = 0.0;
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new PatchException(this.world.fastGetPatchAt((int)this.wrapX(n6), (int)this.wrapY(n7)));
        }
        for (n7 = n3; n7 < n5; ++n7) {
            for (n6 = n2; n6 < n4; ++n6) {
                double d2 = dArray[n6 - n2][n7 - n3] / 8.0 * d;
                if (n6 > n2 && n6 < n4 - 1) {
                    double[] dArray3 = dArray2[n6 - n2];
                    int n10 = n7 - n3;
                    dArray3[n10] = dArray3[n10] + (dArray[n6 - n2][n7 - n3] - 8.0 * d2);
                    double[] dArray4 = dArray2[(n6 - 1) % n2];
                    int n11 = (n7 - 1) % n3;
                    dArray4[n11] = dArray4[n11] + d2;
                    double[] dArray5 = dArray2[(n6 - 1) % n2];
                    int n12 = n7 % n3;
                    dArray5[n12] = dArray5[n12] + d2;
                    double[] dArray6 = dArray2[(n6 - 1) % n2];
                    int n13 = (n7 + 1) % n3;
                    dArray6[n13] = dArray6[n13] + d2;
                    double[] dArray7 = dArray2[n6 % n2];
                    int n14 = (n7 + 1) % n3;
                    dArray7[n14] = dArray7[n14] + d2;
                    double[] dArray8 = dArray2[n6 % n2];
                    int n15 = (n7 - 1) % n3;
                    dArray8[n15] = dArray8[n15] + d2;
                    double[] dArray9 = dArray2[(n6 + 1) % n2];
                    int n16 = (n7 - 1) % n3;
                    dArray9[n16] = dArray9[n16] + d2;
                    double[] dArray10 = dArray2[(n6 + 1) % n2];
                    int n17 = n7 % n3;
                    dArray10[n17] = dArray10[n17] + d2;
                    double[] dArray11 = dArray2[(n6 + 1) % n2];
                    int n18 = (n7 + 1) % n3;
                    dArray11[n18] = dArray11[n18] + d2;
                    continue;
                }
                if (n6 == n2) {
                    double[] dArray12 = dArray2[n6 - n2];
                    int n19 = n7 - n3;
                    dArray12[n19] = dArray12[n19] + (dArray[n6 - n2][n7 - n3] - 5.0 * d2);
                    double[] dArray13 = dArray2[n6 % n2];
                    int n20 = (n7 + 1) % n3;
                    dArray13[n20] = dArray13[n20] + d2;
                    double[] dArray14 = dArray2[n6 % n2];
                    int n21 = (n7 - 1) % n3;
                    dArray14[n21] = dArray14[n21] + d2;
                    double[] dArray15 = dArray2[(n6 + 1) % n2];
                    int n22 = (n7 - 1) % n3;
                    dArray15[n22] = dArray15[n22] + d2;
                    double[] dArray16 = dArray2[(n6 + 1) % n2];
                    int n23 = n7 % n3;
                    dArray16[n23] = dArray16[n23] + d2;
                    double[] dArray17 = dArray2[(n6 + 1) % n2];
                    int n24 = (n7 + 1) % n3;
                    dArray17[n24] = dArray17[n24] + d2;
                    continue;
                }
                double[] dArray18 = dArray2[n6 - n2];
                int n25 = n7 - n3;
                dArray18[n25] = dArray18[n25] + (dArray[n6 - n2][n7 - n3] - 5.0 * d2);
                double[] dArray19 = dArray2[n6 % n2];
                int n26 = (n7 + 1) % n3;
                dArray19[n26] = dArray19[n26] + d2;
                double[] dArray20 = dArray2[n6 % n2];
                int n27 = (n7 - 1) % n3;
                dArray20[n27] = dArray20[n27] + d2;
                double[] dArray21 = dArray2[(n6 - 1) % n2];
                int n28 = (n7 - 1) % n3;
                dArray21[n28] = dArray21[n28] + d2;
                double[] dArray22 = dArray2[(n6 - 1) % n2];
                int n29 = n7 % n3;
                dArray22[n29] = dArray22[n29] + d2;
                double[] dArray23 = dArray2[(n6 - 1) % n2];
                int n30 = (n7 + 1) % n3;
                dArray23[n30] = dArray23[n30] + d2;
            }
        }
        for (n7 = 0; n7 < n3; ++n7) {
            for (n6 = 0; n6 < n2; ++n6) {
                if (dArray2[n6][n7] == dArray[n6][n7]) continue;
                this.world.getPatchAtWrap(n6 + n8, n7 + n9).setPatchVariable(n, dArray2[n6][n7]);
            }
        }
    }

    void diffuse4(double d, int n) throws AgentException, PatchException {
        int n2 = this.world.worldWidth();
        int n3 = this.world.worldHeight();
        int n4 = n2 * 2;
        int n5 = n3 * 2;
        double[][] dArray = this.world.getPatchScratch();
        double[][] dArray2 = new double[n2][n3];
        int n6 = 0;
        int n7 = 0;
        int n8 = this.world.minPxcor();
        int n9 = this.world.minPycor();
        try {
            for (n7 = 0; n7 < n3; ++n7) {
                for (n6 = 0; n6 < n2; ++n6) {
                    dArray[n6][n7] = (Double)this.world.fastGetPatchAt(n6 + n8, n7 + n9).getPatchVariable(n);
                    dArray2[n6][n7] = 0.0;
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new PatchException(this.world.fastGetPatchAt((int)this.wrapX(n6), (int)this.wrapY(n7)));
        }
        for (n7 = n3; n7 < n5; ++n7) {
            for (n6 = n2; n6 < n4; ++n6) {
                double d2 = dArray[n6 - n2][n7 - n3] / 4.0 * d;
                if (n6 > 0 && n6 < n2 - 1) {
                    double[] dArray3 = dArray2[n6 - n2];
                    int n10 = n7 - n3;
                    dArray3[n10] = dArray3[n10] + (dArray[n6 - n2][n7 - n3] - 4.0 * d2);
                    double[] dArray4 = dArray2[(n6 - 1) % n2];
                    int n11 = n7;
                    dArray4[n11] = dArray4[n11] + d2;
                    double[] dArray5 = dArray2[n6 % n2];
                    int n12 = (n7 + 1) % n3;
                    dArray5[n12] = dArray5[n12] + d2;
                    double[] dArray6 = dArray2[n6 % n2];
                    int n13 = (n7 - 1) % n3;
                    dArray6[n13] = dArray6[n13] + d2;
                    double[] dArray7 = dArray2[(n6 + 1) % n2];
                    int n14 = n7 % n3;
                    dArray7[n14] = dArray7[n14] + d2;
                    continue;
                }
                if (n6 == n2) {
                    double[] dArray8 = dArray2[n6 - n2];
                    int n15 = n7 - n3;
                    dArray8[n15] = dArray8[n15] + (dArray[n6 - n2][n7 - n3] - 3.0 * d2);
                    double[] dArray9 = dArray2[n6 % n2];
                    int n16 = (n7 + 1) % n3;
                    dArray9[n16] = dArray9[n16] + d2;
                    double[] dArray10 = dArray2[n6 % n2];
                    int n17 = (n7 - 1) % n3;
                    dArray10[n17] = dArray10[n17] + d2;
                    double[] dArray11 = dArray2[(n6 + 1) % n2];
                    int n18 = n7 % n3;
                    dArray11[n18] = dArray11[n18] + d2;
                    continue;
                }
                double[] dArray12 = dArray2[n6 - n2];
                int n19 = n7 - n3;
                dArray12[n19] = dArray12[n19] + (dArray[n6 - n2][n7 - n3] - 3.0 * d2);
                double[] dArray13 = dArray2[n6 % n2];
                int n20 = (n7 + 1) % n3;
                dArray13[n20] = dArray13[n20] + d2;
                double[] dArray14 = dArray2[n6 % n2];
                int n21 = (n7 - 1) % n3;
                dArray14[n21] = dArray14[n21] + d2;
                double[] dArray15 = dArray2[(n6 - 1) % n2];
                int n22 = n7 % n3;
                dArray15[n22] = dArray15[n22] + d2;
            }
        }
        for (n7 = 0; n7 < n3; ++n7) {
            for (n6 = 0; n6 < n2; ++n6) {
                if (dArray2[n6][n7] == dArray[n6][n7]) continue;
                this.world.getPatchAtWrap(n6 + n8, n7 + n9).setPatchVariable(n, dArray2[n6][n7]);
            }
        }
    }

    double followOffsetX() {
        return 0.0;
    }

    AgentSet getNeighbors(Patch patch) {
        if (patch.pxcor == this.world.maxPxcor()) {
            if (patch.pxcor == this.world.minPxcor()) {
                if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
                    return new ArrayAgentSet(Patch.class, new Agent[0], this.world);
                }
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchSouth(patch)}, this.world);
            }
            if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchWest(patch)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchSouth(patch), this.getPatchWest(patch), this.getPatchSouthWest(patch), this.getPatchNorthWest(patch)}, this.world);
        }
        if (patch.pxcor == this.world.minPxcor()) {
            if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(patch)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchEast(patch), this.getPatchSouth(patch), this.getPatchNorthEast(patch), this.getPatchSouthEast(patch)}, this.world);
        }
        if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(patch), this.getPatchWest(patch)}, this.world);
        }
        return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchEast(patch), this.getPatchSouth(patch), this.getPatchWest(patch), this.getPatchNorthEast(patch), this.getPatchSouthEast(patch), this.getPatchSouthWest(patch), this.getPatchNorthWest(patch)}, this.world);
    }

    AgentSet getNeighbors4(Patch patch) {
        if (patch.pxcor == this.world.maxPxcor()) {
            if (patch.pxcor == this.world.minPxcor()) {
                if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
                    return new ArrayAgentSet(Patch.class, new Agent[0], this.world);
                }
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchSouth(patch)}, this.world);
            }
            if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchWest(patch)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchSouth(patch), this.getPatchWest(patch)}, this.world);
        }
        if (patch.pxcor == this.world.minPxcor()) {
            if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(patch)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchEast(patch), this.getPatchSouth(patch)}, this.world);
        }
        if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(patch), this.getPatchWest(patch)}, this.world);
        }
        return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchEast(patch), this.getPatchSouth(patch), this.getPatchWest(patch)}, this.world);
    }

    Patch getPN(Patch patch) {
        return this.getPatchNorth(patch);
    }

    Patch getPE(Patch patch) {
        if (patch.pxcor == this.world.maxPxcor()) {
            return null;
        }
        return this.getPatchEast(patch);
    }

    Patch getPS(Patch patch) {
        return this.getPatchSouth(patch);
    }

    Patch getPW(Patch patch) {
        if (patch.pxcor == this.world.minPxcor()) {
            return null;
        }
        return this.getPatchWest(patch);
    }

    Patch getPNE(Patch patch) {
        if (patch.pxcor == this.world.maxPxcor()) {
            return null;
        }
        return this.getPatchNorthEast(patch);
    }

    Patch getPSE(Patch patch) {
        if (patch.pxcor == this.world.maxPxcor()) {
            return null;
        }
        return this.getPatchSouthEast(patch);
    }

    Patch getPSW(Patch patch) {
        if (patch.pxcor == this.world.minPxcor()) {
            return null;
        }
        return this.getPatchSouthWest(patch);
    }

    Patch getPNW(Patch patch) {
        if (patch.pxcor == this.world.minPxcor()) {
            return null;
        }
        return this.getPatchNorthWest(patch);
    }
}

