/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.Color;
import org.nlogo.api.File;
import org.nlogo.api.I18N;

public class ImportPatchColors {
    public static strictfp void importPatchColors(File file, World world, boolean bl) throws IOException {
        String string = file.getAbsolutePath();
        BufferedImage bufferedImage = ImageIO.read(file.getInputStream());
        if (bufferedImage == null) {
            throw new IOException(I18N.errorsJ().getN("org.nlogo.agent.ImportPatchColors.unsupportedImageFormat", string));
        }
        ImportPatchColors.doImport(bufferedImage, world, bl);
    }

    public static strictfp void doImport(BufferedImage bufferedImage, World world, boolean bl) {
        Object object;
        float f;
        float f2 = (float)world.worldWidth() / (float)bufferedImage.getWidth();
        float f3 = f2 < (f = (float)world.worldHeight() / (float)bufferedImage.getHeight()) ? f2 : f;
        BufferedImage bufferedImage2 = null;
        if (f3 != 1.0f) {
            object = new AffineTransformOp(AffineTransform.getScaleInstance(f3, f3), 2);
            if (bufferedImage.getColorModel().getColorSpace().getType() == 6 && !bufferedImage.getColorModel().hasAlpha()) {
                bufferedImage2 = ((AffineTransformOp)object).createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
                ((AffineTransformOp)object).filter(bufferedImage, bufferedImage2);
            } else {
                bufferedImage2 = ((AffineTransformOp)object).filter(bufferedImage, null);
            }
        } else {
            bufferedImage2 = bufferedImage;
        }
        object = bufferedImage2.getSampleModel();
        int n = StrictMath.min(bufferedImage2.getWidth(), world.worldWidth());
        int n2 = StrictMath.min(bufferedImage2.getHeight(), world.worldHeight());
        DataBuffer dataBuffer = bufferedImage2.getData().getDataBuffer();
        ColorModel colorModel = bufferedImage2.getColorModel();
        CachedColorLookup cachedColorLookup = new CachedColorLookup();
        int n3 = (int)StrictMath.floor((world.worldWidth() - bufferedImage2.getWidth()) / 2);
        int n4 = (int)StrictMath.floor((world.worldHeight() - bufferedImage2.getHeight()) / 2);
        int n5 = world.minPxcor() + n3;
        for (int i = 0; i < n; ++i) {
            int n6 = world.maxPycor() - n4;
            for (int j = 0; j < n2; ++j) {
                Object object2 = ((SampleModel)object).getDataElements(i, j, null, dataBuffer);
                if (colorModel.getAlpha(object2) != 0) {
                    int n7 = colorModel.getRGB(object2);
                    if (bl) {
                        world.fastGetPatchAt(n5, n6).pcolor(cachedColorLookup.lookupColor(n7));
                    } else {
                        try {
                            world.fastGetPatchAt(n5, n6).pcolor(Color.getRGBListByARGB(n7));
                        }
                        catch (AgentException agentException) {
                            throw new IllegalStateException(agentException);
                        }
                    }
                }
                --n6;
            }
            ++n5;
        }
    }

    private strictfp static class CachedColorLookup {
        private final Map<Integer, Double> cache = new HashMap<Integer, Double>();

        private CachedColorLookup() {
        }

        double lookupColor(int n) {
            Integer n2 = n;
            Double d = this.cache.get(n2);
            if (d == null && !this.cache.containsKey(n2)) {
                d = Color.getClosestColorNumberByARGB(n);
                this.cache.put(n2, d);
            }
            return d;
        }
    }
}

