/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ImportLexer;
import org.nlogo.agent.Link;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentVariables;
import org.nlogo.api.Color;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ImportErrorHandler;
import org.nlogo.api.ImporterUser;
import org.nlogo.api.LogoException;
import org.nlogo.api.Perspective;
import org.nlogo.api.PlotInterface;
import org.nlogo.api.PlotPenInterface;
import org.nlogo.api.WorldDimensions;
import scala.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class Importer
implements ImportErrorHandler {
    final ImporterUser importerUser;
    final ErrorHandler errorHandler;
    final World world;
    final StringReader stringReader;
    Set<Object> shapesNotToImport;
    Set<String> breedsNotToImport;
    List<String> someBreedOwns;
    List<String> someLinkBreedOwns;
    boolean needToResize = false;
    private boolean olderThan40beta2 = false;
    BitSet varsToImport;
    String[] builtInVars;
    boolean tooManyValuesForSection = false;
    boolean convertPenDown = false;
    boolean convertTopology = false;
    boolean importLinks = true;
    int TURTLE_BREED;
    Map<Class<? extends Agent>, List<String>> specialVariables;
    Map<Class<? extends Agent>, List<String>> essentialVarHeadersToImport;
    int lineNum = 0;
    String nextLine;
    private String[] nextLineFields;
    private final String[] sentinels = new String[]{"GLOBALS", "TURTLES", "PATCHES", "LINKS", "DRAWING", "OUTPUT", "PLOTS", "EXTENSIONS", "DONE"};
    private final int numSentinels = this.sentinels.length - 1;
    private int currentSentinel = 0;
    BufferedReader lines;

    void setupVarsToImport(int n) {
        this.varsToImport = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            this.varsToImport.set(i);
        }
    }

    public Importer(ErrorHandler errorHandler, World world, ImporterUser importerUser, StringReader stringReader) {
        this.errorHandler = errorHandler;
        this.world = world;
        this.importerUser = importerUser;
        this.stringReader = stringReader;
        this.TURTLE_BREED = 8;
        this.shapesNotToImport = new HashSet<Object>();
        this.breedsNotToImport = new HashSet<String>();
        this.someBreedOwns = this.getAllBreedVars();
        this.someLinkBreedOwns = this.getAllLinkBreedVars();
        this.specialVariables = this.fillSpecialVariables();
    }

    void checkVersion(String string) throws AbortingImportException {
        if (string.startsWith("1.") || string.startsWith("2.0") || string.startsWith("2.1") || string.startsWith("2.2pre1") || string.startsWith("2.2pre2")) {
            this.convertPenDown = true;
            this.convertTopology = true;
            this.importLinks = false;
        } else if (string.startsWith("3.0")) {
            this.convertTopology = true;
            this.importLinks = false;
        }
        if (string.startsWith("1.") || string.startsWith("2.") || string.startsWith("3.")) {
            this.importLinks = false;
        }
        if (string.startsWith("1.") || string.startsWith("2.") || string.startsWith("3.") || string.startsWith("4.0pre") || string.startsWith("4.0alpha") || string.startsWith("4.0beta1")) {
            this.olderThan40beta2 = true;
        }
    }

    public void importWorld(BufferedReader bufferedReader) throws IOException {
        this.lines = bufferedReader;
        try {
            while (this.hasMoreLines(false)) {
                String string;
                String[] stringArray = this.nextLine();
                if (stringArray[0].startsWith(string = "export-world data (NetLogo ")) {
                    String string2 = stringArray[0].substring(string.length());
                    this.checkVersion(string2);
                }
                if (!stringArray[0].trim().equals("RANDOM STATE")) continue;
                this.hasMoreLines(false);
                stringArray = this.nextLine();
                this.world.mainRNG.load(stringArray[0]);
            }
            this.essentialVarHeadersToImport = this.fillEssentialVarsToImport();
            this.world.clearAll();
            this.importAgents(Observer.class);
            this.importAgents(Turtle.class);
            this.importAgents(Patch.class);
            this.checkForBlankTurtles();
            if (this.importLinks) {
                this.importAgents(Link.class);
            }
            if (this.nextLine != null && this.nextLine.indexOf("DRAWING") != -1) {
                this.importDrawing();
            }
            if (this.nextLine != null && this.nextLine.indexOf("OUTPUT") != -1) {
                this.importOutputArea();
            }
            if (this.needToResize) {
                this.importerUser.resizeView();
            }
            this.importPlots();
            this.importExtensionData();
        }
        catch (AbortingImportException abortingImportException) {
            this.world.clearAll();
            if (abortingImportException.errorType != ImportError.ERROR_GIVEN) {
                this.showError(abortingImportException);
            }
        }
        catch (InvalidDataException invalidDataException) {
            this.errorHandler.showError("Error Importing Drawing", "Invalid data length, the drawing will not be imported", false);
        }
    }

    void importPlots() throws IOException {
        if (this.hasMoreLines(false)) {
            String[] stringArray = this.nextLine();
            String string = stringArray[0];
            if (string.length() > 0) {
                this.importerUser.currentPlot(string);
            }
            while (this.hasMoreLines(false)) {
                stringArray = this.nextLine();
                try {
                    String string2 = (String)this.getTokenValue(stringArray[0], false, false);
                    PlotInterface plotInterface = this.importerUser.getPlot(string2);
                    if (plotInterface == null) {
                        this.errorHandler.showError("Error Importing Plots", "The plot \"" + string2 + "\" does not exist.", false);
                        while (this.hasMoreLines(false)) {
                        }
                        return;
                    }
                    int n = this.importIntro(plotInterface);
                    this.importPens(plotInterface, n);
                    this.importPoints(plotInterface);
                    plotInterface.makeDirty();
                }
                catch (ClassCastException classCastException) {
                    throw new AbortingImportException(ImportError.ILLEGAL_CLASS_CAST_ERROR, "");
                }
            }
        }
    }

    int importIntro(PlotInterface plotInterface) throws IOException {
        if (this.hasMoreLines(false) && this.hasMoreLines(false)) {
            String[] stringArray = this.nextLine();
            plotInterface.xMin_$eq(this.readNumber(stringArray[0]));
            plotInterface.xMax_$eq(this.readNumber(stringArray[1]));
            plotInterface.yMin_$eq(this.readNumber(stringArray[2]));
            plotInterface.yMax_$eq(this.readNumber(stringArray[3]));
            plotInterface.autoPlotOn_$eq(this.readBoolean(stringArray[4]));
            plotInterface.currentPen_$eq(this.readString(stringArray[5]));
            plotInterface.legendIsOpen_$eq(this.readBoolean(stringArray[6]));
            return (int)this.readNumber(stringArray[7]);
        }
        return 0;
    }

    void importPens(PlotInterface plotInterface, int n) throws IOException {
        if (this.hasMoreLines(false)) {
            for (int i = 0; i < n; ++i) {
                if (!this.hasMoreLines(false)) continue;
                String[] stringArray = this.nextLine();
                Object object = this.getTokenValue(stringArray[0], false, false);
                if (object instanceof Junk) {
                    return;
                }
                Option<PlotPenInterface> option = plotInterface.getPen((String)object);
                if (option.isDefined()) {
                    PlotPenInterface plotPenInterface = option.get();
                    plotPenInterface.isDown_$eq(this.readBoolean(stringArray[1]));
                    plotPenInterface.mode_$eq((int)this.readNumber(stringArray[2]));
                    plotPenInterface.interval_$eq(this.readNumber(stringArray[3]));
                    plotPenInterface.color_$eq(Color.getARGBbyPremodulatedColorNumber(this.readNumber(stringArray[4])));
                    plotPenInterface.x_$eq(this.readNumber(stringArray[5]));
                    continue;
                }
                this.errorHandler.showError("Error Importing Plots", "The pen \"" + object + "\" does not exist.", false);
                while (this.hasMoreLines(false)) {
                    this.nextLine();
                }
            }
        }
    }

    void importPoints(PlotInterface plotInterface) throws IOException {
        if (this.hasMoreLines(false)) {
            String[] stringArray = this.nextLine();
            String[] stringArray2 = new String[(stringArray.length - 1) / 4 + 1];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = this.readString(stringArray[i * 4]);
            }
            if (this.hasMoreLines(false)) {
                while (this.hasMoreLines(true)) {
                    String[] stringArray3 = this.nextLine();
                    for (int i = 0; i < stringArray2.length; ++i) {
                        Option<PlotPenInterface> option = plotInterface.getPen(stringArray2[i]);
                        if (option.isDefined()) {
                            PlotPenInterface plotPenInterface = option.get();
                            if (stringArray3[i * 4].length() <= 0) continue;
                            try {
                                plotPenInterface.plot(this.readNumber(stringArray3[i * 4]), this.readNumber(stringArray3[i * 4 + 1]), Color.getARGBbyPremodulatedColorNumber((int)this.readNumber(stringArray3[i * 4 + 2])), this.readBoolean(stringArray3[i * 4 + 3]));
                            }
                            catch (ClassCastException classCastException) {
                                this.errorHandler.showError("Import Error", "Error while importing " + plotInterface.name() + ", this point will be skipped.", false);
                            }
                            continue;
                        }
                        this.errorHandler.showError("Error Importing Plots", "The pen \"" + stringArray2[i] + "\" does not exist.", false);
                    }
                }
            }
        }
    }

    private double readNumber(String string) {
        Object object = this.getTokenValue(string, false, false);
        if (!(object instanceof Junk)) {
            return (Double)object;
        }
        return 0.0;
    }

    private boolean readBoolean(String string) {
        Object object = this.getTokenValue(string, false, false);
        if (!(object instanceof Junk)) {
            return (Boolean)object;
        }
        return false;
    }

    private String readString(String string) {
        Object object = this.getTokenValue(string, false, false);
        if (!(object instanceof Junk)) {
            return (String)object;
        }
        return null;
    }

    void importOutputArea() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.hasMoreLines(false)) {
            String[] stringArray = this.nextLine();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append(stringArray[i]);
            }
        }
        if (stringBuilder.length() > 0) {
            this.importerUser.setOutputAreaContents((String)this.getTokenValue(stringBuilder.toString(), false, false));
        } else {
            this.importerUser.setOutputAreaContents("");
        }
    }

    void importDrawing() throws IOException {
        if (this.hasMoreLines(false)) {
            Double d = Double.valueOf(this.nextLine()[0]);
            this.importerUser.patchSize(d);
            this.importerUser.resizeView();
            this.needToResize = false;
            int n = (int)(d * (double)this.world.worldWidth());
            int n2 = (int)(d * (double)this.world.worldHeight());
            StringBuilder stringBuilder = new StringBuilder(n * n2 * 32);
            try {
                Object[] objectArray;
                while (this.hasMoreLines(false)) {
                    objectArray = this.nextLine();
                    for (int i = 0; i < objectArray.length; ++i) {
                        stringBuilder.append(this.stringReader.readFromString(objectArray[i].replaceAll(",", "")));
                    }
                }
                objectArray = Importer.fromHexString(stringBuilder.toString());
                if (objectArray.length != n * n2 * 4) {
                    throw new InvalidDataException("The data was not the correct length for the size of the world");
                }
                this.world.trailDrawer.setColors((int[])objectArray);
            }
            catch (StringReaderException stringReaderException) {
                throw new InvalidDataException("invalid drawing data: drawing will not be imported");
            }
        }
    }

    public void importExtensionData() {
        try {
            if (this.hasMoreLines(false)) {
                String[] stringArray = this.nextLine();
                String string = stringArray[0];
                while (this.hasMoreLines(false)) {
                    ArrayList<String[]> arrayList = new ArrayList<String[]>();
                    while (!this.importerUser.isExtensionName((stringArray = this.nextLine())[0])) {
                        arrayList.add(stringArray);
                        if (this.hasMoreLines(false)) continue;
                    }
                    this.importerUser.importExtensionData(string, arrayList, this);
                    string = stringArray[0];
                }
            }
        }
        catch (ExtensionException extensionException) {
            this.errorHandler.showError("Error Importing Extension Data", extensionException.getMessage(), false);
        }
        catch (IOException iOException) {
            this.errorHandler.showError("Error Importing Extension Data", iOException.getMessage(), false);
        }
    }

    void importAgents(Class<? extends Agent> clazz) throws IOException {
        this.tooManyValuesForSection = false;
        this.builtInVars = this.getImplicitVariables(clazz);
        String[] stringArray = this.getHeaders(clazz);
        this.setupVarsToImport(stringArray.length);
        while (this.hasMoreLines(false)) {
            String[] stringArray2 = this.nextLine();
            this.importOneAgent(clazz, stringArray2, stringArray);
        }
    }

    void importOneAgent(Class<? extends Agent> clazz, String[] stringArray, String[] stringArray2) {
        Map<String, Object> map2 = this.getVarVals(stringArray2, stringArray, clazz);
        if (clazz == Observer.class) {
            this.setScreenDimensions(map2);
        }
        map2 = this.getVarVals(stringArray2, stringArray, clazz);
        Agent agent = this.nextAgent(clazz, map2);
        for (int i = 0; i < stringArray2.length; ++i) {
            Object object;
            String string = stringArray2[i];
            if (this.isSpecialVariable(clazz, string)) {
                this.handleSpecialVariable(agent, string, map2, i);
                continue;
            }
            int n = this.getVarIndex(agent, string, i);
            if (n == -1 || (object = map2.get(string)) == null) continue;
            this.setVarVal(agent, n, string, object);
        }
    }

    Agent nextAgent(Class<? extends Agent> clazz, Map<String, Object> map2) {
        if (clazz == Observer.class) {
            return this.world.observer();
        }
        if (clazz == Turtle.class) {
            AgentSet agentSet = this.getTurtleBreed(map2, this.builtInVars[this.TURTLE_BREED]);
            long l = this.getTurtleId(map2, this.builtInVars[0]);
            Turtle turtle2 = this.world.getOrCreateTurtle(l);
            turtle2.setBreed(agentSet);
            return turtle2;
        }
        if (clazz == Patch.class) {
            return this.getPatch(map2);
        }
        if (clazz == Link.class) {
            AgentSet agentSet = this.getLinkBreed(map2, this.builtInVars[6]);
            Turtle turtle3 = this.getLinkEnd(map2, this.builtInVars[0]);
            Turtle turtle4 = this.getLinkEnd(map2, this.builtInVars[1]);
            return this.world.getOrCreateLink(turtle3, turtle4, agentSet);
        }
        return null;
    }

    void handleSpecialVariable(Agent agent, String string, Map<String, Object> map2, int n) {
        try {
            if (!(agent instanceof Observer)) {
                int n2 = this.getVarIndex(agent, string, n);
                if (n2 != -1) {
                    if (agent instanceof Turtle) {
                        this.handleSpecialTurtleVariable((Turtle)agent, map2.get(string), n2);
                    } else if (agent instanceof Patch) {
                        this.handleSpecialPatchVariable((Patch)agent, map2.get(string), n2);
                    } else if (agent instanceof Link) {
                        this.handleSpecialLinkVariable((Link)agent, map2.get(string), n2, string);
                    }
                }
            } else {
                this.handleSpecialObserverVariable((Observer)agent, map2.get(string), string);
            }
        }
        catch (ImportException importException) {
            this.showError(importException);
        }
    }

    void handleSpecialObserverVariable(Observer observer, Object object, String string) {
        if (string.equals("PERSPECTIVE")) {
            observer.perspective(Perspective.load(((Double)object).intValue()));
        } else if (string.equals("SUBJECT") && object instanceof Agent) {
            observer.targetAgent((Agent)object);
        } else if (string.equals("NEXTINDEX")) {
            this.world.nextTurtleIndex(((Double)object).longValue());
        } else if (string.equals("DIRECTED-LINKS")) {
            String string2 = (String)object;
            if (!string2.equals("NEITHER")) {
                this.world.links().setDirected(string2.equals("DIRECTED"));
            }
        } else if (string.equals("TICKS")) {
            this.world.tickCounter.ticks_$eq((Double)object);
        }
    }

    void handleSpecialTurtleVariable(Turtle turtle2, Object object, int n) {
        switch (n) {
            case 5: {
                this.setTurtleShape(turtle2, object, this.builtInVars[5], n);
                break;
            }
            case 6: {
                this.setVarVal(turtle2, n, this.builtInVars[6], this.getLabel(object));
                break;
            }
            case 0: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    void handleSpecialLinkVariable(Link link, Object object, int n, String string) {
        switch (n) {
            case 3: {
                this.setVarVal(link, n, this.builtInVars[3], this.getLabel(object));
                break;
            }
            case 0: 
            case 1: 
            case 6: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    void handleSpecialPatchVariable(Patch patch, Object object, int n) {
        switch (n) {
            case 3: {
                this.setVarVal(patch, n, this.builtInVars[3], this.getLabel(object));
                break;
            }
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    String[] getHeaders(Class<? extends Agent> clazz) throws IOException {
        if (!this.hasMoreLines(false)) {
            String string = "No " + this.printName(clazz) + " headers have been imported. " + "Globals, Turtles, and Patches must be in the same import file.";
            throw new AbortingImportException(ImportError.UNEXPECTED_EOF_ERROR, string);
        }
        String[] stringArray = this.nextLine();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].trim().equals("")) continue;
            if (this.convertPenDown && stringArray[i].equalsIgnoreCase("PEN-DOWN?")) {
                arrayList.add("PEN-MODE");
                continue;
            }
            arrayList.add(stringArray[i].toUpperCase());
        }
        String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        this.varHeadersImported(clazz, stringArray2, true);
        this.varHeadersImported(clazz, stringArray2, false);
        return stringArray2;
    }

    List<String> getOptionalHeaders(Class<? extends Agent> clazz) {
        if (this.convertPenDown && clazz == Turtle.class) {
            return Arrays.asList("PEN-SIZE", "PEN-COLOR");
        }
        if (this.olderThan40beta2 && clazz == Link.class) {
            return Arrays.asList("SHAPE", "TIE-MODE");
        }
        if (clazz == Link.class) {
            return Arrays.asList("TIE-MODE");
        }
        return null;
    }

    Map<String, Object> getVarVals(String[] stringArray, String[] stringArray2, Class<? extends Agent> clazz) {
        int n;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (!this.tooManyValuesForSection && stringArray2.length > stringArray.length) {
            for (n = stringArray.length; n < stringArray2.length; ++n) {
                if (stringArray2[n].equals("")) continue;
                this.tooManyValuesForSection = true;
                this.showError(new ImportException(ImportError.TOO_MANY_VALUES_ERROR, "Too Many Values For Agent", "There are a total of " + stringArray.length + " " + this.printName(clazz) + " variables declared in this " + "model (including built-in " + (clazz == Turtle.class || clazz == Link.class ? "and breed " : "") + "variables).  The import-world file has at least one agent " + "in the " + this.printSectionName() + " section with more than this number of values.", "All the extra values will be ignored for this section."));
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            Junk junk;
            boolean bl;
            boolean bl2 = clazz == Turtle.class && stringArray[n].equals(this.builtInVars[this.TURTLE_BREED]);
            boolean bl3 = bl = clazz == Link.class && stringArray[n].equals(this.builtInVars[6]);
            if (this.convertPenDown && stringArray[n].equals("PEN-MODE")) {
                if (stringArray2[n].equalsIgnoreCase("FALSE")) {
                    stringArray2[n] = "\"up\"";
                } else if (stringArray2[n].equals("TRUE")) {
                    stringArray2[n] = "\"down\"";
                }
            }
            Junk junk2 = junk = stringArray2[n].equals("") ? new Junk() : this.getTokenValue(stringArray2[n], bl2, bl);
            if (this.essentialVarHeadersToImport.get(clazz).contains(stringArray[n]) && junk instanceof Junk) {
                String string = "A " + this.printName(clazz) + " with the essential variable " + stringArray[n] + " cannot be imported since the agent's value in the import" + " file for " + stringArray[n] + " could not be imported.";
                throw new AbortingImportException(ImportError.UNIMPORTED_ESSENTIAL_VAR_ERROR, string);
            }
            hashMap.put(stringArray[n], junk);
        }
        return hashMap;
    }

    Object getTokenValue(String string, boolean bl, boolean bl2) {
        try {
            return this.stringReader.readFromString(string);
        }
        catch (StringReaderException stringReaderException) {
            if (bl) {
                if (!this.breedsNotToImport.contains(string)) {
                    this.breedsNotToImport.add(string);
                    this.showError(new ImportException(ImportError.ILLEGAL_BREED_ERROR, "Illegal Breed", stringReaderException.getMessage(), "all turtles with this breed will be made as regular turtles"));
                }
                return this.world.turtles();
            }
            if (bl2) {
                if (!this.breedsNotToImport.contains(string)) {
                    this.breedsNotToImport.add(string);
                    this.showError(new ImportException(ImportError.ILLEGAL_BREED_ERROR, "Illegal Link Breed", stringReaderException.getMessage(), "all links with this breed will be made as regular links"));
                }
                return this.world.links();
            }
            this.showError(new ImportException(ImportError.PARSING_ERROR, "Parsing Error", "error parsing the values:\n" + string, "the import will continue if it can, but values for this agent's variables will be set to an appropriate default", stringReaderException.getMessage()));
            return new Junk();
        }
    }

    int getVarIndex(Agent agent, String string, int n) {
        Class<? extends Agent> clazz = agent.getAgentClass();
        int n2 = Arrays.asList(this.builtInVars).indexOf(string);
        String string2 = this.printName(clazz);
        if (n2 == -1) {
            if (clazz == Observer.class) {
                n2 = this.world.observerOwnsIndexOf(string);
            } else if (clazz == Patch.class) {
                n2 = this.world.patchesOwnIndexOf(string);
            } else if (clazz == Turtle.class ? (n2 = this.world.turtlesOwnIndexOf(string)) == -1 && (n2 = this.getBreedVarIndex((Turtle)agent, string)) == -1 && this.someBreedOwns.contains(string) : clazz == Link.class && (n2 = this.world.linksOwnIndexOf(string)) == -1 && (n2 = this.getLinkBreedVarIndex((Link)agent, string)) == -1 && this.someLinkBreedOwns.contains(string)) {
                return -1;
            }
        }
        if (this.varsToImport.get(n) && n2 == -1) {
            this.varsToImport.clear(n);
            this.showError(new ImportException(ImportError.ILLEGAL_AGENT_VAR_ERROR, "Illegal " + string2 + " Variable", "the " + string2 + " variable " + string + " does not " + "exist in this model.", "the import will continue but this variable will be ignored."));
        }
        return n2;
    }

    int getBreedVarIndex(Turtle turtle2, String string) {
        if (turtle2.getBreed() != this.world.turtles() && this.world.breedOwns(turtle2.getBreed(), string)) {
            return this.world.breedsOwnIndexOf(turtle2.getBreed(), string);
        }
        return -1;
    }

    int getLinkBreedVarIndex(Link link, String string) {
        if (link.getBreed() != this.world.links() && this.world.linkBreedOwns(link.getBreed(), string)) {
            return this.world.linkBreedsOwnIndexOf(link.getBreed(), string);
        }
        return -1;
    }

    void setVarVal(Agent agent, int n, String string, Object object) {
        try {
            if (object instanceof Junk) {
                object = World.ZERO;
            }
            agent.setVariable(n, object);
        }
        catch (AgentException agentException) {
            this.showError(new ImportException(ImportError.SETTING_VAR_ERROR, "Error Setting Value", "could not set " + agent + "'s variable " + string + " to " + object, "the import will continue, but the variable will be set to an appropriate default."));
        }
        catch (LogoException logoException) {
            this.showError(new ImportException(ImportError.SETTING_VAR_ERROR, "Error Setting Value", "could not set " + agent + "'s variable " + string + " to " + object, "the import will continue, but the variable will be set to an appropriate default."));
        }
    }

    Patch getPatch(Map<String, Object> map2) {
        try {
            int n = ((Double)map2.get(this.builtInVars[0])).intValue();
            int n2 = ((Double)map2.get(this.builtInVars[1])).intValue();
            if (!this.world.validPatchCoordinates(n, n2)) {
                String string = "Illegal Patch Coordinate- pxcor and pycor must be in range.";
                throw new AbortingImportException(ImportError.ILLEGAL_PCOR_ERROR, string);
            }
            return this.world.fastGetPatchAt(n, n2);
        }
        catch (ClassCastException classCastException) {
            String string = "Illegal Patch Coordinate- pxcor and pycor must be integers.";
            throw new AbortingImportException(ImportError.ILLEGAL_CLASS_CAST_ERROR, string);
        }
    }

    long getTurtleId(Map<String, Object> map2, String string) {
        try {
            return ((Double)map2.get(string)).longValue();
        }
        catch (ClassCastException classCastException) {
            String string2 = "Illegal Who- a turtle's who must be an integer.";
            throw new AbortingImportException(ImportError.ILLEGAL_CLASS_CAST_ERROR, string2);
        }
    }

    Turtle getLinkEnd(Map<String, Object> map2, String string) {
        try {
            return (Turtle)map2.get(string);
        }
        catch (ClassCastException classCastException) {
            String string2 = "Illegal End a link's end points must be a turtle.";
            throw new AbortingImportException(ImportError.ILLEGAL_CLASS_CAST_ERROR, string2);
        }
    }

    void setTurtleShape(Turtle turtle2, Object object, String string, int n) {
        try {
            turtle2.setVariable(n, object);
        }
        catch (AgentException agentException) {
            if (!this.shapesNotToImport.contains(object)) {
                this.shapesNotToImport.add(object);
                throw new ImportException(ImportError.ILLEGAL_SHAPE_ERROR, "Illegal Shape", agentException.getMessage(), "setting " + turtle2 + "'s shape to its breed's default shape");
            }
            this.setVarVal(turtle2, n, string, this.world.turtleBreedShapes.breedShape(turtle2.getBreed()));
        }
    }

    AgentSet getTurtleBreed(Map<String, Object> map2, String string) {
        if (map2.containsKey(string)) {
            return (AgentSet)map2.get(string);
        }
        return this.world.turtles();
    }

    AgentSet getLinkBreed(Map<String, Object> map2, String string) {
        if (map2.containsKey(string)) {
            return (AgentSet)map2.get(string);
        }
        return this.world.links();
    }

    Object getLabel(Object object) {
        if (object instanceof Junk) {
            return "";
        }
        return object;
    }

    void setScreenDimensions(Map<String, Object> map2) {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            if (!this.convertTopology) {
                n4 = ((Double)map2.get("MIN-PXCOR")).intValue();
                n3 = ((Double)map2.get("MAX-PXCOR")).intValue();
                n2 = ((Double)map2.get("MIN-PYCOR")).intValue();
                n = ((Double)map2.get("MAX-PYCOR")).intValue();
            } else {
                int n5 = ((Double)map2.get("SCREEN-EDGE-X")).intValue();
                int n6 = ((Double)map2.get("SCREEN-EDGE-Y")).intValue();
                n4 = -n5;
                n3 = n5;
                n2 = -n6;
                n = n6;
            }
            if (n4 != this.world.minPxcor() || n3 != this.world.maxPxcor() || n2 != this.world.minPycor() || n != this.world.maxPycor()) {
                this.importerUser.setDimensions(new WorldDimensions(n4, n3, n2, n));
                this.needToResize = true;
            }
        }
        catch (ClassCastException classCastException) {
            String string = "Illegal Screen dimension- max-px/ycor, min-px/ycor must be numbers.";
            throw new AbortingImportException(ImportError.ILLEGAL_CLASS_CAST_ERROR, string);
        }
    }

    List<String> getAllBreedVars() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<String, Object> map2 = this.world.getBreeds();
        if (map2 != null) {
            for (AgentSet agentSet : map2.values()) {
                List<String> list = this.world.program().breedsOwn().get(agentSet.printName());
                if (list == null) continue;
                for (int i = 0; i < list.size(); ++i) {
                    arrayList.add(list.get(i));
                }
            }
        }
        return arrayList;
    }

    List<String> getAllLinkBreedVars() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<String, Object> map2 = this.world.getLinkBreeds();
        if (map2 != null) {
            for (AgentSet agentSet : map2.values()) {
                List<String> list = this.world.program().linkBreedsOwn().get(agentSet.printName());
                if (list == null) continue;
                for (int i = 0; i < list.size(); ++i) {
                    arrayList.add(list.get(i));
                }
            }
        }
        return arrayList;
    }

    Map<Class<? extends Agent>, List<String>> fillSpecialVariables() {
        HashMap<Class<? extends Agent>, List<String>> hashMap = new HashMap<Class<? extends Agent>, List<String>>();
        List<String> list = this.stringArrayToList(this.getSpecialObserverVariables());
        List<String> list2 = this.stringArrayToList(this.getSpecialTurtleVariables());
        List<String> list3 = this.stringArrayToList(this.getSpecialPatchVariables());
        List<String> list4 = this.stringArrayToList(this.getSpecialLinkVariables());
        hashMap.put(Observer.class, list);
        hashMap.put(Turtle.class, list2);
        hashMap.put(Patch.class, list3);
        hashMap.put(Link.class, list4);
        return hashMap;
    }

    private List<String> stringArrayToList(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    String[] getSpecialObserverVariables() {
        return new String[]{"MIN-PXCOR", "MAX-PXCOR", "MIN-PYCOR", "MAX-PYCOR", "SCREEN-EDGE-X", "SCREEN-EDGE-Y", "PERSPECTIVE", "SUBJECT", "NEXTINDEX", "DIRECTED-LINKS", "TICKS"};
    }

    String[] getSpecialTurtleVariables() {
        String[] stringArray = AgentVariables.getImplicitTurtleVariables(false);
        return new String[]{stringArray[0], stringArray[8], stringArray[6], stringArray[5]};
    }

    String[] getSpecialPatchVariables() {
        String[] stringArray = AgentVariables.getImplicitPatchVariables(false);
        return new String[]{stringArray[0], stringArray[1], stringArray[3]};
    }

    String[] getSpecialLinkVariables() {
        String[] stringArray = AgentVariables.getImplicitLinkVariables();
        return new String[]{stringArray[6], stringArray[3], stringArray[0], stringArray[1]};
    }

    boolean isSpecialVariable(Class<? extends Agent> clazz, String string) {
        return this.specialVariables.get(clazz).contains(string);
    }

    Map<Class<? extends Agent>, List<String>> fillEssentialVarsToImport() {
        HashMap<Class<? extends Agent>, List<String>> hashMap = new HashMap<Class<? extends Agent>, List<String>>();
        List<String> list = !this.convertTopology ? this.stringArrayToList(this.getEssentialObserverVars()) : this.stringArrayToList(this.getEssentialObserverVarsOld());
        List<String> list2 = this.stringArrayToList(this.getEssentialTurtleVariables());
        List<String> list3 = this.stringArrayToList(this.getEssentialPatchVariables());
        List<String> list4 = this.stringArrayToList(this.getEssentialLinkVariables());
        hashMap.put(Observer.class, list);
        hashMap.put(Turtle.class, list2);
        hashMap.put(Patch.class, list3);
        hashMap.put(Link.class, list4);
        return hashMap;
    }

    String[] getEssentialObserverVars() {
        return new String[]{"MIN-PXCOR", "MAX-PXCOR", "MIN-PYCOR", "MAX-PYCOR"};
    }

    String[] getEssentialObserverVarsOld() {
        return new String[]{"SCREEN-EDGE-X", "SCREEN-EDGE-Y"};
    }

    String[] getEssentialTurtleVariables() {
        return new String[]{AgentVariables.getImplicitTurtleVariables(false)[0]};
    }

    String[] getEssentialPatchVariables() {
        String[] stringArray = AgentVariables.getImplicitPatchVariables(false);
        return new String[]{stringArray[0], stringArray[1]};
    }

    String[] getEssentialLinkVariables() {
        String[] stringArray = AgentVariables.getImplicitLinkVariables();
        return new String[]{stringArray[0], stringArray[1]};
    }

    void varHeadersImported(Class<? extends Agent> clazz, String[] stringArray, boolean bl) {
        List<String> list = bl ? this.essentialVarHeadersToImport.get(clazz) : Arrays.asList(this.builtInVars);
        List<String> list2 = this.getOptionalHeaders(clazz);
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            boolean bl2 = false;
            for (int j = 0; j < stringArray.length; ++j) {
                if (!string.equals(stringArray[j])) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            if (bl) {
                String string2 = string + " is not in the list of variables to be imported " + "from the import file in the " + this.printSectionName() + " section. " + "This variable is essential to a model.";
                throw new AbortingImportException(ImportError.UNDECLARED_ESSENTIAL_VAR_ERROR, string2);
            }
            if (list2 != null && list2.contains(string)) continue;
            this.showError(new ImportException(ImportError.UNDECLARED_AGENT_VAR_ERROR, "Implicit Variable Not Declared", "the " + this.printName(clazz) + " variable " + string + " was not declared.", "the import will continue but all agents with this variable will have it set to an appropriate default."));
        }
    }

    String[] getImplicitVariables(Class<? extends Agent> clazz) {
        if (clazz == Observer.class) {
            return AgentVariables.getImplicitObserverVariables();
        }
        if (clazz == Turtle.class) {
            return AgentVariables.getImplicitTurtleVariables(this.world.program().is3D());
        }
        if (clazz == Patch.class) {
            return AgentVariables.getImplicitPatchVariables(this.world.program().is3D());
        }
        if (clazz == Link.class) {
            return AgentVariables.getImplicitLinkVariables();
        }
        throw new IllegalStateException();
    }

    public boolean hasMoreLines(boolean bl) throws IOException {
        this.nextLine = this.lines.readLine();
        ++this.lineNum;
        if (this.nextLine == null) {
            if (this.currentSentinel != this.numSentinels) {
                if (this.sentinels[this.currentSentinel].equals("DRAWING") || this.sentinels[this.currentSentinel].equals("LINKS") || this.sentinels[this.currentSentinel].equals("OUTPUT") || this.sentinels[this.currentSentinel].equals("PLOTS") || this.sentinels[this.currentSentinel].equals("EXTENSIONS")) {
                    ++this.currentSentinel;
                    return false;
                }
                String string = "No " + this.sentinels[this.currentSentinel] + " have been imported.  Globals, Turtles, and Patches " + "must be in the same import file.";
                throw new AbortingImportException(ImportError.UNEXPECTED_EOF_ERROR, string);
            }
            return false;
        }
        if (this.nextLine.equals("")) {
            if (bl) {
                return false;
            }
            return this.hasMoreLines(false);
        }
        try {
            this.nextLineFields = ImportLexer.lex(this.nextLine);
        }
        catch (ImportLexer.LexerException lexerException) {
            throw new AbortingImportException(ImportError.CSV_LEXING_ERROR, "At line " + this.lineNum + ": " + lexerException.getMessage());
        }
        if (this.nextLineFields.length <= 0) {
            if (bl) {
                return true;
            }
            return this.hasMoreLines(bl);
        }
        if (this.nextLineFields[0].toUpperCase().startsWith(this.sentinels[this.currentSentinel])) {
            ++this.currentSentinel;
            return false;
        }
        if (this.anotherSentinelEquals(this.nextLineFields[0].toUpperCase())) {
            if (this.currentSentinel < 3) {
                String string = "The agents are in the wrong order in the import file. The global variables should be first, followed by the turtles, followed by the patches.  Found " + this.nextLineFields[0] + " but needed " + this.sentinels[this.currentSentinel];
                throw new AbortingImportException(ImportError.FILE_STRUCTURE_ERROR, string);
            }
            return false;
        }
        return true;
    }

    boolean anotherSentinelEquals(String string) {
        int n;
        for (n = 0; n < this.currentSentinel; ++n) {
            if (!string.equals(this.sentinels[n])) continue;
            return true;
        }
        for (n = this.currentSentinel + 1; n < this.numSentinels; ++n) {
            if (!string.equals(this.sentinels[n])) continue;
            return true;
        }
        return false;
    }

    String[] nextLine() {
        return this.nextLineFields;
    }

    String printSectionName() {
        return this.currentSentinel > 0 ? this.sentinels[this.currentSentinel - 1] : "UNKNOWN";
    }

    String printName(Class<? extends Agent> clazz) {
        if (clazz == Observer.class) {
            return "Global";
        }
        if (clazz == Turtle.class) {
            return "Turtle";
        }
        if (clazz == Patch.class) {
            return "Patch";
        }
        if (clazz == Link.class) {
            return "Link";
        }
        return "";
    }

    void checkForBlankTurtles() {
        AgentSet.Iterator iterator2 = this.world.turtles().iterator();
        while (iterator2.hasNext()) {
            Turtle turtle2 = (Turtle)iterator2.next();
            if (turtle2.getBreed() != null) continue;
            String string = turtle2.toString() + " was referenced in an agentset or agent " + "but was not defined in the TURTLES section.";
            throw new AbortingImportException(ImportError.BLANK_TURTLE_ERROR, string);
        }
    }

    void showError(ImportException importException) {
        if (importException.type.compareTo(ImportError.LAST_NONFATAL_ERROR) > 0) {
            throw new AbortingImportException(ImportError.UNKNOWN_ERROR, "An unknown error has occurred. The import will now abort.");
        }
        if (!this.errorHandler.showError("Warning: " + importException.title, "Error Importing at Line " + this.lineNum + ": " + importException.message + "\n\nAction to be Taken: " + importException.action, false)) {
            throw new AbortingImportException(ImportError.ERROR_GIVEN, "");
        }
    }

    @Override
    public void showError(String string, String string2, String string3) {
        this.showError(new ImportException(ImportError.PARSING_ERROR, string, string2, string3));
    }

    void showError(AbortingImportException abortingImportException) {
        this.errorHandler.showError(abortingImportException.title, abortingImportException.details, true);
    }

    private static int[] fromHexString(String string) throws InvalidDataException {
        int n = string.length();
        int[] nArray = new int[n / 8];
        if (n % 8 == 0) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < n / 8) {
                nArray[n3] = Importer.charToNibble(string.charAt(n2++)) << 28;
                int n4 = n3;
                nArray[n4] = nArray[n4] | Importer.charToNibble(string.charAt(n2++)) << 24;
                int n5 = n3;
                nArray[n5] = nArray[n5] | Importer.charToNibble(string.charAt(n2++)) << 20;
                int n6 = n3;
                nArray[n6] = nArray[n6] | Importer.charToNibble(string.charAt(n2++)) << 16;
                int n7 = n3;
                nArray[n7] = nArray[n7] | Importer.charToNibble(string.charAt(n2++)) << 12;
                int n8 = n3;
                nArray[n8] = nArray[n8] | Importer.charToNibble(string.charAt(n2++)) << 8;
                int n9 = n3;
                nArray[n9] = nArray[n9] | Importer.charToNibble(string.charAt(n2++)) << 4;
                int n10 = n3++;
                nArray[n10] = nArray[n10] | Importer.charToNibble(string.charAt(n2++));
            }
        } else {
            throw new InvalidDataException("The data must be a multiple of 4 to covert from Hex string to ints");
        }
        return nArray;
    }

    private static int charToNibble(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid hex character: " + c);
    }

    strictfp static class InvalidDataException
    extends IOException {
        public InvalidDataException(String string) {
            super(string);
        }
    }

    strictfp class Junk {
        Junk() {
        }
    }

    public static interface ErrorHandler {
        public boolean showError(String var1, String var2, boolean var3);
    }

    public strictfp static class StringReaderException
    extends Exception {
        public StringReaderException(String string) {
            super(string);
        }
    }

    public static interface StringReader {
        public Object readFromString(String var1) throws StringReaderException;
    }

    strictfp class AbortingImportException
    extends RuntimeException {
        ImportError errorType;
        public String title;
        public String details;

        public AbortingImportException(ImportError importError, String string) {
            super("Fatal Error Type:" + (Object)((Object)importError));
            this.errorType = importError;
            this.title = "Fatal Error- " + this.getErrorMessage();
            this.details = string + "\n\nThe import will now abort.";
        }

        String getErrorMessage() {
            String string;
            switch (this.errorType) {
                case ERROR_GIVEN: {
                    string = "Error Already Given";
                    break;
                }
                case ILLEGAL_CLASS_CAST_ERROR: {
                    string = "Illegal Type Cast";
                    break;
                }
                case UNEXPECTED_EOF_ERROR: {
                    string = "Unexpected End of File";
                    break;
                }
                case FILE_STRUCTURE_ERROR: {
                    string = "Incorrect Structure For Import File";
                    break;
                }
                case UNDECLARED_ESSENTIAL_VAR_ERROR: {
                    string = "Essential Variable Not Declared";
                    break;
                }
                case UNIMPORTED_ESSENTIAL_VAR_ERROR: {
                    string = "Essential Variable Not Imported";
                    break;
                }
                case BLANK_TURTLE_ERROR: {
                    string = "Referenced Turtle Not Defined";
                    break;
                }
                case CSV_LEXING_ERROR: {
                    string = "Invalid CSV File";
                    break;
                }
                case IMPORT_3D_ERROR: {
                    string = "You cannot import a 2D world into 3D NetLogo";
                    break;
                }
                default: {
                    string = "Unknown Fatal Error";
                }
            }
            return string;
        }
    }

    strictfp class ImportException
    extends RuntimeException {
        public ImportError type;
        public String message;
        public String action;
        public String title;

        public ImportException(ImportError importError, String string, String string2, String string3) {
            super(string + "- Error Type: " + (Object)((Object)importError));
            this.type = importError;
            this.title = string;
            this.message = string2;
            this.action = string3;
        }

        public ImportException(ImportError importError, String string, String string2, String string3, String string4) {
            this(importError, string, string2, string3);
            this.message = this.message + "\n\nAdditional Information: " + string4;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    strictfp static enum ImportError {
        ILLEGAL_AGENT_VAR_ERROR,
        ILLEGAL_SHAPE_ERROR,
        ILLEGAL_BREED_ERROR,
        PARSING_ERROR,
        SETTING_VAR_ERROR,
        UNDECLARED_AGENT_VAR_ERROR,
        TOO_MANY_VALUES_ERROR,
        LAST_NONFATAL_ERROR,
        ILLEGAL_CLASS_CAST_ERROR,
        UNEXPECTED_EOF_ERROR,
        ERROR_GIVEN,
        FILE_STRUCTURE_ERROR,
        UNDECLARED_ESSENTIAL_VAR_ERROR,
        UNIMPORTED_ESSENTIAL_VAR_ERROR,
        BLANK_TURTLE_ERROR,
        CSV_LEXING_ERROR,
        ILLEGAL_PCOR_ERROR,
        IMPORT_3D_ERROR,
        UNKNOWN_ERROR;

    }
}

