/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.IOException;
import java.util.Map;
import org.nlogo.agent.Drawing3D;
import org.nlogo.agent.Importer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.agent.World3D;
import org.nlogo.api.AgentVariables;
import org.nlogo.api.ImporterUser;
import org.nlogo.api.WorldDimensions3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class Importer3D
extends Importer {
    public Importer3D(Importer.ErrorHandler errorHandler, World world, ImporterUser importerUser, Importer.StringReader stringReader) {
        super(errorHandler, world, importerUser, stringReader);
        this.TURTLE_BREED = 11;
    }

    @Override
    void checkVersion(String string) throws Importer.AbortingImportException {
        if (!string.startsWith("3-D") && !string.startsWith("3D")) {
            throw new Importer.AbortingImportException(Importer.ImportError.IMPORT_3D_ERROR, "");
        }
    }

    @Override
    void importDrawing() throws IOException {
        Drawing3D drawing3D = ((World3D)this.world).drawing;
        while (this.hasMoreLines(false)) {
            String[] stringArray = this.nextLine();
            if (stringArray[0].equalsIgnoreCase("x0")) continue;
            if (stringArray[0].equalsIgnoreCase("shape")) {
                while (this.hasMoreLines(false)) {
                    stringArray = this.nextLine();
                    if (stringArray[1].equalsIgnoreCase("x1")) {
                        while (this.hasMoreLines(false)) {
                            try {
                                stringArray = this.nextLine();
                                drawing3D.addStamp(stringArray[0], (Double)this.stringReader.readFromString(stringArray[1]), (Double)this.stringReader.readFromString(stringArray[2]), (Double)this.stringReader.readFromString(stringArray[3]), (Double)this.stringReader.readFromString(stringArray[4]), (Double)this.stringReader.readFromString(stringArray[5]), (Double)this.stringReader.readFromString(stringArray[6]), this.stringReader.readFromString(stringArray[7]), (Double)this.stringReader.readFromString(stringArray[8]), (Boolean)this.stringReader.readFromString(stringArray[9]), (Double)this.stringReader.readFromString(stringArray[10]), (Double)this.stringReader.readFromString(stringArray[11]), (Double)this.stringReader.readFromString(stringArray[12]));
                            }
                            catch (Importer.StringReaderException stringReaderException) {
                                throw new Importer.AbortingImportException(Importer.ImportError.ILLEGAL_CLASS_CAST_ERROR, "Coordinates in the drawing must be doubles");
                            }
                        }
                        return;
                    }
                    try {
                        drawing3D.addStamp(stringArray[0], (Double)this.stringReader.readFromString(stringArray[1]), (Double)this.stringReader.readFromString(stringArray[2]), (Double)this.stringReader.readFromString(stringArray[3]), (Double)this.stringReader.readFromString(stringArray[4]), (Double)this.stringReader.readFromString(stringArray[5]), (Double)this.stringReader.readFromString(stringArray[6]), (Double)this.stringReader.readFromString(stringArray[7]), (double)((Double)this.stringReader.readFromString(stringArray[8])), (Double)this.stringReader.readFromString(stringArray[9]));
                    }
                    catch (Importer.StringReaderException stringReaderException) {
                        throw new Importer.AbortingImportException(Importer.ImportError.ILLEGAL_CLASS_CAST_ERROR, "Coordinates in the drawing must be doubles");
                    }
                }
            }
            try {
                drawing3D.addLine((Double)this.stringReader.readFromString(stringArray[0]), (Double)this.stringReader.readFromString(stringArray[1]), (Double)this.stringReader.readFromString(stringArray[2]), (Double)this.stringReader.readFromString(stringArray[3]), (Double)this.stringReader.readFromString(stringArray[4]), (Double)this.stringReader.readFromString(stringArray[5]), (Double)this.stringReader.readFromString(stringArray[6]), this.stringReader.readFromString(stringArray[7]));
            }
            catch (Importer.StringReaderException stringReaderException) {
                throw new Importer.AbortingImportException(Importer.ImportError.ILLEGAL_CLASS_CAST_ERROR, "Coordinates in the drawing must be doubles");
            }
        }
    }

    @Override
    void handleSpecialTurtleVariable(Turtle turtle2, Object object, int n) {
        switch (n) {
            case 8: {
                this.setTurtleShape(turtle2, object, this.builtInVars[8], n);
                break;
            }
            case 9: {
                this.setVarVal(turtle2, n, this.builtInVars[9], this.getLabel(object));
                break;
            }
            case 0: 
            case 11: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    void handleSpecialPatchVariable(Patch patch, Object object, int n) {
        switch (n) {
            case 4: {
                this.setVarVal(patch, n, this.builtInVars[4], this.getLabel(object));
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    Patch getPatch(Map<String, Object> map2) {
        try {
            World3D world3D = (World3D)this.world;
            int n = ((Double)map2.get(this.builtInVars[0])).intValue();
            int n2 = ((Double)map2.get(this.builtInVars[1])).intValue();
            int n3 = ((Double)map2.get(this.builtInVars[2])).intValue();
            if (!world3D.validPatchCoordinates(n, n2, n3)) {
                String string = "Illegal Patch Coordinate- pxcor, pycor and pzcor must be in range.";
                throw new Importer.AbortingImportException(Importer.ImportError.ILLEGAL_PCOR_ERROR, string);
            }
            return world3D.fastGetPatchAt(n, n2, n3);
        }
        catch (ClassCastException classCastException) {
            String string = "Illegal Patch Coordinate- pxcor and pycor must be integers.";
            throw new Importer.AbortingImportException(Importer.ImportError.ILLEGAL_CLASS_CAST_ERROR, string);
        }
    }

    @Override
    void setScreenDimensions(Map<String, Object> map2) {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            if (!this.convertTopology) {
                n6 = ((Double)map2.get("MIN-PXCOR")).intValue();
                n5 = ((Double)map2.get("MAX-PXCOR")).intValue();
                n4 = ((Double)map2.get("MIN-PYCOR")).intValue();
                n3 = ((Double)map2.get("MAX-PYCOR")).intValue();
                n2 = ((Double)map2.get("MIN-PZCOR")).intValue();
                n = ((Double)map2.get("MAX-PZCOR")).intValue();
            } else {
                int n7 = ((Double)map2.get("SCREEN-EDGE-X")).intValue();
                int n8 = ((Double)map2.get("SCREEN-EDGE-Y")).intValue();
                n6 = -n7;
                n5 = n7;
                n4 = -n8;
                n3 = n8;
                n = 0;
                n2 = 0;
            }
            World3D world3D = (World3D)this.world;
            if (n6 != this.world.minPxcor() || n5 != this.world.maxPxcor() || n4 != this.world.minPycor() || n3 != this.world.maxPycor() || n2 != world3D.minPzcor() || n != world3D.maxPzcor()) {
                this.importerUser.setDimensions(new WorldDimensions3D(n6, n5, n4, n3, n2, n));
                this.needToResize = true;
            }
        }
        catch (ClassCastException classCastException) {
            String string = "Illegal Screen dimension- max-px/y/zcor, min-px/y/zcor must be numbers.";
            throw new Importer.AbortingImportException(Importer.ImportError.ILLEGAL_CLASS_CAST_ERROR, string);
        }
    }

    @Override
    String[] getSpecialObserverVariables() {
        return new String[]{"MIN-PXCOR", "MAX-PXCOR", "MIN-PYCOR", "MAX-PYCOR", "MIN-PZCOR", "MAX-PZCOR", "PERSPECTIVE", "SUBJECT", "NEXTINDEX", "DIRECTED-LINKS", "TICKS"};
    }

    @Override
    String[] getSpecialTurtleVariables() {
        String[] stringArray = AgentVariables.getImplicitTurtleVariables(true);
        return new String[]{stringArray[0], stringArray[11], stringArray[9], stringArray[8]};
    }

    @Override
    String[] getSpecialPatchVariables() {
        String[] stringArray = AgentVariables.getImplicitPatchVariables(true);
        return new String[]{stringArray[0], stringArray[1], stringArray[2], stringArray[4]};
    }

    @Override
    String[] getEssentialObserverVars() {
        return new String[]{"MIN-PXCOR", "MAX-PXCOR", "MIN-PYCOR", "MAX-PYCOR", "MIN-PZCOR", "MAX-PZCOR"};
    }

    @Override
    String[] getEssentialPatchVariables() {
        String[] stringArray = AgentVariables.getImplicitPatchVariables(true);
        return new String[]{stringArray[0], stringArray[1], stringArray[2]};
    }
}

