/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.LinkManager;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.Turtle3D;
import org.nlogo.agent.World;
import org.nlogo.agent.World3D;
import org.nlogo.api.AgentException;
import org.nlogo.api.LogoList;
import org.nlogo.util.MersenneTwisterFast;

public final class Layouts {
    public static strictfp void circle(World world, LogoList logoList, double d) throws AgentException {
        int n = 0;
        int n2 = logoList.size();
        int n3 = world.minPxcor() + (int)StrictMath.floor(world.worldWidth() / 2);
        int n4 = world.minPycor() + (int)StrictMath.floor(world.worldHeight() / 2);
        for (Object object : logoList) {
            if (object instanceof Turtle) {
                Turtle turtle2 = (Turtle)object;
                double d2 = n * 360 / n2;
                world.protractor().getPatchAtHeadingAndDistance(n3, n4, d2, d);
                turtle2.xandycor(n3, n4);
                turtle2.heading(d2);
                turtle2.jump(d);
            }
            ++n;
        }
    }

    public static strictfp void circle(AgentSet agentSet, double d, MersenneTwisterFast mersenneTwisterFast) throws AgentException {
        int n = 0;
        int n2 = agentSet.count();
        World world = agentSet.world();
        int n3 = world.minPxcor() + (int)StrictMath.floor(world.worldWidth() / 2);
        int n4 = world.minPycor() + (int)StrictMath.floor(world.worldHeight() / 2);
        AgentSet.Iterator iterator2 = agentSet.shufflerator(mersenneTwisterFast);
        while (iterator2.hasNext()) {
            Turtle turtle2 = (Turtle)iterator2.next();
            double d2 = n * 360 / n2;
            world.protractor().getPatchAtHeadingAndDistance(n3, n4, d2, d);
            turtle2.xandycor(n3, n4);
            turtle2.heading(d2);
            turtle2.jump(d);
            ++n;
        }
    }

    public static strictfp void spring(AgentSet agentSet, AgentSet agentSet2, double d, double d2, double d3, MersenneTwisterFast mersenneTwisterFast) {
        World world = agentSet.world();
        if (world.program().is3D()) {
            Layouts.spring3D(agentSet, agentSet2, d, d2, d3, mersenneTwisterFast);
        } else {
            Layouts.spring2D(agentSet, agentSet2, d, d2, d3, mersenneTwisterFast);
        }
    }

    public static strictfp void spring2D(AgentSet agentSet, AgentSet agentSet2, double d, double d2, double d3, MersenneTwisterFast mersenneTwisterFast) {
        double d4;
        Agent agent;
        World world = agentSet.world();
        int n = agentSet.count();
        if (n == 0) {
            return;
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = 0;
        HashMap<Turtle, Integer> hashMap = new HashMap<Turtle, Integer>();
        int[] nArray = new int[n];
        Turtle[] turtleArray = new Turtle[n];
        Object object = agentSet.shufflerator(mersenneTwisterFast);
        while (object.hasNext()) {
            agent = (Turtle)object.next();
            turtleArray[n2] = agent;
            hashMap.put((Turtle)agent, n2);
            dArray[n2] = 0.0;
            dArray2[n2] = 0.0;
            ++n2;
        }
        object = agentSet2.iterator();
        while (object.hasNext()) {
            int n3;
            agent = (Link)object.next();
            Turtle turtle2 = ((Link)agent).end1();
            Turtle turtle3 = ((Link)agent).end2();
            if (hashMap.containsKey(turtle2)) {
                int n4 = n3 = ((Integer)hashMap.get(turtle2)).intValue();
                nArray[n4] = nArray[n4] + 1;
            }
            if (hashMap.containsKey(turtle3)) {
                int n5 = n3 = ((Integer)hashMap.get(turtle3)).intValue();
                nArray[n5] = nArray[n5] + 1;
            }
            ++n2;
        }
        object = agentSet2.iterator();
        while (object.hasNext()) {
            agent = (Link)object.next();
            double d5 = 0.0;
            double d6 = 0.0;
            Turtle turtle4 = ((Link)agent).end1();
            Turtle turtle5 = ((Link)agent).end2();
            int n6 = -1;
            int n7 = 0;
            if (hashMap.containsKey(turtle4)) {
                n6 = (Integer)hashMap.get(turtle4);
                n7 = nArray[n6];
            }
            int n8 = -1;
            int n9 = 0;
            if (hashMap.containsKey(turtle5)) {
                n8 = (Integer)hashMap.get(turtle5);
                n9 = nArray[n8];
            }
            double d7 = world.protractor().distance(turtle4, turtle5, false);
            double d8 = (double)(n7 + n9) / 2.0;
            d8 = StrictMath.max(d8, 1.0);
            if (d7 == 0.0) {
                d5 += d * d2 / d8;
            } else {
                double d9 = d * (d7 - d2) / d8;
                d5 += d9 * (turtle5.xcor() - turtle4.xcor()) / d7;
                d6 += d9 * (turtle5.ycor() - turtle4.ycor()) / d7;
            }
            if (n6 != -1) {
                int n10 = n6;
                dArray[n10] = dArray[n10] + d5;
                int n11 = n6;
                dArray2[n11] = dArray2[n11] + d6;
            }
            if (n8 != -1) {
                int n12 = n8;
                dArray[n12] = dArray[n12] - d5;
                int n13 = n8;
                dArray2[n13] = dArray2[n13] - d6;
            }
            ++n2;
        }
        for (n2 = 0; n2 < n; ++n2) {
            object = turtleArray[n2];
            int n14 = n2 + 1;
            while (n14 < n) {
                double d10;
                Turtle turtle6 = turtleArray[n14];
                double d11 = 0.0;
                d4 = 0.0;
                double d12 = (double)(nArray[n2] + nArray[n14]) / 2.0;
                d12 = StrictMath.max(d12, 1.0);
                if (turtle6.xcor() == ((Turtle)object).xcor() && turtle6.ycor() == ((Turtle)object).ycor()) {
                    d10 = 360.0 * mersenneTwisterFast.nextDouble();
                    d11 = -(d3 / d12 * StrictMath.sin(StrictMath.toRadians(d10)));
                    d4 = -(d3 / d12 * StrictMath.cos(StrictMath.toRadians(d10)));
                } else {
                    d10 = world.protractor().distance((org.nlogo.api.Agent)object, turtle6, false);
                    double d13 = d3 / (d10 * d10) / d12;
                    d11 = -(d13 * (turtle6.xcor() - ((Turtle)object).xcor()) / d10);
                    d4 = -(d13 * (turtle6.ycor() - ((Turtle)object).ycor()) / d10);
                }
                int n15 = n2;
                dArray[n15] = dArray[n15] + d11;
                int n16 = n2;
                dArray2[n16] = dArray2[n16] + d4;
                int n17 = n14;
                dArray[n17] = dArray[n17] - d11;
                int n18 = n14++;
                dArray2[n18] = dArray2[n18] - d4;
            }
        }
        if (n > 1) {
            double d14 = (double)(world.worldWidth() + world.worldHeight()) / 1.0E10;
            dArray[0] = dArray[0] + (mersenneTwisterFast.nextDouble() * d14 - d14 / 2.0);
            dArray2[0] = dArray2[0] + (mersenneTwisterFast.nextDouble() * d14 - d14 / 2.0);
        }
        double d15 = (double)(world.worldWidth() + world.worldHeight()) / 50.0;
        for (n2 = 0; n2 < n; ++n2) {
            Turtle turtle7 = turtleArray[n2];
            double d16 = dArray[n2];
            d4 = dArray2[n2];
            if (d16 > d15) {
                d16 = d15;
            } else if (d16 < -d15) {
                d16 = -d15;
            }
            if (d4 > d15) {
                d4 = d15;
            } else if (d4 < -d15) {
                d4 = -d15;
            }
            double d17 = turtle7.xcor() + d16;
            double d18 = turtle7.ycor() + d4;
            if (d17 > (double)world.maxPxcor()) {
                d17 = world.maxPxcor();
            } else if (d17 < (double)world.minPxcor()) {
                d17 = world.minPxcor();
            }
            if (d18 > (double)world.maxPycor()) {
                d18 = world.maxPycor();
            } else if (d18 < (double)world.minPycor()) {
                d18 = world.minPycor();
            }
            try {
                turtle7.xandycor(d17, d18);
                continue;
            }
            catch (AgentException agentException) {
                throw new IllegalStateException(agentException);
            }
        }
    }

    public static strictfp void spring3D(AgentSet agentSet, AgentSet agentSet2, double d, double d2, double d3, MersenneTwisterFast mersenneTwisterFast) {
        double d4;
        double d5;
        Agent agent;
        World3D world3D = (World3D)agentSet.world();
        int n = agentSet.count();
        if (n == 0) {
            return;
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        int n2 = 0;
        HashMap<Turtle3D, Integer> hashMap = new HashMap<Turtle3D, Integer>();
        int[] nArray = new int[n];
        Turtle3D[] turtle3DArray = new Turtle3D[n];
        Object object = agentSet.shufflerator(mersenneTwisterFast);
        while (object.hasNext()) {
            agent = (Turtle3D)object.next();
            turtle3DArray[n2] = agent;
            hashMap.put((Turtle3D)agent, n2);
            dArray[n2] = 0.0;
            dArray2[n2] = 0.0;
            dArray3[n2] = 0.0;
            ++n2;
        }
        object = agentSet2.iterator();
        while (object.hasNext()) {
            int n3;
            agent = (Link)object.next();
            Turtle turtle2 = ((Link)agent).end1();
            Turtle turtle3 = ((Link)agent).end2();
            if (hashMap.containsKey(turtle2)) {
                int n4 = n3 = ((Integer)hashMap.get(turtle2)).intValue();
                nArray[n4] = nArray[n4] + 1;
            }
            if (hashMap.containsKey(turtle3)) {
                int n5 = n3 = ((Integer)hashMap.get(turtle3)).intValue();
                nArray[n5] = nArray[n5] + 1;
            }
            ++n2;
        }
        object = agentSet2.iterator();
        while (object.hasNext()) {
            agent = (Link)object.next();
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            Turtle3D turtle3D = (Turtle3D)((Link)agent).end1();
            Turtle3D turtle3D2 = (Turtle3D)((Link)agent).end2();
            int n6 = -1;
            int n7 = 0;
            if (hashMap.containsKey(turtle3D)) {
                n6 = (Integer)hashMap.get(turtle3D);
                n7 = nArray[n6];
            }
            int n8 = -1;
            int n9 = 0;
            if (hashMap.containsKey(turtle3D2)) {
                n8 = (Integer)hashMap.get(turtle3D2);
                n9 = nArray[n8];
            }
            double d9 = world3D.protractor().distance(turtle3D, turtle3D2, false);
            double d10 = (double)(n7 + n9) / 2.0;
            d10 = StrictMath.max(d10, 1.0);
            if (d9 == 0.0) {
                d6 += d * d2 / d10;
            } else {
                double d11 = d * (d9 - d2) / d10;
                d6 += d11 * (turtle3D2.xcor() - turtle3D.xcor()) / d9;
                d7 += d11 * (turtle3D2.ycor() - turtle3D.ycor()) / d9;
                d8 += d11 * (turtle3D2.zcor() - turtle3D.zcor()) / d9;
            }
            if (n6 != -1) {
                int n10 = n6;
                dArray[n10] = dArray[n10] + d6;
                int n11 = n6;
                dArray2[n11] = dArray2[n11] + d7;
                int n12 = n6;
                dArray3[n12] = dArray3[n12] + d8;
            }
            if (n8 != -1) {
                int n13 = n8;
                dArray[n13] = dArray[n13] - d6;
                int n14 = n8;
                dArray2[n14] = dArray2[n14] - d7;
                int n15 = n8;
                dArray3[n15] = dArray3[n15] - d8;
            }
            ++n2;
        }
        for (n2 = 0; n2 < n; ++n2) {
            object = turtle3DArray[n2];
            int n16 = n2 + 1;
            while (n16 < n) {
                double d12;
                double d13;
                Turtle3D turtle3D = turtle3DArray[n16];
                double d14 = 0.0;
                d5 = 0.0;
                d4 = 0.0;
                double d15 = (double)(nArray[n2] + nArray[n16]) / 2.0;
                d15 = StrictMath.max(d15, 1.0);
                if (turtle3D.xcor() == ((Turtle)object).xcor() && turtle3D.ycor() == ((Turtle)object).ycor() && turtle3D.zcor() == ((Turtle3D)object).zcor()) {
                    d13 = 360.0 * mersenneTwisterFast.nextDouble();
                    d12 = d3 * (2.0 * mersenneTwisterFast.nextDouble() - 1.0);
                    double d16 = StrictMath.sqrt(d3 * d3 - d12 * d12);
                    d14 = -(d16 * StrictMath.sin(StrictMath.toRadians(d13)));
                    d5 = -(d16 * StrictMath.cos(StrictMath.toRadians(d13)));
                    d4 = -d12;
                } else {
                    d13 = world3D.protractor().distance((org.nlogo.api.Agent)object, turtle3D, false);
                    d12 = d3 / (d13 * d13) / d15;
                    d14 = -(d12 * (turtle3D.xcor() - ((Turtle)object).xcor()) / d13);
                    d5 = -(d12 * (turtle3D.ycor() - ((Turtle)object).ycor()) / d13);
                    d4 = -(d12 * (turtle3D.zcor() - ((Turtle3D)object).zcor()) / d13);
                }
                int n17 = n2;
                dArray[n17] = dArray[n17] + d14;
                int n18 = n2;
                dArray2[n18] = dArray2[n18] + d5;
                int n19 = n2;
                dArray3[n19] = dArray3[n19] + d4;
                int n20 = n16;
                dArray[n20] = dArray[n20] - d14;
                int n21 = n16;
                dArray2[n21] = dArray2[n21] - d5;
                int n22 = n16++;
                dArray3[n22] = dArray3[n22] - d4;
            }
        }
        if (n > 1) {
            double d17 = (double)(world3D.worldWidth() + world3D.worldHeight()) / 1.0E10;
            dArray[0] = dArray[0] + (mersenneTwisterFast.nextDouble() * d17 - d17 / 2.0);
            dArray2[0] = dArray2[0] + (mersenneTwisterFast.nextDouble() * d17 - d17 / 2.0);
            dArray3[0] = dArray3[0] + (mersenneTwisterFast.nextDouble() * d17 - d17 / 2.0);
        }
        double d18 = (double)(world3D.worldWidth() + world3D.worldHeight() + world3D.worldDepth()) / 75.0;
        for (n2 = 0; n2 < n; ++n2) {
            Turtle3D turtle3D = turtle3DArray[n2];
            double d19 = dArray[n2];
            d5 = dArray2[n2];
            d4 = dArray3[n2];
            if (d19 > d18) {
                d19 = d18;
            } else if (d19 < -d18) {
                d19 = -d18;
            }
            if (d5 > d18) {
                d5 = d18;
            } else if (d5 < -d18) {
                d5 = -d18;
            }
            if (d4 > d18) {
                d4 = d18;
            } else if (d4 < -d18) {
                d4 = -d18;
            }
            double d20 = turtle3D.xcor() + d19;
            double d21 = turtle3D.ycor() + d5;
            double d22 = turtle3D.zcor() + d4;
            if (d20 > (double)world3D.maxPxcor()) {
                d20 = world3D.maxPxcor();
            } else if (d20 < (double)world3D.minPxcor()) {
                d20 = world3D.minPxcor();
            }
            if (d21 > (double)world3D.maxPycor()) {
                d21 = world3D.maxPycor();
            } else if (d21 < (double)world3D.minPycor()) {
                d21 = world3D.minPycor();
            }
            if (d22 > (double)world3D.maxPzcor()) {
                d22 = world3D.maxPzcor();
            } else if (d22 < (double)world3D.minPzcor()) {
                d22 = world3D.minPzcor();
            }
            turtle3D.xyandzcor(d20, d21, d22);
        }
    }

    public static strictfp void tutte(AgentSet agentSet, AgentSet agentSet2, double d, MersenneTwisterFast mersenneTwisterFast) throws AgentException {
        Turtle[] turtleArray;
        World world = agentSet.world();
        ArrayList<Turtle> arrayList = new ArrayList<Turtle>();
        AgentSet.Iterator iterator2 = agentSet2.iterator();
        while (iterator2.hasNext()) {
            turtleArray = (Turtle[])iterator2.next();
            if (!agentSet.contains(turtleArray.end1()) && !arrayList.contains(turtleArray.end1())) {
                arrayList.add(turtleArray.end1());
            }
            if (agentSet.contains(turtleArray.end2()) || arrayList.contains(turtleArray.end2())) continue;
            arrayList.add(turtleArray.end2());
        }
        Layouts.circle(world, LogoList.fromJava(arrayList), d);
        int n = agentSet.count();
        turtleArray = new Turtle[n];
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = 0;
        AgentSet.Iterator iterator3 = agentSet.shufflerator(mersenneTwisterFast);
        while (iterator3.hasNext()) {
            turtleArray[n2] = (Turtle)iterator3.next();
            ++n2;
        }
        for (int i = 0; i < n; ++i) {
            Turtle turtle2 = turtleArray[i];
            double d2 = 0.0;
            double d3 = 0.0;
            int n3 = 0;
            AgentSet.Iterator iterator4 = world.links().shufflerator(mersenneTwisterFast);
            while (iterator4.hasNext()) {
                Link link = (Link)iterator4.next();
                if (link.end1() != turtle2 && link.end2() != turtle2 || !agentSet2.contains(link)) continue;
                Turtle turtle3 = link.end1();
                if (turtle2 == link.end1()) {
                    turtle3 = link.end2();
                }
                d2 += turtle3.xcor();
                d3 += turtle3.ycor();
                ++n3;
            }
            d2 /= (double)n3;
            d3 /= (double)n3;
            d2 -= turtle2.xcor();
            d3 -= turtle2.ycor();
            double d4 = 100.0;
            if (d2 > d4) {
                d2 = d4;
            } else if (d2 < -d4) {
                d2 = -d4;
            }
            if (d3 > d4) {
                d3 = d4;
            } else if (d3 < -d4) {
                d3 = -d4;
            }
            d2 += turtle2.xcor();
            d3 += turtle2.ycor();
            if (d2 > (double)world.maxPxcor()) {
                d2 = world.maxPxcor();
            } else if (d2 < (double)world.minPxcor()) {
                d2 = world.minPxcor();
            }
            if (d3 > (double)world.maxPycor()) {
                d3 = world.maxPycor();
            } else if (d3 < (double)world.minPycor()) {
                d3 = world.minPycor();
            }
            dArray[i] = d2;
            dArray2[i] = d3;
        }
        Layouts.reposition(turtleArray, dArray, dArray2);
    }

    private static strictfp void reposition(Turtle[] turtleArray, double[] dArray, double[] dArray2) {
        try {
            for (int i = 0; i < turtleArray.length; ++i) {
                turtleArray[i].xandycor(dArray[i], dArray2[i]);
            }
        }
        catch (AgentException agentException) {
            throw new IllegalStateException(agentException);
        }
    }

    public static strictfp void radial(World world, AgentSet agentSet, AgentSet agentSet2, Turtle turtle2) throws AgentException {
        double d = (double)(world.minPxcor() + world.maxPxcor()) / 2.0;
        double d2 = (double)(world.minPycor() + world.maxPycor()) / 2.0;
        LinkManager linkManager = world.linkManager;
        HashMap<Turtle, TreeNode> hashMap = new HashMap<Turtle, TreeNode>(agentSet.count());
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>(agentSet.count());
        TreeNode treeNode = new TreeNode(turtle2, null);
        arrayList.add(treeNode);
        hashMap.put(treeNode.val, treeNode);
        TreeNode treeNode2 = treeNode;
        while (!arrayList.isEmpty()) {
            TreeNode treeNode3;
            treeNode2 = treeNode3 = (TreeNode)arrayList.remove(0);
            AgentSet agentSet3 = linkManager.findLinkedWith(treeNode3.val, agentSet2);
            AgentSet.Iterator iterator2 = agentSet3.iterator();
            while (iterator2.hasNext()) {
                Turtle turtle3 = (Turtle)iterator2.next();
                if (!agentSet.contains(turtle3) || hashMap.containsKey(turtle3)) continue;
                TreeNode treeNode4 = new TreeNode(turtle3, treeNode3);
                treeNode3.children.add(treeNode4);
                hashMap.put(turtle3, treeNode4);
                arrayList.add(treeNode4);
            }
        }
        treeNode.layoutRadial(0.0, 360.0);
        double d3 = (double)treeNode2.getDepth() + 0.2;
        if (d3 < 1.0) {
            d3 = 1.0;
        }
        double d4 = StrictMath.min((double)world.maxPxcor() - d, d - (double)world.minPxcor());
        double d5 = StrictMath.min((double)world.maxPycor() - d2, d2 - (double)world.minPycor());
        double d6 = StrictMath.min(d4, d5);
        double d7 = d6 / d3;
        for (TreeNode treeNode5 : hashMap.values()) {
            Turtle turtle4 = treeNode5.val;
            turtle4.heading(treeNode5.angle);
            turtle4.xandycor(d, d2);
            turtle4.jump((double)treeNode5.getDepth() * d7);
        }
    }

    private strictfp static class TreeNode {
        public Turtle val;
        public TreeNode parent;
        public List<TreeNode> children = new ArrayList<TreeNode>(10);
        public double angle = 0.0;

        public TreeNode(Turtle turtle2, TreeNode treeNode) {
            this.val = turtle2;
            this.parent = treeNode;
        }

        public int getDepth() {
            int n = 0;
            TreeNode treeNode = this.parent;
            while (treeNode != null) {
                treeNode = treeNode.parent;
                ++n;
            }
            return n;
        }

        public double getWeight() {
            double d = this.children.size() + 1;
            double d2 = 0.0;
            for (TreeNode treeNode : this.children) {
                double d3 = treeNode.getWeight();
                if (!(d3 > d2)) continue;
                d2 = d3;
            }
            return StrictMath.max(d, d2 *= 0.8);
        }

        public void layoutRadial(double d, double d2) {
            this.angle = (d + d2) / 2.0;
            double d3 = 0.0;
            for (TreeNode treeNode : this.children) {
                d3 += treeNode.getWeight();
            }
            double d4 = d;
            for (TreeNode treeNode : this.children) {
                double d5 = d4 + (d2 - d) * treeNode.getWeight() / d3;
                treeNode.layoutRadial(d4, d5);
                d4 = d5;
            }
        }
    }
}

