/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.Iterator;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Topology;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentVariables;
import org.nlogo.api.Color;
import org.nlogo.api.Dump;
import org.nlogo.api.I18N;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class Link
extends Agent
implements org.nlogo.api.Link {
    final Turtle end1;
    final Turtle end2;
    public static final int VAR_END1 = 0;
    public static final int VAR_END2 = 1;
    public static final int VAR_BREED = 6;
    public int LAST_PREDEFINED_VAR = 9;
    public int NUMBER_PREDEFINED_VARS = this.LAST_PREDEFINED_VAR + 1;
    public static final Double DEFAULT_COLOR = 5.0;
    public static final String MODE_NONE = "none";
    public static final String MODE_FIXED = "fixed";

    @Override
    public Turtle end1() {
        return this.end1;
    }

    @Override
    public Turtle end2() {
        return this.end2;
    }

    @Override
    public Object agentKey() {
        return this;
    }

    public Link(World world, Turtle turtle2, Turtle turtle3, int n) {
        super(world);
        this.variables = new Object[n];
        this.variables[0] = turtle2;
        this.variables[1] = turtle3;
        this.end1 = turtle2;
        this.end2 = turtle3;
        this.id = world.newLinkId();
        for (int i = 2; i < this.variables.length; ++i) {
            this.variables[i] = World.ZERO;
        }
    }

    Link(World world, Turtle turtle2, Turtle turtle3, AgentSet agentSet) {
        super(world);
        this.variables = new Object[world.getVariablesArraySize(this, (org.nlogo.api.AgentSet)agentSet)];
        this.variables[2] = Color.BoxedBlack();
        this.variables[0] = turtle2;
        this.variables[1] = turtle3;
        this.variables[3] = "";
        this.variables[4] = Color.BoxedWhite();
        this.variables[5] = Boolean.FALSE;
        this.variables[7] = World.ZERO;
        this.variables[8] = world.linkBreedShapes.breedShape(agentSet);
        this.variables[9] = MODE_NONE;
        this.end1 = turtle2;
        this.end2 = turtle3;
        this.id = world.newLinkId();
        this.variables[6] = agentSet;
        world.links().add(this);
        if (agentSet != world.links()) {
            agentSet.add(this);
        }
        for (int i = this.LAST_PREDEFINED_VAR + 1; i < this.variables.length; ++i) {
            this.variables[i] = World.ZERO;
        }
    }

    public void die() {
        if (this.id == -1L) {
            return;
        }
        AgentSet agentSet = this.getBreed();
        this.world.links().remove(this.agentKey());
        if (agentSet != this.world.links()) {
            agentSet.remove(this.agentKey());
        }
        this.world.linkManager.cleanup(this);
        this.id = -1L;
    }

    @Override
    Agent realloc(boolean bl) {
        return this.realloc(bl, null);
    }

    Agent realloc(boolean bl, AgentSet agentSet) {
        int n;
        String string;
        int n2;
        if (bl && this.getBreed() != this.world.links() && this.world.getLinkBreed(this.getBreed().printName()) == null) {
            return this;
        }
        Object[] objectArray = this.variables;
        this.variables = new Object[this.world.getVariablesArraySize(this, (org.nlogo.api.AgentSet)this.getBreed())];
        int n3 = this.world.getVariablesArraySize((org.nlogo.api.Link)null, (org.nlogo.api.AgentSet)this.world.links());
        int n4 = bl ? this.NUMBER_PREDEFINED_VARS : n3;
        System.arraycopy(objectArray, 0, this.variables, 0, n4);
        if (bl) {
            for (n2 = this.NUMBER_PREDEFINED_VARS; n2 < n3; ++n2) {
                string = this.world.linksOwnNameAt(n2);
                n = this.world.oldLinksOwnIndexOf(string);
                if (n == -1) {
                    this.variables[n2] = World.ZERO;
                    continue;
                }
                this.variables[n2] = objectArray[n];
                objectArray[n] = null;
            }
        }
        for (n2 = n3; n2 < this.variables.length; ++n2) {
            string = this.world.linkBreedsOwnNameAt(this.getBreed(), n2);
            int n5 = n = bl ? this.world.oldLinkBreedsOwnIndexOf(this.getBreed(), string) : this.world.linkBreedsOwnIndexOf(agentSet, string);
            if (n == -1) {
                this.variables[n2] = World.ZERO;
                continue;
            }
            this.variables[n2] = objectArray[n];
            objectArray[n] = null;
        }
        return null;
    }

    @Override
    public Object getVariable(int n) {
        return this.getLinkVariable(n);
    }

    @Override
    public Object getTurtleOrLinkVariable(String string) {
        return this.getLinkVariable(this.world.program().linksOwn().indexOf(string));
    }

    @Override
    public void setVariable(int n, Object object) throws AgentException {
        this.setLinkVariable(n, object);
    }

    @Override
    public Object getObserverVariable(int n) {
        return this.world.observer().getObserverVariable(n);
    }

    @Override
    public Object getLinkVariable(int n) {
        return this.variables[n];
    }

    @Override
    public void setObserverVariable(int n, Object object) throws AgentException, LogoException {
        this.world.observer().setObserverVariable(n, object);
    }

    @Override
    public void setTurtleOrLinkVariable(String string, Object object) throws AgentException {
        this.setLinkVariable(this.world.program().linksOwn().indexOf(string), object);
    }

    @Override
    public void setLinkVariable(int n, Object object) throws AgentException {
        if (n > this.LAST_PREDEFINED_VAR) {
            this.variables[n] = object;
        } else {
            switch (n) {
                case 2: {
                    if (object instanceof Double) {
                        this.colorDouble((Double)object);
                        break;
                    }
                    if (object instanceof LogoList) {
                        this.color((LogoList)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitLinkVariables()[n], Double.class, object);
                    break;
                }
                case 3: {
                    this.label(object);
                    break;
                }
                case 4: {
                    if (object instanceof Double) {
                        this.labelColor((Double)object);
                        break;
                    }
                    if (object instanceof LogoList) {
                        this.labelColor((LogoList)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitLinkVariables()[n], Double.class, object);
                    break;
                }
                case 5: {
                    if (object instanceof Boolean) {
                        this.hidden((Boolean)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitLinkVariables()[n], Boolean.class, object);
                    break;
                }
                case 6: {
                    if (object instanceof AgentSet) {
                        AgentSet agentSet = (AgentSet)object;
                        if (agentSet != this.world.links() && !this.world.isLinkBreed(agentSet)) {
                            throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Link.cantSetBreedToNonLinkBreedAgentSet"));
                        }
                        if (this.world.getLink(this.end1.agentKey(), this.end2.agentKey(), agentSet) != null) {
                            throw new AgentException("there is already a " + this.world.getLinkBreedSingular(agentSet) + " with endpoints " + this.end1.toString() + " and " + this.end2.toString());
                        }
                        if (!this.world.linkManager.checkBreededCompatibility(agentSet == this.world.links())) {
                            throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Link.cantHaveBreededAndUnbreededLinks"));
                        }
                        this.setBreed(agentSet);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitLinkVariables()[n], AgentSet.class, object);
                    break;
                }
                case 7: {
                    if (object instanceof Double) {
                        this.lineThickness((Double)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitLinkVariables()[n], Double.class, object);
                    break;
                }
                case 8: {
                    if (object instanceof String) {
                        String string = this.world.checkLinkShapeName((String)object);
                        if (string == null) {
                            throw new AgentException(I18N.errorsJ().getN("org.nlogo.agent.Agent.shapeUndefined", object));
                        }
                        this.shape(string);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitLinkVariables()[n], String.class, object);
                    break;
                }
                case 9: {
                    if (object instanceof String) {
                        this.mode((String)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitLinkVariables()[n], String.class, object);
                    break;
                }
                case 0: 
                case 1: {
                    throw new AgentException("you can't change a link's endpoints");
                }
                default: {
                    return;
                }
            }
        }
    }

    @Override
    public Object getTurtleVariable(int n) throws AgentException {
        throw new AgentException("a link can't access a turtle variable without specifying which turtle");
    }

    @Override
    public Object getBreedVariable(String string) throws AgentException {
        throw new AgentException("a link can't access a turtle variable without specifying which turtle");
    }

    @Override
    public Object getLinkBreedVariable(String string) throws AgentException {
        this.mustOwn(string);
        int n = this.world.linkBreedsOwnIndexOf(this.getBreed(), string);
        return this.getLinkVariable(n);
    }

    @Override
    public Object getPatchVariable(int n) throws AgentException {
        throw new AgentException("a link can't access a patch variable without specifying which patch");
    }

    @Override
    public void setTurtleVariable(int n, Object object) throws AgentException {
        throw new AgentException("a link can't set a turtle variable without specifying which turtle");
    }

    @Override
    public void setBreedVariable(String string, Object object) throws AgentException {
        throw new AgentException("a link can't set a turtle variable without specifying which turtle");
    }

    @Override
    public void setLinkBreedVariable(String string, Object object) throws AgentException {
        this.mustOwn(string);
        int n = this.world.linkBreedsOwnIndexOf(this.getBreed(), string);
        this.setLinkVariable(n, object);
    }

    @Override
    public void setPatchVariable(int n, Object object) throws AgentException {
        throw new AgentException("a link can't set a patch variable without specifying which turtle");
    }

    void mustOwn(String string) throws AgentException {
        if (string != null && !this.world.linkBreedOwns(this.getBreed(), string)) {
            throw new AgentException(I18N.errorsJ().getN("org.nlogo.agent.Agent.breedDoesNotOwnVariable", this.getBreed().printName(), string));
        }
    }

    @Override
    public double x1() {
        return this.end1.xcor();
    }

    @Override
    public double y1() {
        return this.end1.ycor();
    }

    @Override
    public double x2() {
        return this.world.topology.shortestPathX(this.end1.xcor(), this.end2.xcor());
    }

    @Override
    public double y2() {
        return this.world.topology.shortestPathY(this.end1.ycor(), this.end2.ycor());
    }

    @Override
    public double midpointX() {
        double d = this.x1();
        double d2 = this.x2();
        return Topology.wrap((d + d2) / 2.0, (double)this.world._minPxcor - 0.5, (double)this.world._maxPxcor + 0.5);
    }

    @Override
    public double midpointY() {
        double d = this.y1();
        double d2 = this.y2();
        return Topology.wrap((d + d2) / 2.0, (double)this.world._minPycor - 0.5, (double)this.world._maxPycor + 0.5);
    }

    @Override
    public double heading() {
        try {
            return this.world.protractor().towards(this.end1, this.end2, true);
        }
        catch (AgentException agentException) {
            return 0.0;
        }
    }

    @Override
    public double lineThickness() {
        return (Double)this.variables[7];
    }

    public void lineThickness(Double d) {
        this.variables[7] = d;
    }

    @Override
    public boolean isDirectedLink() {
        return ((AgentSet)this.variables[6]).isDirected();
    }

    @Override
    public double linkDestinationSize() {
        return this.end2.size();
    }

    @Override
    public double size() {
        return this.world.protractor().distance(this.end1, this.end2, true);
    }

    @Override
    public String shape() {
        return (String)this.variables[8];
    }

    public void shape(String string) {
        this.variables[8] = string;
    }

    public String mode() {
        return (String)this.variables[9];
    }

    public void mode(String string) {
        this.world.tieManager.setTieMode(this, string);
        this.variables[9] = string;
    }

    public boolean isTied() {
        return !this.variables[9].equals(MODE_NONE);
    }

    public void untie() {
        this.mode(MODE_NONE);
    }

    @Override
    public Object color() {
        return this.variables[2];
    }

    public void colorDouble(Double d) {
        double d2 = d;
        if (d2 < 0.0 || d2 >= (double)Color.MaxColor()) {
            d2 = Color.modulateDouble(d2);
            d = d2;
        }
        this.variables[2] = d;
    }

    public void colorDoubleUnchecked(Double d) {
        this.variables[2] = d;
    }

    public void color(LogoList logoList) throws AgentException {
        this.validRGBList(logoList, true);
        this.variables[2] = logoList;
        if (logoList.size() > 3) {
            this.world.mayHavePartiallyTransparentObjects = true;
        }
    }

    public AgentSet bothEnds() {
        ArrayAgentSet arrayAgentSet = new ArrayAgentSet(Turtle.class, 2, false, this.world);
        ((AgentSet)arrayAgentSet).add(this.end1);
        ((AgentSet)arrayAgentSet).add(this.end2);
        return arrayAgentSet;
    }

    @Override
    public Patch getPatchAtOffsets(double d, double d2) throws AgentException {
        throw new AgentException("links can't access patches via relative coordinates");
    }

    public Object label() {
        return this.variables[3];
    }

    @Override
    public boolean hasLabel() {
        return !(this.label() instanceof String) || ((String)this.label()).length() != 0;
    }

    @Override
    public String labelString() {
        return Dump.logoObject(this.variables[3]);
    }

    public void label(Object object) {
        this.variables[3] = object;
    }

    @Override
    public boolean hidden() {
        return (Boolean)this.variables[5];
    }

    public void hidden(boolean bl) {
        this.variables[5] = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public AgentSet getBreed() {
        return (AgentSet)this.variables[6];
    }

    @Override
    public Object labelColor() {
        return this.variables[4];
    }

    public void labelColor(double d) {
        this.variables[4] = Color.modulateDouble(d);
    }

    public void labelColor(LogoList logoList) throws AgentException {
        this.validRGBList(logoList, true);
        this.variables[4] = logoList;
    }

    public String toString() {
        return this.world.getLinkBreedSingular(this.getBreed()).toLowerCase() + " " + this.end1.id + " " + this.end2.id;
    }

    @Override
    public String classDisplayName() {
        return this.world.getLinkBreedSingular(this.getBreed()).toLowerCase();
    }

    public Class<Link> getAgentClass() {
        return Link.class;
    }

    @Override
    public int getAgentBit() {
        return 8;
    }

    public void setBreed(AgentSet agentSet) {
        AgentSet agentSet2 = null;
        if (this.variables[6] instanceof AgentSet) {
            agentSet2 = (AgentSet)this.variables[6];
            if (agentSet == agentSet2) {
                return;
            }
            if (agentSet2 != this.world.links()) {
                ((AgentSet)this.variables[6]).remove(this.agentKey());
            }
        }
        if (agentSet != this.world.links()) {
            agentSet.add(this);
        }
        this.variables[6] = agentSet;
        this.shape(this.world.linkBreedShapes.breedShape(agentSet));
        this.realloc(false, agentSet2);
    }

    @Override
    public int getBreedIndex() {
        AgentSet agentSet = this.getBreed();
        if (agentSet == this.world.links()) {
            return 0;
        }
        int n = 1;
        Iterator<Object> iterator2 = this.world.program().linkBreeds().values().iterator();
        while (iterator2.hasNext()) {
            if (agentSet == (AgentSet)iterator2.next()) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    @Override
    public int compareTo(Agent agent) {
        if (agent == this) {
            return 0;
        }
        Link link = (Link)agent;
        if (this.end1.id < link.end1.id) {
            return -1;
        }
        if (this.end1.id > link.end1.id) {
            return 1;
        }
        if (this.end2.id < link.end2.id) {
            return -1;
        }
        if (this.end2.id > link.end2.id) {
            return 1;
        }
        if (this.getBreed() == link.getBreed()) {
            return 0;
        }
        if (this.getBreed() == this.world.links()) {
            return -1;
        }
        if (link.getBreed() == this.world.links()) {
            return 1;
        }
        return this.world.compareLinkBreeds(this.getBreed(), link.getBreed());
    }

    @Override
    public int alpha() {
        return Color.getColor(this.color()).getAlpha();
    }
}

