/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.ArrayList;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentVariables;
import org.nlogo.api.Color;
import org.nlogo.api.Dump;
import org.nlogo.api.I18N;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class Patch
extends Agent
implements org.nlogo.api.Patch {
    public static final int VAR_PXCOR = 0;
    public static final int VAR_PYCOR = 1;
    public int NUMBER_PREDEFINED_VARS = 5;
    private final ArrayList<Turtle> _turtlesHere = new ArrayList(0);
    public AgentSet patchNeighbors;
    public AgentSet patchNeighbors4;
    double pcolor = 0.0;
    public final int pxcor;
    public final int pycor;

    public Iterable<Turtle> turtlesHere() {
        return this._turtlesHere;
    }

    public int turtleCount() {
        return this._turtlesHere.size();
    }

    public void clearTurtles() {
        this._turtlesHere.clear();
    }

    public void addTurtle(Turtle turtle2) {
        this._turtlesHere.add(turtle2);
    }

    public void removeTurtle(Turtle turtle2) {
        this._turtlesHere.remove(turtle2);
    }

    public AgentSet turtlesHereAgentSet() {
        return new ArrayAgentSet(Turtle.class, this._turtlesHere.toArray(new Agent[this._turtlesHere.size()]), this.world);
    }

    void topologyChanged() {
        this.patchNeighbors = null;
        this.patchNeighbors4 = null;
    }

    Patch(World world, int n, int n2, int n3, int n4) {
        super(world);
        this.id = n;
        this.pxcor = n2;
        this.pycor = n3;
        this.variables = new Object[n4];
        block6: for (int i = 0; i < n4; ++i) {
            switch (i) {
                case 0: {
                    this.variables[i] = (double)n2;
                    continue block6;
                }
                case 1: {
                    this.variables[i] = (double)n3;
                    continue block6;
                }
                case 3: {
                    this.variables[i] = "";
                    continue block6;
                }
                case 4: {
                    this.variables[i] = Color.BoxedWhite();
                    continue block6;
                }
                default: {
                    this.variables[i] = World.ZERO;
                }
            }
        }
    }

    Patch(World world, int n, int n2) {
        super(world);
        this.pxcor = n;
        this.pycor = n2;
    }

    @Override
    Agent realloc(boolean bl) {
        int n;
        Object[] objectArray = this.variables;
        Object[] objectArray2 = new Object[this.world.getVariablesArraySize(this)];
        for (n = 0; objectArray2.length != n; ++n) {
            objectArray2[n] = n < this.NUMBER_PREDEFINED_VARS ? objectArray[n] : World.ZERO;
        }
        if (bl) {
            for (n = this.NUMBER_PREDEFINED_VARS; n < objectArray.length && n < this.world.oldPatchesOwn.size(); ++n) {
                String string = this.world.oldPatchesOwn.get(n);
                int n2 = this.world.patchesOwnIndexOf(string);
                if (n2 == -1) continue;
                objectArray2[n2] = objectArray[n];
            }
        }
        this.variables = objectArray2;
        return null;
    }

    @Override
    public Object getObserverVariable(int n) {
        return this.world.observer().getObserverVariable(n);
    }

    @Override
    public Object getTurtleVariable(int n) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantAccessTurtleWithoutSpecifyingTurtle"));
    }

    @Override
    public Object getLinkVariable(int n) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantAccessLinkVarWithoutSpecifyingLink"));
    }

    @Override
    public Object getTurtleOrLinkVariable(String string) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantAccessTurtleOrLinkWithoutSpecifyingAgent"));
    }

    @Override
    public Object getLinkBreedVariable(String string) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantAccessLinkVarWithoutSpecifyingLink"));
    }

    @Override
    public Object getBreedVariable(String string) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantAccessTurtleWithoutSpecifyingTurtle"));
    }

    @Override
    public Object getVariable(int n) {
        return this.getPatchVariable(n);
    }

    @Override
    public void setObserverVariable(int n, Object object) throws AgentException, LogoException {
        this.world.observer().setObserverVariable(n, object);
    }

    @Override
    public void setTurtleVariable(int n, Object object) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantSetTurtleWithoutSpecifyingTurtle"));
    }

    @Override
    public void setBreedVariable(String string, Object object) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantSetTurtleWithoutSpecifyingTurtle"));
    }

    @Override
    public void setLinkVariable(int n, Object object) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantAccessLinkVarWithoutSpecifyingLink"));
    }

    @Override
    public void setTurtleOrLinkVariable(String string, Object object) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantAccessTurtleOrLinkWithoutSpecifyingAgent"));
    }

    @Override
    public void setLinkBreedVariable(String string, Object object) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantAccessLinkVarWithoutSpecifyingLink"));
    }

    @Override
    public void setVariable(int n, Object object) throws AgentException {
        this.setPatchVariable(n, object);
    }

    @Override
    public void setPatchVariable(int n, Object object) throws AgentException {
        if (n > 4) {
            this.variables[n] = object;
        } else {
            switch (n) {
                case 2: {
                    if (object instanceof Double) {
                        this.pcolor((Double)object);
                        break;
                    }
                    if (object instanceof LogoList) {
                        this.pcolor((LogoList)object, 2, false);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitPatchVariables(false)[n], Double.class, object);
                    break;
                }
                case 3: {
                    this.label(object);
                    break;
                }
                case 4: {
                    if (object instanceof Double) {
                        this.labelColor((double)((Double)object));
                        break;
                    }
                    if (object instanceof LogoList) {
                        this.labelColor((LogoList)object, 4);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitPatchVariables(false)[n], Double.class, object);
                    break;
                }
                case 0: 
                case 1: {
                    throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantChangePatchCoordinates"));
                }
                default: {
                    throw new IllegalStateException(I18N.errorsJ().getN("org.nlogo.agent.Agent.cantSetUnknownVariable", n));
                }
            }
        }
    }

    @Override
    public Object getPatchVariable(int n) {
        if (n == 2 && this.variables[2] == null) {
            this.variables[2] = this.pcolor;
        }
        return this.variables[n];
    }

    public double getPatchVariableDouble(int n) {
        switch (n) {
            case 0: {
                return this.pxcor;
            }
            case 1: {
                return this.pycor;
            }
        }
        throw new IllegalArgumentException(I18N.errorsJ().getN("org.nlogo.agent.Agent.notADoubleVariable", Integer.toString(n)));
    }

    @Override
    public Patch getPatchAtOffsets(double d, double d2) throws AgentException {
        Patch patch = this.world.getTopology().getPatchAt((double)this.pxcor + d, (double)this.pycor + d2);
        if (patch == null) {
            throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Turtle.patchBeyondLimits"));
        }
        return patch;
    }

    public Patch fastGetPatchAt(int n, int n2) {
        return this.world.fastGetPatchAt(n, n2);
    }

    public AgentSet getNeighbors() {
        if (this.patchNeighbors == null) {
            this.patchNeighbors = this.world.getTopology().getNeighbors(this);
        }
        return this.patchNeighbors;
    }

    public AgentSet getNeighbors4() {
        if (this.patchNeighbors4 == null) {
            this.patchNeighbors4 = this.world.getTopology().getNeighbors4(this);
        }
        return this.patchNeighbors4;
    }

    public Turtle sprout(int n, int n2, AgentSet agentSet) {
        Turtle turtle2 = new Turtle(this.world, agentSet, (Double)this.variables[0], (Double)this.variables[1]);
        double d = 5 + 10 * n;
        turtle2.colorDoubleUnchecked(d);
        turtle2.heading(n2);
        return turtle2;
    }

    public double pcolorDouble() {
        if (this.variables[2] == null || this.variables[2] instanceof Double) {
            return this.pcolor;
        }
        throw new IllegalStateException(I18N.errorsJ().get("org.nlogo.agent.Patch.pcolorNotADouble"));
    }

    @Override
    public Object pcolor() {
        if (this.variables[2] == null) {
            this.variables[2] = this.pcolor;
        }
        return this.variables[2];
    }

    public void pcolor(double d) {
        if (d < 0.0 || d >= (double)Color.MaxColor()) {
            d = Color.modulateDouble(d);
        }
        if (this.pcolor != d) {
            this.pcolor = d;
            this.variables[2] = null;
            this.world.patchColors[(int)this.id] = Color.getARGBbyPremodulatedColorNumber(d);
            this.world.patchColorsDirty = true;
            if (d != 0.0) {
                this.world.patchesAllBlack = false;
            }
        }
    }

    public void pcolor(Double d) {
        double d2 = d;
        if (d2 < 0.0 || d2 >= (double)Color.MaxColor()) {
            if (this.pcolor != (d2 = Color.modulateDouble(d2))) {
                this.pcolor = d2;
                this.variables[2] = null;
                this.world.patchColors[(int)this.id] = Color.getARGBbyPremodulatedColorNumber(this.pcolor);
                this.world.patchColorsDirty = true;
                if (this.pcolor != 0.0) {
                    this.world.patchesAllBlack = false;
                }
            }
        } else if (this.pcolor != d2) {
            this.pcolor = d2;
            this.variables[2] = d;
            this.world.patchColors[(int)this.id] = Color.getARGBbyPremodulatedColorNumber(this.pcolor);
            this.world.patchColorsDirty = true;
            if (this.pcolor != 0.0) {
                this.world.patchesAllBlack = false;
            }
        }
    }

    public void pcolorDoubleUnchecked(Double d) {
        double d2 = d;
        if (d2 != this.pcolor) {
            this.pcolor = d2;
            this.variables[2] = d;
            this.world.patchColors[(int)this.id] = Color.getARGBbyPremodulatedColorNumber(d2);
            this.world.patchColorsDirty = true;
            if (d2 != 0.0) {
                this.world.patchesAllBlack = false;
            }
        }
    }

    public void pcolor(LogoList logoList) throws AgentException {
        this.pcolor(logoList, 2, true);
    }

    public void pcolor(LogoList logoList, int n, boolean bl) throws AgentException {
        this.validRGBList(logoList, bl);
        this.pcolor = Double.NaN;
        if (!(this.variables[n] instanceof LogoList) || !logoList.equals(this.variables[n])) {
            this.variables[n] = logoList;
            this.world.patchColors[(int)this.id] = Color.getRGBInt(((Double)logoList.get(0)).intValue(), ((Double)logoList.get(1)).intValue(), ((Double)logoList.get(2)).intValue());
            this.world.patchColorsDirty = true;
            this.world.patchesAllBlack = false;
            if (logoList.size() > 3) {
                this.world.mayHavePartiallyTransparentObjects = true;
            }
        }
    }

    @Override
    public int pxcor() {
        return this.pxcor;
    }

    @Override
    public int pycor() {
        return this.pycor;
    }

    public Object label() {
        return this.variables[3];
    }

    @Override
    public boolean hasLabel() {
        return !(this.label() instanceof String) || ((String)this.label()).length() != 0;
    }

    @Override
    public String labelString() {
        return Dump.logoObject(this.variables[3]);
    }

    public void label(Object object) {
        if (object instanceof String && ((String)object).length() == 0) {
            if (this.hasLabel()) {
                --this.world.patchesWithLabels;
            }
        } else if (!this.hasLabel()) {
            ++this.world.patchesWithLabels;
        }
        this.variables[3] = object;
    }

    @Override
    public Object labelColor() {
        return this.variables[4];
    }

    public void labelColor(double d) {
        this.variables[4] = Color.modulateDouble(d);
    }

    public void labelColor(Double d) {
        this.variables[4] = d;
    }

    public void labelColor(LogoList logoList, int n) throws AgentException {
        this.validRGBList(logoList, true);
        this.variables[n] = logoList;
    }

    public String toString() {
        return "patch " + this.pxcor + " " + this.pycor;
    }

    @Override
    public String classDisplayName() {
        return "patch";
    }

    public Class<Patch> getAgentClass() {
        return Patch.class;
    }

    @Override
    public int getAgentBit() {
        return 4;
    }

    @Override
    public String shape() {
        return "";
    }

    @Override
    public double size() {
        return 1.0;
    }

    public Patch getPatchNorth() {
        return this.world.getTopology().getPN(this);
    }

    public Patch getPatchSouth() {
        return this.world.getTopology().getPS(this);
    }

    public Patch getPatchEast() {
        return this.world.getTopology().getPE(this);
    }

    public Patch getPatchWest() {
        return this.world.getTopology().getPW(this);
    }

    public Patch getPatchNorthWest() {
        return this.world.getTopology().getPNW(this);
    }

    public Patch getPatchSouthWest() {
        return this.world.getTopology().getPSW(this);
    }

    public Patch getPatchSouthEast() {
        return this.world.getTopology().getPSE(this);
    }

    public Patch getPatchNorthEast() {
        return this.world.getTopology().getPNE(this);
    }

    @Override
    public int alpha() {
        return Color.getColor(this.pcolor()).getAlpha();
    }
}

