/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent3D;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Topology3D;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.Turtle3D;
import org.nlogo.agent.World;
import org.nlogo.agent.World3D;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentVariables;
import org.nlogo.api.Color;
import org.nlogo.api.Dump;
import org.nlogo.api.LogoList;

public strictfp final class Patch3D
extends Patch
implements Agent3D,
org.nlogo.api.Patch3D {
    public final int pzcor;
    public AgentSet patchNeighbors6;

    public int pzcor() {
        return this.pzcor;
    }

    void topologyChanged() {
        super.topologyChanged();
        this.patchNeighbors6 = null;
    }

    Patch3D(World world, int n, int n2, int n3, int n4, int n5) {
        super(world, n2, n3);
        this.id = n;
        this.pzcor = n4;
        this.variables = new Object[n5];
        block7: for (int i = 0; i < n5; ++i) {
            switch (i) {
                case 0: {
                    this.variables[i] = (double)n2;
                    continue block7;
                }
                case 1: {
                    this.variables[i] = (double)n3;
                    continue block7;
                }
                case 2: {
                    this.variables[i] = (double)n4;
                    continue block7;
                }
                case 4: {
                    this.variables[i] = "";
                    continue block7;
                }
                case 5: {
                    this.variables[i] = Color.BoxedWhite();
                    continue block7;
                }
                default: {
                    this.variables[i] = World.ZERO;
                }
            }
        }
        this.NUMBER_PREDEFINED_VARS = 6;
    }

    public void setPatchVariable(int n, Object object) throws AgentException {
        if (n > 5) {
            this.variables[n] = object;
        } else {
            switch (n) {
                case 3: {
                    if (object instanceof Double) {
                        this.pcolor((Double)object);
                        break;
                    }
                    if (object instanceof LogoList) {
                        this.pcolor((LogoList)object, 3, true);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitPatchVariables(true)[n], Double.class, object);
                    break;
                }
                case 4: {
                    this.label(object);
                    break;
                }
                case 5: {
                    if (object instanceof Double) {
                        this.labelColor((double)((Double)object));
                        break;
                    }
                    if (object instanceof LogoList) {
                        this.labelColor((LogoList)object, 5);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitPatchVariables(true)[n], Double.class, object);
                    break;
                }
                case 0: 
                case 1: 
                case 2: {
                    throw new AgentException("you can't change a patch's coordinates");
                }
                default: {
                    return;
                }
            }
        }
    }

    public Object getPatchVariable(int n) {
        if (n == 3 && this.variables[3] == null) {
            this.variables[3] = this.pcolor;
        }
        return this.variables[n];
    }

    public double getPatchVariableDouble(int n) {
        switch (n) {
            case 0: {
                return this.pxcor;
            }
            case 1: {
                return this.pycor;
            }
            case 2: {
                return this.pzcor;
            }
        }
        throw new IllegalArgumentException(n + " is not a double variable");
    }

    public Patch getPatchAtOffsets(double d, double d2) throws AgentException {
        Patch3D patch3D = ((World3D)this.world).getPatchAt((double)this.pxcor + d, (double)this.pycor + d2, this.pzcor);
        if (patch3D == null) {
            throw new AgentException("Cannot get patch beyond limits of current world.");
        }
        return patch3D;
    }

    public Patch3D getPatchAtOffsets(double d, double d2, double d3) throws AgentException {
        Patch3D patch3D = ((World3D)this.world).getPatchAt((double)this.pxcor + d, (double)this.pycor + d2, (double)this.pzcor + d3);
        if (patch3D == null) {
            throw new AgentException("Cannot get patch beyond limits of current world.");
        }
        return patch3D;
    }

    public Patch fastGetPatchAt(int n, int n2) {
        return ((World3D)this.world).fastGetPatchAt(n, n2, this.pzcor);
    }

    public Turtle sprout(int n, int n2, AgentSet agentSet) {
        Turtle3D turtle3D = new Turtle3D((World3D)this.world, agentSet, (Double)this.variables[0], (Double)this.variables[1], (Double)this.variables[2]);
        turtle3D.colorDouble(Double.valueOf(5 + 10 * n));
        turtle3D.heading(n2);
        return turtle3D;
    }

    public Object pcolor() {
        if (this.variables[3] == null) {
            this.variables[3] = this.pcolor;
        }
        return this.variables[3];
    }

    public void pcolor(double d) {
        if (d < 0.0 || d >= (double)Color.MaxColor()) {
            d = Color.modulateDouble(d);
        }
        if (this.pcolor != d) {
            this.pcolor = d;
            this.variables[3] = null;
            this.world.patchColors[(int)this.id] = Color.getARGBbyPremodulatedColorNumber(d);
            this.world.patchColorsDirty = true;
            if (d != 0.0) {
                this.world.patchesAllBlack = false;
            }
        }
    }

    public void pcolor(Double d) {
        double d2 = d;
        if (d2 < 0.0 || d2 >= (double)Color.MaxColor()) {
            if (this.pcolor != (d2 = Color.modulateDouble(d2))) {
                this.pcolor = d2;
                this.variables[3] = null;
                this.world.patchColors[(int)this.id] = Color.getARGBbyPremodulatedColorNumber(this.pcolor);
                this.world.patchColorsDirty = true;
                if (this.pcolor != 0.0) {
                    this.world.patchesAllBlack = false;
                }
            }
        } else if (this.pcolor != d2) {
            this.pcolor = d2;
            this.variables[3] = d;
            this.world.patchColors[(int)this.id] = Color.getARGBbyPremodulatedColorNumber(this.pcolor);
            this.world.patchColorsDirty = true;
            if (this.pcolor != 0.0) {
                this.world.patchesAllBlack = false;
            }
        }
    }

    public void pcolor(LogoList logoList) throws AgentException {
        this.pcolor(logoList, 3, true);
    }

    public void pcolorDoubleUnchecked(Double d) {
        double d2 = d;
        if (d2 != this.pcolor) {
            this.pcolor = d2;
            this.variables[3] = d;
            this.world.patchColors[(int)this.id] = Color.getARGBbyPremodulatedColorNumber(d2);
            this.world.patchColorsDirty = true;
            if (d2 != 0.0) {
                this.world.patchesAllBlack = false;
            }
        }
    }

    public Object label() {
        return this.variables[4];
    }

    public String labelString() {
        return Dump.logoObject(this.variables[4]);
    }

    public void label(Object object) {
        if (object instanceof String && ((String)object).length() == 0) {
            if (this.hasLabel()) {
                --this.world.patchesWithLabels;
            }
        } else if (!this.hasLabel()) {
            ++this.world.patchesWithLabels;
        }
        this.variables[4] = object;
    }

    public Object labelColor() {
        return this.variables[5];
    }

    public void labelColor(double d) {
        this.variables[5] = Color.modulateDouble(d);
    }

    public void labelColor(Double d) {
        this.variables[5] = d;
    }

    public AgentSet getNeighbors() {
        if (this.patchNeighbors == null) {
            this.patchNeighbors = ((Topology3D)((Object)this.world.getTopology())).getNeighbors3d(this);
        }
        return this.patchNeighbors;
    }

    public String toString() {
        return "patch " + this.pxcor + " " + this.pycor + " " + this.pzcor;
    }

    public int alpha() {
        return this.pcolor().equals(Color.BoxedBlack()) ? 0 : Color.getColor(this.pcolor()).getAlpha();
    }
}

