/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.Link;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Topology;
import org.nlogo.agent.TrigTables;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.Constants;
import org.nlogo.api.I18N;

public strictfp class Protractor
implements org.nlogo.api.Protractor {
    private final World world;

    Protractor(World world) {
        this.world = world;
    }

    public double distanceToLink(Link link, double d, double d2) {
        double d3;
        double d4;
        double[] dArray;
        double d5;
        double d6;
        double d7;
        double d8 = link.x1();
        if (this.inBounds(d8, d7 = link.y1(), d6 = link.x2(), d5 = link.y2(), (dArray = this.closestPoint(d, d2, d8, d7, d4 = d6 - d8, d3 = d5 - d7))[0], dArray[1])) {
            return this.distance(dArray[0], dArray[1], d, d2, true);
        }
        double d9 = d;
        double d10 = d2;
        if (d6 < (double)this.world._minPxcor) {
            d -= (double)this.world._worldWidth;
        } else if (d6 > (double)this.world._maxPxcor) {
            d += (double)this.world._worldWidth;
        }
        dArray = this.closestPoint(d, d2, d8, d7, d4, d3);
        if (this.inBounds(d8, d7, d6, d5, dArray[0], dArray[1])) {
            return this.distance(dArray[0], dArray[1], d, d2, true);
        }
        if (d5 < (double)this.world._minPycor) {
            d2 -= (double)this.world._worldHeight;
        } else if (d5 > (double)this.world._maxPycor) {
            d2 += (double)this.world._worldHeight;
        }
        dArray = this.closestPoint(d, d2, d8, d7, d4, d3);
        if (this.inBounds(d8, d7, d6, d5, dArray[0], dArray[1])) {
            return this.distance(dArray[0], dArray[1], d, d2, true);
        }
        d = d9;
        d2 = d10;
        dArray = this.closestPoint(d, d2, d8, d7, d4, d3);
        if (this.inBounds(d8, d7, d6, d5, dArray[0], dArray[1])) {
            return this.distance(dArray[0], dArray[1], d, d2, true);
        }
        return StrictMath.min(this.distance(d8, d7, d, d2, true), this.distance(d6, d5, d, d2, true));
    }

    private double[] closestPoint(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = ((d - d3) * d5 + (d2 - d4) * d6) / (d5 * d5 + d6 * d6);
        double d8 = d3 + d7 * d5;
        double d9 = d4 + d7 * d6;
        return new double[]{d8, d9};
    }

    public boolean inBounds(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9;
        double d10;
        if (d2 > d4) {
            d10 = d2;
            d9 = d4;
        } else {
            d10 = d4;
            d9 = d2;
        }
        if (d > d3) {
            d8 = d;
            d7 = d3;
        } else {
            d8 = d3;
            d7 = d;
        }
        return d5 <= d8 && d5 >= d7 && d6 <= d10 && d6 >= d9;
    }

    public double distance(org.nlogo.api.Agent agent, double d, double d2, boolean bl) {
        double d3;
        double d4;
        if (agent instanceof Turtle) {
            Turtle turtle2 = (Turtle)agent;
            d4 = turtle2.xcor();
            d3 = turtle2.ycor();
        } else {
            if (agent instanceof Link) {
                return this.distanceToLink((Link)agent, d, d2);
            }
            Patch patch = (Patch)agent;
            d4 = patch.pxcor;
            d3 = patch.pycor;
        }
        return this.distance(d4, d3, d, d2, bl);
    }

    public double distance(org.nlogo.api.Agent agent, org.nlogo.api.Agent agent2, boolean bl) {
        double d;
        double d2;
        if (agent instanceof Turtle) {
            Turtle turtle2 = (Turtle)agent;
            d2 = turtle2.xcor();
            d = turtle2.ycor();
        } else {
            Patch patch = (Patch)agent;
            d2 = patch.pxcor;
            d = patch.pycor;
        }
        return this.distance(agent2, d2, d, bl);
    }

    public double distance(double d, double d2, double d3, double d4, boolean bl) {
        double d5;
        double d6 = d3 - d;
        double d7 = d4 - d2;
        double d8 = this.world.rootsTable.gridRoot(d6 * d6 + d7 * d7);
        if (bl && (d5 = this.world.topology.distanceWrap(d6, d7, d, d2, d3, d4)) < d8) {
            return d5;
        }
        return d8;
    }

    public Patch getPatchAtHeadingAndDistance(Agent agent, double d, double d2) throws AgentException {
        if (agent instanceof Turtle) {
            Turtle turtle2 = (Turtle)agent;
            return this.getPatchAtHeadingAndDistance(turtle2.xcor(), turtle2.ycor(), d, d2);
        }
        Patch patch = (Patch)agent;
        return this.getPatchAtHeadingAndDistance(patch.pxcor, patch.pycor, d, d2);
    }

    public Patch getPatchAtHeadingAndDistance(double d, double d2, double d3, double d4) throws AgentException {
        double d5;
        double d6;
        int n = (int)d3;
        if (d3 == (double)n) {
            d6 = TrigTables.cos()[n];
            d5 = TrigTables.sin()[n];
        } else {
            double d7 = StrictMath.toRadians(d3);
            d6 = StrictMath.cos(d7);
            d5 = StrictMath.sin(d7);
            if (StrictMath.abs(d6) < Constants.Infinitesimal()) {
                d6 = 0.0;
            }
            if (StrictMath.abs(d5) < Constants.Infinitesimal()) {
                d5 = 0.0;
            }
        }
        return this.world.getPatchAt(d + d4 * d5, d2 + d4 * d6);
    }

    public double towards(org.nlogo.api.Agent agent, org.nlogo.api.Agent agent2, boolean bl) throws AgentException {
        double d;
        double d2;
        if (agent == agent2) {
            throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Protractor.noHeadingFromAgentToSelf"));
        }
        if (agent2 instanceof Turtle) {
            Turtle turtle2 = (Turtle)agent2;
            d2 = turtle2.xcor();
            d = turtle2.ycor();
        } else if (agent2 instanceof Link) {
            Link link = (Link)agent2;
            d2 = link.midpointX();
            d = link.midpointY();
        } else {
            Patch patch = (Patch)agent2;
            d2 = patch.pxcor;
            d = patch.pycor;
        }
        return this.towards(agent, d2, d, bl);
    }

    public double towards(org.nlogo.api.Agent agent, double d, double d2, boolean bl) throws AgentException {
        double d3;
        double d4;
        if (agent instanceof Turtle) {
            Turtle turtle2 = (Turtle)agent;
            d4 = turtle2.xcor();
            d3 = turtle2.ycor();
        } else if (agent instanceof Observer) {
            Observer observer = (Observer)agent;
            d4 = observer.oxcor();
            d3 = observer.oycor();
        } else if (agent instanceof Patch) {
            Patch patch = (Patch)agent;
            d4 = patch.pxcor;
            d3 = patch.pycor;
        } else {
            throw new IllegalStateException("In towards: fromAgent must not be a link");
        }
        return this.towards(d4, d3, d, d2, bl);
    }

    public double towards(double d, double d2, double d3, double d4, boolean bl) throws AgentException {
        if (d == d3 && d2 == d4) {
            throw new AgentException(I18N.errorsJ().getN("org.nlogo.agent.Protractor.noHeadingFromPointToSelf", d, d2));
        }
        double d5 = d3 - d;
        double d6 = d4 - d2;
        if (bl) {
            return this.world.topology.towardsWrap(d5, d6);
        }
        if (d5 == 0.0) {
            return d6 > 0.0 ? 0.0 : 180.0;
        }
        if (d6 == 0.0) {
            return d5 > 0.0 ? 90.0 : 270.0;
        }
        return (270.0 + StrictMath.toDegrees(Math.PI + StrictMath.atan2(-d6, d5))) % 360.0;
    }

    public double towardsPitch(org.nlogo.api.Agent agent, org.nlogo.api.Agent agent2, boolean bl) throws AgentException {
        double d;
        double d2;
        double d3;
        if (agent == agent2) {
            throw new AgentException("no pitch is defined from an agent to itself");
        }
        if (agent2 instanceof Turtle) {
            Turtle turtle2 = (Turtle)agent2;
            d3 = turtle2.xcor();
            d2 = turtle2.ycor();
            d = 0.0;
        } else if (agent2 instanceof Link) {
            Link link = (Link)agent2;
            d3 = link.midpointX();
            d2 = link.midpointY();
            d = 0.0;
        } else {
            Patch patch = (Patch)agent2;
            d3 = patch.pxcor;
            d2 = patch.pycor;
            d = 0.0;
        }
        return this.towardsPitch(agent, d3, d2, d, bl);
    }

    public double towardsPitch(org.nlogo.api.Agent agent, double d, double d2, double d3, boolean bl) throws AgentException {
        if (agent instanceof Observer) {
            Observer observer = (Observer)agent;
            double d4 = observer.oxcor();
            double d5 = observer.oycor();
            double d6 = observer.ozcor();
            return this.towardsPitch(d4, d5, d6, d, d2, d3, bl);
        }
        throw new IllegalStateException("In towardsPitch: fromAgent must be the observer");
    }

    public double towardsPitch(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) throws AgentException {
        if (d == d4 && d2 == d5 && d3 == d6) {
            throw new AgentException("no pitch is defined from a point (" + d + "," + d2 + "," + d3 + ") to that same point");
        }
        double d7 = d4 - d;
        double d8 = d5 - d2;
        double d9 = d6 - d3;
        if (bl) {
            d7 = Topology.wrap(d7, (double)this.world._minPxcor - 0.5, (double)this.world._maxPxcor + 0.5);
            d8 = Topology.wrap(d8, (double)this.world._minPycor - 0.5, (double)this.world._maxPycor + 0.5);
        }
        return StrictMath.toDegrees(StrictMath.atan(d9 / StrictMath.sqrt(d7 * d7 + d8 * d8)));
    }
}

