/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.Link;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Patch3D;
import org.nlogo.agent.Protractor;
import org.nlogo.agent.Topology;
import org.nlogo.agent.Topology3D;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.Turtle3D;
import org.nlogo.agent.World3D;
import org.nlogo.api.AgentException;
import org.nlogo.api.Constants;

public strictfp class Protractor3D
extends Protractor {
    private final World3D world;

    Protractor3D(World3D world3D) {
        super(world3D);
        this.world = world3D;
    }

    public double distance(org.nlogo.api.Agent agent, org.nlogo.api.Agent agent2, boolean bl) {
        double d;
        double d2;
        double d3;
        if (agent instanceof Turtle) {
            Turtle3D turtle3D = (Turtle3D)agent;
            d3 = turtle3D.xcor();
            d2 = turtle3D.ycor();
            d = turtle3D.zcor();
        } else {
            if (agent instanceof Link) {
                throw new IllegalStateException("you can't find distance to links");
            }
            Patch3D patch3D = (Patch3D)agent;
            d3 = patch3D.pxcor;
            d2 = patch3D.pycor;
            d = patch3D.pzcor;
        }
        return this.distance(agent2, d3, d2, d, bl);
    }

    public double distance(org.nlogo.api.Agent agent, double d, double d2, double d3, boolean bl) {
        double d4;
        double d5;
        double d6;
        if (agent instanceof Turtle) {
            Turtle3D turtle3D = (Turtle3D)agent;
            d6 = turtle3D.xcor();
            d5 = turtle3D.ycor();
            d4 = turtle3D.zcor();
        } else {
            Patch3D patch3D = (Patch3D)agent;
            d6 = patch3D.pxcor;
            d5 = patch3D.pycor;
            d4 = patch3D.pzcor;
        }
        return this.distance(d, d2, d3, d6, d5, d4, bl);
    }

    public double distance(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        double d7;
        double d8 = -StrictMath.abs(d4 - d);
        double d9 = -StrictMath.abs(d5 - d2);
        double d10 = -StrictMath.abs(d6 - d3);
        double d11 = StrictMath.sqrt(d8 * d8 + d9 * d9 + d10 * d10);
        if (bl && (d7 = ((Topology3D)((Object)this.world.topology)).distanceWrap(d8, d9, d10, d, d2, d3, d4, d5, d6)) < d11) {
            return d7;
        }
        return d11;
    }

    public Patch getPatchAtHeadingAndDistance(Agent agent, double d, double d2) throws AgentException {
        if (agent instanceof Turtle) {
            Turtle3D turtle3D = (Turtle3D)agent;
            return this.getPatchAtHeadingPitchAndDistance(turtle3D.xcor(), turtle3D.ycor(), turtle3D.zcor(), d, turtle3D.pitch(), d2);
        }
        Patch3D patch3D = (Patch3D)agent;
        return this.getPatchAtHeadingPitchAndDistance(patch3D.pxcor, patch3D.pycor, patch3D.pzcor, d, 0.0, d2);
    }

    public Patch getPatchAtHeadingPitchAndDistance(double d, double d2, double d3, double d4, double d5, double d6) throws AgentException {
        double d7 = StrictMath.toRadians(d5);
        double d8 = StrictMath.sin(d7);
        double d9 = d6 * StrictMath.cos(d7);
        if (StrictMath.abs(d8) < Constants.Infinitesimal()) {
            d8 = 0.0;
        }
        if (StrictMath.abs(d9) < Constants.Infinitesimal()) {
            d9 = 0.0;
        }
        double d10 = StrictMath.toRadians(d4);
        double d11 = StrictMath.cos(d10);
        double d12 = StrictMath.sin(d10);
        if (StrictMath.abs(d11) < Constants.Infinitesimal()) {
            d11 = 0.0;
        }
        if (StrictMath.abs(d12) < Constants.Infinitesimal()) {
            d12 = 0.0;
        }
        return this.world.getPatchAt(d + d9 * d12, d2 + d9 * d11, d3 + d6 * d8);
    }

    public double towardsPitch(org.nlogo.api.Agent agent, org.nlogo.api.Agent agent2, boolean bl) throws AgentException {
        double d;
        double d2;
        double d3;
        if (agent == agent2) {
            throw new AgentException("no pitch is defined from an agent to itself");
        }
        if (agent2 instanceof Turtle) {
            Turtle3D turtle3D = (Turtle3D)agent2;
            d3 = turtle3D.xcor();
            d2 = turtle3D.ycor();
            d = turtle3D.zcor();
        } else {
            Patch3D patch3D = (Patch3D)agent2;
            d3 = patch3D.pxcor;
            d2 = patch3D.pycor;
            d = patch3D.pzcor;
        }
        return this.towardsPitch(agent, d3, d2, d, bl);
    }

    public double towardsPitch(org.nlogo.api.Agent agent, double d, double d2, double d3, boolean bl) throws AgentException {
        double d4;
        double d5;
        double d6;
        if (agent instanceof Turtle) {
            Turtle3D turtle3D = (Turtle3D)agent;
            d6 = turtle3D.xcor();
            d5 = turtle3D.ycor();
            d4 = turtle3D.zcor();
        } else if (agent instanceof Observer) {
            Observer observer = (Observer)agent;
            d6 = observer.oxcor();
            d5 = observer.oycor();
            d4 = observer.ozcor();
        } else {
            Patch3D patch3D = (Patch3D)agent;
            d6 = patch3D.pxcor;
            d5 = patch3D.pycor;
            d4 = patch3D.pzcor;
        }
        return this.towardsPitch(d6, d5, d4, d, d2, d3, bl);
    }

    public double towardsPitch(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) throws AgentException {
        if (d == d4 && d2 == d5 && d3 == d6) {
            throw new AgentException("no pitch is defined from a point (" + d + "," + d2 + "," + d3 + ") to that same point");
        }
        double d7 = d4 - d;
        double d8 = d5 - d2;
        double d9 = d6 - d3;
        if (bl) {
            return ((Topology3D)((Object)this.world.topology)).towardsPitchWrap(d7, d8, d9);
        }
        return (360.0 + StrictMath.toDegrees(StrictMath.atan(d9 / StrictMath.sqrt(d7 * d7 + d8 * d8)))) % 360.0;
    }

    public double[] towardsVector(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) throws AgentException {
        if (d == d4 && d2 == d5 && d3 == d6) {
            throw new AgentException("no pitch is defined from a point (" + d + "," + d2 + "," + d3 + ") to that same point");
        }
        double d7 = d4 - d;
        double d8 = d5 - d2;
        double d9 = d6 - d3;
        if (bl) {
            d7 = Topology.wrap(d7, (double)this.world._minPxcor - 0.5, (double)this.world._maxPxcor + 0.5);
            d8 = Topology.wrap(d8, (double)this.world._minPycor - 0.5, (double)this.world._maxPycor + 0.5);
            d9 = Topology.wrap(d9, (double)this.world._minPzcor - 0.5, (double)this.world._maxPzcor + 0.5);
        }
        return new double[]{d7, d8, d9};
    }
}

