/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.Patch;
import org.nlogo.agent.PatchException;
import org.nlogo.agent.Topology;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;

strictfp class Torus
extends Topology {
    Torus(World world) {
        super(world);
    }

    double wrapX(double d) {
        return Torus.wrap(d, (double)this.world.minPxcor() - 0.5, (double)this.world.maxPxcor() + 0.5);
    }

    double wrapY(double d) {
        return Torus.wrap(d, (double)this.world.minPycor() - 0.5, (double)this.world.maxPycor() + 0.5);
    }

    double distanceWrap(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d3 > d5 ? d5 + (double)this.world.worldWidth() - d3 : d5 - (double)this.world.worldWidth() - d3;
        d = StrictMath.abs(d7) < StrictMath.abs(d) ? d7 : d;
        double d8 = d4 > d6 ? d6 + (double)this.world.worldHeight() - d4 : d6 - (double)this.world.worldHeight() - d4;
        d2 = StrictMath.abs(d8) < StrictMath.abs(d2) ? d8 : d2;
        return this.world.rootsTable.gridRoot(d * d + d2 * d2);
    }

    double towardsWrap(double d, double d2) {
        d = Torus.wrap(d, -((double)this.world.worldWidth()) / 2.0, (double)this.world.worldWidth() / 2.0);
        if ((d2 = Torus.wrap(d2, -((double)this.world.worldHeight()) / 2.0, (double)this.world.worldHeight() / 2.0)) == 0.0) {
            return d > 0.0 ? 90.0 : 270.0;
        }
        if (d == 0.0) {
            return d2 > 0.0 ? 0.0 : 180.0;
        }
        return (270.0 + StrictMath.toDegrees(Math.PI + StrictMath.atan2(-d2, d))) % 360.0;
    }

    Patch getPatchAt(double d, double d2) throws AgentException {
        return this.world.getPatchAt(d, d2);
    }

    AgentSet getNeighbors(Patch patch) {
        if (patch.pxcor == this.world.maxPxcor() && patch.pxcor == this.world.minPxcor()) {
            if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[0], this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchSouth(patch)}, this.world);
        }
        if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(patch), this.getPatchWest(patch)}, this.world);
        }
        return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchEast(patch), this.getPatchSouth(patch), this.getPatchWest(patch), this.getPatchNorthEast(patch), this.getPatchSouthEast(patch), this.getPatchSouthWest(patch), this.getPatchNorthWest(patch)}, this.world);
    }

    AgentSet getNeighbors4(Patch patch) {
        if (patch.pxcor == this.world.maxPxcor() && patch.pxcor == this.world.minPxcor()) {
            if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[0], this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchSouth(patch)}, this.world);
        }
        if (patch.pycor == this.world.maxPycor() && patch.pycor == this.world.minPycor()) {
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(patch), this.getPatchWest(patch)}, this.world);
        }
        return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchEast(patch), this.getPatchSouth(patch), this.getPatchWest(patch)}, this.world);
    }

    double shortestPathX(double d, double d2) {
        double d3 = d > d2 ? d2 + (double)this.world.worldWidth() : d2 - (double)this.world.worldWidth();
        if (StrictMath.abs(d2 - d) > StrictMath.abs(d3 - d)) {
            d2 = d3;
        }
        return d2;
    }

    double shortestPathY(double d, double d2) {
        double d3 = d > d2 ? d2 + (double)this.world.worldHeight() : d2 - (double)this.world.worldHeight();
        if (StrictMath.abs(d2 - d) > StrictMath.abs(d3 - d)) {
            d2 = d3;
        }
        return d2;
    }

    void diffuse(double d, int n) throws AgentException, PatchException {
        int n2 = this.world.worldWidth();
        int n3 = n2 * 2;
        int n4 = this.world.worldHeight();
        int n5 = n4 * 2;
        double[][] dArray = this.world.getPatchScratch();
        int n6 = 0;
        int n7 = 0;
        try {
            for (n7 = 0; n7 < n4; ++n7) {
                for (n6 = 0; n6 < n2; ++n6) {
                    dArray[n6][n7] = (Double)this.world.fastGetPatchAt((int)this.wrapX(n6), (int)this.wrapY(n7)).getPatchVariable(n);
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new PatchException(this.world.fastGetPatchAt((int)this.wrapX(n6), (int)this.wrapY(n7)));
        }
        for (n7 = n4; n7 < n5; ++n7) {
            for (n6 = n2; n6 < n3; ++n6) {
                double d2 = dArray[(n6 - 1) % n2][(n7 - 1) % n4];
                d2 += dArray[(n6 - 1) % n2][n7 % n4];
                d2 += dArray[(n6 - 1) % n2][(n7 + 1) % n4];
                d2 += dArray[n6 % n2][(n7 - 1) % n4];
                d2 += dArray[n6 % n2][(n7 + 1) % n4];
                d2 += dArray[(n6 + 1) % n2][(n7 - 1) % n4];
                d2 += dArray[(n6 + 1) % n2][n7 % n4];
                double d3 = dArray[n6 - n2][n7 - n4];
                double d4 = d3 * (1.0 - d) + (d2 += dArray[(n6 + 1) % n2][(n7 + 1) % n4]) / 8.0 * d;
                if (d4 == d3) continue;
                this.world.getPatchAt(n6 - n2, n7 - n4).setPatchVariable(n, d4);
            }
        }
    }

    void diffuse4(double d, int n) throws AgentException, PatchException {
        int n2 = this.world.worldWidth();
        int n3 = this.world.worldHeight();
        double[][] dArray = this.world.getPatchScratch();
        int n4 = 0;
        int n5 = 0;
        try {
            for (n5 = 0; n5 < n3; ++n5) {
                for (n4 = 0; n4 < n2; ++n4) {
                    dArray[n4][n5] = (Double)this.world.fastGetPatchAt((int)this.wrapX(n4), (int)this.wrapY(n5)).getPatchVariable(n);
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new PatchException(this.world.fastGetPatchAt((int)this.wrapX(n4), (int)this.wrapY(n5)));
        }
        for (n5 = 0; n5 < n3; ++n5) {
            for (n4 = 0; n4 < n2; ++n4) {
                double d2 = 0.0;
                d2 += dArray[(n4 + n2 - 1) % n2][(n5 + n3) % n3];
                d2 += dArray[(n4 + n2) % n2][(n5 + n3 + 1) % n3];
                d2 += dArray[(n4 + n2 + 1) % n2][(n5 + n3) % n3];
                double d3 = dArray[n4][n5] * (1.0 - d) + (d2 += dArray[(n4 + n2) % n2][(n5 + n3 - 1) % n3]) * d / 4.0;
                if (d3 == dArray[n4][n5]) continue;
                this.world.getPatchAt(n4, n5).setPatchVariable(n, d3);
            }
        }
    }

    Patch getPN(Patch patch) {
        return this.getPatchNorth(patch);
    }

    Patch getPE(Patch patch) {
        return this.getPatchEast(patch);
    }

    Patch getPS(Patch patch) {
        return this.getPatchSouth(patch);
    }

    Patch getPW(Patch patch) {
        return this.getPatchWest(patch);
    }

    Patch getPNE(Patch patch) {
        return this.getPatchNorthEast(patch);
    }

    Patch getPSE(Patch patch) {
        return this.getPatchSouthEast(patch);
    }

    Patch getPSW(Patch patch) {
        return this.getPatchSouthWest(patch);
    }

    Patch getPNW(Patch patch) {
        return this.getPatchNorthWest(patch);
    }
}

