/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Patch3D;
import org.nlogo.agent.PatchException;
import org.nlogo.agent.Topology3D;
import org.nlogo.agent.Torus;
import org.nlogo.agent.World3D;
import org.nlogo.api.AgentException;

public strictfp final class Torus3D
extends Torus
implements Topology3D {
    public Torus3D(World3D world3D) {
        super(world3D);
    }

    public double distanceWrap(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d4 > d7 ? d7 + (double)this.world.worldWidth() - d4 : d7 - (double)this.world.worldWidth() - d4;
        d = StrictMath.abs(d10) < StrictMath.abs(d) ? d10 : d;
        double d11 = d5 > d8 ? d8 + (double)this.world.worldHeight() - d5 : d8 - (double)this.world.worldHeight() - d5;
        d2 = StrictMath.abs(d11) < StrictMath.abs(d2) ? d11 : d2;
        double d12 = d6 > d9 ? d9 + (double)((World3D)this.world).worldDepth() - d6 : d9 - (double)((World3D)this.world).worldDepth() - d6;
        d3 = StrictMath.abs(d12) < StrictMath.abs(d3) ? d12 : d3;
        return StrictMath.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    public double towardsPitchWrap(double d, double d2, double d3) {
        d = Torus3D.wrap(d, -((double)this.world.worldWidth()) / 2.0, (double)this.world.worldWidth() / 2.0);
        d2 = Torus3D.wrap(d2, -((double)this.world.worldHeight()) / 2.0, (double)this.world.worldHeight() / 2.0);
        d3 = Torus3D.wrap(d3, -((double)((World3D)this.world).worldDepth()) / 2.0, (double)((World3D)this.world).worldDepth() / 2.0);
        return (360.0 + StrictMath.toDegrees(StrictMath.atan(d3 / StrictMath.sqrt(d * d + d2 * d2)))) % 360.0;
    }

    public void diffuse(double d, int n) throws AgentException, PatchException {
        World3D world3D = (World3D)this.world;
        int n2 = world3D.worldWidth();
        int n3 = n2 * 2;
        int n4 = world3D.worldHeight();
        int n5 = n4 * 2;
        int n6 = world3D.worldDepth();
        int n7 = n6 * 2;
        double[][][] dArray = world3D.getPatchScratch3d();
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        try {
            for (n10 = 0; n10 < n6; ++n10) {
                for (n9 = 0; n9 < n4; ++n9) {
                    for (n8 = 0; n8 < n2; ++n8) {
                        dArray[n8][n9][n10] = ((Number)world3D.fastGetPatchAt((int)this.wrapX(n8), (int)this.wrapY(n9), (int)this.wrapZ(n10)).getPatchVariable(n)).doubleValue();
                    }
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new PatchException(world3D.fastGetPatchAt((int)this.wrapX(n8), (int)this.wrapY(n9), (int)this.wrapZ(n10)));
        }
        for (n10 = n6; n10 < n7; ++n10) {
            for (n9 = n4; n9 < n5; ++n9) {
                for (n8 = n2; n8 < n3; ++n8) {
                    double d2 = dArray[(n8 - 1) % n2][(n9 - 1) % n4][n10 % n6];
                    d2 += dArray[(n8 - 1) % n2][n9 % n4][n10 % n6];
                    d2 += dArray[(n8 - 1) % n2][(n9 + 1) % n4][n10 % n6];
                    d2 += dArray[n8 % n2][(n9 - 1) % n4][n10 % n6];
                    d2 += dArray[n8 % n2][(n9 + 1) % n4][n10 % n6];
                    d2 += dArray[(n8 + 1) % n2][(n9 - 1) % n4][n10 % n6];
                    d2 += dArray[(n8 + 1) % n2][n9 % n4][n10 % n6];
                    d2 += dArray[(n8 + 1) % n2][(n9 + 1) % n4][n10 % n6];
                    d2 += dArray[(n8 - 1) % n2][(n9 - 1) % n4][(n10 - 1) % n6];
                    d2 += dArray[(n8 - 1) % n2][n9 % n4][(n10 - 1) % n6];
                    d2 += dArray[(n8 - 1) % n2][(n9 + 1) % n4][(n10 - 1) % n6];
                    d2 += dArray[n8 % n2][(n9 - 1) % n4][(n10 - 1) % n6];
                    d2 += dArray[n8 % n2][(n9 + 1) % n4][(n10 - 1) % n6];
                    d2 += dArray[(n8 + 1) % n2][(n9 - 1) % n4][(n10 - 1) % n6];
                    d2 += dArray[(n8 + 1) % n2][n9 % n4][(n10 - 1) % n6];
                    d2 += dArray[(n8 + 1) % n2][(n9 + 1) % n4][(n10 - 1) % n6];
                    d2 += dArray[n8 % n2][n9 % n4][(n10 - 1) % n6];
                    d2 += dArray[(n8 - 1) % n2][(n9 - 1) % n4][(n10 + 1) % n6];
                    d2 += dArray[(n8 - 1) % n2][n9 % n4][(n10 + 1) % n6];
                    d2 += dArray[(n8 - 1) % n2][(n9 + 1) % n4][(n10 + 1) % n6];
                    d2 += dArray[n8 % n2][(n9 - 1) % n4][(n10 + 1) % n6];
                    d2 += dArray[n8 % n2][(n9 + 1) % n4][(n10 + 1) % n6];
                    d2 += dArray[(n8 + 1) % n2][(n9 - 1) % n4][(n10 + 1) % n6];
                    d2 += dArray[(n8 + 1) % n2][n9 % n4][(n10 + 1) % n6];
                    d2 += dArray[(n8 + 1) % n2][(n9 + 1) % n4][(n10 + 1) % n6];
                    double d3 = dArray[n8 - n2][n9 - n4][n10 - n6];
                    double d4 = d3 * (1.0 - d) + (d2 += dArray[n8 % n2][n9 % n4][(n10 + 1) % n6]) / 26.0 * d;
                    if (d4 == d3) continue;
                    world3D.getPatchAt(n8 - n2, n9 - n4, n10 - n6).setPatchVariable(n, d4);
                }
            }
        }
    }

    public AgentSet getNeighbors3d(Patch3D patch3D) {
        return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch3D), this.getPatchEast(patch3D), this.getPatchSouth(patch3D), this.getPatchWest(patch3D), this.getPatchNorthEast(patch3D), this.getPatchSouthEast(patch3D), this.getPatchSouthWest(patch3D), this.getPatchNorthWest(patch3D), this.getPatchUp(patch3D), this.getPatchDown(patch3D), this.getPNU(patch3D), this.getPEU(patch3D), this.getPSU(patch3D), this.getPWU(patch3D), this.getPNEU(patch3D), this.getPSEU(patch3D), this.getPSWU(patch3D), this.getPNWU(patch3D), this.getPND(patch3D), this.getPED(patch3D), this.getPSD(patch3D), this.getPWD(patch3D), this.getPNED(patch3D), this.getPSED(patch3D), this.getPSWD(patch3D), this.getPNWD(patch3D)}, this.world);
    }

    public Patch getPNU(Patch3D patch3D) {
        return this.getPatchNorth(this.getPatchUp(patch3D));
    }

    public Patch getPEU(Patch3D patch3D) {
        return this.getPatchEast(this.getPatchUp(patch3D));
    }

    public Patch getPSU(Patch3D patch3D) {
        return this.getPatchSouth(this.getPatchUp(patch3D));
    }

    public Patch getPWU(Patch3D patch3D) {
        return this.getPatchWest(this.getPatchUp(patch3D));
    }

    public Patch getPNEU(Patch3D patch3D) {
        return this.getPatchNorthEast(this.getPatchUp(patch3D));
    }

    public Patch getPSEU(Patch3D patch3D) {
        return this.getPatchSouthEast(this.getPatchUp(patch3D));
    }

    public Patch getPSWU(Patch3D patch3D) {
        return this.getPatchSouthWest(this.getPatchUp(patch3D));
    }

    public Patch getPNWU(Patch3D patch3D) {
        return this.getPatchNorthWest(this.getPatchUp(patch3D));
    }

    public Patch getPND(Patch3D patch3D) {
        return this.getPatchNorth(this.getPatchDown(patch3D));
    }

    public Patch getPED(Patch3D patch3D) {
        return this.getPatchEast(this.getPatchDown(patch3D));
    }

    public Patch getPSD(Patch3D patch3D) {
        return this.getPatchSouth(this.getPatchDown(patch3D));
    }

    public Patch getPWD(Patch3D patch3D) {
        return this.getPatchWest(this.getPatchDown(patch3D));
    }

    public Patch getPNED(Patch3D patch3D) {
        return this.getPatchNorthEast(this.getPatchDown(patch3D));
    }

    public Patch getPSED(Patch3D patch3D) {
        return this.getPatchSouthEast(this.getPatchDown(patch3D));
    }

    public Patch getPSWD(Patch3D patch3D) {
        return this.getPatchSouthWest(this.getPatchDown(patch3D));
    }

    public Patch getPNWD(Patch3D patch3D) {
        return this.getPatchNorthWest(this.getPatchDown(patch3D));
    }

    public double wrapZ(double d) {
        World3D world3D = (World3D)this.world;
        return Torus3D.wrap(d, (double)world3D.minPzcor() - 0.5, (double)world3D.maxPzcor() + 0.5);
    }

    Patch getPatchUp(Patch3D patch3D) {
        World3D world3D = (World3D)this.world;
        if (patch3D.pzcor == world3D.maxPzcor()) {
            return world3D.fastGetPatchAt(patch3D.pxcor, patch3D.pycor, world3D.minPzcor());
        }
        return world3D.fastGetPatchAt(patch3D.pxcor, patch3D.pycor, patch3D.pzcor + 1);
    }

    Patch getPatchDown(Patch3D patch3D) {
        World3D world3D = (World3D)this.world;
        if (patch3D.pzcor == world3D.minPzcor()) {
            return world3D.fastGetPatchAt(patch3D.pxcor, patch3D.pycor, world3D.maxPzcor());
        }
        return world3D.fastGetPatchAt(patch3D.pxcor, patch3D.pycor, patch3D.pzcor - 1);
    }

    public double shortestPathZ(double d, double d2) {
        double d3 = ((World3D)this.world).worldDepth();
        double d4 = d > d2 ? d2 + d3 : d2 - d3;
        if (StrictMath.abs(d2 - d) > StrictMath.abs(d4 - d)) {
            d2 = d4;
        }
        return d2;
    }
}

