/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.Map;
import java.util.TreeMap;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.LogoList;
import org.nlogo.util.MersenneTwisterFast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class TreeAgentSet
extends AgentSet {
    final Map<Object, Agent> agents = new TreeMap<Object, Agent>();
    private long nextIndex = 0L;

    @Override
    public int count() {
        return this.agents.size();
    }

    @Override
    public boolean isEmpty() {
        return this.agents.isEmpty();
    }

    @Override
    boolean equalAgentSetsHelper(org.nlogo.api.AgentSet agentSet) {
        for (org.nlogo.api.Agent agent : agentSet.agents()) {
            if (this.contains((Agent)agent)) continue;
            return false;
        }
        return true;
    }

    public TreeAgentSet(Class<? extends Agent> clazz, String string, World world) {
        super(clazz, world, string, true);
    }

    @Override
    public Agent agent(long l) {
        Double d = l;
        if (this.type == Turtle.class || this.type == Link.class) {
            Agent agent = this.agents.get(d);
            if (agent == null) {
                return null;
            }
            if (agent.id == -1L) {
                this.agents.remove(d);
                return null;
            }
            return agent;
        }
        return this.agents.get(d);
    }

    @Override
    Agent getAgent(Object object) {
        return this.agents.get(object);
    }

    @Override
    public void add(Agent agent) {
        if (agent.getAgentClass() != this.type) {
            throw new IllegalStateException();
        }
        this.agents.put(agent.agentKey(), agent);
        this.nextIndex = StrictMath.max(this.nextIndex, agent.id + 1L);
    }

    @Override
    public void remove(Object object) {
        this.agents.remove(object);
    }

    @Override
    void clear() {
        this.agents.clear();
    }

    @Override
    public boolean contains(Agent agent) {
        return this.agents.containsValue(agent);
    }

    @Override
    public Agent randomOne(int n, int n2) {
        AgentSet.Iterator iterator2 = this.iterator();
        for (int i = 0; i < n2; ++i) {
            iterator2.next();
        }
        return iterator2.next();
    }

    @Override
    Agent[] randomTwo(int n, int n2, int n3) {
        Agent[] agentArray = new Agent[2];
        if (n3 >= n2) {
            ++n3;
        } else {
            int n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        if ((long)n == this.nextIndex) {
            agentArray[0] = this.agents.get(n2);
            agentArray[1] = this.agents.get(n3);
        } else {
            AgentSet.Iterator iterator2 = this.iterator();
            int n5 = 0;
            while (n5++ < n2) {
                iterator2.next();
            }
            agentArray[0] = iterator2.next();
            while (n5++ < n3) {
                iterator2.next();
            }
            agentArray[1] = iterator2.next();
        }
        return agentArray;
    }

    @Override
    Agent[] randomSubsetGeneral(int n, int n2, MersenneTwisterFast mersenneTwisterFast) {
        Agent[] agentArray = new Agent[n];
        AgentSet.Iterator iterator2 = this.iterator();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            Agent agent = iterator2.next();
            if (mersenneTwisterFast.nextInt(n2 - n3) < n - n4) {
                agentArray[n4] = agent;
                ++n4;
            }
            ++n3;
        }
        return agentArray;
    }

    @Override
    public LogoList toLogoList() {
        return LogoList.fromJava(this.agents.values());
    }

    @Override
    public Agent[] toArray() {
        return this.agents.values().toArray(new Agent[this.agents.size()]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TreeAgentSet");
        stringBuilder = stringBuilder.append("\n...... type: ");
        stringBuilder = stringBuilder.append(this.type == null ? "null" : this.type.toString());
        stringBuilder = stringBuilder.append("\n...... count(): " + this.count());
        stringBuilder = stringBuilder.append("\n...... agents: ");
        AgentSet.Iterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            stringBuilder = stringBuilder.append("\n" + iterator2.next().toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public AgentSet.Iterator iterator() {
        return new Iterator();
    }

    @Override
    public AgentSet.Iterator shufflerator(MersenneTwisterFast mersenneTwisterFast) {
        return new Shufflerator(mersenneTwisterFast);
    }

    private strictfp class Shufflerator
    extends Iterator {
        private int i;
        private final Agent[] copy;
        private Agent next;
        private final MersenneTwisterFast random;

        Shufflerator(MersenneTwisterFast mersenneTwisterFast) {
            this.i = 0;
            this.copy = TreeAgentSet.this.agents.values().toArray(new Agent[TreeAgentSet.this.agents.size()]);
            this.random = mersenneTwisterFast;
            this.fetch();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Agent next() {
            Agent agent = this.next;
            this.fetch();
            return agent;
        }

        private void fetch() {
            if (this.i >= this.copy.length) {
                this.next = null;
            } else {
                if (this.i < this.copy.length - 1) {
                    int n = this.i + this.random.nextInt(this.copy.length - this.i);
                    this.next = this.copy[n];
                    this.copy[n] = this.copy[this.i];
                } else {
                    this.next = this.copy[this.i];
                }
                ++this.i;
            }
        }
    }

    public strictfp class Iterator
    implements AgentSet.Iterator {
        java.util.Iterator<Agent> iter;

        public Iterator() {
            this.iter = TreeAgentSet.this.agents.values().iterator();
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Agent next() {
            return this.iter.next();
        }
    }
}

