/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.Agent3D;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Patch3D;
import org.nlogo.agent.Protractor3D;
import org.nlogo.agent.TieManager3D;
import org.nlogo.agent.Topology;
import org.nlogo.agent.Topology3D;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.agent.World3D;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentVariables;
import org.nlogo.api.Color;
import org.nlogo.api.Constants;
import org.nlogo.api.Dump;
import org.nlogo.api.I18N;
import org.nlogo.api.LogoList;
import org.nlogo.api.Vect;

public strictfp final class Turtle3D
extends Turtle
implements Agent3D,
org.nlogo.api.Turtle3D {
    static final int VAR_BREED3D = 11;
    double zcor;

    void initvars(Number number, Number number2, AgentSet agentSet) {
        this.LAST_PREDEFINED_VAR = 15;
        this.NUMBER_PREDEFINED_VARS = this.LAST_PREDEFINED_VAR + 1;
        this.variables[1] = Color.BoxedBlack();
        this.heading = 0.0;
        this.variables[2] = World.ZERO;
        this.xcor = number.doubleValue();
        if (number instanceof Double) {
            this.variables[5] = number;
        }
        this.ycor = number2.doubleValue();
        if (number2 instanceof Double) {
            this.variables[6] = number2;
        }
        this.variables[8] = this.world.turtleBreedShapes.breedShape(agentSet);
        this.variables[9] = "";
        this.variables[10] = Color.BoxedWhite();
        this.variables[11] = agentSet;
        this.variables[12] = Boolean.FALSE;
        this.variables[13] = World.ONE;
        this.variables[14] = World.ONE;
        this.variables[15] = "up";
    }

    public Turtle3D(World3D world3D, AgentSet agentSet, Number number, Number number2, Number number3) {
        this(world3D, agentSet, number, number2, number3, true);
    }

    private Turtle3D(World3D world3D, AgentSet agentSet, Number number, Number number2, Number number3, boolean bl) {
        super(world3D);
        this.variables = new Object[world3D.getVariablesArraySize(this, (org.nlogo.api.AgentSet)agentSet)];
        if (bl) {
            this.id(world3D.newTurtleId());
            world3D.turtles().add(this);
        }
        this.initvars(number, number2, agentSet);
        for (int i = this.LAST_PREDEFINED_VAR + 1; i < this.variables.length; ++i) {
            this.variables[i] = World.ZERO;
        }
        if (agentSet != world3D.turtles()) {
            agentSet.add(this);
        }
        this.variables[3] = World.ZERO;
        this.variables[4] = World.ZERO;
        this.zcor = number3.doubleValue();
        if (number3 instanceof Double) {
            this.variables[7] = number3;
        }
        this.getPatchHere().addTurtle(this);
    }

    Turtle3D(World world) {
        super(world);
    }

    Turtle3D(World world, long l) {
        this((World3D)world, world.turtles(), World.ZERO, World.ZERO, World.ZERO, false);
        this.id(l);
        world.turtles().add(this);
    }

    public Turtle hatch() {
        Turtle3D turtle3D = new Turtle3D(this.world);
        turtle3D.heading = this.heading;
        turtle3D.xcor = this.xcor;
        turtle3D.ycor = this.ycor;
        turtle3D.zcor = this.zcor;
        turtle3D.variables = (Object[])this.variables.clone();
        turtle3D.id(this.world.newTurtleId());
        this.world.turtles().add(turtle3D);
        if (this.getBreed() != this.world.turtles()) {
            this.getBreed().add(turtle3D);
        }
        turtle3D.getPatchHere().addTurtle(turtle3D);
        return turtle3D;
    }

    public Patch getPatchAtOffsets(double d, double d2) throws AgentException {
        Patch3D patch3D = ((World3D)this.world).getPatchAt(this.xcor + d, this.ycor + d2, this.zcor);
        if (patch3D == null) {
            throw new AgentException("Cannot get patch beyond limits of current world.");
        }
        return patch3D;
    }

    public Patch3D getPatchAtOffsets(double d, double d2, double d3) throws AgentException {
        Patch3D patch3D = ((World3D)this.world).getPatchAt(this.xcor + d, this.ycor + d2, this.zcor + d3);
        if (patch3D == null) {
            throw new AgentException("Cannot get patch beyond limits of current world.");
        }
        return patch3D;
    }

    public void jump(double d) {
        double d2 = StrictMath.toRadians(this.pitch());
        double d3 = StrictMath.sin(d2);
        double d4 = d * StrictMath.cos(d2);
        if (StrictMath.abs(d3) < Constants.Infinitesimal()) {
            d3 = 0.0;
        }
        if (StrictMath.abs(d4) < Constants.Infinitesimal()) {
            d4 = 0.0;
        }
        double d5 = StrictMath.toRadians(this.heading());
        double d6 = StrictMath.cos(d5);
        double d7 = StrictMath.sin(d5);
        if (StrictMath.abs(d6) < Constants.Infinitesimal()) {
            d6 = 0.0;
        }
        if (StrictMath.abs(d7) < Constants.Infinitesimal()) {
            d7 = 0.0;
        }
        this.xyandzcor(this.xcor + d4 * d7, this.ycor + d4 * d6, this.zcor + d * d3);
    }

    public Patch getPatchHere() {
        if (this.currentPatch == null) {
            this.currentPatch = ((World3D)this.world).getPatchAtWrap(this.xcor, this.ycor, this.zcor);
        }
        return this.currentPatch;
    }

    public Object getTurtleVariable(int n) {
        switch (n) {
            case 0: {
                if (this.variables[0] != null) break;
                this.variables[0] = (double)this.id;
                break;
            }
            case 2: {
                if (this.variables[2] != null) break;
                this.variables[2] = this.heading;
                break;
            }
            case 5: {
                if (this.variables[5] != null) break;
                this.variables[5] = this.xcor;
                break;
            }
            case 6: {
                if (this.variables[6] != null) break;
                this.variables[6] = this.ycor;
                break;
            }
            case 7: {
                if (this.variables[7] != null) break;
                this.variables[7] = this.zcor;
                break;
            }
        }
        return this.variables[n];
    }

    public double getTurtleVariableDouble(int n) {
        switch (n) {
            case 2: {
                return this.heading;
            }
            case 3: {
                return this.pitch();
            }
            case 4: {
                return this.roll();
            }
            case 5: {
                return this.xcor;
            }
            case 6: {
                return this.ycor;
            }
            case 7: {
                return this.zcor;
            }
            case 13: {
                return this.size();
            }
            case 14: {
                return this.penSize();
            }
        }
        throw new IllegalArgumentException(n + " is not a double variable");
    }

    public void setTurtleVariable(int n, Object object) throws AgentException {
        if (n > this.LAST_PREDEFINED_VAR) {
            this.variables[n] = object;
        } else {
            switch (n) {
                case 1: {
                    if (object instanceof Double) {
                        this.colorDouble((Double)object);
                        break;
                    }
                    if (object instanceof LogoList) {
                        this.color((LogoList)object, 1);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[n], Double.class, object);
                    break;
                }
                case 2: {
                    if (object instanceof Double) {
                        this.heading((Double)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[n], Double.class, object);
                    break;
                }
                case 5: {
                    if (object instanceof Double) {
                        this.xcor((Double)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[n], Double.class, object);
                    break;
                }
                case 6: {
                    if (object instanceof Double) {
                        this.ycor((Double)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[n], Double.class, object);
                    break;
                }
                case 8: {
                    if (object instanceof String) {
                        String string = this.world.checkTurtleShapeName((String)object);
                        if (string == null) {
                            throw new AgentException("\"" + (String)object + "\" is not a currently defined shape");
                        }
                        this.shape(string);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[n], String.class, object);
                    break;
                }
                case 9: {
                    this.label(object);
                    break;
                }
                case 10: {
                    if (object instanceof Number) {
                        this.labelColor(((Number)object).doubleValue());
                        break;
                    }
                    if (object instanceof LogoList) {
                        this.labelColor((LogoList)object, 10);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[n], Double.class, object);
                    break;
                }
                case 11: {
                    if (object instanceof AgentSet) {
                        AgentSet agentSet = (AgentSet)object;
                        if (agentSet != this.world.turtles() && !this.world.isBreed(agentSet)) {
                            throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Turtle.cantSetBreedToNonBreedAgentSet"));
                        }
                        this.setBreed(agentSet);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[n], AgentSet.class, object);
                    break;
                }
                case 12: {
                    if (object instanceof Boolean) {
                        this.hidden((Boolean)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[n], Boolean.class, object);
                    break;
                }
                case 13: {
                    if (object instanceof Number) {
                        this.size(((Number)object).doubleValue());
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[n], Double.class, object);
                    break;
                }
                case 15: {
                    if (object instanceof String) {
                        this.penMode((String)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[n], String.class, object);
                    break;
                }
                case 14: {
                    if (object instanceof Number) {
                        this.penSize(((Number)object).doubleValue());
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[n], Double.class, object);
                    break;
                }
                case 0: {
                    throw new AgentException("you can't change a turtle's ID number");
                }
                case 3: {
                    if (object instanceof Number) {
                        this.pitch(((Number)object).doubleValue());
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[n], Double.class, object);
                    break;
                }
                case 4: {
                    if (object instanceof Number) {
                        this.roll(((Number)object).doubleValue());
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[n], Double.class, object);
                    break;
                }
                case 7: {
                    if (object instanceof Double) {
                        this.zcor((Double)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(true)[n], Double.class, object);
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    public double pitch() {
        return (Double)this.variables[3];
    }

    public void pitch(double d) {
        double d2 = this.pitch();
        if (d < 0.0 || d >= 360.0) {
            d = (d % 360.0 + 360.0) % 360.0;
        }
        this.variables[3] = d;
        if (this == this.world.observer().targetAgent()) {
            this.world.observer().updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.turtleOrientationChanged(this.heading, d, this.roll(), this.heading, d2, this.roll());
        }
    }

    public double roll() {
        return (Double)this.variables[4];
    }

    public void roll(double d) {
        double d2 = this.roll();
        if (d < 0.0 || d >= 360.0) {
            d = (d % 360.0 + 360.0) % 360.0;
        }
        this.variables[4] = d;
        if (this == this.world.observer().targetAgent()) {
            this.world.observer().updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.turtleOrientationChanged(this.heading(), this.pitch(), d, this.heading(), this.pitch(), d2);
        }
    }

    public void headingPitchAndRoll(double d, double d2, double d3) {
        double d4 = this.heading();
        double d5 = this.pitch();
        double d6 = this.roll();
        if (d3 < 0.0 || d3 >= 360.0) {
            d3 = (d3 % 360.0 + 360.0) % 360.0;
        }
        if (d2 < 0.0 || d2 >= 360.0) {
            d2 = (d2 % 360.0 + 360.0) % 360.0;
        }
        if (d < 0.0 || d >= 360.0) {
            d = (d % 360.0 + 360.0) % 360.0;
        }
        this.variables[3] = d2;
        this.variables[4] = d3;
        this.heading = d;
        this.variables[2] = null;
        if (this == this.world.observer().targetAgent()) {
            this.world.observer().updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.turtleOrientationChanged(d, d2, d3, d4, d5, d6);
        }
    }

    void drawLine(double d, double d2, double d3, double d4) {
        if (this.penMode().equals("down") && (d != d3 || d2 != d4)) {
            ((World3D)this.world).drawLine(d, d2, this.zcor, d3, d4, this.zcor, this.color(), this.penSize());
        }
    }

    void drawLine(double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.penMode().equals("down") && (d != d4 || d2 != d5 || d3 != d6)) {
            ((World3D)this.world).drawLine(d, d2, d3, d4, d5, d6, this.color(), this.penSize());
        }
    }

    public double shortestPathZ(double d) {
        if (!this.penMode().equals("down")) {
            return d;
        }
        World3D world3D = (World3D)this.world;
        d = ((Topology3D)((Object)this.world.getTopology())).wrapZ(d);
        double d2 = d > this.zcor ? d - (double)world3D.worldDepth() : d + (double)world3D.worldDepth();
        if (StrictMath.abs(d - this.zcor) > StrictMath.abs(d2 - this.zcor)) {
            d = d2;
        }
        return d;
    }

    public void moveTo(Agent agent) throws AgentException {
        double d;
        double d2;
        double d3;
        if (agent instanceof Turtle) {
            Turtle3D turtle3D = (Turtle3D)agent;
            d3 = turtle3D.xcor();
            d2 = turtle3D.ycor();
            d = turtle3D.zcor();
        } else {
            Patch3D patch3D = (Patch3D)agent;
            d3 = patch3D.pxcor;
            d2 = patch3D.pycor;
            d = patch3D.pzcor;
        }
        this.xyandzcor(this.shortestPathX(d3), this.shortestPathY(d2), this.shortestPathZ(d));
    }

    public void moveToPatchCenter() {
        Patch3D patch3D = (Patch3D)this.getPatchHere();
        double d = patch3D.pxcor;
        double d2 = patch3D.pycor;
        double d3 = patch3D.pzcor;
        double d4 = this.xcor;
        double d5 = this.ycor;
        double d6 = this.zcor;
        this.drawLine(d4, d5, d6, d, d2, d3);
        if (d != d4 || d2 != d5 || d3 != d6) {
            this.xcor = d;
            this.ycor = d2;
            this.zcor = d3;
            this.variables[5] = patch3D.variables[0];
            this.variables[6] = patch3D.variables[1];
            this.variables[7] = patch3D.variables[2];
            Observer observer = this.world.observer();
            if (this == observer.targetAgent()) {
                observer.updatePosition();
            }
            if (this.world.tieManager.tieCount > 0) {
                ((TieManager3D)this.world.tieManager).turtleMoved(this, d, d2, d3, d4, d5, d6);
            }
        }
    }

    public void xcor(Double d) throws AgentException {
        Observer observer;
        Patch patch = this.getPatchHere();
        double d2 = d;
        double d3 = this.world.getTopology().wrapX(d2);
        double d4 = this.xcor;
        this.drawLine(this.xcor, this.ycor, this.shortestPathX(d2), this.ycor);
        this.xcor = d3;
        this.variables[5] = d2 == d3 ? d : null;
        this.currentPatch = null;
        Patch patch2 = this.getPatchHere();
        if (patch != patch2) {
            patch.removeTurtle(this);
            patch2.addTurtle(this);
        }
        if (this == (observer = this.world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.turtleMoved(d2, this.ycor, this.zcor, d4, this.ycor, this.zcor);
        }
    }

    public double zcor() {
        return this.zcor;
    }

    public void zcor(Double d) {
        Patch patch = this.getPatchHere();
        double d2 = this.zcor;
        double d3 = d;
        World3D world3D = (World3D)this.world;
        double d4 = Topology.wrap(d, (double)world3D.minPzcor() - 0.5, (double)world3D.maxPzcor() + 0.5);
        this.drawLine(this.xcor, this.ycor, this.zcor, this.xcor, this.ycor, this.shortestPathZ(d3));
        this.zcor = d4;
        this.variables[7] = d3 == d4 ? d : null;
        this.currentPatch = null;
        Patch patch2 = this.getPatchHere();
        if (patch != patch2) {
            patch.removeTurtle(this);
            patch2.addTurtle(this);
        }
        if (this.world.tieManager.tieCount > 0) {
            this.turtleMoved(this.xcor, this.ycor, d3, this.xcor, this.ycor, d2);
        }
    }

    public void ycor(Double d) throws AgentException {
        Observer observer;
        Patch patch = this.getPatchHere();
        double d2 = this.ycor;
        double d3 = d;
        double d4 = this.world.getTopology().wrapY(d3);
        this.drawLine(this.xcor, this.ycor, this.xcor, this.shortestPathY(d3));
        this.ycor = d4;
        this.variables[6] = d3 == d4 ? d : null;
        this.currentPatch = null;
        Patch patch2 = this.getPatchHere();
        if (patch != patch2) {
            patch.removeTurtle(this);
            patch2.addTurtle(this);
        }
        if (this == (observer = this.world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.turtleMoved(this.xcor, d3, this.zcor, this.xcor, d2, this.zcor);
        }
    }

    public void xandycor(double d, double d2) throws AgentException {
        Observer observer;
        Patch patch = this.getPatchHere();
        double d3 = this.xcor;
        double d4 = this.ycor;
        double d5 = this.world.getTopology().wrapX(d);
        double d6 = this.world.getTopology().wrapY(d2);
        this.drawLine(this.xcor, this.ycor, d, d2);
        this.xcor = d5;
        this.ycor = d6;
        this.variables[5] = null;
        this.variables[6] = null;
        this.currentPatch = null;
        Patch patch2 = this.getPatchHere();
        if (patch != patch2) {
            patch.removeTurtle(this);
            patch2.addTurtle(this);
        }
        if (this == (observer = this.world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.turtleMoved(d, d2, this.zcor, d3, d4, this.zcor);
        }
    }

    public void xandycor(Double d, Double d2) throws AgentException {
        Observer observer;
        Patch patch = this.getPatchHere();
        double d3 = this.xcor;
        double d4 = this.ycor;
        double d5 = d;
        double d6 = d2;
        double d7 = this.world.getTopology().wrapX(d5);
        double d8 = this.world.getTopology().wrapY(d6);
        this.drawLine(this.xcor, this.ycor, d5, d6);
        this.xcor = d7;
        this.ycor = d8;
        this.variables[5] = d5 == d7 ? d : null;
        this.variables[6] = d6 == d8 ? d2 : null;
        this.currentPatch = null;
        Patch patch2 = this.getPatchHere();
        if (patch != patch2) {
            patch.removeTurtle(this);
            patch2.addTurtle(this);
        }
        if (this == (observer = this.world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.turtleMoved(d5, d6, this.zcor, d3, d4, this.zcor);
        }
    }

    public void xyandzcor(double d, double d2, double d3) {
        Observer observer;
        Patch patch = this.getPatchHere();
        double d4 = this.xcor;
        double d5 = this.ycor;
        double d6 = this.zcor;
        World3D world3D = (World3D)this.world;
        double d7 = Topology.wrap(d, (double)world3D.minPxcor() - 0.5, (double)world3D.maxPxcor() + 0.5);
        double d8 = Topology.wrap(d2, (double)world3D.minPycor() - 0.5, (double)world3D.maxPycor() + 0.5);
        double d9 = Topology.wrap(d3, (double)world3D.minPzcor() - 0.5, (double)world3D.maxPzcor() + 0.5);
        this.drawLine(this.xcor, this.ycor, this.zcor, d, d2, d3);
        this.xcor = d7;
        this.ycor = d8;
        this.zcor = d9;
        this.variables[5] = null;
        this.variables[6] = null;
        this.variables[7] = null;
        this.currentPatch = null;
        Patch patch2 = this.getPatchHere();
        if (patch != patch2) {
            patch.removeTurtle(this);
            patch2.addTurtle(this);
        }
        if (this == (observer = this.world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.turtleMoved(d, d2, d3, d4, d5, d6);
        }
    }

    public void xyandzcor(Double d, Double d2, Double d3) {
        Observer observer;
        Patch patch = this.getPatchHere();
        double d4 = this.xcor;
        double d5 = this.ycor;
        double d6 = this.zcor;
        double d7 = d;
        double d8 = d2;
        double d9 = d3;
        World3D world3D = (World3D)this.world;
        double d10 = Topology.wrap(d7, (double)world3D.minPxcor() - 0.5, (double)world3D.maxPxcor() + 0.5);
        double d11 = Topology.wrap(d8, (double)world3D.minPycor() - 0.5, (double)world3D.maxPycor() + 0.5);
        double d12 = Topology.wrap(d9, (double)world3D.minPzcor() - 0.5, (double)world3D.maxPzcor() + 0.5);
        this.drawLine(this.xcor, this.ycor, this.zcor, d7, d8, d9);
        this.xcor = d10;
        this.ycor = d11;
        this.zcor = d12;
        this.variables[5] = d7 == d10 ? d : null;
        this.variables[6] = d8 == d11 ? d2 : null;
        this.variables[7] = d9 == d12 ? d3 : null;
        this.currentPatch = null;
        Patch patch2 = this.getPatchHere();
        if (patch != patch2) {
            patch.removeTurtle(this);
            patch2.addTurtle(this);
        }
        if (this == (observer = this.world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.turtleMoved(d7, d8, d9, d4, d5, d6);
        }
    }

    public void home() {
        this.xyandzcor(World.ZERO, World.ZERO, World.ZERO);
    }

    public void face(Agent agent, boolean bl) {
        double d;
        double d2;
        try {
            d2 = this.world.protractor().towards(this, agent, bl);
        }
        catch (AgentException agentException) {
            d2 = this.heading();
        }
        try {
            d = this.world.protractor().towardsPitch(this, agent, bl);
        }
        catch (AgentException agentException) {
            d = this.pitch();
        }
        this.headingPitchAndRoll(d2, d, this.roll());
    }

    public double dx() {
        return StrictMath.cos(StrictMath.toRadians(this.pitch())) * StrictMath.sin(StrictMath.toRadians(this.heading()));
    }

    public double dy() {
        return StrictMath.cos(StrictMath.toRadians(this.pitch())) * StrictMath.cos(StrictMath.toRadians(this.heading()));
    }

    public double dz() {
        return StrictMath.sin(StrictMath.toRadians(this.pitch()));
    }

    public String shape() {
        return (String)this.variables[8];
    }

    public void shape(String string) {
        this.variables[8] = string;
    }

    public Object label() {
        return this.variables[9];
    }

    public String labelString() {
        return Dump.logoObject(this.variables[9]);
    }

    public void label(Object object) {
        this.variables[9] = object;
    }

    public Object labelColor() {
        return this.variables[10];
    }

    public void labelColor(double d) {
        this.variables[10] = Color.modulateDouble(d);
    }

    public AgentSet getBreed() {
        return (AgentSet)this.variables[11];
    }

    public void setBreed(AgentSet agentSet) {
        AgentSet agentSet2 = null;
        if (this.variables[11] instanceof AgentSet) {
            agentSet2 = (AgentSet)this.variables[11];
            if (agentSet == agentSet2) {
                return;
            }
            if (agentSet2 != this.world.turtles()) {
                ((AgentSet)this.variables[11]).remove(this.agentKey());
            }
        }
        if (agentSet != this.world.turtles()) {
            agentSet.add(this);
        }
        this.variables[11] = agentSet;
        this.shape(this.world.turtleBreedShapes.breedShape(agentSet));
        this.realloc(false, agentSet2);
    }

    public Patch getPatchAtHeadingAndDistance(double d, double d2) throws AgentException {
        double[] dArray = this.right(d);
        return ((Protractor3D)this.world.protractor()).getPatchAtHeadingPitchAndDistance(this.xcor, this.ycor, this.zcor, dArray[0], dArray[1], d2);
    }

    public void turnRight(double d) {
        double[] dArray = this.right(d);
        this.headingPitchAndRoll(dArray[0], dArray[1], dArray[2]);
    }

    public double[] right(double d) {
        d = -d;
        Vect[] vectArray = Vect.toVectors(this.heading, this.pitch(), this.roll());
        double d2 = StrictMath.sin(StrictMath.toRadians(d));
        double d3 = StrictMath.cos(StrictMath.toRadians(d));
        if (StrictMath.abs(d2) < Constants.Infinitesimal()) {
            d2 = 0.0;
        }
        if (StrictMath.abs(d3) < Constants.Infinitesimal()) {
            d3 = 0.0;
        }
        Vect vect = new Vect(-d2, d3, 0.0);
        Vect vect2 = new Vect(d3, d2, 0.0);
        Vect vect3 = vectArray[1].cross(vectArray[0]);
        Vect vect4 = Vect.axisTransformation(vect, vectArray[1], vectArray[0], vect3);
        Vect vect5 = Vect.axisTransformation(vect2, vectArray[1], vectArray[0], vect3);
        return Vect.toAngles(vect4, vect5);
    }

    public boolean hidden() {
        return (Boolean)this.variables[12];
    }

    public void hidden(boolean bl) {
        this.variables[12] = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public double size() {
        return (Double)this.variables[13];
    }

    public void size(double d) {
        this.variables[13] = d;
    }

    public double penSize() {
        return (Double)this.variables[14];
    }

    public void penSize(double d) {
        this.variables[14] = d;
    }

    public String penMode() {
        return (String)this.variables[15];
    }

    public void penMode(String string) {
        this.variables[15] = string;
    }

    private void turtleMoved(double d, double d2, double d3, double d4, double d5, double d6) {
        ((TieManager3D)this.world.tieManager).turtleMoved(this, d, d2, d3, d4, d5, d6);
    }

    private void turtleOrientationChanged(double d, double d2, double d3, double d4, double d5, double d6) {
        ((TieManager3D)this.world.tieManager).turtleOrientationChanged(this, d, d2, d3, d4, d5, d6);
    }
}

