/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.Drawing3D;
import org.nlogo.agent.Exporter3D;
import org.nlogo.agent.Importer;
import org.nlogo.agent.Importer3D;
import org.nlogo.agent.InRadiusOrCone3D;
import org.nlogo.agent.Link;
import org.nlogo.agent.LinkManager3D;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Observer3D;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Patch3D;
import org.nlogo.agent.Protractor3D;
import org.nlogo.agent.RootsTable;
import org.nlogo.agent.TieManager3D;
import org.nlogo.agent.Topology;
import org.nlogo.agent.Topology3D;
import org.nlogo.agent.Torus3D;
import org.nlogo.agent.TreeAgentSet;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.Turtle3D;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.Color;
import org.nlogo.api.ImporterUser;
import org.nlogo.api.Program;
import org.nlogo.api.WorldDimensions;
import org.nlogo.api.WorldDimensions3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class World3D
extends World
implements org.nlogo.api.World3D {
    Drawing3D drawing;
    int _worldDepth;
    int _maxPzcor;
    int _minPzcor;
    Double _minPzcorBoxed;
    Double _maxPzcorBoxed;
    Double _worldDepthBoxed;
    private double[][][] patchScratch3d;

    @Override
    public org.nlogo.api.Protractor3D protractor3D() {
        return (org.nlogo.api.Protractor3D)((Object)this._protractor);
    }

    public World3D() {
        this.linkManager = new LinkManager3D(this);
        this.tieManager = new TieManager3D(this, this.linkManager);
        this.drawing = new Drawing3D(this);
        this.inRadiusOrCone = new InRadiusOrCone3D(this);
        this._protractor = new Protractor3D(this);
    }

    @Override
    Observer createObserver() {
        return new Observer3D(this);
    }

    @Override
    public void changeTopology(boolean bl, boolean bl2) {
        this.topology = new Torus3D(this);
    }

    public boolean wrappingAllowedInZ() {
        return true;
    }

    @Override
    public double wrappedObserverZ(double d) {
        d = ((Topology3D)((Object)this.topology)).wrapZ(d - this.followOffsetZ());
        return d;
    }

    @Override
    public double followOffsetZ() {
        return ((Observer3D)this._observer).followOffsetZ();
    }

    @Override
    public void diffuse4(double d, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int worldDepth() {
        return this._worldDepth;
    }

    @Override
    public int maxPzcor() {
        return this._maxPzcor;
    }

    @Override
    public int minPzcor() {
        return this._minPzcor;
    }

    @Override
    public double wrapZ(double d) {
        return Topology.wrap(d, (double)this._minPzcor - 0.5, (double)this._maxPzcor + 0.5);
    }

    public int roundZ(double d) {
        if ((d = ((Topology3D)((Object)this.topology)).wrapZ(d)) > 0.0) {
            return (int)(d + 0.5);
        }
        int n = (int)d;
        double d2 = (double)n - d;
        return d2 > 0.5 ? n - 1 : n;
    }

    public Patch getPatchAtWrap(double d, double d2, double d3) {
        int n;
        double d4;
        int n2;
        int n3;
        d = Topology.wrap(d, (double)this._minPxcor - 0.5, (double)this._maxPxcor + 0.5);
        d2 = Topology.wrap(d2, (double)this._minPycor - 0.5, (double)this._maxPycor + 0.5);
        d3 = Topology.wrap(d3, (double)this._minPzcor - 0.5, (double)this._maxPzcor + 0.5);
        if (d > 0.0) {
            n3 = (int)(d + 0.5);
        } else {
            n2 = (int)d;
            d4 = (double)n2 - d;
            int n4 = n3 = d4 > 0.5 ? n2 - 1 : n2;
        }
        if (d2 > 0.0) {
            n = (int)(d2 + 0.5);
        } else {
            n2 = (int)d2;
            d4 = (double)n2 - d2;
            int n5 = n = d4 > 0.5 ? n2 - 1 : n2;
        }
        int n6 = d3 > 0.0 ? (int)(d3 + 0.5) : ((d4 = (double)(n2 = (int)d3) - d3) > 0.5 ? n2 - 1 : n2);
        int n7 = this._worldWidth * this._worldHeight * (this._maxPzcor - n6) + this._worldWidth * (this._maxPycor - n) + n3 - this._minPxcor;
        return (Patch)this._patches.toArray()[n7];
    }

    public boolean validPatchCoordinates(int n, int n2, int n3) {
        return n >= this._minPxcor && n <= this._maxPxcor && n2 >= this._minPycor && n2 <= this._maxPycor && n3 >= this._minPzcor && n3 <= this._maxPzcor;
    }

    public Patch fastGetPatchAt(int n, int n2, int n3) {
        return (Patch)this._patches.toArray()[this._worldWidth * this._worldHeight * (this._maxPzcor - n3) + this._worldWidth * (this._maxPycor - n2) + n - this._minPxcor];
    }

    @Override
    public Patch fastGetPatchAt(int n, int n2) {
        return this.fastGetPatchAt(n, n2, 0);
    }

    @Override
    public void createPatches(int n, int n2, int n3, int n4) {
        this.createPatches(n, n2, n3, n4, 0, 0);
    }

    @Override
    public Program newProgram() {
        return new Program(true);
    }

    @Override
    public Program newProgram(List<String> list) {
        return new Program(list, true);
    }

    public void createPatches(int n, int n2, int n3, int n4, int n5, int n6) {
        this.patchScratch = null;
        this.patchScratch3d = null;
        this._minPxcor = n;
        this._maxPxcor = n2;
        this._minPycor = n3;
        this._maxPycor = n4;
        this._minPzcor = n5;
        this._maxPzcor = n6;
        this._worldWidth = this._maxPxcor - this._minPxcor + 1;
        this._worldHeight = this._maxPycor - this._minPycor + 1;
        this._worldDepth = this._maxPzcor - this._minPzcor + 1;
        this.rootsTable = new RootsTable(this._worldWidth, this._worldHeight);
        this._worldWidthBoxed = this._worldWidth;
        this._worldHeightBoxed = this._worldHeight;
        this._worldDepthBoxed = this._worldDepth;
        this._minPxcorBoxed = this._minPxcor;
        this._minPycorBoxed = this._minPycor;
        this._minPzcorBoxed = this._minPzcor;
        this._maxPxcorBoxed = this._maxPxcor;
        this._maxPycorBoxed = this._maxPycor;
        this._maxPzcorBoxed = this._maxPzcor;
        if (this.program().breeds() != null) {
            Iterator<Object> iterator2 = this.program().breeds().values().iterator();
            while (iterator2.hasNext()) {
                ((AgentSet)iterator2.next()).clear();
            }
        }
        this._turtles = new TreeAgentSet(Turtle.class, "TURTLES", this);
        this._links = new TreeAgentSet(Link.class, "LINKS", this);
        int n7 = this._minPxcor;
        int n8 = this._maxPycor;
        int n9 = this._maxPzcor;
        Agent[] agentArray = new Agent[this._worldWidth * this._worldHeight * this._worldDepth];
        this.patchColors = new int[this._worldWidth * this._worldHeight * this._worldDepth];
        Arrays.fill(this.patchColors, Color.getARGBbyPremodulatedColorNumber(0.0));
        this.patchColorsDirty = true;
        int n10 = this.program().patchesOwn().size();
        this._observer.resetPerspective();
        for (int i = 0; this._worldWidth * this._worldHeight * this._worldDepth != i; ++i) {
            Patch3D patch3D = new Patch3D(this, i, n7, n8, n9, n10);
            if (++n7 == this._maxPxcor + 1) {
                n7 = this._minPxcor;
                if (--n8 == this._minPycor - 1) {
                    n8 = this._maxPycor;
                    --n9;
                }
            }
            agentArray[i] = patch3D;
        }
        this._patches = new ArrayAgentSet(Patch.class, agentArray, "patches", (World)this);
        this.patchesWithLabels = 0;
        this.patchesAllBlack = true;
        this.mayHavePartiallyTransparentObjects = false;
    }

    @Override
    public void exportWorld(PrintWriter printWriter, boolean bl) {
        new Exporter3D(this, printWriter).exportWorld(bl);
    }

    @Override
    public void importWorld(Importer.ErrorHandler errorHandler, ImporterUser importerUser, Importer.StringReader stringReader, BufferedReader bufferedReader) throws IOException {
        new Importer3D(errorHandler, this, importerUser, stringReader).importWorld(bufferedReader);
    }

    @Override
    public Turtle getOrCreateTurtle(long l) {
        Turtle turtle2 = this.getTurtle(l);
        if (turtle2 == null) {
            turtle2 = new Turtle3D(this, l);
        }
        return turtle2;
    }

    public double[][][] getPatchScratch3d() {
        if (this.patchScratch3d == null) {
            this.patchScratch3d = new double[this._worldWidth][this._worldHeight][this._worldDepth];
        }
        return this.patchScratch3d;
    }

    @Override
    public WorldDimensions getDimensions() {
        return new WorldDimensions3D(this._minPxcor, this._maxPxcor, this._minPycor, this._maxPycor, this._minPzcor, this._maxPzcor);
    }

    @Override
    public Patch getPatchAt(double d, double d2) throws AgentException {
        return this.getPatchAt(d, d2, 0.0);
    }

    @Override
    public Patch3D getPatchAt(double d, double d2, double d3) throws AgentException {
        int n = this.roundX(d);
        int n2 = this.roundY(d2);
        int n3 = this.roundZ(d3);
        int n4 = this._worldWidth * this._worldHeight * (this._maxPzcor - n3) + this._worldWidth * (this._maxPycor - n2) + n - this._minPxcor;
        return (Patch3D)this._patches.toArray()[n4];
    }

    @Override
    public Turtle createTurtle(AgentSet agentSet) {
        return new Turtle3D(this, agentSet, ZERO, ZERO, ZERO);
    }

    @Override
    public Turtle createTurtle(AgentSet agentSet, int n, int n2) {
        Turtle3D turtle3D = new Turtle3D(this, agentSet, ZERO, ZERO, ZERO);
        turtle3D.colorDoubleUnchecked(Double.valueOf(5 + 10 * n));
        turtle3D.heading(n2);
        return turtle3D;
    }

    @Override
    public Object getDrawing() {
        return this.drawing;
    }

    @Override
    public boolean sendPixels() {
        return false;
    }

    @Override
    void drawLine(double d, double d2, double d3, double d4, Object object, double d5, String string) {
        this.drawing.drawLine(d, d2, 0.0, d3, d4, 0.0, d5, object);
    }

    void drawLine(double d, double d2, double d3, double d4, double d5, double d6, Object object, double d7) {
        this.drawing.drawLine(d, d2, d3, d4, d5, d6, d7, object);
    }

    @Override
    public void clearAll() {
        super.clearAll();
        this.drawing.clear();
    }

    @Override
    public void clearDrawing() {
        this.drawing.clear();
    }

    @Override
    public void stamp(Agent agent, boolean bl) {
        if (!bl) {
            this.drawing.stamp(agent);
        }
    }
}

