/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.awt.Color;
import java.text.DecimalFormat;
import org.nlogo.api.Approximate$;
import org.nlogo.api.Color$;
import org.nlogo.api.LogoList;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.util.Utils$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.LongRef;
import scala.sys.package$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Color$
implements ScalaObject {
    public static final Color$ MODULE$;
    private final int NumHues;
    private final int MaxColor;
    private final String[] ColorNames;
    private final int Black;
    private final double White;
    private final Double BoxedBlack;
    private final Double BoxedWhite;
    private final double[] ColorNumbers;
    private final int[] ColorsRGB;
    private final int[] ARGB_Cache;
    private final Color[] AWT_Cache;
    private final HashMap<Object, Object> rgbMap;
    private final String ColorTranslations;
    private final HashMap<Object, Object> colorTranslations;
    private volatile int bitmap$init$0;

    static {
        new Color$();
    }

    public int NumHues() {
        if ((this.bitmap$init$0 & 1) != 0) {
            return this.NumHues;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 12".toString());
    }

    public int MaxColor() {
        if ((this.bitmap$init$0 & 2) != 0) {
            return this.MaxColor;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 13".toString());
    }

    public String[] ColorNames() {
        if ((this.bitmap$init$0 & 4) != 0) {
            return this.ColorNames;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 16".toString());
    }

    public int Black() {
        if ((this.bitmap$init$0 & 8) != 0) {
            return this.Black;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 24".toString());
    }

    public double White() {
        if ((this.bitmap$init$0 & 0x10) != 0) {
            return this.White;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 25".toString());
    }

    public Double BoxedBlack() {
        if ((this.bitmap$init$0 & 0x20) != 0) {
            return this.BoxedBlack;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 26".toString());
    }

    public Double BoxedWhite() {
        if ((this.bitmap$init$0 & 0x40) != 0) {
            return this.BoxedWhite;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 27".toString());
    }

    private double[] ColorNumbers() {
        if ((this.bitmap$init$0 & 0x80) != 0) {
            return this.ColorNumbers;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 29".toString());
    }

    private int[] ColorsRGB() {
        if ((this.bitmap$init$0 & 0x100) != 0) {
            return this.ColorsRGB;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 40".toString());
    }

    private int[] ARGB_Cache() {
        if ((this.bitmap$init$0 & 0x200) != 0) {
            return this.ARGB_Cache;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 59".toString());
    }

    private Color[] AWT_Cache() {
        if ((this.bitmap$init$0 & 0x400) != 0) {
            return this.AWT_Cache;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 67".toString());
    }

    public Color getColor(Object object) {
        Object object2;
        block4: {
            block6: {
                Color color;
                block3: {
                    LogoList logoList;
                    block5: {
                        block2: {
                            object2 = object;
                            if (!(object2 instanceof Double)) break block2;
                            color = this.AWT_Cache()[(int)((Double)object2 * (double)10)];
                            break block3;
                        }
                        if (!(object2 instanceof LogoList)) break block4;
                        logoList = (LogoList)object2;
                        LogoList logoList2 = logoList;
                        if (!this.gd1$1(logoList2)) break block5;
                        color = new Color(((Number)logoList2.get(0)).intValue(), ((Number)logoList2.get(1)).intValue(), ((Number)logoList2.get(2)).intValue());
                        break block3;
                    }
                    LogoList logoList3 = logoList;
                    if (!this.gd2$1(logoList3)) break block6;
                    color = new Color(((Number)logoList3.get(0)).intValue(), ((Number)logoList3.get(1)).intValue(), ((Number)logoList3.get(2)).intValue(), ((Number)logoList3.get(3)).intValue());
                }
                return color;
            }
            throw new MatchError(object2);
        }
        throw new MatchError(object2);
    }

    private HashMap<Object, Object> rgbMap() {
        if ((this.bitmap$init$0 & 0x800) != 0) {
            return this.rgbMap;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 90".toString());
    }

    public double getColorNumberByIndex(int n) {
        return this.ColorNumbers()[n];
    }

    public String[] getColorNamesArray() {
        return this.ColorNames();
    }

    public String getColorNameByIndex(int n) {
        return this.ColorNames()[n];
    }

    public int modulateInteger(int n) {
        int n2 = n;
        if ((n2 < 0 || n2 >= this.MaxColor()) && (n2 %= this.MaxColor()) < 0) {
            n2 += this.MaxColor();
        }
        return n2;
    }

    public double modulateDouble(Double d) {
        return this.modulateDouble((double)d);
    }

    public double modulateDouble(double d) {
        double d2 = d;
        if (d2 < 0.0 || d2 >= (double)this.MaxColor()) {
            if ((d2 %= (double)this.MaxColor()) < 0.0) {
                d2 += (double)this.MaxColor();
            }
            if (d2 >= (double)this.MaxColor()) {
                d2 = 139.9999999999999;
            }
        }
        return d2;
    }

    public double findCentralColorNumber(double d) {
        double d2 = d < 0.0 || d >= (double)this.MaxColor() ? this.modulateDouble(d) : d;
        return ((double)((int)(d2 / (double)10)) + 0.5) * (double)10;
    }

    public double getClosestColorNumberByARGB(int n) {
        return BoxesRunTime.unboxToDouble(this.rgbMap().get(BoxesRunTime.boxToDouble(n)).getOrElse(new Serializable(n){
            public static final long serialVersionUID;
            private final int argb$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return Color$.MODULE$.org$nlogo$api$Color$$estimateClosestColorNumberByRGB(this.argb$1);
            }

            public final /* synthetic */ Object apply() {
                return BoxesRunTime.boxToDouble(this.apply());
            }
            {
                this.argb$1 = n;
            }
        }));
    }

    public String getClosestColorNameByARGB(int n) {
        String string;
        DecimalFormat decimalFormat = new DecimalFormat("###.####");
        double d = this.getClosestColorNumberByARGB(n);
        if (BoxesRunTime.equals(BoxesRunTime.boxToInteger(this.Black()), BoxesRunTime.boxToDouble(d))) {
            string = this.getColorNameByIndex(14);
        } else if (BoxesRunTime.equals(BoxesRunTime.boxToDouble(this.White()), BoxesRunTime.boxToDouble(d))) {
            string = this.getColorNameByIndex(15);
        } else {
            double d2 = d;
            int n2 = (int)this.findCentralColorNumber(d2);
            double d3 = d2 - (double)n2;
            String string2 = this.getColorNameByIndex((n2 - 5) / 10);
            string = d3 == 0.0 ? string2 : (d3 > 0.0 ? new StringBuilder().append((Object)string2).append((Object)" + ").append((Object)decimalFormat.format(StrictMath.abs(d3))).toString() : new StringBuilder().append((Object)string2).append((Object)" - ").append((Object)decimalFormat.format(StrictMath.abs(d3))).toString());
        }
        return string;
    }

    public double getClosestColorNumberByHSB(float f, float f2, float f3) {
        float f4 = BoxesRunTime.unboxToFloat(Predef$.MODULE$.floatWrapper(BoxesRunTime.unboxToFloat(Predef$.MODULE$.floatWrapper(0.0f).max(BoxesRunTime.boxToFloat(f)))).min(BoxesRunTime.boxToFloat(255.0f)));
        float f5 = BoxesRunTime.unboxToFloat(Predef$.MODULE$.floatWrapper(BoxesRunTime.unboxToFloat(Predef$.MODULE$.floatWrapper(0.0f).max(BoxesRunTime.boxToFloat(f)))).min(BoxesRunTime.boxToFloat(255.0f)));
        float f6 = BoxesRunTime.unboxToFloat(Predef$.MODULE$.floatWrapper(BoxesRunTime.unboxToFloat(Predef$.MODULE$.floatWrapper(0.0f).max(BoxesRunTime.boxToFloat(f)))).min(BoxesRunTime.boxToFloat(255.0f)));
        int n = Color.HSBtoRGB(f / (float)255, f2 / (float)255, f3 / (float)255);
        return BoxesRunTime.unboxToDouble(this.rgbMap().get(BoxesRunTime.boxToDouble(n)).getOrElse(new Serializable(n){
            public static final long serialVersionUID;
            private final int argb$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return Color$.MODULE$.org$nlogo$api$Color$$estimateClosestColorNumberByRGB(this.argb$3);
            }

            public final /* synthetic */ Object apply() {
                return BoxesRunTime.boxToDouble(this.apply());
            }
            {
                this.argb$3 = n;
            }
        }));
    }

    public final double org$nlogo$api$Color$$estimateClosestColorNumberByRGB(int n) {
        LongRef longRef = new LongRef(100000000L);
        DoubleRef doubleRef = new DoubleRef(0.0);
        ((HashMap)this.rgbMap().filter((Function1<Object, Object>)((Object)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<Object, Object> tuple2) {
                Tuple2<Object, Object> tuple22 = tuple2;
                return tuple22 != null;
            }

            public final /* synthetic */ Object apply(Object object) {
                return BoxesRunTime.boxToBoolean(this.apply((Tuple2)object));
            }
        }))).foreach(new Serializable(n, longRef, doubleRef){
            public static final long serialVersionUID;
            private final int argb$2;
            private final LongRef smallestDistance$1;
            private final DoubleRef closest$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<Object, Object> tuple2) {
                Tuple2<Object, Object> tuple22 = tuple2;
                if (tuple22 != null) {
                    double d = BoxesRunTime.unboxToDouble(tuple22._1());
                    double d2 = d;
                    int n = (int)d2;
                    long l = Color$.MODULE$.org$nlogo$api$Color$$colorDistance(this.argb$2, n);
                    if (l < this.smallestDistance$1.elem) {
                        this.smallestDistance$1.elem = l;
                        this.closest$1.elem = BoxesRunTime.unboxToDouble(tuple22._2());
                    }
                    return;
                }
                throw new MatchError(tuple22);
            }
            {
                this.argb$2 = n;
                this.smallestDistance$1 = longRef;
                this.closest$1 = doubleRef;
            }
        });
        return doubleRef.elem;
    }

    public final long org$nlogo$api$Color$$colorDistance(int n, int n2) {
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        int n6 = n2 >> 16 & 0xFF;
        int n7 = n2 >> 8 & 0xFF;
        int n8 = n2 & 0xFF;
        int n9 = n3 + n6 / 2;
        int n10 = n3 - n6;
        int n11 = n4 - n7;
        int n12 = n5 - n8;
        return ((512 + n9) * n10 * n10 >> 8) + 4 * n11 * n11 + ((767 - n9) * n12 * n12 >> 8);
    }

    public int getARGBbyPremodulatedColorNumber(double d) {
        return this.ARGB_Cache()[(int)(d * (double)10)];
    }

    public final int org$nlogo$api$Color$$computeARGBforCache(int n) {
        int n2 = n / 100;
        int n3 = this.ColorsRGB()[n2 * 3];
        int n4 = this.ColorsRGB()[n2 * 3 + 1];
        int n5 = this.ColorsRGB()[n2 * 3 + 2];
        double d = (double)(n % 100 - 50) / 50.48 + 0.012;
        if (d < 0.0) {
            n3 += (int)((double)n3 * d);
            n4 += (int)((double)n4 * d);
            n5 += (int)((double)n5 * d);
        } else if (d > 0.0) {
            n3 += (int)((double)(255 - n3) * d);
            n4 += (int)((double)(255 - n4) * d);
            n5 += (int)((double)(255 - n5) * d);
        }
        return -16777216 + (n3 << 16) + (n4 << 8) + n5;
    }

    public int getRGBByName(String string) {
        return this.getARGBByIndex(Predef$.MODULE$.refArrayOps((Object[])this.ColorNames()).indexOf(string));
    }

    public int getARGBByIndex(int n) {
        int n2;
        int n3 = n;
        switch (n3) {
            default: {
                n2 = this.ARGB_Cache()[n * 100 + 50];
                break;
            }
            case 14: {
                n2 = -16777216;
                break;
            }
            case 15: {
                n2 = -1;
            }
        }
        return n2;
    }

    public LogoList getRGBListByARGB(int n) {
        LogoListBuilder logoListBuilder = new LogoListBuilder();
        logoListBuilder.add(Predef$.MODULE$.double2Double(Approximate$.MODULE$.approximate(n >> 16 & 0xFF, 3)));
        logoListBuilder.add(Predef$.MODULE$.double2Double(Approximate$.MODULE$.approximate(n >> 8 & 0xFF, 3)));
        logoListBuilder.add(Predef$.MODULE$.double2Double(Approximate$.MODULE$.approximate(n & 0xFF, 3)));
        return logoListBuilder.toLogoList();
    }

    public LogoList getRGBAListByARGB(int n) {
        LogoListBuilder logoListBuilder = new LogoListBuilder();
        logoListBuilder.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(n >> 16 & 0xFF, 3)));
        logoListBuilder.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(n >> 8 & 0xFF, 3)));
        logoListBuilder.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(n & 0xFF, 3)));
        logoListBuilder.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(n >> 24 & 0xFF, 3)));
        return logoListBuilder.toLogoList();
    }

    public int getARGBIntByRGBAList(LogoList logoList) {
        return logoList.size() == 4 ? ((Double)logoList.get(3)).intValue() << 24 | ((Double)logoList.get(0)).intValue() << 16 | ((Double)logoList.get(1)).intValue() << 8 | ((Double)logoList.get(2)).intValue() : 0xFF000000 | ((Double)logoList.get(0)).intValue() << 16 | ((Double)logoList.get(1)).intValue() << 8 | ((Double)logoList.get(2)).intValue();
    }

    public LogoList getHSBListByARGB(int n) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF, fArray);
        LogoListBuilder logoListBuilder = new LogoListBuilder();
        logoListBuilder.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(fArray[0] * (float)255, 3)));
        logoListBuilder.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(fArray[1] * (float)255, 3)));
        logoListBuilder.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(fArray[2] * (float)255, 3)));
        return logoListBuilder.toLogoList();
    }

    private String ColorTranslations() {
        if ((this.bitmap$init$0 & 0x1000) != 0) {
            return this.ColorTranslations;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 360".toString());
    }

    private HashMap<Object, Object> colorTranslations() {
        if ((this.bitmap$init$0 & 0x2000) != 0) {
            return this.colorTranslations;
        }
        throw new UninitializedFieldError("Uninitialized field: Color.scala: 361".toString());
    }

    public int translateSavedColor(int n) {
        return BoxesRunTime.unboxToInt(this.colorTranslations().get(BoxesRunTime.boxToDouble(n)).map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(int n) {
                return this.apply$mcII$sp(n);
            }

            public int apply$mcII$sp(int n) {
                return Predef$.MODULE$.int2Integer(n);
            }

            public final /* synthetic */ Object apply(Object object) {
                return BoxesRunTime.boxToInteger(this.apply(BoxesRunTime.unboxToInt(object)));
            }
        }).map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(int n) {
                return this.apply$mcII$sp(n);
            }

            public int apply$mcII$sp(int n) {
                return Color$.MODULE$.getARGBByIndex(n);
            }

            public final /* synthetic */ Object apply(Object object) {
                return BoxesRunTime.boxToInteger(this.apply(BoxesRunTime.unboxToInt(object)));
            }
        }).getOrElse(new Serializable(n){
            public static final long serialVersionUID;
            private final int color$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.color$1;
            }

            public final /* synthetic */ Object apply() {
                return BoxesRunTime.boxToInteger(this.apply());
            }
            {
                this.color$1 = n;
            }
        }));
    }

    public Double argbToColor(int n) {
        return Predef$.MODULE$.double2Double(this.getClosestColorNumberByARGB(n));
    }

    public int getRGBInt(int n, int n2, int n3) {
        return ((n << 8) + n2 << 8) + n3;
    }

    public int getRGBInt(Object object) {
        block4: {
            int n;
            block3: {
                Object object2;
                block2: {
                    object2 = object;
                    if (!(object2 instanceof LogoList)) break block2;
                    n = this.getARGBIntByRGBAList((LogoList)object2);
                    break block3;
                }
                if (!(object2 instanceof Double)) break block4;
                n = this.getARGBbyPremodulatedColorNumber((Double)object2);
            }
            return n;
        }
        throw package$.MODULE$.error("Can't get RGB color");
    }

    public Color getComplement(Color color) {
        float[] fArray = color.getRGBColorComponents(null);
        return new Color((fArray[0] + 0.5f) % 1.0f, (fArray[1] + 0.5f) % 1.0f, (fArray[2] + 0.5f) % 1.0f);
    }

    private final boolean gd1$1(LogoList logoList) {
        return logoList.size() == 3;
    }

    private final boolean gd2$1(LogoList logoList) {
        return logoList.size() == 4;
    }

    private Color$() {
        MODULE$ = this;
        this.NumHues = 14;
        this.bitmap$init$0 |= 1;
        this.MaxColor = 10 * this.NumHues();
        this.bitmap$init$0 |= 2;
        this.ColorNames = (String[])((Object[])new String[]{"gray", "red", "orange", "brown", "yellow", "green", "lime", "turquoise", "cyan", "sky", "blue", "violet", "magenta", "pink", "black", "white"});
        this.bitmap$init$0 |= 4;
        this.Black = 0;
        this.bitmap$init$0 |= 8;
        this.White = 9.9;
        this.bitmap$init$0 |= 0x10;
        this.BoxedBlack = Predef$.MODULE$.double2Double(0.0);
        this.bitmap$init$0 |= 0x20;
        this.BoxedWhite = Predef$.MODULE$.double2Double(this.White());
        this.bitmap$init$0 |= 0x40;
        this.ColorNumbers = (double[])Array$.MODULE$.apply(Predef$.MODULE$.wrapDoubleArray(new double[]{5.0, 15.0, 25.0, 35.0, 45.0, 55.0, 65.0, 75.0, 85.0, 95.0, 105.0, 115.0, 125.0, 135.0, this.Black(), this.White()}), Manifest$.MODULE$.Double());
        this.bitmap$init$0 |= 0x80;
        this.ColorsRGB = (int[])Array$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{140, 140, 140, 215, 48, 39, 241, 105, 19, 156, 109, 70, 237, 237, 47, 87, 176, 58, 42, 209, 57, 27, 158, 119, 82, 196, 196, 43, 140, 190, 50, 92, 168, 123, 78, 163, 166, 25, 105, 224, 126, 149, 0, 0, 0, 255, 255, 255}), Manifest$.MODULE$.Int());
        this.bitmap$init$0 |= 0x100;
        int[] nArray = (int[])((TraversableOnce)Predef$.MODULE$.intWrapper(0).until(this.MaxColor() * 10).map(new anonfun.1(), IndexedSeq$.MODULE$.canBuildFrom())).toArray(Manifest$.MODULE$.Int());
        nArray[0] = -16777216;
        nArray[99] = -1;
        this.ARGB_Cache = nArray;
        this.bitmap$init$0 |= 0x200;
        this.AWT_Cache = (Color[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intWrapper(0).until(this.MaxColor() * 10).toArray(Manifest$.MODULE$.Int())).map(new anonfun.3(), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Color.class)));
        this.bitmap$init$0 |= 0x400;
        HashMap hashMap = (HashMap)HashMap$.MODULE$.apply(Nil$.MODULE$);
        Predef$.MODULE$.intWrapper(0).until(this.MaxColor() * 10).foreach$mVc$sp(new anonfun.2(hashMap));
        this.rgbMap = hashMap;
        this.bitmap$init$0 |= 0x800;
        this.ColorTranslations = "/system/color-translation.txt";
        this.bitmap$init$0 |= 0x1000;
        HashMap hashMap2 = (HashMap)HashMap$.MODULE$.apply(Nil$.MODULE$);
        String[] stringArray = Utils$.MODULE$.getResourceAsStringArray(this.ColorTranslations());
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])stringArray).map(new anonfun.4(), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(String.class)))).filter(new anonfun.5())).filter(new anonfun.6())).foreach(new anonfun.7(hashMap2));
        this.colorTranslations = hashMap2;
        this.bitmap$init$0 |= 0x2000;
    }
}

