/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import org.nlogo.api.Matrix3D;
import org.nlogo.api.Vect$;
import scala.Array$;
import scala.Predef$;
import scala.Product;
import scala.Product$class;
import scala.Serializable;
import scala.collection.Iterator;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vect
implements Product,
Serializable {
    private final double x;
    private final double y;
    private final double z;

    public static final double[] toAngles(Vect vect, Vect vect2) {
        return Vect$.MODULE$.toAngles(vect, vect2);
    }

    public static final Vect[] toVectors(double d, double d2, double d3) {
        return Vect$.MODULE$.toVectors(d, d2, d3);
    }

    public static final Vect axisTransformation(Vect vect, Vect vect2, Vect vect3, Vect vect4) {
        return Vect$.MODULE$.axisTransformation(vect, vect2, vect3, vect4);
    }

    public static final double org$nlogo$api$Vect$$bindWithinOne(double d) {
        return Vect$.MODULE$.org$nlogo$api$Vect$$bindWithinOne(d);
    }

    public static final double org$nlogo$api$Vect$$Infinitesimal() {
        return Vect$.MODULE$.org$nlogo$api$Vect$$Infinitesimal();
    }

    @Override
    public Iterator<Object> productIterator() {
        return Product$class.productIterator(this);
    }

    public Iterator<Object> productElements() {
        return Product$class.productElements(this);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public double magnitude() {
        return StrictMath.sqrt(this.x() * this.x() + this.y() * this.y() + this.z() * this.z());
    }

    public double zeroify(double d) {
        return StrictMath.abs(d) < Vect$.MODULE$.org$nlogo$api$Vect$$Infinitesimal() ? 0.0 : d;
    }

    public Vect invert() {
        return new Vect(-this.x(), -this.y(), -this.z());
    }

    public Vect add(Vect vect) {
        return new Vect(this.x() + vect.x(), this.y() + vect.y(), this.z() + vect.z());
    }

    public Vect subtract(Vect vect) {
        return new Vect(this.x() - vect.x(), this.y() - vect.y(), this.z() - vect.z());
    }

    public Vect correct() {
        return new Vect(this.zeroify(this.x()), this.zeroify(this.y()), this.zeroify(this.z()));
    }

    public Vect normalize() {
        double d = this.magnitude();
        return d == 0.0 ? this : new Vect(this.x() / d, this.y() / d, this.z() / d);
    }

    public Vect rotateX(double d) {
        double d2 = StrictMath.toRadians(d);
        double d3 = StrictMath.sin(d2);
        double d4 = StrictMath.cos(d2);
        return new Vect(this.x(), this.y() * d4 - this.z() * d3, this.y() * d3 + this.z() * d4).correct();
    }

    public Vect rotateY(double d) {
        double d2 = StrictMath.toRadians(d);
        double d3 = StrictMath.sin(d2);
        double d4 = StrictMath.cos(d2);
        return new Vect(this.z() * d3 + this.x() * d4, this.y(), this.z() * d4 - this.x() * d3).correct();
    }

    public Vect rotateZ(double d) {
        double d2 = StrictMath.toRadians(d);
        double d3 = StrictMath.sin(d2);
        double d4 = StrictMath.cos(d2);
        return new Vect(this.x() * d4 - this.y() * d3, this.x() * d3 + this.y() * d4, this.z()).correct();
    }

    public Vect transform(Matrix3D matrix3D) {
        double[] dArray = Array$.MODULE$.apply(this.x(), Predef$.MODULE$.wrapDoubleArray(new double[]{this.y(), this.z()}));
        matrix3D.transform(dArray, dArray, 1);
        return new Vect(dArray[0], dArray[1], dArray[2]);
    }

    public double dot(Vect vect) {
        return this.x() * vect.x() + this.y() * vect.y() + this.z() * vect.z();
    }

    public Vect cross(Vect vect) {
        return new Vect(this.y() * vect.z() - this.z() * vect.y(), this.z() * vect.x() - this.x() * vect.z(), this.x() * vect.y() - this.y() * vect.x()).normalize();
    }

    public double angleTo(Vect vect) {
        double d;
        if (this.magnitude() == 0.0 || vect.magnitude() == 0.0) {
            d = 0.0;
        } else {
            double d2 = this.normalize().dot(vect.normalize());
            double d3 = StrictMath.acos(Vect$.MODULE$.org$nlogo$api$Vect$$bindWithinOne(d2));
            d = this.cross(vect).z() == (double)-1 ? Math.PI * 2 - d3 : d3;
        }
        return d;
    }

    public final double org$nlogo$api$Vect$$angle(Vect vect) {
        return StrictMath.acos(Vect$.MODULE$.org$nlogo$api$Vect$$bindWithinOne(this.normalize().dot(vect.normalize())));
    }

    public Vect copy(double d, double d2, double d3) {
        return new Vect(d, d2, d3);
    }

    public double copy$default$3() {
        return this.z();
    }

    public double copy$default$2() {
        return this.y();
    }

    public double copy$default$1() {
        return this.x();
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        double d;
        double d2;
        double d3;
        double d4;
        if (this == object) return true;
        Object object2 = object;
        if (!(object2 instanceof Vect)) return false;
        Vect vect = (Vect)object2;
        double d5 = vect.x();
        double d6 = d5;
        if (!this.gd1$1(d6, d4 = (d3 = vect.y()), d2 = (d = vect.z()))) return false;
        boolean bl = ((Vect)object).canEqual(this);
        if (!bl) return false;
        return true;
    }

    @Override
    public String productPrefix() {
        return "Vect";
    }

    @Override
    public int productArity() {
        return 3;
    }

    @Override
    public Object productElement(int n) {
        Double d;
        int n2 = n;
        switch (n2) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(n)).toString());
            }
            case 0: {
                d = BoxesRunTime.boxToDouble(this.x());
                break;
            }
            case 2: {
                d = BoxesRunTime.boxToDouble(this.z());
                break;
            }
            case 1: {
                d = BoxesRunTime.boxToDouble(this.y());
            }
        }
        return d;
    }

    @Override
    public boolean canEqual(Object object) {
        return object instanceof Vect;
    }

    private final boolean gd1$1(double d, double d2, double d3) {
        return d == this.x() && d2 == this.y() && d3 == this.z();
    }

    public Vect(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        Product$class.$init$(this);
    }
}

