/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.awt;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaException;
import javax.media.MediaLocator;
import javax.media.PrefetchCompleteEvent;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.control.TrackControl;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.util.ImageToBuffer;
import org.nlogo.awt.JMFMovieEncoderDataSource;
import org.nlogo.awt.MovieEncoder;

public strictfp class JMFMovieEncoder
implements Serializable,
ControllerListener,
DataSinkListener,
MovieEncoder {
    private boolean isSetup = false;
    private boolean stopped = false;
    private float frameRate;
    private final String fileName;
    private Processor processor;
    private JMFMovieEncoderDataSource source;
    private DataSink sink;
    private int numFrames = 0;
    private File outFile;
    private Dimension frameSize;
    private Format format;
    private int type;
    private final Object waitSync = new Object();
    private boolean stateTransitionOK = true;
    private final Object waitFileSync = new Object();
    private boolean fileDone = false;
    private boolean fileSuccess = true;

    public JMFMovieEncoder(int n, String string) {
        this.frameRate = n;
        this.fileName = string;
    }

    public synchronized void setFrameRate(float f) throws IOException {
        if (this.isSetup) {
            throw new IOException("Can't set framerate after setup");
        }
        this.frameRate = f;
    }

    public synchronized float getFrameRate() {
        return this.frameRate;
    }

    public synchronized Dimension getFrameSize() {
        return this.frameSize;
    }

    public synchronized void add(BufferedImage bufferedImage) throws IOException {
        if (this.numFrames == 0) {
            this.setup(bufferedImage);
        }
        if (!this.stopped) {
            bufferedImage = this.preProcess(bufferedImage);
            this.source.add(bufferedImage);
            ++this.numFrames;
        }
    }

    public boolean isSetup() {
        return this.isSetup;
    }

    protected synchronized void setup(BufferedImage bufferedImage) throws IOException {
        try {
            this.frameSize = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
            this.type = bufferedImage.getType();
            this.numFrames = 0;
            this.format = ImageToBuffer.createBuffer((Image)bufferedImage, (float)this.frameRate).getFormat();
            this.source = new JMFMovieEncoderDataSource(this.format, this.frameRate);
            this.processor = Manager.createProcessor((DataSource)this.source);
            this.processor.addControllerListener((ControllerListener)this);
            this.processor.configure();
            if (!this.waitForState(this.processor, 180)) {
                throw new IOException("JMFMovieEncoder error: Failed to configure processor");
            }
            this.processor.setContentDescriptor(new ContentDescriptor("video.quicktime"));
            TrackControl[] trackControlArray = this.processor.getTrackControls();
            Format[] formatArray = trackControlArray[0].getSupportedFormats();
            if (formatArray == null || formatArray.length <= 0) {
                throw new IOException("The mux does not support the input format: " + trackControlArray[0].getFormat());
            }
            trackControlArray[0].setFormat(formatArray[0]);
            this.format = formatArray[0];
            this.processor.realize();
            if (!this.waitForState(this.processor, 300)) {
                throw new IOException("Failed to realize processor");
            }
            this.outFile = new File(this.fileName);
            this.sink = Manager.createDataSink((DataSource)this.processor.getDataOutput(), (MediaLocator)new MediaLocator(JMFMovieEncoder.toURL(this.outFile)));
            this.sink.addDataSinkListener((DataSinkListener)this);
            this.sink.open();
            this.processor.start();
            this.sink.start();
            this.isSetup = true;
        }
        catch (MediaException mediaException) {
            throw new IOException("Cannot setup movie: " + (Object)((Object)mediaException));
        }
    }

    public synchronized void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.isSetup) {
            this.source.finish();
            this.waitForFileDone();
            this.sink.close();
            this.processor.removeControllerListener((ControllerListener)this);
        }
    }

    public synchronized void cancel() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.isSetup) {
            this.source.finish();
            this.waitForFileDone();
            this.sink.close();
            this.processor.removeControllerListener((ControllerListener)this);
            this.stopped = true;
            this.outFile.delete();
        }
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    protected BufferedImage preProcess(BufferedImage bufferedImage) {
        if (bufferedImage.getWidth() != this.frameSize.width || bufferedImage.getHeight() != this.frameSize.height || bufferedImage.getType() != this.type) {
            BufferedImage bufferedImage2 = new BufferedImage(this.frameSize.width, this.frameSize.height, this.type);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            bufferedImage = bufferedImage2;
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForState(Processor processor, int n) {
        Object object = this.waitSync;
        synchronized (object) {
            try {
                while (processor.getState() < n && this.stateTransitionOK) {
                    this.waitSync.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                JMFMovieEncoder.ignore(interruptedException);
            }
        }
        return this.stateTransitionOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof ConfigureCompleteEvent || controllerEvent instanceof RealizeCompleteEvent || controllerEvent instanceof PrefetchCompleteEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = true;
                this.waitSync.notifyAll();
            }
        } else if (controllerEvent instanceof ResourceUnavailableEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = false;
                this.waitSync.notifyAll();
            }
        } else if (controllerEvent instanceof EndOfMediaEvent) {
            controllerEvent.getSourceController().stop();
            controllerEvent.getSourceController().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForFileDone() {
        Object object = this.waitFileSync;
        synchronized (object) {
            try {
                while (!this.fileDone) {
                    this.waitFileSync.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                JMFMovieEncoder.ignore(interruptedException);
            }
        }
        return this.fileSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataSinkUpdate(DataSinkEvent dataSinkEvent) {
        if (dataSinkEvent instanceof EndOfStreamEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.waitFileSync.notifyAll();
            }
        }
        if (dataSinkEvent instanceof DataSinkErrorEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.fileSuccess = false;
                this.waitFileSync.notifyAll();
            }
        }
    }

    private static void ignore(Throwable throwable) {
    }

    private static URL toURL(File file) throws MalformedURLException {
        return file.toURL();
    }
}

