/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.editor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.nlogo.editor.Colorizer;
import org.nlogo.editor.EditorArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
strictfp class BracketMatcher<TokenType>
implements CaretListener {
    private static final Color GOOD_COLOR = Color.GRAY;
    private static final Color BAD_COLOR = Color.RED;
    private final Colorizer<TokenType> colorizer;
    private String oldText = "";
    private List<TokenType> tokenTypes = null;
    private String oldLineText = "";
    private List<TokenType> lineTokenTypes = null;
    private final BracketHighlightPainter goodPainter;
    private final BracketHighlightPainter badPainter;

    BracketMatcher(Colorizer<TokenType> colorizer) {
        this.colorizer = colorizer;
        this.goodPainter = new BracketHighlightPainter(GOOD_COLOR);
        this.badPainter = new BracketHighlightPainter(BAD_COLOR);
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        EditorArea editorArea = (EditorArea)caretEvent.getSource();
        Highlighter highlighter = editorArea.getHighlighter();
        this.removeOldHighlights(highlighter);
        int n = caretEvent.getDot();
        if (n != caretEvent.getMark() || n == 0) {
            return;
        }
        try {
            int n2;
            PlainDocument plainDocument;
            int n3;
            String string = editorArea.getLineText(n);
            if (!string.equals(this.oldLineText)) {
                this.lineTokenTypes = this.colorizer.getCharacterTokenTypes(string);
                this.oldLineText = string;
            }
            if ((n3 = n - editorArea.lineToStartOffset(plainDocument = (PlainDocument)editorArea.getDocument(), n2 = editorArea.offsetToLine(plainDocument, n))) == 0 || !this.colorizer.isOpener(this.lineTokenTypes.get(n3 - 1)) && !this.colorizer.isCloser(this.lineTokenTypes.get(n3 - 1))) {
                return;
            }
            String string2 = editorArea.getText();
            if (!string2.equals(this.oldText)) {
                this.tokenTypes = this.colorizer.getCharacterTokenTypes(string2);
                this.oldText = string2;
            }
            this.doHighlighting(highlighter, this.colorizer.isOpener(this.lineTokenTypes.get(n3 - 1)), this.tokenTypes, n);
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalStateException(badLocationException);
        }
    }

    void focusLost(EditorArea<?> editorArea) {
        this.removeOldHighlights(editorArea.getHighlighter());
        this.oldText = "";
        this.tokenTypes = null;
        this.oldLineText = "";
        this.lineTokenTypes = null;
    }

    private void doHighlighting(Highlighter highlighter, boolean bl, List<TokenType> list, int n) throws BadLocationException {
        if (bl) {
            int n2 = this.findCloser(this.colorizer, list, n - 1);
            if (n2 != -1 && this.colorizer.isMatch(list.get(n - 1), list.get(n2))) {
                this.highlightGood(highlighter, n2);
            }
        } else {
            int n3 = this.findOpener(this.colorizer, list, n - 1);
            if (n3 != -1) {
                if (this.colorizer.isMatch(list.get(n3), list.get(n - 1))) {
                    this.highlightGood(highlighter, n3);
                } else {
                    this.highlightBad(highlighter, n3);
                }
            } else {
                this.highlightBad(highlighter, n - 1);
            }
        }
    }

    int findCloser(Colorizer<TokenType> colorizer, List<TokenType> list, int n) {
        int n2 = 1;
        for (int i = n + 1; i < list.size(); ++i) {
            if (colorizer.isOpener(list.get(i))) {
                ++n2;
            } else if (colorizer.isCloser(list.get(i))) {
                --n2;
            }
            if (n2 != 0) continue;
            return i;
        }
        return -1;
    }

    int findOpener(Colorizer<TokenType> colorizer, List<TokenType> list, int n) {
        int n2 = 1;
        for (int i = n - 1; i >= 0; --i) {
            if (colorizer.isCloser(list.get(i))) {
                ++n2;
            } else if (colorizer.isOpener(list.get(i))) {
                --n2;
            }
            if (n2 != 0) continue;
            return i;
        }
        return -1;
    }

    private void removeOldHighlights(Highlighter highlighter) {
        Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
        for (int i = 0; i < highlightArray.length; ++i) {
            if (highlightArray[i].getPainter() != this.goodPainter && highlightArray[i].getPainter() != this.badPainter) continue;
            highlighter.removeHighlight(highlightArray[i]);
        }
    }

    private void highlightGood(Highlighter highlighter, int n) throws BadLocationException {
        highlighter.addHighlight(n, n + 1, this.goodPainter);
    }

    private void highlightBad(Highlighter highlighter, int n) throws BadLocationException {
        highlighter.addHighlight(n, n + 1, this.badPainter);
    }

    private strictfp class BracketHighlightPainter
    implements Highlighter.HighlightPainter {
        private final Color color;

        BracketHighlightPainter(Color color) {
            this.color = color;
        }

        public void paint(Graphics graphics, int n, int n2, Shape shape2, JTextComponent jTextComponent) {
            try {
                graphics.setColor(this.color);
                Rectangle rectangle = jTextComponent.getUI().modelToView(jTextComponent, n).union(jTextComponent.getUI().modelToView(jTextComponent, n2));
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalStateException(badLocationException);
            }
        }
    }
}

