/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.editor;

import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import org.nlogo.editor.BracketMatcher;
import org.nlogo.editor.Colorizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
strictfp class DoubleClickCaret<TokenType>
extends DefaultCaret {
    private final Colorizer<TokenType> colorizer;
    private final BracketMatcher<TokenType> bracketMatcher;

    DoubleClickCaret(Colorizer<TokenType> colorizer, BracketMatcher<TokenType> bracketMatcher) {
        this.colorizer = colorizer;
        this.bracketMatcher = bracketMatcher;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
            JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
            if (!this.handleDoubleClick(jTextComponent, this.colorizer.getCharacterTokenTypes(jTextComponent.getText()), jTextComponent.getUI().viewToModel(jTextComponent, mouseEvent.getPoint()))) {
                super.mouseClicked(mouseEvent);
            }
        } else {
            super.mouseClicked(mouseEvent);
        }
    }

    public int getMousePosition(MouseEvent mouseEvent) {
        JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
        return jTextComponent.getUI().viewToModel(jTextComponent, mouseEvent.getPoint());
    }

    private boolean handleDoubleClick(JTextComponent jTextComponent, List<TokenType> list, int n) {
        int n2;
        if (n < list.size() && this.colorizer.isOpener(list.get(n))) {
            int n3 = this.bracketMatcher.findCloser(this.colorizer, list, n);
            if (n3 != -1 && this.colorizer.isMatch(list.get(n), list.get(n3))) {
                jTextComponent.select(n, n3 + 1);
                return true;
            }
        } else if (n > 0 && this.colorizer.isCloser(list.get(n - 1)) && (n2 = this.bracketMatcher.findOpener(this.colorizer, list, n - 1)) != -1 && this.colorizer.isMatch(list.get(n2), list.get(n - 1))) {
            jTextComponent.select(n2, n);
            return true;
        }
        return false;
    }
}

