/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.editor;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.TextListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.TextAction;
import org.nlogo.editor.AbstractEditorArea;
import org.nlogo.editor.Actions;
import org.nlogo.editor.BracketMatcher;
import org.nlogo.editor.Colorizer;
import org.nlogo.editor.DoubleClickCaret;
import org.nlogo.editor.DumbIndenter;
import org.nlogo.editor.HighlightEditorKit;
import org.nlogo.editor.IndenterInterface;
import org.nlogo.editor.UndoManager;
import scala.Function1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class EditorArea<TokenType>
extends AbstractEditorArea
implements FocusListener {
    private final int rows;
    private final int columns;
    protected final boolean disableFocusTraversalKeys;
    private final BracketMatcher<TokenType> bracketMatcher;
    private final UndoManager undoManager = new UndoManager();
    protected final Colorizer<TokenType> colorizer;
    protected IndenterInterface indenter;
    private final Function1<String, String> i18n;
    private final DoubleClickCaret<TokenType> caret;
    private boolean enabled = true;
    private boolean mouseEvent = false;
    private boolean setSelection = true;
    private int mousePos;

    public EditorArea(int n, int n2, Font font, boolean bl, TextListener textListener, Colorizer<TokenType> colorizer, Function1<String, String> function1) {
        this.rows = n;
        this.columns = n2;
        this.disableFocusTraversalKeys = bl;
        this.colorizer = colorizer;
        this.i18n = function1;
        this.indenter = new DumbIndenter(this);
        this.enableEvents(16L);
        this.addFocusListener(this);
        this.bracketMatcher = new BracketMatcher<TokenType>(colorizer);
        this.addCaretListener(this.bracketMatcher);
        int n3 = this.getCaret().getBlinkRate();
        this.caret = new DoubleClickCaret<TokenType>(colorizer, this.bracketMatcher);
        this.caret.setBlinkRate(n3);
        this.setCaret(this.caret);
        this.setDragEnabled(false);
        this.setFocusTraversalKeysEnabled(!bl);
        if (!bl) {
            this.getInputMap().put(KeyStroke.getKeyStroke(9, 0), new TransferFocusAction());
            this.getInputMap().put(KeyStroke.getKeyStroke(9, 1), new TransferFocusBackwardAction());
        } else {
            this.getInputMap().put(KeyStroke.getKeyStroke(9, 0), Actions.tabKeyAction());
            this.getInputMap().put(KeyStroke.getKeyStroke(9, 1), Actions.shiftTabKeyAction());
        }
        this.setFont(font);
        this.setEditorKit(new HighlightEditorKit<TokenType>(textListener, colorizer));
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), new EnterAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(Character.valueOf(']'), 0), new CloseBracketAction());
        this.getDocument().putProperty("tabSize", 2);
        this.getDocument().putProperty("__EndOfLine__", "\n");
        this.getDocument().addUndoableEditListener(this.undoManager);
        int n4 = this.getToolkit().getMenuShortcutKeyMask();
        this.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(90, n4), UndoManager.undoAction());
        this.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(89, n4), UndoManager.redoAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(112, 0), Actions.quickHelpAction(colorizer, function1));
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(graphics);
    }

    @Override
    public void enableBracketMatcher(boolean bl) {
        if (this.enabled != bl) {
            if (bl) {
                this.addCaretListener(this.bracketMatcher);
            } else {
                this.removeCaretListener(this.bracketMatcher);
            }
            this.enabled = bl;
        }
    }

    @Override
    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), new Action[]{Actions.commentAction(), Actions.uncommentAction(), Actions.shiftLeftAction(), Actions.shiftRightAction(), Actions.quickHelpAction(this.colorizer, this.i18n)});
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = super.getPreferredScrollableViewportSize();
        dimension = dimension != null ? dimension : new Dimension(400, 400);
        dimension.width = this.columns != 0 ? this.columns * this.getColumnWidth() : dimension.width;
        dimension.height = this.rows != 0 ? this.rows * this.getRowHeight() : dimension.height;
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = dimension = dimension == null ? new Dimension(400, 400) : dimension;
        if (this.columns != 0) {
            dimension.width = StrictMath.max(dimension.width, this.columns * this.getColumnWidth());
        }
        if (this.rows != 0) {
            dimension.height = StrictMath.max(dimension.height, this.rows * this.getRowHeight());
        }
        return dimension;
    }

    private int getColumnWidth() {
        return this.getFontMetrics(this.getFont()).charWidth('m');
    }

    private int getRowHeight() {
        return this.getFontMetrics(this.getFont()).getHeight();
    }

    @Override
    public void setText(String string) {
        if (!string.equals(this.getText())) {
            super.setText(string);
            this.undoManager.discardAllEdits();
        }
    }

    String getLineText(int n) throws BadLocationException {
        PlainDocument plainDocument = (PlainDocument)this.getDocument();
        int n2 = this.offsetToLine(plainDocument, n);
        int n3 = this.lineToStartOffset(plainDocument, n2);
        int n4 = this.lineToEndOffset(plainDocument, n2);
        return plainDocument.getText(n3, n4 - n3);
    }

    void indentSelection() {
        this.indenter.handleTab();
    }

    int lineToStartOffset(PlainDocument plainDocument, int n) {
        return plainDocument.getDefaultRootElement().getElement(n).getStartOffset();
    }

    int lineToEndOffset(PlainDocument plainDocument, int n) {
        return plainDocument.getDefaultRootElement().getElement(n).getEndOffset();
    }

    int offsetToLine(PlainDocument plainDocument, int n) {
        return plainDocument.getDefaultRootElement().getElementIndex(n);
    }

    void insertBeforeEachSelectedLine(String string) {
        PlainDocument plainDocument = (PlainDocument)this.getDocument();
        try {
            int n = this.offsetToLine(plainDocument, this.getSelectionStart());
            int n2 = this.offsetToLine(plainDocument, this.getSelectionEnd());
            if (n2 > n && this.getSelectionEnd() == this.lineToStartOffset(plainDocument, n2)) {
                --n2;
            }
            if (n2 > n && this.getSelectionStart() == this.lineToEndOffset(plainDocument, n) - 1) {
                ++n;
            }
            while (n <= n2) {
                plainDocument.insertString(this.lineToStartOffset(plainDocument, n), string, null);
                ++n;
            }
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalStateException(badLocationException);
        }
    }

    void uncomment() {
        PlainDocument plainDocument = (PlainDocument)this.getDocument();
        try {
            int n = this.offsetToLine(plainDocument, this.getSelectionStart());
            int n2 = this.offsetToLine(plainDocument, this.getSelectionEnd());
            if (n2 > n && this.getSelectionEnd() == this.lineToStartOffset(plainDocument, n2)) {
                --n2;
            }
            if (n2 > n && this.getSelectionStart() == this.lineToEndOffset(plainDocument, n) - 1) {
                ++n;
            }
            while (n <= n2) {
                int n3;
                int n4 = this.lineToStartOffset(plainDocument, n);
                String string = plainDocument.getText(n4, (n3 = this.lineToEndOffset(plainDocument, n)) - n4);
                int n5 = string.indexOf(59);
                if (n5 != -1) {
                    boolean bl = true;
                    for (int i = 0; i < n5; ++i) {
                        if (Character.isWhitespace(string.charAt(i))) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        plainDocument.remove(n4 + n5, 1);
                    }
                }
                ++n;
            }
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalStateException(badLocationException);
        }
    }

    void shiftLeft() {
        PlainDocument plainDocument = (PlainDocument)this.getDocument();
        try {
            int n = this.offsetToLine(plainDocument, this.getSelectionStart());
            int n2 = this.offsetToLine(plainDocument, this.getSelectionEnd());
            if (n2 > n && this.getSelectionEnd() == this.lineToStartOffset(plainDocument, n2)) {
                --n2;
            }
            if (n2 > n && this.getSelectionStart() == this.lineToEndOffset(plainDocument, n) - 1) {
                ++n;
            }
            while (n <= n2) {
                int n3;
                int n4 = this.lineToStartOffset(plainDocument, n);
                String string = plainDocument.getText(n4, (n3 = this.lineToEndOffset(plainDocument, n)) - n4);
                if (string.length() > 0 && string.charAt(0) == ' ') {
                    plainDocument.remove(n4, 1);
                }
                ++n;
            }
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalStateException(badLocationException);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (!this.mouseEvent && !this.disableFocusTraversalKeys && this.setSelection) {
            this.setCaretPosition(this.getText().length());
            this.moveCaretPosition(0);
        }
        Actions.setEnabled(true);
        UndoManager.setCurrentManager(this.undoManager);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (!this.disableFocusTraversalKeys) {
            this.select(0, 0);
        }
        this.mouseEvent = focusEvent.isTemporary();
        this.bracketMatcher.focusLost(this);
        this.colorizer.reset();
        if (!focusEvent.isTemporary()) {
            Actions.setEnabled(false);
            UndoManager.setCurrentManager(null);
        }
    }

    public int getMousePos() {
        return this.mousePos;
    }

    @Override
    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            this.mouseEvent = true;
        }
        if (mouseEvent.isPopupTrigger()) {
            this.mousePos = this.caret.getMousePosition(mouseEvent);
            this.doPopup(mouseEvent);
            return;
        }
        super.processMouseEvent(mouseEvent);
    }

    private void doPopup(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JMenuItem(Actions.COPY_ACTION()));
        Actions.COPY_ACTION().putValue("Name", this.i18n.apply("menu.edit.copy"));
        jPopupMenu.add(new JMenuItem(Actions.CUT_ACTION()));
        Actions.CUT_ACTION().putValue("Name", this.i18n.apply("menu.edit.cut"));
        jPopupMenu.add(new JMenuItem(Actions.PASTE_ACTION()));
        Actions.PASTE_ACTION().putValue("Name", this.i18n.apply("menu.edit.paste"));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem(Actions.mouseQuickHelpAction(this.colorizer, this.i18n)));
        jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public void replaceSelection(String string) {
        if (string == null) {
            super.replaceSelection(string);
            return;
        }
        if (string.length() > 0 && Character.getType(string.charAt(0)) == 16) {
            string = string.substring(1);
        }
        if (string.indexOf(9) >= 0) {
            string = string.replaceAll("\t", "  ");
        }
        super.replaceSelection(string);
        this.indenter.handleInsertion(string);
    }

    @Override
    public String getText(int n, int n2) {
        try {
            return this.getDocument().getText(n, n2);
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalStateException(badLocationException);
        }
    }

    String getHelpTarget(int n) {
        PlainDocument plainDocument = (PlainDocument)this.getDocument();
        try {
            int n2 = this.offsetToLine(plainDocument, n);
            int n3 = this.lineToStartOffset(plainDocument, n2);
            int n4 = this.lineToEndOffset(plainDocument, n2) - n3;
            String string = plainDocument.getText(n3, n4);
            int n5 = n - n3;
            return this.colorizer.getTokenAtPosition(string, n5);
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalStateException(badLocationException);
        }
    }

    protected strictfp class TransferFocusBackwardAction
    extends AbstractAction {
        protected TransferFocusBackwardAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditorArea.this.transferFocusBackward();
        }
    }

    protected strictfp class TransferFocusAction
    extends AbstractAction {
        protected TransferFocusAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditorArea.this.transferFocus();
        }
    }

    strictfp class CloseBracketAction
    extends TextAction {
        CloseBracketAction() {
            super("close-bracket");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditorArea.this.replaceSelection("]");
            EditorArea.this.indenter.handleCloseBracket();
        }
    }

    strictfp class EnterAction
    extends TextAction {
        EnterAction() {
            super("enter");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditorArea.this.indenter.handleEnter();
        }
    }
}

