/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.editor;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.nlogo.editor.Colorizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
strictfp class HighlightView<TokenType>
extends PlainView {
    private final JEditorPane pane;
    private final Colorizer<TokenType> colorizer;
    private int lineStart;
    private Color[] charColors;
    private static final boolean LEAVE_COLORS_ALONE = System.getProperty("os.name").startsWith("Mac");
    private static final Color SELECTED_BACKGROUND_COLOR = HighlightView.retrieveDefaultUIColor("textHighlight", Color.BLUE);
    private static final Color UNSELECTED_TEXT_COLOR = HighlightView.retrieveDefaultUIColor("textText", Color.BLACK);
    private static final Color SELECTED_TEXT_COLOR = HighlightView.retrieveDefaultUIColor("textHighlightText", Color.WHITE);

    HighlightView(JEditorPane jEditorPane, Element element, Colorizer<TokenType> colorizer) {
        super(element);
        this.pane = jEditorPane;
        this.colorizer = colorizer;
    }

    @Override
    protected void drawLine(int n, Graphics graphics, int n2, int n3) {
        try {
            this.studyLine(n);
            super.drawLine(n, graphics, n2, n3);
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalStateException(badLocationException);
        }
    }

    private void studyLine(int n) throws BadLocationException {
        Element element = this.getElement().getElement(n);
        PlainDocument plainDocument = (PlainDocument)this.getDocument();
        Segment segment = this.getLineBuffer();
        this.lineStart = element.getStartOffset();
        int n2 = element.getEndOffset();
        int n3 = n2 - this.lineStart;
        if (n3 < 0) {
            n3 = 0;
        }
        plainDocument.getText(this.lineStart, n3, segment);
        this.charColors = this.colorizer.getCharacterColors(segment.toString());
    }

    @Override
    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        return this.drawText(graphics, n, n2, n3, n4, false);
    }

    @Override
    protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        return this.drawText(graphics, n, n2, n3, n4, true);
    }

    private int drawText(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) throws BadLocationException {
        PlainDocument plainDocument = (PlainDocument)this.getDocument();
        Segment segment = this.getLineBuffer();
        while (n3 < n4) {
            plainDocument.getText(n3, 1, segment);
            Color color = this.charColors[n3 - this.lineStart];
            if (!this.pane.isEnabled()) {
                color = this.lightenColor(color, 0.5f);
            }
            graphics.setColor(bl && !LEAVE_COLORS_ALONE ? this.selectedColor(color) : color);
            n = Utilities.drawTabbedText(segment, n, n2, graphics, (TabExpander)this, n3);
            ++n3;
        }
        return n;
    }

    private static Color retrieveDefaultUIColor(String string, Color color) {
        Color color2 = UIManager.getDefaults().getColor(string);
        if (color2 == null) {
            return color;
        }
        return color2;
    }

    private Color selectedColor(Color color) {
        if (color.getRGB() == UNSELECTED_TEXT_COLOR.getRGB()) {
            return SELECTED_TEXT_COLOR;
        }
        if (this.isDarkSelectionColor()) {
            return this.lightenColor(color, 0.75f);
        }
        return this.darkenColor(color, 0.75f);
    }

    private boolean isDarkSelectionColor() {
        int n;
        int n2;
        int n3 = SELECTED_BACKGROUND_COLOR.getRed();
        return n3 + (n2 = SELECTED_BACKGROUND_COLOR.getGreen()) + (n = SELECTED_BACKGROUND_COLOR.getBlue()) < 375;
    }

    private Color lightenColor(Color color, float f) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        return new Color((int)((float)n + (float)(255 - n) * f), (int)((float)n2 + (float)(255 - n2) * f), (int)((float)n3 + (float)(255 - n3) * f));
    }

    private Color darkenColor(Color color, float f) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        return new Color((int)((float)n * f), (int)((float)n2 * f), (int)((float)n3 * f));
    }
}

