/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.editor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Timer;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public strictfp class UndoManager
extends javax.swing.undo.UndoManager
implements ActionListener {
    private static UndoAction undoAction = new UndoAction();
    private static RedoAction redoAction = new RedoAction();
    private static UndoManager currentManager = null;
    private final Timer _timer = new Timer(200, this);
    private CompoundEdit _editInProgress = null;
    private long _lastEditTime = 0L;
    private Object _lastEditSource = null;

    public static UndoAction undoAction() {
        return undoAction;
    }

    public static Action redoAction() {
        return redoAction;
    }

    public static void setCurrentManager(UndoManager undoManager) {
        currentManager = undoManager;
        undoAction.updateUndoState();
        redoAction.updateRedoState();
    }

    public synchronized void undo() throws CannotUndoException {
        this.closeEditInProgress(true);
        super.undo();
    }

    public synchronized void redo() throws CannotRedoException {
        this.closeEditInProgress(false);
        super.redo();
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this._timer.stop();
        long l = System.currentTimeMillis();
        Object object = undoableEditEvent.getSource();
        if (this._editInProgress == null) {
            this._editInProgress = new CompoundEdit();
        } else if (this._lastEditSource != object || l - this._lastEditTime > 200L) {
            this.closeEditInProgress(false);
            this._editInProgress = new CompoundEdit();
        }
        this._editInProgress.addEdit(undoableEditEvent.getEdit());
        this._lastEditTime = l;
        this._lastEditSource = object;
        this._timer.restart();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._timer) {
            this.closeEditInProgress(true);
        }
    }

    private void closeEditInProgress(boolean bl) {
        if (this._editInProgress != null) {
            this._editInProgress.end();
            if (bl) {
                this.addEdit(this._editInProgress);
            } else {
                this._editInProgress.die();
            }
            this._editInProgress = null;
            this._lastEditTime = 0L;
            this._lastEditSource = null;
            this._timer.stop();
        }
    }

    public boolean addEdit(UndoableEdit undoableEdit) {
        boolean bl = super.addEdit(undoableEdit);
        if (this == currentManager) {
            undoAction.updateUndoState();
            redoAction.updateRedoState();
        }
        return bl;
    }

    public void discardAllEdits() {
        this.closeEditInProgress(false);
        super.discardAllEdits();
        if (this == currentManager) {
            undoAction.updateUndoState();
            redoAction.updateRedoState();
        }
    }

    strictfp static class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            currentManager.redo();
            this.updateRedoState();
            undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (currentManager != null && currentManager.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", currentManager.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    strictfp static class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            currentManager.undo();
            this.updateUndoState();
            redoAction.updateRedoState();
        }

        protected void updateUndoState() {
            if (currentManager != null && currentManager.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", currentManager.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }
}

