/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.api.JobOwner;
import org.nlogo.api.LogoException;
import org.nlogo.nvm.Activation;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.Job;
import org.nlogo.nvm.Procedure;
import org.nlogo.util.MersenneTwisterFast;

public strictfp class ConcurrentJob
extends Job {
    private Context[] contexts;

    public ConcurrentJob(JobOwner jobOwner, AgentSet agentSet, Procedure procedure, int n, Context context, MersenneTwisterFast mersenneTwisterFast) {
        super(jobOwner, agentSet, procedure, n, context, mersenneTwisterFast);
    }

    boolean exclusive() {
        return false;
    }

    private void initialize() {
        this.contexts = new Context[this.agentset.count()];
        int n = 0;
        AgentSet.Iterator iterator2 = this.agentset.shufflerator(this.random);
        while (iterator2.hasNext()) {
            Agent agent = iterator2.next();
            this.newAgentJoining(agent, n++, this.address);
        }
    }

    public void newAgentJoining(Agent agent, int n, int n2) {
        Context context = new Context(this, agent, n2, this.parentContext == null ? new Activation(this.topLevelProcedure, null, 0) : this.parentContext.activation);
        if (n == -1) {
            if (this.contexts == null) {
                this.initialize();
            }
            n = this.contexts.length;
            Context[] contextArray = new Context[n + 1];
            System.arraycopy(this.contexts, 0, contextArray, 0, n);
            this.contexts = contextArray;
        }
        this.contexts[n] = context;
    }

    public void step() throws LogoException {
        if (this.contexts == null) {
            this.initialize();
        }
        int n = this.contexts.length;
        boolean bl = true;
        Context context = null;
        try {
            for (int i = 0; i < n && this.state == 0; ++i) {
                context = this.contexts[i];
                if (context == null) continue;
                if (!context.finished) {
                    if (!context.waiting) {
                        context.stepConcurrent();
                    }
                    bl = false;
                    continue;
                }
                this.contexts[i] = null;
            }
        }
        catch (LogoException logoException) {
            this.finish();
            if (!Thread.currentThread().isInterrupted()) {
                context.runtimeError(logoException);
            }
            throw logoException;
        }
        catch (RuntimeException runtimeException) {
            this.finish();
            context.runtimeError(runtimeException);
            throw runtimeException;
        }
        if (this.state == 0 && bl) {
            this.finish();
        }
    }

    public void finish() {
        super.finish();
        if (this.contexts != null) {
            for (Context context : this.contexts) {
                if (context == null) continue;
                context.finished = true;
            }
        }
    }
}

