/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import org.nlogo.api.LogoException;
import org.nlogo.api.Version;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.HaltException;
import org.nlogo.nvm.Instruction;
import scala.Option;

public strictfp class EngineException
extends LogoException {
    protected boolean hasBeenResolved = false;
    public Context context = null;
    public Instruction instruction = null;
    Option<String> cachedRuntimeErrorMessage = Option.apply(null);

    public EngineException(Context context, Instruction instruction, String string) {
        super(string, null);
        this.context = context;
        this.instruction = instruction;
    }

    public EngineException(Context context, String string) {
        super(string, null);
        if (!Version.useGenerator()) {
            throw new IllegalStateException();
        }
        this.context = context;
        this.instruction = null;
    }

    static void rethrow(LogoException logoException, Context context, Instruction instruction) throws LogoException {
        if (logoException instanceof EngineException) {
            EngineException engineException = (EngineException)logoException;
            if (engineException.context == null) {
                engineException.context = context;
            }
            if (engineException.instruction == null) {
                engineException.instruction = instruction;
            }
            if (!engineException.hasBeenResolved) {
                engineException.resolveErrorInstruction();
            }
            throw engineException;
        }
        if (logoException instanceof HaltException) {
            throw logoException;
        }
        EngineException engineException = new EngineException(context, instruction, logoException.getMessage());
        engineException.resolveErrorInstruction();
        throw engineException;
    }

    protected void resolveErrorInstruction() {
        if (this.hasBeenResolved) {
            throw new IllegalStateException("An EngineException must only be 'resolved' once!");
        }
        this.hasBeenResolved = true;
        this.instruction = this.instruction.extractErrorInstruction(this);
    }

    public Throwable fillInStackTrace() {
        super.fillInStackTrace();
        if (this.context != null && !this.cachedRuntimeErrorMessage.isDefined()) {
            this.cachedRuntimeErrorMessage = Option.apply(this.context.buildRuntimeErrorMessage(this.instruction, this));
        }
        return this;
    }
}

