/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.I18N;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoList;
import org.nlogo.api.Patch;
import org.nlogo.api.Syntax;
import org.nlogo.api.Token;
import org.nlogo.api.TokenHolder;
import org.nlogo.nvm.ArgumentTypeException;
import org.nlogo.nvm.CommandTask;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.EngineException;
import org.nlogo.nvm.Reference;
import org.nlogo.nvm.Reporter;
import org.nlogo.nvm.ReporterTask;
import org.nlogo.nvm.Workspace;
import org.nlogo.util.Thunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class Instruction
implements TokenHolder {
    public Workspace workspace;
    public World world;
    public Reporter[] args = new Reporter[0];
    private Token token;
    private Token token2 = null;
    public Method chosenMethod = null;
    public String source;
    public Thunk<String> disassembly = new Thunk<String>(){};
    public String agentClassString = "OTPL";
    public int agentBits = 0;
    public Reference reference = null;
    public int storedSourceStartPosition = -1;
    public int storedSourceEndPosition = -1;
    private String storedSourceSnippet = "";

    public abstract Syntax syntax();

    public Token token() {
        return this.token;
    }

    @Override
    public void token(Token token) {
        this.token = token;
    }

    public Token tokenLimitingType() {
        return this.token2 == null ? this.token : this.token2;
    }

    public void tokenLimitingType(Token token) {
        this.token2 = token;
    }

    public void init(Workspace workspace) {
        if (workspace != null) {
            this.workspace = workspace;
            this.world = workspace.world();
        }
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i].init(workspace);
        }
        this.agentBits = (this.agentClassString.indexOf(79) != -1 ? 1 : 0) | (this.agentClassString.indexOf(84) != -1 ? 2 : 0) | (this.agentClassString.indexOf(80) != -1 ? 4 : 0) | (this.agentClassString.indexOf(76) != -1 ? 8 : 0);
    }

    public int[] getPositionAndLength() {
        int n = this.getSourceStartPosition();
        int n2 = this.getSourceEndPosition();
        return new int[]{n, n2 - n};
    }

    public int getSourceStartPosition() {
        if (this.storedSourceStartPosition > -1) {
            return this.storedSourceStartPosition;
        }
        if (this.token() == null) {
            return -1;
        }
        int n = this.token().startPos();
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].token() == null) continue;
            int n2 = this.args[i].getSourceStartPosition();
            n = StrictMath.min(n, n2);
        }
        this.storedSourceStartPosition = n;
        return n;
    }

    public int getSourceEndPosition() {
        if (this.storedSourceEndPosition > -1) {
            return this.storedSourceEndPosition;
        }
        if (this.token() == null) {
            return -1;
        }
        int n = this.token().endPos();
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].token() == null) continue;
            int n2 = this.args[i].getSourceEndPosition();
            n = StrictMath.max(n, n2);
        }
        this.storedSourceEndPosition = n;
        return n;
    }

    public void setSourceSnippet(String string) {
        this.storedSourceSnippet = string;
    }

    public String getSourceSnippet() {
        return this.storedSourceSnippet;
    }

    public String displayName() {
        if (this.token != null) {
            return this.token.name().toUpperCase();
        }
        String string = "." + this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public String toString() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(n + 1);
    }

    public String dump() {
        return this.dump(3);
    }

    public String dump(int n) {
        StringBuilder stringBuilder = new StringBuilder(this.toString());
        if (this.source != null) {
            stringBuilder.append(" \"");
            stringBuilder.append(this.source);
            stringBuilder.append('\"');
        }
        if (this.chosenMethod != null) {
            stringBuilder.append(' ');
            stringBuilder.append(this.describeMethod(this.chosenMethod));
        }
        if (this.args.length > 0) {
            stringBuilder.append('\n');
            for (int i = 0; i < this.args.length; ++i) {
                for (int j = 0; j < n * 2; ++j) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(this.args[i].dump(n + 1));
                if (i >= this.args.length - 1) continue;
                stringBuilder.append('\n');
            }
        }
        return stringBuilder.toString();
    }

    private String describeMethod(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < classArray.length; ++i) {
            if (i > 1) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.shortClassName(classArray[i].getName()));
        }
        if (classArray.length > 1) {
            stringBuilder.append(' ');
        }
        stringBuilder.append("=> ");
        stringBuilder.append(this.shortClassName(method.getReturnType().getName()));
        return stringBuilder.toString();
    }

    private String shortClassName(String string) {
        String[] stringArray = string.split("\\.");
        return stringArray[stringArray.length - 1];
    }

    protected void mustNotBeDirected(AgentSet agentSet, Context context) throws EngineException {
        if (agentSet.isDirected()) {
            throw new EngineException(context, this, agentSet.printName() + " is a directed breed.");
        }
    }

    protected void mustNotBeUndirected(AgentSet agentSet, Context context) throws EngineException {
        if (agentSet.isUndirected()) {
            throw new EngineException(context, this, agentSet.printName() + " is an undirected breed.");
        }
    }

    protected void checkForBreedCompatibility(AgentSet agentSet, Context context) throws EngineException {
        if (!this.world.linkManager.checkBreededCompatibility(agentSet == this.world.links())) {
            throw new EngineException(context, this, I18N.errorsJ().get("org.nlogo.agent.Link.cantHaveBreededAndUnbreededLinks"));
        }
    }

    public long validLong(double d) throws LogoException {
        if (d > 9.007199254740992E15 || d < -9.007199254740992E15) {
            throw new EngineException(null, this, d + " is too large to be represented exactly as an integer in NetLogo");
        }
        return (long)d;
    }

    public static boolean isValidLong(double d) {
        return d <= 9.007199254740992E15 && d >= -9.007199254740992E15;
    }

    public Double newValidDouble(double d) throws LogoException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            this.invalidDouble(d);
        }
        return d;
    }

    public double validDouble(double d) throws LogoException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            this.invalidDouble(d);
        }
        return d;
    }

    private void invalidDouble(double d) throws LogoException {
        throw new EngineException(null, this, "math operation produced " + (Double.isInfinite(d) ? "a number too large for NetLogo" : "a non-number"));
    }

    public void throwAgentClassException(Context context, Class<? extends Agent> clazz) throws EngineException {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        if (this.syntax().agentClassString().indexOf("O") != -1) {
            arrayList.add(Observer.class);
        }
        if (this.syntax().agentClassString().indexOf("T") != -1) {
            arrayList.add(Turtle.class);
        }
        if (this.syntax().agentClassString().indexOf("P") != -1) {
            arrayList.add(org.nlogo.agent.Patch.class);
        }
        if (this.syntax().agentClassString().indexOf("L") != -1) {
            arrayList.add(Link.class);
        }
        if (arrayList.size() == 1) {
            throw new EngineException(context, this, "this code can't be run by " + Instruction.agentClassDescription(clazz) + ", only " + Instruction.agentClassDescription((Class)arrayList.get(0)));
        }
        throw new EngineException(context, this, "this code can't be run by " + Instruction.agentClassDescription(clazz));
    }

    protected static String agentClassDescription(Class<? extends Agent> clazz) {
        if (clazz == Observer.class) {
            return "the observer";
        }
        if (clazz == Turtle.class) {
            return "a turtle";
        }
        if (clazz == org.nlogo.agent.Patch.class) {
            return "a patch";
        }
        if (clazz == Link.class) {
            return "a link";
        }
        return null;
    }

    public Agent argEvalAgent(Context context, int n) throws LogoException {
        Object object = this.args[n].report(context);
        try {
            Agent agent = (Agent)object;
            if (agent.id == -1L) {
                throw new EngineException(context, this, I18N.errorsJ().getN("org.nlogo.$common.thatAgentIsDead", agent.classDisplayName()));
            }
            return agent;
        }
        catch (ClassCastException classCastException) {
            throw new ArgumentTypeException(context, this, n, Syntax.AgentType(), object);
        }
    }

    public AgentSet argEvalAgentSet(Context context, int n) throws LogoException {
        Object object = this.args[n].report(context);
        try {
            return (AgentSet)object;
        }
        catch (ClassCastException classCastException) {
            throw new ArgumentTypeException(context, this, n, Syntax.AgentsetType(), object);
        }
    }

    public AgentSet argEvalAgentSet(Context context, int n, Class<? extends Agent> clazz) throws LogoException {
        Object object = this.args[n].report(context);
        try {
            AgentSet agentSet = (AgentSet)object;
            if (agentSet.type() != clazz) {
                throw new ArgumentTypeException(context, this, n, Instruction.getAgentSetMask(clazz), object);
            }
            return agentSet;
        }
        catch (ClassCastException classCastException) {
            throw new ArgumentTypeException(context, this, n, Syntax.AgentsetType(), object);
        }
    }

    public Boolean argEvalBoolean(Context context, int n) throws LogoException {
        Object object = this.args[n].report(context);
        try {
            return (Boolean)object;
        }
        catch (ClassCastException classCastException) {
            throw new ArgumentTypeException(context, this, n, Syntax.BooleanType(), object);
        }
    }

    public boolean argEvalBooleanValue(Context context, int n) throws LogoException {
        Object object = this.args[n].report(context);
        try {
            return (Boolean)object;
        }
        catch (ClassCastException classCastException) {
            throw new ArgumentTypeException(context, this, n, Syntax.BooleanType(), object);
        }
    }

    public double argEvalDoubleValue(Context context, int n) throws LogoException {
        return this.argEvalDouble(context, n);
    }

    public int argEvalIntValue(Context context, int n) throws LogoException {
        return this.argEvalDouble(context, n).intValue();
    }

    public LogoList argEvalList(Context context, int n) throws LogoException {
        Object object = this.args[n].report(context);
        try {
            return (LogoList)object;
        }
        catch (ClassCastException classCastException) {
            throw new ArgumentTypeException(context, this, n, Syntax.ListType(), object);
        }
    }

    public org.nlogo.agent.Patch argEvalPatch(Context context, int n) throws LogoException {
        Object object = this.args[n].report(context);
        try {
            return (org.nlogo.agent.Patch)object;
        }
        catch (ClassCastException classCastException) {
            throw new ArgumentTypeException(context, this, n, Syntax.PatchType(), object);
        }
    }

    public String argEvalString(Context context, int n) throws LogoException {
        Object object = this.args[n].report(context);
        try {
            return (String)object;
        }
        catch (ClassCastException classCastException) {
            throw new ArgumentTypeException(context, this, n, Syntax.StringType(), object);
        }
    }

    public Double argEvalDouble(Context context, int n) throws LogoException {
        Reporter reporter = this.args[n];
        Object object = reporter.report(context);
        try {
            return (Double)object;
        }
        catch (ClassCastException classCastException) {
            throw new ArgumentTypeException(context, this, n, Syntax.NumberType(), object);
        }
    }

    public Turtle argEvalTurtle(Context context, int n) throws LogoException {
        Object object = this.args[n].report(context);
        try {
            return (Turtle)object;
        }
        catch (ClassCastException classCastException) {
            throw new ArgumentTypeException(context, this, n, Syntax.TurtleType(), object);
        }
    }

    public Link argEvalLink(Context context, int n) throws LogoException {
        Object object = this.args[n].report(context);
        try {
            return (Link)object;
        }
        catch (ClassCastException classCastException) {
            throw new ArgumentTypeException(context, this, n, Syntax.LinkType(), object);
        }
    }

    public ReporterTask argEvalReporterTask(Context context, int n) throws LogoException {
        Object object = this.args[n].report(context);
        try {
            return (ReporterTask)object;
        }
        catch (ClassCastException classCastException) {
            throw new ArgumentTypeException(context, this, n, Syntax.ReporterTaskType(), object);
        }
    }

    public CommandTask argEvalCommandTask(Context context, int n) throws LogoException {
        Object object = this.args[n].report(context);
        try {
            return (CommandTask)object;
        }
        catch (ClassCastException classCastException) {
            throw new ArgumentTypeException(context, this, n, Syntax.CommandTaskType(), object);
        }
    }

    private static int getAgentSetMask(Class<? extends Agent> clazz) {
        if (org.nlogo.api.Turtle.class.isAssignableFrom(clazz)) {
            return Syntax.TurtlesetType();
        }
        if (Patch.class.isAssignableFrom(clazz)) {
            return Syntax.PatchsetType();
        }
        if (org.nlogo.api.Link.class.isAssignableFrom(clazz)) {
            return Syntax.LinksetType();
        }
        return Syntax.AgentsetType();
    }

    public void copyFieldsFrom(Instruction instruction) {
        this.workspace = instruction.workspace;
        this.world = instruction.world;
        this.token = instruction.token;
    }

    public Instruction extractErrorInstruction(EngineException engineException) {
        return this;
    }
}

