/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import org.nlogo.agent.AgentSet;
import org.nlogo.api.JobOwner;
import org.nlogo.api.LogoException;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.Procedure;
import org.nlogo.util.MersenneTwisterFast;

public strictfp abstract class Job {
    public static final byte RUNNING = 0;
    public static final byte REMOVED = 2;
    public final JobOwner owner;
    public byte state = 0;
    public boolean stopping = false;
    public boolean buttonTurnIsOver = false;
    public Object result;
    final int address;
    public final AgentSet agentset;
    public final Context parentContext;
    public final Procedure topLevelProcedure;
    public MersenneTwisterFast random;

    abstract boolean exclusive();

    Job(JobOwner jobOwner, AgentSet agentSet, Procedure procedure, int n, Context context, MersenneTwisterFast mersenneTwisterFast) {
        this.owner = jobOwner;
        this.agentset = agentSet;
        this.topLevelProcedure = procedure;
        this.address = n;
        this.parentContext = context;
        this.random = mersenneTwisterFast;
    }

    public abstract void step() throws LogoException;

    public void finish() {
        this.state = 1;
        if (this.parentContext != null) {
            this.parentContext.waiting = false;
        }
    }

    public boolean isTurtleForeverButtonJob() {
        return this.topLevelProcedure != null && this.owner.isTurtleForeverButton();
    }

    public boolean isLinkForeverButtonJob() {
        return this.topLevelProcedure != null && this.owner.isLinkForeverButton();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("(owner: {" + this.owner + "}, state:");
        switch (this.state) {
            case 0: {
                stringBuilder.append("running");
                break;
            }
            case 1: {
                stringBuilder.append("done");
                break;
            }
            case 2: {
                stringBuilder.append("removed");
                break;
            }
            default: {
                throw new IllegalStateException("unknown state: " + this.state);
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

